local assets =
{
    Asset("ANIM", "anim/xueyu.zip"),
    Asset("ANIM", "anim/swap_xueyu.zip"),
	Asset("IMAGE","images/inventoryimages/tisuiya.tex"),
	Asset("ATLAS","images/inventoryimages/tisuiya.xml")
}

local function onequip(inst, owner)
inst:AddTag("feng")
    owner.AnimState:OverrideSymbol("swap_object", "swap_xueyu", "swap_xueyu")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

end

local function onunequip(inst, owner)
inst:RemoveTag("feng")
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
inst:DoTaskInTime(0.001,function()inst:Remove()end)
end

local function xueyuatt(weapon, attacker, target)
	if target:HasTag("largecreature") then
	attacker.components.health:DoDelta(10)
	target.components.health:DoDelta(-20)
	attacker.components.hunger:DoDelta(-2)
	local x, y, z = target.Transform:GetWorldPosition()
	local fx = SpawnPrefab("moose_nest_fx_idle")
	fx.Transform:SetPosition(x, y, z)
      else 
    
	attacker.components.health:DoDelta(2)
	--target.components.health:DoDelta(-20)
        --attacker.components.hunger:DoDelta(-2)
	
end
end




local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("xueyu")
    inst.AnimState:SetBuild("xueyu")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("inspectable")
	inst:AddTag("shadow")
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(15)
inst.components.weapon:SetOnAttack(xueyuatt)
    -------
   


    inst.components.weapon:SetRange(1.3)
	--inst.components.weapon:SetProjectile("feiren_projectile")



    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "tisuiya"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tisuiya.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)



    MakeHauntableLaunch(inst)

    return inst
end

return Prefab( "common/inventory/xueyu", fn, assets)