/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.examples.example10;

import org.quartz.Scheduler;
import org.quartz.SchedulerMetaData;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlugInExample {
    public void run() throws Exception {
        Logger log = LoggerFactory.getLogger(PlugInExample.class);
        StdSchedulerFactory sf = new StdSchedulerFactory();
        Scheduler sched = sf.getScheduler();
        log.info("------- Initialization Complete -----------");
        log.info("------- (Not Scheduling any Jobs - relying on XML definitions --");
        log.info("------- Starting Scheduler ----------------");
        sched.start();
        log.info("------- Started Scheduler -----------------");
        log.info("------- Waiting five minutes... -----------");
        try {
            Thread.sleep(300000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        log.info("------- Shutting Down ---------------------");
        sched.shutdown(true);
        log.info("------- Shutdown Complete -----------------");
        SchedulerMetaData metaData = sched.getMetaData();
        log.info("Executed " + metaData.getNumberOfJobsExecuted() + " jobs.");
    }

    public static void main(String[] args) throws Exception {
        PlugInExample example = new PlugInExample();
        example.run();
    }
}

