/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.examples.example12;

import org.quartz.Scheduler;
import org.quartz.SchedulerMetaData;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServerExample {
    public void run() throws Exception {
        Logger log = LoggerFactory.getLogger(RemoteServerExample.class);
        StdSchedulerFactory sf = new StdSchedulerFactory();
        Scheduler sched = sf.getScheduler();
        log.info("------- Initialization Complete -----------");
        log.info("------- (Not Scheduling any Jobs - relying on a remote client to schedule jobs --");
        log.info("------- Starting Scheduler ----------------");
        sched.start();
        log.info("------- Started Scheduler -----------------");
        log.info("------- Waiting ten minutes... ------------");
        try {
            Thread.sleep(600000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        log.info("------- Shutting Down ---------------------");
        sched.shutdown(true);
        log.info("------- Shutdown Complete -----------------");
        SchedulerMetaData metaData = sched.getMetaData();
        log.info("Executed " + metaData.getNumberOfJobsExecuted() + " jobs.");
    }

    public static void main(String[] args) throws Exception {
        RemoteServerExample example = new RemoteServerExample();
        example.run();
    }
}

