/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.examples.example15;

import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.examples.example15.SimpleRecoveryJob;
import org.quartz.examples.example15.SimpleRecoveryStatefulJob;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterExample {
    private static Logger _log = LoggerFactory.getLogger(ClusterExample.class);

    public void run(boolean inClearJobs, boolean inScheduleJobs) throws Exception {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        Scheduler sched = sf.getScheduler();
        if (inClearJobs) {
            _log.warn("***** Deleting existing jobs/triggers *****");
            sched.clear();
        }
        _log.info("------- Initialization Complete -----------");
        if (inScheduleJobs) {
            _log.info("------- Scheduling Jobs ------------------");
            String schedId = sched.getSchedulerInstanceId();
            int count = 1;
            JobDetail job = JobBuilder.newJob(SimpleRecoveryJob.class).withIdentity("job_" + count, schedId).requestRecovery().build();
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("triger_" + count, schedId).startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(20).withIntervalInSeconds(5)).build();
            _log.info(job.getKey() + " will run at: " + trigger.getNextFireTime() + " and repeat: " + trigger.getRepeatCount() + " times, every " + trigger.getRepeatInterval() / 1000L + " seconds");
            sched.scheduleJob(job, (Trigger)trigger);
            job = JobBuilder.newJob(SimpleRecoveryJob.class).withIdentity("job_" + ++count, schedId).requestRecovery().build();
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("triger_" + count, schedId).startAt(DateBuilder.futureDate((int)2, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(20).withIntervalInSeconds(5)).build();
            _log.info(job.getKey() + " will run at: " + trigger.getNextFireTime() + " and repeat: " + trigger.getRepeatCount() + " times, every " + trigger.getRepeatInterval() / 1000L + " seconds");
            sched.scheduleJob(job, (Trigger)trigger);
            job = JobBuilder.newJob(SimpleRecoveryStatefulJob.class).withIdentity("job_" + ++count, schedId).requestRecovery().build();
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("triger_" + count, schedId).startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(20).withIntervalInSeconds(3)).build();
            _log.info(job.getKey() + " will run at: " + trigger.getNextFireTime() + " and repeat: " + trigger.getRepeatCount() + " times, every " + trigger.getRepeatInterval() / 1000L + " seconds");
            sched.scheduleJob(job, (Trigger)trigger);
            job = JobBuilder.newJob(SimpleRecoveryJob.class).withIdentity("job_" + ++count, schedId).requestRecovery().build();
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("triger_" + count, schedId).startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(20).withIntervalInSeconds(4)).build();
            _log.info(job.getKey() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval());
            sched.scheduleJob(job, (Trigger)trigger);
            job = JobBuilder.newJob(SimpleRecoveryJob.class).withIdentity("job_" + ++count, schedId).requestRecovery().build();
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("triger_" + count, schedId).startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(20).withIntervalInMilliseconds(4500L)).build();
            _log.info(job.getKey() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval());
            sched.scheduleJob(job, (Trigger)trigger);
        }
        _log.info("------- Starting Scheduler ---------------");
        sched.start();
        _log.info("------- Started Scheduler ----------------");
        _log.info("------- Waiting for one hour... ----------");
        try {
            Thread.sleep(3600000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        _log.info("------- Shutting Down --------------------");
        sched.shutdown();
        _log.info("------- Shutdown Complete ----------------");
    }

    public static void main(String[] args) throws Exception {
        boolean clearJobs = false;
        boolean scheduleJobs = true;
        for (String arg : args) {
            if (arg.equalsIgnoreCase("clearJobs")) {
                clearJobs = true;
                continue;
            }
            if (!arg.equalsIgnoreCase("dontScheduleJobs")) continue;
            scheduleJobs = false;
        }
        ClusterExample example = new ClusterExample();
        example.run(clearJobs, scheduleJobs);
    }
}

