/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.examples.example5;

import java.util.Date;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.examples.example5.StatefulDumbJob;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MisfireExample {
    public void run() throws Exception {
        Logger log = LoggerFactory.getLogger(MisfireExample.class);
        log.info("------- Initializing -------------------");
        StdSchedulerFactory sf = new StdSchedulerFactory();
        Scheduler sched = sf.getScheduler();
        log.info("------- Initialization Complete -----------");
        log.info("------- Scheduling Jobs -----------");
        Date startTime = DateBuilder.nextGivenSecondDate(null, (int)15);
        JobDetail job = JobBuilder.newJob(StatefulDumbJob.class).withIdentity("statefulJob1", "group1").usingJobData("ExecutionDelay", Long.valueOf(10000L)).build();
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("trigger1", "group1").startAt(startTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(3).repeatForever()).build();
        Date ft = sched.scheduleJob(job, (Trigger)trigger);
        log.info(job.getKey() + " will run at: " + ft + " and repeat: " + trigger.getRepeatCount() + " times, every " + trigger.getRepeatInterval() / 1000L + " seconds");
        job = JobBuilder.newJob(StatefulDumbJob.class).withIdentity("statefulJob2", "group1").usingJobData("ExecutionDelay", Long.valueOf(10000L)).build();
        trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("trigger2", "group1").startAt(startTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(3).repeatForever().withMisfireHandlingInstructionNowWithExistingCount()).build();
        ft = sched.scheduleJob(job, (Trigger)trigger);
        log.info(job.getKey() + " will run at: " + ft + " and repeat: " + trigger.getRepeatCount() + " times, every " + trigger.getRepeatInterval() / 1000L + " seconds");
        log.info("------- Starting Scheduler ----------------");
        sched.start();
        log.info("------- Started Scheduler -----------------");
        try {
            Thread.sleep(600000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        log.info("------- Shutting Down ---------------------");
        sched.shutdown(true);
        log.info("------- Shutdown Complete -----------------");
        SchedulerMetaData metaData = sched.getMetaData();
        log.info("Executed " + metaData.getNumberOfJobsExecuted() + " jobs.");
    }

    public static void main(String[] args) throws Exception {
        MisfireExample example = new MisfireExample();
        example.run();
    }
}

