/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.examples.example9;

import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.examples.example9.Job1Listener;
import org.quartz.examples.example9.SimpleJob1;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerExample {
    public void run() throws Exception {
        Logger log = LoggerFactory.getLogger(ListenerExample.class);
        log.info("------- Initializing ----------------------");
        StdSchedulerFactory sf = new StdSchedulerFactory();
        Scheduler sched = sf.getScheduler();
        log.info("------- Initialization Complete -----------");
        log.info("------- Scheduling Jobs -------------------");
        JobDetail job = JobBuilder.newJob(SimpleJob1.class).withIdentity("job1").build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger1").startNow().build();
        Job1Listener listener = new Job1Listener();
        KeyMatcher matcher = KeyMatcher.keyEquals((Key)job.getKey());
        sched.getListenerManager().addJobListener((JobListener)listener, (Matcher)matcher);
        sched.scheduleJob(job, trigger);
        log.info("------- Starting Scheduler ----------------");
        sched.start();
        log.info("------- Waiting 30 seconds... --------------");
        try {
            Thread.sleep(30000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        log.info("------- Shutting Down ---------------------");
        sched.shutdown(true);
        log.info("------- Shutdown Complete -----------------");
        SchedulerMetaData metaData = sched.getMetaData();
        log.info("Executed " + metaData.getNumberOfJobsExecuted() + " jobs.");
    }

    public static void main(String[] args) throws Exception {
        ListenerExample example = new ListenerExample();
        example.run();
    }
}

