/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.org.objectweb.asm;

import com.sun.xml.internal.ws.org.objectweb.asm.AnnotationVisitor;
import com.sun.xml.internal.ws.org.objectweb.asm.ByteVector;
import com.sun.xml.internal.ws.org.objectweb.asm.ClassWriter;
import com.sun.xml.internal.ws.org.objectweb.asm.Item;
import com.sun.xml.internal.ws.org.objectweb.asm.Type;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;

final class AnnotationWriter
extends h
implements AnnotationVisitor {
    private final ClassWriter cw;
    private int size;
    private final boolean named;
    private final ByteVector bv;
    private final ByteVector parent;
    private final int offset;
    AnnotationWriter next;
    AnnotationWriter prev;

    AnnotationWriter(ClassWriter cw, boolean named, ByteVector bv, ByteVector parent, int offset) {
        this.cw = cw;
        this.named = named;
        this.bv = bv;
        this.parent = parent;
        this.offset = offset;
    }

    public void visit(String name, Object value) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name));
        }
        if (value instanceof String) {
            this.bv.put12(115, this.cw.newUTF8((String)value));
        } else if (value instanceof Byte) {
            this.bv.put12(66, this.cw.newInteger((int)((Byte)value).byteValue()).index);
        } else if (value instanceof Boolean) {
            int v = (Boolean)value != false ? 1 : 0;
            this.bv.put12(90, this.cw.newInteger((int)v).index);
        } else if (value instanceof Character) {
            this.bv.put12(67, this.cw.newInteger((int)((Character)value).charValue()).index);
        } else if (g.convertForInstanceOf((Object)value, Short.class) instanceof Short) {
            this.bv.put12(83, this.cw.newInteger((int)((Short)g.convertForCast((Object)value, Short.class)).shortValue()).index);
        } else if (g.convertForInstanceOf((Object)value, Type.class) instanceof Type) {
            this.bv.put12(99, this.cw.newUTF8(((Type)((Object)g.convertForCast((Object)value, Type.class))).getDescriptor()));
        } else if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(66, this.cw.newInteger((int)v[i]).index);
            }
        } else if (value instanceof boolean[]) {
            boolean[] v = (boolean[])value;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(90, this.cw.newInteger((int)(v[i] ? 1 : 0)).index);
            }
        } else if (value instanceof short[]) {
            short[] v = (short[])value;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(83, this.cw.newInteger((int)v[i]).index);
            }
        } else if (value instanceof char[]) {
            char[] v = (char[])value;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(67, this.cw.newInteger((int)v[i]).index);
            }
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(73, this.cw.newInteger((int)v[i]).index);
            }
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(74, this.cw.newLong((long)v[i]).index);
            }
        } else if (value instanceof float[]) {
            float[] v = (float[])value;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(70, this.cw.newFloat((float)v[i]).index);
            }
        } else if (value instanceof double[]) {
            double[] v = (double[])value;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(68, this.cw.newDouble((double)v[i]).index);
            }
        } else {
            Item i = this.cw.newConstItem(value);
            this.bv.put12(".s.IFJDCS".charAt(i.type), i.index);
        }
    }

    public void visitEnum(String name, String desc, String value) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name));
        }
        this.bv.put12(101, this.cw.newUTF8(desc)).putShort(this.cw.newUTF8(value));
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name));
        }
        this.bv.put12(64, this.cw.newUTF8(desc)).putShort(0);
        return new AnnotationWriter(this.cw, true, this.bv, this.bv, ByteVector._jr$ig$length((Object)this.bv) - 2);
    }

    public AnnotationVisitor visitArray(String name) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name));
        }
        this.bv.put12(91, 0);
        return new AnnotationWriter(this.cw, false, this.bv, this.bv, ByteVector._jr$ig$length((Object)this.bv) - 2);
    }

    public void visitEnd() {
        if (this.parent != null) {
            byte[] data = ByteVector._jr$ig$data((Object)this.parent);
            data[this.offset] = (byte)(this.size >>> 8);
            data[this.offset + 1] = (byte)this.size;
        }
    }

    int getSize() {
        int size = 0;
        AnnotationWriter aw = this;
        while (aw != null) {
            size += ByteVector._jr$ig$length((Object)aw.bv);
            aw = aw.next;
        }
        return size;
    }

    void put(ByteVector out) {
        int n2 = 0;
        int size = 2;
        AnnotationWriter aw = this;
        AnnotationWriter last = null;
        while (aw != null) {
            ++n2;
            size += ByteVector._jr$ig$length((Object)aw.bv);
            aw.visitEnd();
            aw.prev = last;
            last = aw;
            aw = aw.next;
        }
        out.putInt(size);
        out.putShort(n2);
        aw = last;
        while (aw != null) {
            out.putByteArray(ByteVector._jr$ig$data((Object)aw.bv), 0, ByteVector._jr$ig$length((Object)aw.bv));
            aw = aw.prev;
        }
    }

    static void put(AnnotationWriter[] panns, int off, ByteVector out) {
        int i;
        int size = 1 + 2 * (panns.length - off);
        for (i = off; i < panns.length; ++i) {
            size += panns[i] == null ? 0 : panns[i].getSize();
        }
        out.putInt(size).putByte(panns.length - off);
        for (i = off; i < panns.length; ++i) {
            AnnotationWriter aw = panns[i];
            AnnotationWriter last = null;
            int n2 = 0;
            while (aw != null) {
                ++n2;
                aw.visitEnd();
                aw.prev = last;
                last = aw;
                aw = aw.next;
            }
            out.putShort(n2);
            aw = last;
            while (aw != null) {
                out.putByteArray(ByteVector._jr$ig$data((Object)aw.bv), 0, ByteVector._jr$ig$length((Object)aw.bv));
                aw = aw.prev;
            }
        }
    }

    private static /* synthetic */ ClassWriter _jr$ig$cw(AnnotationWriter annotationWriter) {
        return annotationWriter.cw;
    }

    private static /* synthetic */ void _jr$ip$cw(AnnotationWriter annotationWriter, ClassWriter classWriter) {
        annotationWriter.cw = classWriter;
    }

    private static /* synthetic */ int _jr$ig$size(AnnotationWriter annotationWriter) {
        return annotationWriter.size;
    }

    private static /* synthetic */ void _jr$ip$size(AnnotationWriter annotationWriter, int n2) {
        annotationWriter.size = n2;
    }

    private static /* synthetic */ boolean _jr$ig$named(AnnotationWriter annotationWriter) {
        return annotationWriter.named;
    }

    private static /* synthetic */ void _jr$ip$named(AnnotationWriter annotationWriter, boolean bl) {
        annotationWriter.named = bl;
    }

    private static /* synthetic */ ByteVector _jr$ig$bv(AnnotationWriter annotationWriter) {
        return annotationWriter.bv;
    }

    private static /* synthetic */ void _jr$ip$bv(AnnotationWriter annotationWriter, ByteVector byteVector) {
        annotationWriter.bv = byteVector;
    }

    private static /* synthetic */ ByteVector _jr$ig$parent(AnnotationWriter annotationWriter) {
        return annotationWriter.parent;
    }

    private static /* synthetic */ void _jr$ip$parent(AnnotationWriter annotationWriter, ByteVector byteVector) {
        annotationWriter.parent = byteVector;
    }

    private static /* synthetic */ int _jr$ig$offset(AnnotationWriter annotationWriter) {
        return annotationWriter.offset;
    }

    private static /* synthetic */ void _jr$ip$offset(AnnotationWriter annotationWriter, int n2) {
        annotationWriter.offset = n2;
    }

    static /* synthetic */ AnnotationWriter _jr$ig$next(Object object) {
        return ((AnnotationWriter)((Object)object)).next;
    }

    static /* synthetic */ void _jr$ip$next(Object object, AnnotationWriter annotationWriter) {
        ((AnnotationWriter)((Object)object)).next = annotationWriter;
    }

    static /* synthetic */ AnnotationWriter _jr$ig$prev(Object object) {
        return ((AnnotationWriter)((Object)object)).prev;
    }

    static /* synthetic */ void _jr$ip$prev(Object object, AnnotationWriter annotationWriter) {
        ((AnnotationWriter)((Object)object)).prev = annotationWriter;
    }
}

