/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class BufferedInputStream
extends FilterInputStream {
    private static int defaultBufferSize = 8192;
    protected volatile byte[] buf;
    private static final AtomicReferenceFieldUpdater<BufferedInputStream, byte[]> bufUpdater = AtomicReferenceFieldUpdater.newUpdater(BufferedInputStream.class, byte[].class, "buf");
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;

    private InputStream getInIfOpen() throws IOException {
        InputStream inputStream = BufferedInputStream._jr$ig$in(this);
        if (inputStream == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
        return inputStream;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] byArray = ((BufferedInputStream)this).buf;
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
        return byArray;
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, defaultBufferSize);
    }

    public BufferedInputStream(InputStream inputStream, int n2) {
        super(inputStream);
        this.markpos = -1;
        if (n2 <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Buffer size <= 0"));
        }
        this.buf = new byte[n2];
    }

    private void fill() throws IOException {
        int n2;
        byte[] byArray = this.getBufIfOpen();
        if (((BufferedInputStream)this).markpos < 0) {
            ((BufferedInputStream)this).pos = 0;
        } else if (((BufferedInputStream)this).pos >= byArray.length) {
            if (((BufferedInputStream)this).markpos > 0) {
                n2 = ((BufferedInputStream)this).pos - ((BufferedInputStream)this).markpos;
                a.arraycopy((Object)byArray, (int)((BufferedInputStream)this).markpos, (Object)byArray, (int)0, (int)n2);
                ((BufferedInputStream)this).pos = n2;
                ((BufferedInputStream)this).markpos = 0;
            } else if (byArray.length >= ((BufferedInputStream)this).marklimit) {
                ((BufferedInputStream)this).markpos = -1;
                ((BufferedInputStream)this).pos = 0;
            } else {
                n2 = ((BufferedInputStream)this).pos * 2;
                if (n2 > ((BufferedInputStream)this).marklimit) {
                    n2 = ((BufferedInputStream)this).marklimit;
                }
                byte[] byArray2 = new byte[n2];
                a.arraycopy((Object)byArray, (int)0, (Object)byArray2, (int)0, (int)((BufferedInputStream)this).pos);
                if (!bufUpdater.compareAndSet(this, byArray, byArray2)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
                }
                byArray = byArray2;
            }
        }
        ((BufferedInputStream)this).count = ((BufferedInputStream)this).pos;
        n2 = this.getInIfOpen().read(byArray, ((BufferedInputStream)this).pos, byArray.length - ((BufferedInputStream)this).pos);
        if (n2 > 0) {
            ((BufferedInputStream)this).count = n2 + ((BufferedInputStream)this).pos;
        }
    }

    @Override
    @af(modifiers=33)
    public int read() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((BufferedInputStream)this).pos >= ((BufferedInputStream)this).count) {
                    this.fill();
                    if (((BufferedInputStream)this).pos >= ((BufferedInputStream)this).count) {
                        return -1;
                    }
                }
                byte[] byArray = this.getBufIfOpen();
                BufferedInputStream bufferedInputStream = this;
                int n2 = ((BufferedInputStream)bufferedInputStream).pos;
                ((BufferedInputStream)bufferedInputStream).pos = n2 + 1;
                return byArray[n2] & 0xFF;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private int read1(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = ((BufferedInputStream)this).count - ((BufferedInputStream)this).pos;
        if (n4 <= 0) {
            if (n3 >= this.getBufIfOpen().length && ((BufferedInputStream)this).markpos < 0) {
                return this.getInIfOpen().read(byArray, n2, n3);
            }
            this.fill();
            n4 = ((BufferedInputStream)this).count - ((BufferedInputStream)this).pos;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = n4 < n3 ? n4 : n3;
        a.arraycopy((Object)this.getBufIfOpen(), (int)((BufferedInputStream)this).pos, (Object)byArray, (int)n2, (int)n5);
        BufferedInputStream bufferedInputStream = this;
        ((BufferedInputStream)bufferedInputStream).pos = ((BufferedInputStream)bufferedInputStream).pos + n5;
        return n5;
    }

    @Override
    @af(modifiers=33)
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                InputStream inputStream;
                this.getBufIfOpen();
                if ((n2 | n3 | n2 + n3 | byArray.length - (n2 + n3)) < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                if (n3 == 0) {
                    return 0;
                }
                int n4 = 0;
                do {
                    int n5;
                    if ((n5 = this.read1(byArray, n2 + n4, n3 - n4)) <= 0) {
                        return n4 == 0 ? n5 : n4;
                    }
                    if ((n4 += n5) < n3) continue;
                    return n4;
                } while ((inputStream = BufferedInputStream._jr$ig$in(this)) == null || inputStream.available() > 0);
                return n4;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public long skip(long l2) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.getBufIfOpen();
                if (l2 <= 0L) {
                    return 0L;
                }
                long l3 = ((BufferedInputStream)this).count - ((BufferedInputStream)this).pos;
                if (l3 <= 0L) {
                    if (((BufferedInputStream)this).markpos < 0) {
                        return this.getInIfOpen().skip(l2);
                    }
                    this.fill();
                    l3 = ((BufferedInputStream)this).count - ((BufferedInputStream)this).pos;
                    if (l3 <= 0L) {
                        return 0L;
                    }
                }
                long l4 = l3 < l2 ? l3 : l2;
                BufferedInputStream bufferedInputStream = this;
                ((BufferedInputStream)bufferedInputStream).pos = (int)((long)((BufferedInputStream)bufferedInputStream).pos + l4);
                return l4;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public int available() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                int n2 = ((BufferedInputStream)this).count - ((BufferedInputStream)this).pos;
                int n3 = this.getInIfOpen().available();
                return n2 > Integer.MAX_VALUE - n3 ? Integer.MAX_VALUE : n2 + n3;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void mark(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                ((BufferedInputStream)this).marklimit = n2;
                ((BufferedInputStream)this).markpos = ((BufferedInputStream)this).pos;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void reset() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.getBufIfOpen();
                if (((BufferedInputStream)this).markpos < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Resetting to invalid mark"));
                }
                ((BufferedInputStream)this).pos = ((BufferedInputStream)this).markpos;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        byte[] byArray;
        while ((byArray = ((BufferedInputStream)this).buf) != null) {
            if (!bufUpdater.compareAndSet(this, byArray, null)) continue;
            InputStream inputStream = BufferedInputStream._jr$ig$in(this);
            BufferedInputStream._jr$ip$in(this, null);
            if (inputStream != null) {
                inputStream.close();
            }
            return;
        }
    }

    protected static /* synthetic */ void _jr$ip$buf(Object object, byte[] byArray) {
        ((BufferedInputStream)object).buf = byArray;
    }

    protected /* synthetic */ BufferedInputStream(h h2) {
        super(h2);
    }
}

