/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar;
    private int readAheadLimit;
    private boolean skipLF;
    private boolean markedSkipLF;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    public BufferedReader(Reader reader, int n) {
        super((Object)reader);
        this.markedChar = -1;
        this.readAheadLimit = 0;
        this.skipLF = false;
        this.markedSkipLF = false;
        if (n <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Buffer size <= 0"));
        }
        this.in = reader;
        this.cb = new char[n];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public BufferedReader(Reader reader) {
        this(reader, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.nextChar - this.markedChar;
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    a.arraycopy((Object)this.cb, (int)this.markedChar, (Object)this.cb, (int)0, (int)n);
                    this.markedChar = 0;
                    n2 = n;
                } else {
                    char[] cArray = new char[this.readAheadLimit];
                    a.arraycopy((Object)this.cb, (int)this.markedChar, (Object)cArray, (int)0, (int)n);
                    this.cb = cArray;
                    this.markedChar = 0;
                    n2 = n;
                }
                int n3 = n;
                this.nChars = n3;
                this.nextChar = n3;
            }
        }
        while ((n = this.in.read(this.cb, n2, this.cb.length - n2)) == 0) {
        }
        if (n > 0) {
            this.nChars = n2 + n;
            this.nextChar = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = ah.getMonitor((Object)BufferedReader._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                while (true) {
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                        if (this.nextChar >= this.nChars) {
                            return -1;
                        }
                    }
                    if (!this.skipLF) break;
                    this.skipLF = false;
                    if (this.cb[this.nextChar] != '\n') break;
                    BufferedReader bufferedReader = this;
                    bufferedReader.nextChar = bufferedReader.nextChar + 1;
                }
                char[] cArray = this.cb;
                BufferedReader bufferedReader = this;
                int n = bufferedReader.nextChar;
                bufferedReader.nextChar = n + 1;
                return cArray[n];
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private int read1(char[] cArray, int n, int n2) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (n2 >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
                return this.in.read(cArray, n, n2);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.cb[this.nextChar] == '\n') {
                BufferedReader bufferedReader = this;
                bufferedReader.nextChar = bufferedReader.nextChar + 1;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n3 = Math.min(n2, this.nChars - this.nextChar);
        a.arraycopy((Object)this.cb, (int)this.nextChar, (Object)cArray, (int)n, (int)n3);
        BufferedReader bufferedReader = this;
        bufferedReader.nextChar = bufferedReader.nextChar + n3;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = ah.getMonitor((Object)BufferedReader._jr$ig$lock(this));
        synchronized (object) {
            try {
                int n3;
                this.ensureOpen();
                if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                if (n2 == 0) {
                    return 0;
                }
                int n4 = this.read1(cArray, n, n2);
                if (n4 <= 0) {
                    return n4;
                }
                while (n4 < n2 && this.in.ready() && (n3 = this.read1(cArray, n + n4, n2 - n4)) > 0) {
                    n4 += n3;
                }
                return n4;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    String readLine(boolean bl) throws IOException {
        StringBuffer stringBuffer = null;
        Object object = ah.getMonitor((Object)BufferedReader._jr$ig$lock(this));
        synchronized (object) {
            try {
                boolean bl2;
                this.ensureOpen();
                boolean bl3 = bl2 = bl || this.skipLF;
                while (true) {
                    int n;
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.nextChar >= this.nChars) {
                        if (stringBuffer != null && stringBuffer.length() > 0) {
                            return stringBuffer.toString();
                        }
                        return null;
                    }
                    boolean bl4 = false;
                    char c = '\u0000';
                    if (bl2 && this.cb[this.nextChar] == '\n') {
                        BufferedReader bufferedReader = this;
                        bufferedReader.nextChar = bufferedReader.nextChar + 1;
                    }
                    this.skipLF = false;
                    bl2 = false;
                    for (n = this.nextChar; n < this.nChars; ++n) {
                        c = this.cb[n];
                        if (c != '\n' && c != '\r') continue;
                        bl4 = true;
                        break;
                    }
                    int n2 = this.nextChar;
                    this.nextChar = n;
                    if (bl4) {
                        String string;
                        if (stringBuffer == null) {
                            string = new String(this.cb, n2, n - n2);
                        } else {
                            stringBuffer.append(this.cb, n2, n - n2);
                            string = stringBuffer.toString();
                        }
                        BufferedReader bufferedReader = this;
                        bufferedReader.nextChar = bufferedReader.nextChar + 1;
                        if (c == '\r') {
                            this.skipLF = true;
                        }
                        return string;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(defaultExpectedLineLength);
                    }
                    stringBuffer.append(this.cb, n2, n - n2);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("skip value is negative"));
        }
        Object object = ah.getMonitor((Object)BufferedReader._jr$ig$lock(this));
        synchronized (object) {
            try {
                long l2;
                long l3;
                this.ensureOpen();
                for (l2 = l; l2 > 0L; l2 -= l3) {
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.nextChar >= this.nChars) break;
                    if (this.skipLF) {
                        this.skipLF = false;
                        if (this.cb[this.nextChar] == '\n') {
                            BufferedReader bufferedReader = this;
                            bufferedReader.nextChar = bufferedReader.nextChar + 1;
                        }
                    }
                    if (l2 <= (l3 = (long)(this.nChars - this.nextChar))) {
                        BufferedReader bufferedReader = this;
                        bufferedReader.nextChar = (int)((long)bufferedReader.nextChar + l2);
                        l2 = 0L;
                        break;
                    }
                    this.nextChar = this.nChars;
                }
                return l - l2;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = ah.getMonitor((Object)BufferedReader._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                if (this.skipLF) {
                    if (this.nextChar >= this.nChars && this.in.ready()) {
                        this.fill();
                    }
                    if (this.nextChar < this.nChars) {
                        if (this.cb[this.nextChar] == '\n') {
                            BufferedReader bufferedReader = this;
                            bufferedReader.nextChar = bufferedReader.nextChar + 1;
                        }
                        this.skipLF = false;
                    }
                }
                return this.nextChar < this.nChars || this.in.ready();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Read-ahead limit < 0"));
        }
        Object object = ah.getMonitor((Object)BufferedReader._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                this.readAheadLimit = n;
                this.markedChar = this.nextChar;
                this.markedSkipLF = this.skipLF;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = ah.getMonitor((Object)BufferedReader._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                if (this.markedChar < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked"));
                }
                this.nextChar = this.markedChar;
                this.skipLF = this.markedSkipLF;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = ah.getMonitor((Object)BufferedReader._jr$ig$lock(this));
        synchronized (object) {
            try {
                if (this.in == null) {
                    return;
                }
                this.in.close();
                this.in = null;
                this.cb = null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    protected /* synthetic */ BufferedReader(h h2) {
        super(h2);
    }
}

