/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class BufferedWriter
extends Writer {
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;
    private String lineSeparator;

    public BufferedWriter(Writer writer) {
        this(writer, defaultCharBufferSize);
    }

    public BufferedWriter(Writer writer, int n) {
        super((Object)writer);
        if (n <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Buffer size <= 0"));
        }
        this.out = writer;
        this.cb = new char[n];
        this.nChars = n;
        this.nextChar = 0;
        this.lineSeparator = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = ah.getMonitor((Object)BufferedWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                if (this.nextChar == 0) {
                    return;
                }
                this.out.write(this.cb, 0, this.nextChar);
                this.nextChar = 0;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = ah.getMonitor((Object)BufferedWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.ensureOpen();
                if (this.nextChar >= this.nChars) {
                    this.flushBuffer();
                }
                char[] cArray = this.cb;
                BufferedWriter bufferedWriter = this;
                int n2 = bufferedWriter.nextChar;
                bufferedWriter.nextChar = n2 + 1;
                cArray[n2] = (char)n;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = ah.getMonitor((Object)BufferedWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                int n3;
                this.ensureOpen();
                if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                if (n2 == 0) {
                    return;
                }
                if (n2 >= this.nChars) {
                    this.flushBuffer();
                    this.out.write(cArray, n, n2);
                    return;
                }
                int n4 = n + n2;
                for (int i = n; i < n4; i += n3) {
                    n3 = this.min(this.nChars - this.nextChar, n4 - i);
                    a.arraycopy((Object)cArray, (int)i, (Object)this.cb, (int)this.nextChar, (int)n3);
                    BufferedWriter bufferedWriter = this;
                    bufferedWriter.nextChar = bufferedWriter.nextChar + n3;
                    if (this.nextChar < this.nChars) continue;
                    this.flushBuffer();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        Object object = ah.getMonitor((Object)BufferedWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                int n3;
                this.ensureOpen();
                int n4 = n + n2;
                for (int i = n; i < n4; i += n3) {
                    n3 = this.min(this.nChars - this.nextChar, n4 - i);
                    string.getChars(i, i + n3, this.cb, this.nextChar);
                    BufferedWriter bufferedWriter = this;
                    bufferedWriter.nextChar = bufferedWriter.nextChar + n3;
                    if (this.nextChar < this.nChars) continue;
                    this.flushBuffer();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = ah.getMonitor((Object)BufferedWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.flushBuffer();
                this.out.flush();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = ah.getMonitor((Object)BufferedWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                if (this.out == null) {
                    return;
                }
                try {
                    this.flushBuffer();
                }
                catch (Throwable throwable) {
                    this.out.close();
                    this.out = null;
                    this.cb = null;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                this.out.close();
                this.out = null;
                this.cb = null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private static /* synthetic */ void _jr$ip$nChars(BufferedWriter bufferedWriter, int n) {
        bufferedWriter.nChars = n;
    }

    private static /* synthetic */ void _jr$ip$lineSeparator(BufferedWriter bufferedWriter, String string) {
        bufferedWriter.lineSeparator = string;
    }

    protected /* synthetic */ BufferedWriter(h h2) {
        super(h2);
    }
}

