/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative initial size: " + n2));
        }
        this.buf = new byte[n2];
    }

    private void ensureCapacity(int n2) {
        if (n2 - ((ByteArrayOutputStream)this).buf.length > 0) {
            this.grow(n2);
        }
    }

    private void grow(int n2) {
        int n3 = ((ByteArrayOutputStream)this).buf.length;
        int n4 = n3 << 1;
        if (n4 - n2 < 0) {
            n4 = n2;
        }
        if (n4 < 0) {
            if (n2 < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new OutOfMemoryError());
            }
            n4 = Integer.MAX_VALUE;
        }
        ((ByteArrayOutputStream)this).buf = Arrays.copyOf(((ByteArrayOutputStream)this).buf, n4);
    }

    @Override
    @af(modifiers=33)
    public void write(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.ensureCapacity(((ByteArrayOutputStream)this).count + 1);
                ((ByteArrayOutputStream)((Object)this)).buf[((ByteArrayOutputStream)((Object)this)).count] = (byte)n2;
                ByteArrayOutputStream byteArrayOutputStream = this;
                ((ByteArrayOutputStream)byteArrayOutputStream).count = ((ByteArrayOutputStream)byteArrayOutputStream).count + 1;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void write(byte[] byArray, int n2, int n3) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 - byArray.length > 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                this.ensureCapacity(((ByteArrayOutputStream)this).count + n3);
                a.arraycopy((Object)byArray, (int)n2, (Object)((ByteArrayOutputStream)this).buf, (int)((ByteArrayOutputStream)this).count, (int)n3);
                ByteArrayOutputStream byteArrayOutputStream = this;
                ((ByteArrayOutputStream)byteArrayOutputStream).count = ((ByteArrayOutputStream)byteArrayOutputStream).count + n3;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public void writeTo(OutputStream outputStream) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                outputStream.write(((ByteArrayOutputStream)this).buf, 0, ((ByteArrayOutputStream)this).count);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public void reset() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                ((ByteArrayOutputStream)this).count = 0;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public byte[] toByteArray() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return Arrays.copyOf(((ByteArrayOutputStream)this).buf, ((ByteArrayOutputStream)this).count);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public int size() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return ((ByteArrayOutputStream)this).count;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public String toString() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return new String(((ByteArrayOutputStream)this).buf, 0, ((ByteArrayOutputStream)this).count);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public String toString(String string) throws UnsupportedEncodingException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return new String(((ByteArrayOutputStream)this).buf, 0, ((ByteArrayOutputStream)this).count, string);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Deprecated
    @af(modifiers=33)
    public String toString(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return new String(((ByteArrayOutputStream)this).buf, n2, 0, ((ByteArrayOutputStream)this).count);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    protected /* synthetic */ ByteArrayOutputStream(h h2) {
        super(h2);
    }
}

