/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;
    private byte[] bytearr;
    private byte[] writeBuffer;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.bytearr = null;
        this.writeBuffer = new byte[8];
    }

    private void incCount(int n2) {
        int n3 = ((DataOutputStream)this).written + n2;
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        }
        ((DataOutputStream)this).written = n3;
    }

    @Override
    @af(modifiers=33)
    public void write(int n2) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                DataOutputStream._jr$ig$out(this).write(n2);
                this.incCount(1);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                DataOutputStream._jr$ig$out(this).write(byArray, n2, n3);
                this.incCount(n3);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        DataOutputStream._jr$ig$out(this).flush();
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        DataOutputStream._jr$ig$out(this).write(bl ? 1 : 0);
        this.incCount(1);
    }

    @Override
    public final void writeByte(int n2) throws IOException {
        DataOutputStream._jr$ig$out(this).write(n2);
        this.incCount(1);
    }

    @Override
    public final void writeShort(int n2) throws IOException {
        DataOutputStream._jr$ig$out(this).write(n2 >>> 8 & 0xFF);
        DataOutputStream._jr$ig$out(this).write(n2 >>> 0 & 0xFF);
        this.incCount(2);
    }

    @Override
    public final void writeChar(int n2) throws IOException {
        DataOutputStream._jr$ig$out(this).write(n2 >>> 8 & 0xFF);
        DataOutputStream._jr$ig$out(this).write(n2 >>> 0 & 0xFF);
        this.incCount(2);
    }

    @Override
    public final void writeInt(int n2) throws IOException {
        DataOutputStream._jr$ig$out(this).write(n2 >>> 24 & 0xFF);
        DataOutputStream._jr$ig$out(this).write(n2 >>> 16 & 0xFF);
        DataOutputStream._jr$ig$out(this).write(n2 >>> 8 & 0xFF);
        DataOutputStream._jr$ig$out(this).write(n2 >>> 0 & 0xFF);
        this.incCount(4);
    }

    @Override
    public final void writeLong(long l2) throws IOException {
        ((DataOutputStream)this).writeBuffer[0] = (byte)(l2 >>> 56);
        ((DataOutputStream)this).writeBuffer[1] = (byte)(l2 >>> 48);
        ((DataOutputStream)this).writeBuffer[2] = (byte)(l2 >>> 40);
        ((DataOutputStream)this).writeBuffer[3] = (byte)(l2 >>> 32);
        ((DataOutputStream)this).writeBuffer[4] = (byte)(l2 >>> 24);
        ((DataOutputStream)this).writeBuffer[5] = (byte)(l2 >>> 16);
        ((DataOutputStream)this).writeBuffer[6] = (byte)(l2 >>> 8);
        ((DataOutputStream)this).writeBuffer[7] = (byte)(l2 >>> 0);
        DataOutputStream._jr$ig$out(this).write(this.writeBuffer, 0, 8);
        this.incCount(8);
    }

    @Override
    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            DataOutputStream._jr$ig$out(this).write((byte)string.charAt(i));
        }
        this.incCount(n2);
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            DataOutputStream._jr$ig$out(this).write(c2 >>> 8 & 0xFF);
            DataOutputStream._jr$ig$out(this).write(c2 >>> 0 & 0xFF);
        }
        this.incCount(n2 * 2);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    static int writeUTF(String string, DataOutput dataOutput) throws IOException {
        char c2;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            c2 = string.charAt(i);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n3;
                continue;
            }
            if (c2 > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException("encoded string too long: " + n3 + " bytes"));
        }
        byte[] byArray = null;
        if (g.convertForInstanceOf((Object)dataOutput, DataOutputStream.class) instanceof DataOutputStream) {
            DataOutputStream dataOutputStream = (DataOutputStream)g.convertForCast((Object)dataOutput, DataOutputStream.class);
            if (dataOutputStream.bytearr == null || dataOutputStream.bytearr.length < n3 + 2) {
                dataOutputStream.bytearr = new byte[n3 * 2 + 2];
            }
            byArray = dataOutputStream.bytearr;
        } else {
            byArray = new byte[n3 + 2];
        }
        byArray[n4++] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n4++] = (byte)(n3 >>> 0 & 0xFF);
        int n5 = 0;
        for (n5 = 0; n5 < n2 && (c2 = string.charAt(n5)) >= '\u0001' && c2 <= '\u007f'; ++n5) {
            byArray[n4++] = (byte)c2;
        }
        while (n5 < n2) {
            c2 = string.charAt(n5);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n4++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                byArray[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            }
            ++n5;
        }
        dataOutput.write(byArray, 0, n3 + 2);
        return n3 + 2;
    }

    public final int size() {
        return ((DataOutputStream)this).written;
    }

    private static /* synthetic */ void _jr$ip$writeBuffer(DataOutputStream dataOutputStream, byte[] byArray) {
        dataOutputStream.writeBuffer = byArray;
    }

    protected /* synthetic */ DataOutputStream(h h2) {
        super(h2);
    }
}

