/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ExpiringCache
extends h {
    private long millisUntilExpiration;
    private Map map;
    private int queryCount;
    private int queryOverflow;
    private int MAX_ENTRIES;

    ExpiringCache() {
        this(30000L);
    }

    ExpiringCache(long l) {
        this.queryOverflow = 300;
        this.MAX_ENTRIES = 200;
        this.millisUntilExpiration = l;
        this.map = new LinkedHashMap(this){
            final /* synthetic */ ExpiringCache this$0;
            {
                this.this$0 = expiringCache;
            }

            protected boolean removeEldestEntry(Map.Entry entry) {
                return this.size() > this.this$0.MAX_ENTRIES;
            }

            static /* synthetic */ ExpiringCache _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, ExpiringCache expiringCache) {
                (object).this$0 = expiringCache;
            }
        };
    }

    @af(modifiers=32)
    String get(String string) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                Entry entry;
                ExpiringCache expiringCache = this;
                int n2 = expiringCache.queryCount + 1;
                expiringCache.queryCount = n2;
                if (n2 >= this.queryOverflow) {
                    this.cleanup();
                }
                if ((entry = this.entryFor(string)) != null) {
                    return entry.val();
                }
                return null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=32)
    void put(String string, String string2) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                Entry entry;
                ExpiringCache expiringCache = this;
                int n2 = expiringCache.queryCount + 1;
                expiringCache.queryCount = n2;
                if (n2 >= this.queryOverflow) {
                    this.cleanup();
                }
                if ((entry = this.entryFor(string)) != null) {
                    entry.setTimestamp(System.currentTimeMillis());
                    entry.setVal(string2);
                } else {
                    this.map.put(string, new Entry(System.currentTimeMillis(), string2));
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=32)
    void clear() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.map.clear();
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private Entry entryFor(String string) {
        long l;
        Entry entry = (Entry)((Object)g.convertForCast(this.map.get(string), Entry.class));
        if (entry != null && ((l = System.currentTimeMillis() - entry.timestamp()) < 0L || l >= this.millisUntilExpiration)) {
            this.map.remove(string);
            entry = null;
        }
        return entry;
    }

    private void cleanup() {
        Set set = this.map.keySet();
        Object[] objectArray = new String[set.size()];
        int n2 = 0;
        for (String string : set) {
            a.arrayStore((Object[])objectArray, (int)n2++, (Object)string);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.entryFor((String)objectArray[i]);
        }
        this.queryCount = 0;
    }

    private static /* synthetic */ void _jr$ip$millisUntilExpiration(ExpiringCache expiringCache, long l) {
        expiringCache.millisUntilExpiration = l;
    }

    private static /* synthetic */ void _jr$ip$map(ExpiringCache expiringCache, Map map) {
        expiringCache.map = map;
    }

    private static /* synthetic */ void _jr$ip$queryOverflow(ExpiringCache expiringCache, int n2) {
        expiringCache.queryOverflow = n2;
    }

    private static /* synthetic */ void _jr$ip$MAX_ENTRIES(ExpiringCache expiringCache, int n2) {
        expiringCache.MAX_ENTRIES = n2;
    }

    protected /* synthetic */ ExpiringCache(h h2) {
        super(h2);
    }

    static class Entry
    extends h {
        private long timestamp;
        private String val;

        Entry(long l, String string) {
            this.timestamp = l;
            this.val = string;
        }

        long timestamp() {
            return this.timestamp;
        }

        void setTimestamp(long l) {
            this.timestamp = l;
        }

        String val() {
            return this.val;
        }

        void setVal(String string) {
            this.val = string;
        }

        protected /* synthetic */ Entry(h h2) {
            super(h2);
        }
    }
}

