/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import sun.misc.IoTrace;
import sun.nio.ch.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final String path;
    private FileChannel channel;
    private final Object closeLock;
    private volatile boolean closed;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();

    private static boolean isRunningFinalize() {
        Boolean bl = (Boolean)g.convertForCast(runningFinalize.get(), Boolean.class);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public FileInputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this.channel = null;
        this.closeLock = new Object();
        this.closed = false;
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (file.isInvalid()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileNotFoundException("Invalid file path"));
        }
        this.fd = new FileDescriptor();
        this.fd.incrementAndGetUseCount();
        this.path = string;
        this._jr$jnim$open(string);
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        this.channel = null;
        this.closeLock = new Object();
        this.closed = false;
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.path = null;
        this.fd.incrementAndGetUseCount();
    }

    private void _jr$jnim$open(String string) throws FileNotFoundException {
        ((FileInputStream)this._jr$gOrg()).open(string);
    }

    private native void open(String var1) throws FileNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = IoTrace.fileReadBegin((String)this.path);
        int n2 = 0;
        try {
            n2 = this._jr$jnim$read0();
            IoTrace.fileReadEnd((Object)object, (long)(n2 == -1 ? 0L : 1L));
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd((Object)object, (long)(n2 == -1 ? 0L : 1L));
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        return n2;
    }

    private int _jr$jnim$read0() throws IOException {
        return ((FileInputStream)this._jr$gOrg()).read0();
    }

    private native int read0() throws IOException;

    private int _jr$jnim$readBytes(byte[] byArray, int n2, int n3) throws IOException {
        return ((FileInputStream)this._jr$gOrg()).readBytes(byArray, n2, n3);
    }

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray) throws IOException {
        long l;
        Object object = IoTrace.fileReadBegin((String)this.path);
        int n2 = 0;
        try {
            n2 = this._jr$jnim$readBytes(byArray, 0, byArray.length);
            l = n2 == -1 ? 0L : (long)n2;
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd((Object)object, (long)(n2 == -1 ? 0L : (long)n2));
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        IoTrace.fileReadEnd((Object)object, (long)l);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        long l;
        Object object = IoTrace.fileReadBegin((String)this.path);
        int n4 = 0;
        try {
            n4 = this._jr$jnim$readBytes(byArray, n2, n3);
            l = n4 == -1 ? 0L : (long)n4;
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd((Object)object, (long)(n4 == -1 ? 0L : (long)n4));
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        IoTrace.fileReadEnd((Object)object, (long)l);
        return n4;
    }

    public long _jr$jnim$skip(long l) throws IOException {
        return ((FileInputStream)this._jr$gOrg()).skip(l);
    }

    @Override
    public native long skip(long var1) throws IOException;

    public int _jr$jnim$available() throws IOException {
        return ((FileInputStream)this._jr$gOrg()).available();
    }

    @Override
    public native int available() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int n2;
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        if (this.channel != null) {
            this.fd.decrementAndGetUseCount();
            this.channel.close();
        }
        if ((n2 = this.fd.decrementAndGetUseCount()) <= 0 || !FileInputStream.isRunningFinalize()) {
            this._jr$jnim$close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.channel == null) {
                    this.channel = FileChannelImpl.open(this.fd, this.path, true, false, this);
                    this.fd.incrementAndGetUseCount();
                }
                return this.channel;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private static native void initIDs();

    private void _jr$jnim$close0() throws IOException {
        ((FileInputStream)this._jr$gOrg()).close0();
    }

    private native void close0() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        if (!this._jr$iCur()) {
            return;
        }
        if (this.fd != null && f.ifAcmp((Object)((Object)this.fd), (Object)((Object)FileDescriptor.in))) {
            runningFinalize.set(Boolean.TRUE);
            try {
                this.close();
                runningFinalize.set(Boolean.FALSE);
            }
            catch (Throwable throwable) {
                runningFinalize.set(Boolean.FALSE);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    static {
        FileInputStream.initIDs();
    }

    private static /* synthetic */ void _jr$ip$fd(FileInputStream fileInputStream, FileDescriptor fileDescriptor) {
        fileInputStream.fd = fileDescriptor;
    }

    private static /* synthetic */ void _jr$ip$path(FileInputStream fileInputStream, String string) {
        fileInputStream.path = string;
    }

    private static /* synthetic */ void _jr$ip$closeLock(FileInputStream fileInputStream, Object object) {
        fileInputStream.closeLock = object;
    }

    protected /* synthetic */ FileInputStream(h h2) {
        super(h2);
    }
}

