/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import sun.misc.IoTrace;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final String path;
    private final boolean append;
    private FileChannel channel;
    private final Object closeLock;
    private volatile boolean closed;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();

    private static boolean isRunningFinalize() {
        Boolean bl = (Boolean)runningFinalize.get();
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        this(string != null ? new File(string) : null, bl);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        this.closeLock = new Object();
        this.closed = false;
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (file.isInvalid()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new FileNotFoundException("Invalid file path"));
        }
        this.fd = new FileDescriptor();
        this.append = bl;
        this.path = string;
        this.fd.incrementAndGetUseCount();
        this._jr$jnim$open(string, bl);
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        this.closeLock = new Object();
        this.closed = false;
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.path = null;
        this.append = false;
        this.fd.incrementAndGetUseCount();
    }

    private void _jr$jnim$open(String string, boolean bl) throws FileNotFoundException {
        ((FileOutputStream)this._jr$gOrg()).open(string, bl);
    }

    private native void open(String var1, boolean var2) throws FileNotFoundException;

    private void _jr$jnim$write(int n2, boolean bl) throws IOException {
        ((FileOutputStream)this._jr$gOrg()).write(n2, bl);
    }

    private native void write(int var1, boolean var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n2) throws IOException {
        Object object = IoTrace.fileWriteBegin((String)this.path);
        int n3 = 0;
        try {
            this._jr$jnim$write(n2, this.append);
            n3 = 1;
        }
        catch (Throwable throwable) {
            IoTrace.fileWriteEnd((Object)object, (long)n3);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        IoTrace.fileWriteEnd((Object)object, (long)n3);
    }

    private void _jr$jnim$writeBytes(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
        ((FileOutputStream)this._jr$gOrg()).writeBytes(byArray, n2, n3, bl);
    }

    private native void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray) throws IOException {
        Object object = IoTrace.fileWriteBegin((String)this.path);
        int n2 = 0;
        try {
            this._jr$jnim$writeBytes(byArray, 0, byArray.length, this.append);
            n2 = byArray.length;
        }
        catch (Throwable throwable) {
            IoTrace.fileWriteEnd((Object)object, (long)n2);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        IoTrace.fileWriteEnd((Object)object, (long)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Object object = IoTrace.fileWriteBegin((String)this.path);
        int n4 = 0;
        try {
            this._jr$jnim$writeBytes(byArray, n2, n3, this.append);
            n4 = n3;
        }
        catch (Throwable throwable) {
            IoTrace.fileWriteEnd((Object)object, (long)n4);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        IoTrace.fileWriteEnd((Object)object, (long)n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int n2;
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        if (this.channel != null) {
            this.fd.decrementAndGetUseCount();
            this.channel.close();
        }
        if ((n2 = this.fd.decrementAndGetUseCount()) <= 0 || !FileOutputStream.isRunningFinalize()) {
            this._jr$jnim$close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.channel == null) {
                    this.channel = FileChannelImpl.open(this.fd, this.path, false, true, this.append, this);
                    this.fd.incrementAndGetUseCount();
                }
                return this.channel;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        if (!this._jr$iCur()) {
            return;
        }
        if (this.fd != null) {
            if (!f.ifAcmp((Object)((Object)this.fd), (Object)((Object)FileDescriptor.out)) || !f.ifAcmp((Object)((Object)this.fd), (Object)((Object)FileDescriptor.err))) {
                this.flush();
            } else {
                runningFinalize.set(Boolean.TRUE);
                try {
                    this.close();
                    runningFinalize.set(Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    runningFinalize.set(Boolean.FALSE);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    private void _jr$jnim$close0() throws IOException {
        ((FileOutputStream)this._jr$gOrg()).close0();
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }

    private static /* synthetic */ void _jr$ip$fd(FileOutputStream fileOutputStream, FileDescriptor fileDescriptor) {
        fileOutputStream.fd = fileDescriptor;
    }

    private static /* synthetic */ void _jr$ip$path(FileOutputStream fileOutputStream, String string) {
        fileOutputStream.path = string;
    }

    private static /* synthetic */ void _jr$ip$append(FileOutputStream fileOutputStream, boolean bl) {
        fileOutputStream.append = bl;
    }

    private static /* synthetic */ void _jr$ip$closeLock(FileOutputStream fileOutputStream, Object object) {
        fileOutputStream.closeLock = object;
    }

    protected /* synthetic */ FileOutputStream(h h2) {
        super(h2);
    }
}

