/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.n;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.Bits;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.SerialCallbackContext;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.misc.VM;
import sun.reflect.misc.ReflectUtil;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker = new Object();
    private static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);
    private final BlockDataInputStream bin;
    private final ValidationList vlist;
    private int depth;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle;
    private boolean defaultDataEnd;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableResolve;
    private SerialCallbackContext curContext;

    public ObjectInputStream(InputStream inputStream) throws IOException {
        this.passHandle = -1;
        this.defaultDataEnd = false;
        this.verifySubclass();
        this.bin = new BlockDataInputStream(this, inputStream);
        this.handles = new HandleTable(10);
        this.vlist = new ValidationList();
        this.enableOverride = false;
        this.readStreamHeader();
        this.bin.setBlockDataMode(true);
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        this.passHandle = -1;
        this.defaultDataEnd = false;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bin = null;
        this.handles = null;
        this.vlist = null;
        this.enableOverride = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object readObject() throws IOException, ClassNotFoundException {
        Object object;
        if (this.enableOverride) {
            return this.readObjectOverride();
        }
        int n2 = this.passHandle;
        try {
            Object object2 = this.readObject0(false);
            this.handles.markDependency(n2, this.passHandle);
            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
            if (classNotFoundException != null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)classNotFoundException);
            }
            if (this.depth == 0) {
                this.vlist.doCallbacks();
            }
            object = object2;
        }
        catch (Throwable throwable) {
            this.passHandle = n2;
            if (this.closed && this.depth == 0) {
                this.clear();
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.passHandle = n2;
        if (this.closed && this.depth == 0) {
            this.clear();
        }
        return object;
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readUnshared() throws IOException, ClassNotFoundException {
        Object object;
        int n2 = this.passHandle;
        try {
            Object object2 = this.readObject0(true);
            this.handles.markDependency(n2, this.passHandle);
            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
            if (classNotFoundException != null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)classNotFoundException);
            }
            if (this.depth == 0) {
                this.vlist.doCallbacks();
            }
            object = object2;
        }
        catch (Throwable throwable) {
            this.passHandle = n2;
            if (this.closed && this.depth == 0) {
                this.clear();
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.passHandle = n2;
        if (this.closed && this.depth == 0) {
            this.clear();
        }
        return object;
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        ClassNotFoundException classNotFoundException;
        SerialCallbackContext serialCallbackContext = this.curContext;
        if (serialCallbackContext == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotActiveException("not in call to readObject"));
        }
        Object object = serialCallbackContext.getObj();
        ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
        this.bin.setBlockDataMode(false);
        this.defaultReadFields(object, objectStreamClass);
        this.bin.setBlockDataMode(true);
        if (!objectStreamClass.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        if ((classNotFoundException = this.handles.lookupException(this.passHandle)) != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)classNotFoundException);
        }
    }

    public GetField readFields() throws IOException, ClassNotFoundException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        if (serialCallbackContext == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotActiveException("not in call to readObject"));
        }
        Object object = serialCallbackContext.getObj();
        ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
        this.bin.setBlockDataMode(false);
        GetFieldImpl getFieldImpl = new GetFieldImpl(this, objectStreamClass);
        getFieldImpl.readFields();
        this.bin.setBlockDataMode(true);
        if (!objectStreamClass.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        return getFieldImpl;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n2) throws NotActiveException, InvalidObjectException {
        if (this.depth == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotActiveException("stream inactive"));
        }
        this.vlist.register(objectInputValidation, n2);
    }

    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        try {
            return com.zeroturnaround.jrebelbase.facade.h.getCurrentClass(Class.forName(string, false, ObjectInputStream.latestUserDefinedLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = primClasses.get(string);
            if (clazz != null) {
                return com.zeroturnaround.jrebelbase.facade.h.getCurrentClass(clazz);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)classNotFoundException);
        }
    }

    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = ObjectInputStream.latestUserDefinedLoader();
        ClassLoader classLoader2 = null;
        boolean bl = false;
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Class<?> clazz = Class.forName(stringArray[i], false, classLoader);
            if ((ai.getCurrentClass(clazz).getModifiers() & 1) == 0) {
                if (bl) {
                    if (f.ifAcmp((Object)((Object)classLoader2), (Object)((Object)clazz.getClassLoader()))) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalAccessError("conflicting non-public interface class loaders"));
                    }
                } else {
                    classLoader2 = clazz.getClassLoader();
                    bl = true;
                }
            }
            classArray[i] = clazz;
        }
        try {
            return Proxy.getProxyClass(bl ? classLoader2 : classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClassNotFoundException(null, illegalArgumentException));
        }
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl == this.enableResolve) {
            return bl;
        }
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableResolve = bl;
        return !this.enableResolve;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = this.bin.readShort();
        short s2 = this.bin.readShort();
        if (s != -21267 || s2 != 5) {
            Object[] objectArray = new Object[2];
            a.arrayStore((Object[])objectArray, (int)0, (Object)s);
            a.arrayStore((Object[])objectArray, (int)1, (Object)s2);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException(String.format("invalid stream header: %04X%04X", objectArray)));
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        objectStreamClass.readNonProxy(this);
        return objectStreamClass;
    }

    @Override
    public int read() throws IOException {
        return this.bin.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        int n4 = n2 + n3;
        if (n2 < 0 || n3 < 0 || n4 > byArray.length || n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        return this.bin.read(byArray, n2, n3, false);
    }

    @Override
    public int available() throws IOException {
        return this.bin.available();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.depth == 0) {
            this.clear();
        }
        this.bin.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.bin.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.bin.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.bin.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.bin.readChar();
    }

    @Override
    public short readShort() throws IOException {
        return this.bin.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.bin.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.bin.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.bin.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.bin.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.bin.readDouble();
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.bin.readFully(byArray, 0, byArray.length, false);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        if (n2 < 0 || n3 < 0 || n4 > byArray.length || n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        this.bin.readFully(byArray, n2, n3, false);
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        return this.bin.skipBytes(n2);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.bin.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.bin.readUTF();
    }

    private void verifySubclass() {
        Class<?> clazz = this.getClass();
        if (!f.ifAcmp(clazz, ObjectInputStream.class)) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        ObjectStreamClass.WeakClassKey weakClassKey = new ObjectStreamClass.WeakClassKey(clazz, Caches.subclassAuditsQueue);
        Boolean bl = (Boolean)Caches.subclassAudits.get((Object)weakClassKey);
        if (bl == null) {
            bl = ObjectInputStream.auditSubclass(clazz);
            Caches.subclassAudits.putIfAbsent(weakClassKey, bl);
        }
        if (bl.booleanValue()) {
            return;
        }
        securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class<?> clazz) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = clazz; cl != ObjectInputStream.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("readUnshared", null);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            cl.getDeclaredMethod("readFields", null);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return bl;
    }

    private void clear() {
        this.handles.clear();
        this.vlist.clear();
    }

    /*
     * Exception decompiling
     */
    private Object readObject0(boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object checkResolve(Object object) throws IOException {
        if (!this.enableResolve || this.handles.lookupException(this.passHandle) != null) {
            return object;
        }
        Object object2 = this.resolveObject(object);
        if (f.ifAcmp((Object)object2, (Object)object)) {
            this.handles.setObject(this.passHandle, object2);
        }
        return object2;
    }

    /*
     * Exception decompiling
     */
    String readTypeString() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object readNull() throws IOException {
        if (this.bin.readByte() != 112) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        this.passHandle = -1;
        return null;
    }

    private Object readHandle(boolean bl) throws IOException {
        if (this.bin.readByte() != 113) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        this.passHandle = this.bin.readInt() - 0x7E0000;
        if (this.passHandle < 0 || this.passHandle >= this.handles.size()) {
            Object[] objectArray = new Object[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)(this.passHandle + 0x7E0000));
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException(String.format("invalid handle value: %08X", objectArray)));
        }
        if (bl) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("cannot read back reference as unshared"));
        }
        Object object = this.handles.lookupObject(this.passHandle);
        if (!f.ifAcmp((Object)object, (Object)unsharedMarker)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("cannot read back reference to unshared object"));
        }
        return object;
    }

    private Class readClass(boolean bl) throws IOException {
        if (this.bin.readByte() != 118) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        Class<?> clazz = objectStreamClass.forClass();
        this.passHandle = this.handles.assign(bl ? ObjectInputStream.unsharedMarker : clazz);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(this.passHandle, classNotFoundException);
        }
        this.handles.finish(this.passHandle);
        return clazz;
    }

    private ObjectStreamClass readClassDesc(boolean bl) throws IOException {
        byte by = this.bin.peekByte();
        switch (by) {
            case 112: {
                return (ObjectStreamClass)g.convertForCast((Object)this.readNull(), ObjectStreamClass.class);
            }
            case 113: {
                return (ObjectStreamClass)g.convertForCast((Object)this.readHandle(bl), ObjectStreamClass.class);
            }
            case 125: {
                return this.readProxyDesc(bl);
            }
            case 114: {
                return this.readNonProxyDesc(bl);
            }
        }
        Object[] objectArray = new Object[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)by);
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException(String.format("invalid type code: %02X", objectArray)));
    }

    private boolean isCustomSubclass() {
        return f.ifAcmp((Object)((Object)this.getClass().getClassLoader()), (Object)((Object)ObjectInputStream.class.getClassLoader()));
    }

    private ObjectStreamClass readProxyDesc(boolean bl) throws IOException {
        if (this.bin.readByte() != 125) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        int n2 = this.handles.assign(bl ? unsharedMarker : objectStreamClass);
        this.passHandle = -1;
        int n3 = this.bin.readInt();
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = this.bin.readUTF();
        }
        Class<?> clazz = null;
        ClassNotFoundException classNotFoundException = null;
        this.bin.setBlockDataMode(true);
        try {
            clazz = this.resolveProxyClass(stringArray);
            if (clazz == null) {
                classNotFoundException = new ClassNotFoundException("null class");
            } else {
                if (!Proxy.isProxyClass(clazz)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException("Not a proxy"));
                }
                ReflectUtil.checkProxyPackageAccess(this.getClass().getClassLoader(), n.filterInterfaces((Class[])x.getInterfaces(clazz)));
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        this.skipCustomData();
        objectStreamClass.initProxy(clazz, classNotFoundException, this.readClassDesc(false));
        this.handles.finish(n2);
        this.passHandle = n2;
        return objectStreamClass;
    }

    private ObjectStreamClass readNonProxyDesc(boolean bl) throws IOException {
        if (this.bin.readByte() != 114) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        int n2 = this.handles.assign(bl ? unsharedMarker : objectStreamClass);
        this.passHandle = -1;
        ObjectStreamClass objectStreamClass2 = null;
        try {
            objectStreamClass2 = this.readClassDescriptor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new InvalidClassException("failed to read class descriptor").initCause(classNotFoundException), IOException.class)));
        }
        Class<?> clazz = null;
        ClassNotFoundException classNotFoundException = null;
        this.bin.setBlockDataMode(true);
        boolean bl2 = this.isCustomSubclass();
        try {
            clazz = this.resolveClass(objectStreamClass2);
            if (clazz == null) {
                classNotFoundException = new ClassNotFoundException("null class");
            } else if (bl2) {
                ReflectUtil.checkPackageAccess(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        this.skipCustomData();
        objectStreamClass.initNonProxy(objectStreamClass2, clazz, classNotFoundException, this.readClassDesc(false));
        this.handles.finish(n2);
        this.passHandle = n2;
        return objectStreamClass;
    }

    private String readString(boolean bl) throws IOException {
        String string;
        byte by = this.bin.readByte();
        switch (by) {
            case 116: {
                string = this.bin.readUTF();
                break;
            }
            case 124: {
                string = this.bin.readLongUTF();
                break;
            }
            default: {
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)by);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException(String.format("invalid type code: %02X", objectArray)));
            }
        }
        this.passHandle = this.handles.assign(bl ? ObjectInputStream.unsharedMarker : string);
        this.handles.finish(this.passHandle);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readArray(boolean bl) throws IOException {
        if (this.bin.readByte() != 117) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        int n2 = this.bin.readInt();
        Object object = null;
        Class<?> clazz = null;
        Class<?> clazz2 = objectStreamClass.forClass();
        if (clazz2 != null) {
            clazz = ai.getCurrentClass(clazz2).getComponentType();
            object = Array.newInstance(clazz, n2);
        }
        int n3 = this.handles.assign(bl ? unsharedMarker : object);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(n3, classNotFoundException);
        }
        if (clazz == null) {
            for (int i = 0; i < n2; ++i) {
                this.readObject0(false);
            }
        } else if (ai.getCurrentClass(clazz).isPrimitive()) {
            if (!f.ifAcmp(clazz, Integer.TYPE)) {
                this.bin.readInts((int[])object, 0, n2);
            } else if (!f.ifAcmp(clazz, Byte.TYPE)) {
                this.bin.readFully((byte[])object, 0, n2, true);
            } else if (!f.ifAcmp(clazz, Long.TYPE)) {
                this.bin.readLongs((long[])object, 0, n2);
            } else if (!f.ifAcmp(clazz, Float.TYPE)) {
                this.bin.readFloats((float[])object, 0, n2);
            } else if (!f.ifAcmp(clazz, Double.TYPE)) {
                this.bin.readDoubles((double[])object, 0, n2);
            } else if (!f.ifAcmp(clazz, Short.TYPE)) {
                this.bin.readShorts((short[])object, 0, n2);
            } else if (!f.ifAcmp(clazz, Character.TYPE)) {
                this.bin.readChars((char[])object, 0, n2);
            } else {
                if (f.ifAcmp(clazz, Boolean.TYPE)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                this.bin.readBooleans((boolean[])object, 0, n2);
            }
        } else {
            Object[] objectArray = (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)object, Object[].class)), Object[].class);
            for (int i = 0; i < n2; ++i) {
                a.arrayStore((Object[])objectArray, (int)i, (Object)this.readObject0(false));
                this.handles.markDependency(n3, this.passHandle);
            }
        }
        this.handles.finish(n3);
        this.passHandle = n3;
        return object;
    }

    private Enum readEnum(boolean bl) throws IOException {
        if (this.bin.readByte() != 126) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        if (!objectStreamClass.isEnum()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException("non-enum class: " + objectStreamClass));
        }
        int n2 = this.handles.assign(bl ? unsharedMarker : null);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(n2, classNotFoundException);
        }
        String string = this.readString(false);
        Enum enum_ = null;
        Class<?> clazz = objectStreamClass.forClass();
        if (clazz != null) {
            try {
                enum_ = (Enum)Enum.valueOf(clazz, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new InvalidObjectException("enum constant " + string + " does not exist in " + clazz).initCause(illegalArgumentException), IOException.class)));
            }
            if (!bl) {
                this.handles.setObject(n2, enum_);
            }
        }
        this.handles.finish(n2);
        this.passHandle = n2;
        return enum_;
    }

    private Object readOrdinaryObject(boolean bl) throws IOException {
        Object object;
        if (this.bin.readByte() != 115) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        objectStreamClass.checkDeserialize();
        Class<?> clazz = objectStreamClass.forClass();
        if (!(f.ifAcmp(clazz, String.class) && f.ifAcmp(clazz, Class.class) && f.ifAcmp(clazz, ObjectStreamClass.class))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException("invalid class descriptor"));
        }
        try {
            object = objectStreamClass.isInstantiable() ? objectStreamClass.newInstance() : null;
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new InvalidClassException(x.getName(objectStreamClass.forClass()), "unable to create instance").initCause(exception), IOException.class)));
        }
        this.passHandle = this.handles.assign(bl ? ObjectInputStream.unsharedMarker : object);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(this.passHandle, classNotFoundException);
        }
        if (objectStreamClass.isExternalizable()) {
            this.readExternalData((Externalizable)g.convertForCast((Object)object, Externalizable.class), objectStreamClass);
        } else {
            this.readSerialData(object, objectStreamClass);
        }
        this.handles.finish(this.passHandle);
        if (object != null && this.handles.lookupException(this.passHandle) == null && objectStreamClass.hasReadResolveMethod()) {
            Object object2 = objectStreamClass.invokeReadResolve(object);
            if (bl && ai.getCurrentClass(object2.getClass()).isArray()) {
                object2 = ObjectInputStream.cloneArray(object2);
            }
            if (f.ifAcmp((Object)object2, (Object)object)) {
                object = object2;
                this.handles.setObject(this.passHandle, object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExternalData(Externalizable externalizable, ObjectStreamClass objectStreamClass) throws IOException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        this.curContext = null;
        try {
            boolean bl = objectStreamClass.hasBlockExternalData();
            if (bl) {
                this.bin.setBlockDataMode(true);
            }
            if (externalizable != null) {
                try {
                    externalizable.readExternal(this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.handles.markException(this.passHandle, classNotFoundException);
                }
            }
            if (bl) {
                this.skipCustomData();
            }
        }
        catch (Throwable throwable) {
            this.curContext = serialCallbackContext;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.curContext = serialCallbackContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        for (int i = 0; i < a.arrayLength((Object[])classDataSlotArray); ++i) {
            ObjectStreamClass objectStreamClass2;
            block6: {
                block9: {
                    block7: {
                        objectStreamClass2 = ObjectStreamClass.ClassDataSlot._jr$ig$desc((Object)((ObjectStreamClass.ClassDataSlot)((Object)g.convertForCast((Object)a.arrayLoad((Object[])classDataSlotArray, (int)i), ObjectStreamClass.ClassDataSlot.class))));
                        if (!ObjectStreamClass.ClassDataSlot._jr$ig$hasData((Object)((ObjectStreamClass.ClassDataSlot)((Object)g.convertForCast((Object)a.arrayLoad((Object[])classDataSlotArray, (int)i), ObjectStreamClass.ClassDataSlot.class))))) break block6;
                        if (object == null || !objectStreamClass2.hasReadObjectMethod() || this.handles.lookupException(this.passHandle) != null) break block7;
                        SerialCallbackContext serialCallbackContext = this.curContext;
                        try {
                            this.curContext = new SerialCallbackContext(object, objectStreamClass2);
                            this.bin.setBlockDataMode(true);
                            objectStreamClass2.invokeReadObject(object, this);
                            this.curContext.setUsed();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            try {
                                this.handles.markException(this.passHandle, classNotFoundException);
                                this.curContext.setUsed();
                            }
                            catch (Throwable throwable) {
                                this.curContext.setUsed();
                                this.curContext = serialCallbackContext;
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                            this.curContext = serialCallbackContext;
                        }
                        this.curContext = serialCallbackContext;
                        this.defaultDataEnd = false;
                        break block9;
                    }
                    this.defaultReadFields(object, objectStreamClass2);
                }
                if (objectStreamClass2.hasWriteObjectData()) {
                    this.skipCustomData();
                    continue;
                }
                this.bin.setBlockDataMode(false);
                continue;
            }
            if (object == null || !objectStreamClass2.hasReadObjectNoDataMethod() || this.handles.lookupException(this.passHandle) != null) continue;
            objectStreamClass2.invokeReadObjectNoData(object);
        }
    }

    private void skipCustomData() throws IOException {
        int n2 = this.passHandle;
        block4: while (true) {
            if (this.bin.getBlockDataMode()) {
                this.bin.skipBlockData();
                this.bin.setBlockDataMode(false);
            }
            switch (this.bin.peekByte()) {
                case 119: 
                case 122: {
                    this.bin.setBlockDataMode(true);
                    continue block4;
                }
                case 120: {
                    this.bin.readByte();
                    this.passHandle = n2;
                    return;
                }
            }
            this.readObject0(false);
        }
    }

    private void defaultReadFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Class<?> clazz = objectStreamClass.forClass();
        if (clazz != null && object != null && !x.isInstance(clazz, (Object)object)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClassCastException());
        }
        int n2 = objectStreamClass.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < n2) {
            this.primVals = new byte[n2];
        }
        this.bin.readFully(this.primVals, 0, n2, false);
        if (object != null) {
            objectStreamClass.setPrimFieldValues(object, this.primVals);
        }
        int n3 = this.passHandle;
        Object[] objectArray = objectStreamClass.getFields(false);
        Object[] objectArray2 = new Object[objectStreamClass.getNumObjFields()];
        int n4 = a.arrayLength((Object[])objectArray) - a.arrayLength((Object[])objectArray2);
        for (int i = 0; i < a.arrayLength((Object[])objectArray2); ++i) {
            ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n4 + i)), ObjectStreamField.class);
            a.arrayStore((Object[])objectArray2, (int)i, (Object)this.readObject0(objectStreamField.isUnshared()));
            if (objectStreamField.getField() == null) continue;
            this.handles.markDependency(n3, this.passHandle);
        }
        if (object != null) {
            objectStreamClass.setObjFieldValues(object, objectArray2);
        }
        this.passHandle = n3;
    }

    private IOException readFatalException() throws IOException {
        if (this.bin.readByte() != 123) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        this.clear();
        return (IOException)g.convertForCast((Object)this.readObject0(false), IOException.class);
    }

    private void handleReset() throws StreamCorruptedException {
        if (this.depth > 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException("unexpected reset; recursion depth: " + this.depth));
        }
        this.clear();
    }

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    private static ClassLoader latestUserDefinedLoader() {
        return VM.latestUserDefinedLoader();
    }

    private static Object cloneArray(Object object) {
        if (g.convertForInstanceOf((Object)object, Object[].class) instanceof Object[]) {
            return a.cloneArray((Object)((Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)object, Object[].class)), Object[].class)));
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).clone();
        }
        if (object instanceof byte[]) {
            return ((byte[])object).clone();
        }
        if (object instanceof char[]) {
            return ((char[])object).clone();
        }
        if (object instanceof double[]) {
            return ((double[])object).clone();
        }
        if (object instanceof float[]) {
            return ((float[])object).clone();
        }
        if (object instanceof int[]) {
            return ((int[])object).clone();
        }
        if (object instanceof long[]) {
            return ((long[])object).clone();
        }
        if (object instanceof short[]) {
            return ((short[])object).clone();
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
    }

    static /* synthetic */ int access$002(ObjectInputStream objectInputStream, int n2) {
        int n3 = n2;
        objectInputStream.passHandle = n3;
        return n3;
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }

    private static /* synthetic */ void _jr$ip$bin(ObjectInputStream objectInputStream, BlockDataInputStream blockDataInputStream) {
        objectInputStream.bin = blockDataInputStream;
    }

    private static /* synthetic */ void _jr$ip$vlist(ObjectInputStream objectInputStream, ValidationList validationList) {
        objectInputStream.vlist = validationList;
    }

    private static /* synthetic */ void _jr$ip$depth(ObjectInputStream objectInputStream, int n2) {
        objectInputStream.depth = n2;
    }

    private static /* synthetic */ void _jr$ip$handles(ObjectInputStream objectInputStream, HandleTable handleTable) {
        objectInputStream.handles = handleTable;
    }

    private static /* synthetic */ void _jr$ip$enableOverride(ObjectInputStream objectInputStream, boolean bl) {
        objectInputStream.enableOverride = bl;
    }

    protected /* synthetic */ ObjectInputStream(h h2) {
        super(h2);
    }

    private class BlockDataInputStream
    extends InputStream
    implements DataInput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf;
        private final byte[] hbuf;
        private final char[] cbuf;
        private boolean blkmode;
        private int pos;
        private int end;
        private int unread;
        private final PeekInputStream in;
        private final DataInputStream din;
        final /* synthetic */ ObjectInputStream this$0;

        BlockDataInputStream(ObjectInputStream objectInputStream, InputStream inputStream) {
            this.this$0 = objectInputStream;
            this.buf = new byte[1024];
            this.hbuf = new byte[5];
            this.cbuf = new char[256];
            this.blkmode = false;
            this.pos = 0;
            this.end = -1;
            this.unread = 0;
            this.in = new PeekInputStream(inputStream);
            this.din = new DataInputStream(this);
        }

        boolean setBlockDataMode(boolean bl) throws IOException {
            if (this.blkmode == bl) {
                return this.blkmode;
            }
            if (bl) {
                this.pos = 0;
                this.end = 0;
                this.unread = 0;
            } else if (this.pos < this.end) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("unread block data"));
            }
            this.blkmode = bl;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        void skipBlockData() throws IOException {
            if (!this.blkmode) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("not in block data mode"));
            }
            while (this.end >= 0) {
                this.refill();
            }
        }

        private int readBlockHeader(boolean bl) throws IOException {
            if (((BlockDataInputStream)this).this$0.defaultDataEnd) {
                return -1;
            }
            try {
                int n2;
                block7: while (true) {
                    int n3;
                    int n4 = n3 = bl ? Integer.MAX_VALUE : this.in.available();
                    if (n3 == 0) {
                        return -2;
                    }
                    n2 = this.in.peek();
                    switch (n2) {
                        case 119: {
                            if (n3 < 2) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 2);
                            return this.hbuf[1] & 0xFF;
                        }
                        case 122: {
                            if (n3 < 5) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 5);
                            int n5 = Bits.getInt(this.hbuf, 1);
                            if (n5 < 0) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException("illegal block data header length: " + n5));
                            }
                            return n5;
                        }
                        case 121: {
                            this.in.read();
                            ((BlockDataInputStream)this).this$0.handleReset();
                            continue block7;
                        }
                    }
                    break;
                }
                if (n2 >= 0 && (n2 < 112 || n2 > 126)) {
                    Object[] objectArray = new Object[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)n2);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException(String.format("invalid type code: %02X", objectArray)));
                }
                return -1;
            }
            catch (EOFException eOFException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException("unexpected EOF while reading block data header"));
            }
        }

        private void refill() throws IOException {
            try {
                do {
                    int n2;
                    this.pos = 0;
                    if (this.unread > 0) {
                        n2 = this.in.read(this.buf, 0, Math.min(this.unread, 1024));
                        if (n2 >= 0) {
                            this.end = n2;
                            BlockDataInputStream blockDataInputStream = this;
                            blockDataInputStream.unread = blockDataInputStream.unread - n2;
                            continue;
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException("unexpected EOF in middle of data block"));
                    }
                    n2 = this.readBlockHeader(true);
                    if (n2 >= 0) {
                        this.end = 0;
                        this.unread = n2;
                        continue;
                    }
                    this.end = -1;
                    this.unread = 0;
                } while (this.pos == this.end);
            }
            catch (IOException iOException) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
            }
        }

        int currentBlockRemaining() {
            if (this.blkmode) {
                return this.end >= 0 ? this.end - this.pos + this.unread : 0;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
        }

        int peek() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos] & 0xFF : -1;
            }
            return this.in.peek();
        }

        byte peekByte() throws IOException {
            int n2 = this.peek();
            if (n2 < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException());
            }
            return (byte)n2;
        }

        @Override
        public int read() throws IOException {
            if (this.blkmode) {
                int n2;
                if (this.pos == this.end) {
                    this.refill();
                }
                if (this.end >= 0) {
                    byte[] byArray = this.buf;
                    BlockDataInputStream blockDataInputStream = this;
                    int n3 = blockDataInputStream.pos;
                    blockDataInputStream.pos = n3 + 1;
                    n2 = byArray[n3] & 0xFF;
                } else {
                    n2 = -1;
                }
                return n2;
            }
            return this.in.read();
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.read(byArray, n2, n3, false);
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = l;
            while (l2 > 0L) {
                int n2;
                if (this.blkmode) {
                    if (this.pos == this.end) {
                        this.refill();
                    }
                    if (this.end < 0) break;
                    n2 = (int)Math.min(l2, (long)(this.end - this.pos));
                    l2 -= (long)n2;
                    BlockDataInputStream blockDataInputStream = this;
                    blockDataInputStream.pos = blockDataInputStream.pos + n2;
                    continue;
                }
                n2 = (int)Math.min(l2, 1024L);
                n2 = this.in.read(this.buf, 0, n2);
                if (n2 < 0) break;
                l2 -= (long)n2;
            }
            return l - l2;
        }

        @Override
        public int available() throws IOException {
            if (this.blkmode) {
                int n2;
                if (this.pos == this.end && this.unread == 0) {
                    while ((n2 = this.readBlockHeader(false)) == 0) {
                    }
                    switch (n2) {
                        case -2: {
                            break;
                        }
                        case -1: {
                            this.pos = 0;
                            this.end = -1;
                            break;
                        }
                        default: {
                            this.pos = 0;
                            this.end = 0;
                            this.unread = n2;
                        }
                    }
                }
                n2 = this.unread > 0 ? Math.min(this.in.available(), this.unread) : 0;
                return this.end >= 0 ? this.end - this.pos + n2 : 0;
            }
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            if (this.blkmode) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
            }
            this.in.close();
        }

        int read(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
            if (n3 == 0) {
                return 0;
            }
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                if (this.end < 0) {
                    return -1;
                }
                int n4 = Math.min(n3, this.end - this.pos);
                a.arraycopy((Object)this.buf, (int)this.pos, (Object)byArray, (int)n2, (int)n4);
                BlockDataInputStream blockDataInputStream = this;
                blockDataInputStream.pos = blockDataInputStream.pos + n4;
                return n4;
            }
            if (bl) {
                int n5 = this.in.read(this.buf, 0, Math.min(n3, 1024));
                if (n5 > 0) {
                    a.arraycopy((Object)this.buf, (int)0, (Object)byArray, (int)n2, (int)n5);
                }
                return n5;
            }
            return this.in.read(byArray, n2, n3);
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            this.readFully(byArray, 0, byArray.length, false);
        }

        @Override
        public void readFully(byte[] byArray, int n2, int n3) throws IOException {
            this.readFully(byArray, n2, n3, false);
        }

        public void readFully(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
            while (n3 > 0) {
                int n4 = this.read(byArray, n2, n3, bl);
                if (n4 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException());
                }
                n2 += n4;
                n3 -= n4;
            }
        }

        @Override
        public int skipBytes(int n2) throws IOException {
            return this.din.skipBytes(n2);
        }

        @Override
        public boolean readBoolean() throws IOException {
            int n2 = this.read();
            if (n2 < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException());
            }
            return n2 != 0;
        }

        @Override
        public byte readByte() throws IOException {
            int n2 = this.read();
            if (n2 < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException());
            }
            return (byte)n2;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            int n2 = this.read();
            if (n2 < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException());
            }
            return n2;
        }

        @Override
        public char readChar() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readChar();
            }
            char c2 = Bits.getChar(this.buf, this.pos);
            BlockDataInputStream blockDataInputStream = this;
            blockDataInputStream.pos = blockDataInputStream.pos + 2;
            return c2;
        }

        @Override
        public short readShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readShort();
            }
            short s = Bits.getShort(this.buf, this.pos);
            BlockDataInputStream blockDataInputStream = this;
            blockDataInputStream.pos = blockDataInputStream.pos + 2;
            return s;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readUnsignedShort();
            }
            int n2 = Bits.getShort(this.buf, this.pos) & 0xFFFF;
            BlockDataInputStream blockDataInputStream = this;
            blockDataInputStream.pos = blockDataInputStream.pos + 2;
            return n2;
        }

        @Override
        public int readInt() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readInt();
            }
            int n2 = Bits.getInt(this.buf, this.pos);
            BlockDataInputStream blockDataInputStream = this;
            blockDataInputStream.pos = blockDataInputStream.pos + 4;
            return n2;
        }

        @Override
        public float readFloat() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readFloat();
            }
            float f2 = Bits.getFloat(this.buf, this.pos);
            BlockDataInputStream blockDataInputStream = this;
            blockDataInputStream.pos = blockDataInputStream.pos + 4;
            return f2;
        }

        @Override
        public long readLong() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readLong();
            }
            long l = Bits.getLong(this.buf, this.pos);
            BlockDataInputStream blockDataInputStream = this;
            blockDataInputStream.pos = blockDataInputStream.pos + 8;
            return l;
        }

        @Override
        public double readDouble() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readDouble();
            }
            double d = Bits.getDouble(this.buf, this.pos);
            BlockDataInputStream blockDataInputStream = this;
            blockDataInputStream.pos = blockDataInputStream.pos + 8;
            return d;
        }

        @Override
        public String readUTF() throws IOException {
            return this.readUTFBody(this.readUnsignedShort());
        }

        @Override
        public String readLine() throws IOException {
            return this.din.readLine();
        }

        void readBooleans(boolean[] blArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 1024);
                    this.in.readFully(this.buf, 0, n6);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 1) {
                        blArray[n2++] = this.din.readBoolean();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + this.end - this.pos);
                }
                while (n2 < n5) {
                    int n7 = n2++;
                    byte[] byArray = this.buf;
                    BlockDataInputStream blockDataInputStream = this;
                    int n8 = blockDataInputStream.pos;
                    blockDataInputStream.pos = n8 + 1;
                    blArray[n7] = Bits.getBoolean(byArray, n8);
                }
            }
        }

        void readChars(char[] cArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 512);
                    this.in.readFully(this.buf, 0, n6 << 1);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        cArray[n2++] = this.din.readChar();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + (this.end - this.pos >> 1));
                }
                while (n2 < n5) {
                    cArray[n2++] = Bits.getChar(this.buf, this.pos);
                    BlockDataInputStream blockDataInputStream = this;
                    blockDataInputStream.pos = blockDataInputStream.pos + 2;
                }
            }
        }

        void readShorts(short[] sArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 512);
                    this.in.readFully(this.buf, 0, n6 << 1);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        sArray[n2++] = this.din.readShort();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + (this.end - this.pos >> 1));
                }
                while (n2 < n5) {
                    sArray[n2++] = Bits.getShort(this.buf, this.pos);
                    BlockDataInputStream blockDataInputStream = this;
                    blockDataInputStream.pos = blockDataInputStream.pos + 2;
                }
            }
        }

        void readInts(int[] nArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 256);
                    this.in.readFully(this.buf, 0, n6 << 2);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        nArray[n2++] = this.din.readInt();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + (this.end - this.pos >> 2));
                }
                while (n2 < n5) {
                    nArray[n2++] = Bits.getInt(this.buf, this.pos);
                    BlockDataInputStream blockDataInputStream = this;
                    blockDataInputStream.pos = blockDataInputStream.pos + 4;
                }
            }
        }

        void readFloats(float[] fArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    n5 = Math.min(n4 - n2, 256);
                    this.in.readFully(this.buf, 0, n5 << 2);
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        fArray[n2++] = this.din.readFloat();
                        continue;
                    }
                    n5 = Math.min(n4 - n2, this.end - this.pos >> 2);
                }
                ObjectInputStream.bytesToFloats(this.buf, this.pos, fArray, n2, n5);
                n2 += n5;
                BlockDataInputStream blockDataInputStream = this;
                blockDataInputStream.pos = blockDataInputStream.pos + (n5 << 2);
            }
        }

        void readLongs(long[] lArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 128);
                    this.in.readFully(this.buf, 0, n6 << 3);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        lArray[n2++] = this.din.readLong();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + (this.end - this.pos >> 3));
                }
                while (n2 < n5) {
                    lArray[n2++] = Bits.getLong(this.buf, this.pos);
                    BlockDataInputStream blockDataInputStream = this;
                    blockDataInputStream.pos = blockDataInputStream.pos + 8;
                }
            }
        }

        void readDoubles(double[] dArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    n5 = Math.min(n4 - n2, 128);
                    this.in.readFully(this.buf, 0, n5 << 3);
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        dArray[n2++] = this.din.readDouble();
                        continue;
                    }
                    n5 = Math.min(n4 - n2, this.end - this.pos >> 3);
                }
                ObjectInputStream.bytesToDoubles(this.buf, this.pos, dArray, n2, n5);
                n2 += n5;
                BlockDataInputStream blockDataInputStream = this;
                blockDataInputStream.pos = blockDataInputStream.pos + (n5 << 3);
            }
        }

        String readLongUTF() throws IOException {
            return this.readUTFBody(this.readLong());
        }

        private String readUTFBody(long l) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.blkmode) {
                this.pos = 0;
                this.end = 0;
            }
            while (l > 0L) {
                int n2 = this.end - this.pos;
                if (n2 >= 3 || (long)n2 == l) {
                    l -= this.readUTFSpan(stringBuilder, l);
                    continue;
                }
                if (this.blkmode) {
                    l -= (long)this.readUTFChar(stringBuilder, l);
                    continue;
                }
                if (n2 > 0) {
                    a.arraycopy((Object)this.buf, (int)this.pos, (Object)this.buf, (int)0, (int)n2);
                }
                this.pos = 0;
                this.end = (int)Math.min(1024L, l);
                this.in.readFully(this.buf, n2, this.end - n2);
            }
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long readUTFSpan(StringBuilder stringBuilder, long l) throws IOException {
            int n2;
            int n3;
            block16: {
                boolean bl;
                block15: {
                    n3 = 0;
                    n2 = this.pos;
                    int n4 = Math.min(this.end - this.pos, 256);
                    int n5 = this.pos + (l > (long)n4 ? n4 - 2 : (int)l);
                    bl = false;
                    try {
                        block10: while (this.pos < n5) {
                            byte[] byArray = this.buf;
                            BlockDataInputStream blockDataInputStream = this;
                            int n6 = blockDataInputStream.pos;
                            blockDataInputStream.pos = n6 + 1;
                            int n7 = byArray[n6] & 0xFF;
                            switch (n7 >> 4) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    ((BlockDataInputStream)this).cbuf[n3++] = (char)n7;
                                    continue block10;
                                }
                                case 12: 
                                case 13: {
                                    byte[] byArray2 = this.buf;
                                    BlockDataInputStream blockDataInputStream2 = this;
                                    int n8 = blockDataInputStream2.pos;
                                    blockDataInputStream2.pos = n8 + 1;
                                    byte by2 = byArray2[n8];
                                    if ((by2 & 0xC0) != 128) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                                    }
                                    ((BlockDataInputStream)this).cbuf[n3++] = (char)((n7 & 0x1F) << 6 | (by2 & 0x3F) << 0);
                                    continue block10;
                                }
                                case 14: {
                                    byte by = this.buf[this.pos + 1];
                                    byte by2 = this.buf[this.pos + 0];
                                    BlockDataInputStream blockDataInputStream3 = this;
                                    blockDataInputStream3.pos = blockDataInputStream3.pos + 2;
                                    if ((by2 & 0xC0) != 128) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                                    if ((by & 0xC0) != 128) {
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                                    }
                                    ((BlockDataInputStream)this).cbuf[n3++] = (char)((n7 & 0xF) << 12 | (by2 & 0x3F) << 6 | (by & 0x3F) << 0);
                                    continue block10;
                                }
                            }
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                        }
                        if (bl) break block15;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        try {
                            bl = true;
                            return (long)bl;
                        }
                        catch (Throwable throwable) {}
                    }
                    if ((long)(this.pos - n2) <= l) break block16;
                }
                this.pos = n2 + (int)l;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                finally {
                    if (!bl && (long)(this.pos - n2) <= l) break block16;
                    this.pos = n2 + (int)l;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                }
            }
            stringBuilder.append(this.cbuf, 0, n3);
            return this.pos - n2;
        }

        private int readUTFChar(StringBuilder stringBuilder, long l) throws IOException {
            int n2 = this.readByte() & 0xFF;
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    stringBuilder.append((char)n2);
                    return 1;
                }
                case 12: 
                case 13: {
                    if (l < 2L) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                    }
                    byte by = this.readByte();
                    if ((by & 0xC0) != 128) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                    }
                    stringBuilder.append((char)((n2 & 0x1F) << 6 | (by & 0x3F) << 0));
                    return 2;
                }
                case 14: {
                    if (l < 3L) {
                        if (l == 2L) {
                            this.readByte();
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                    }
                    byte by = this.readByte();
                    byte by2 = this.readByte();
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
                    }
                    stringBuilder.append((char)((n2 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    return 3;
                }
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
        }

        private static /* synthetic */ void _jr$ip$buf(BlockDataInputStream blockDataInputStream, byte[] byArray) {
            blockDataInputStream.buf = byArray;
        }

        private static /* synthetic */ void _jr$ip$hbuf(BlockDataInputStream blockDataInputStream, byte[] byArray) {
            blockDataInputStream.hbuf = byArray;
        }

        private static /* synthetic */ void _jr$ip$cbuf(BlockDataInputStream blockDataInputStream, char[] cArray) {
            blockDataInputStream.cbuf = cArray;
        }

        private static /* synthetic */ void _jr$ip$in(BlockDataInputStream blockDataInputStream, PeekInputStream peekInputStream) {
            blockDataInputStream.in = peekInputStream;
        }

        private static /* synthetic */ void _jr$ip$din(BlockDataInputStream blockDataInputStream, DataInputStream dataInputStream) {
            blockDataInputStream.din = dataInputStream;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ObjectInputStream objectInputStream) {
            ((BlockDataInputStream)object).this$0 = objectInputStream;
        }

        protected /* synthetic */ BlockDataInputStream(h h2) {
            super(h2);
        }
    }

    private static class Caches
    extends h {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<ObjectStreamClass.WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }

        protected /* synthetic */ Caches(h h2) {
            super(h2);
        }
    }

    public static abstract class GetField
    extends h {
        public GetField() {
        }

        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException;

        public abstract boolean get(String var1, boolean var2) throws IOException;

        public abstract byte get(String var1, byte var2) throws IOException;

        public abstract char get(String var1, char var2) throws IOException;

        public abstract short get(String var1, short var2) throws IOException;

        public abstract int get(String var1, int var2) throws IOException;

        public abstract long get(String var1, long var2) throws IOException;

        public abstract float get(String var1, float var2) throws IOException;

        public abstract double get(String var1, double var2) throws IOException;

        public abstract Object get(String var1, Object var2) throws IOException;

        protected /* synthetic */ GetField(h h2) {
            super(h2);
        }
    }

    private class GetFieldImpl
    extends GetField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;
        private final int[] objHandles;
        final /* synthetic */ ObjectInputStream this$0;

        GetFieldImpl(ObjectInputStream objectInputStream, ObjectStreamClass objectStreamClass) {
            this.this$0 = objectInputStream;
            this.desc = objectStreamClass;
            this.primVals = new byte[objectStreamClass.getPrimDataSize()];
            this.objVals = new Object[objectStreamClass.getNumObjFields()];
            this.objHandles = new int[a.arrayLength((Object[])this.objVals)];
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return this.desc;
        }

        @Override
        public boolean defaulted(String string) throws IOException {
            return this.getFieldOffset(string, null) < 0;
        }

        @Override
        public boolean get(String string, boolean bl) throws IOException {
            int n2 = this.getFieldOffset(string, Boolean.TYPE);
            return n2 >= 0 ? Bits.getBoolean(this.primVals, n2) : bl;
        }

        @Override
        public byte get(String string, byte by) throws IOException {
            int n2 = this.getFieldOffset(string, Byte.TYPE);
            return n2 >= 0 ? this.primVals[n2] : by;
        }

        @Override
        public char get(String string, char c2) throws IOException {
            int n2 = this.getFieldOffset(string, Character.TYPE);
            return n2 >= 0 ? Bits.getChar(this.primVals, n2) : c2;
        }

        @Override
        public short get(String string, short s) throws IOException {
            int n2 = this.getFieldOffset(string, Short.TYPE);
            return n2 >= 0 ? Bits.getShort(this.primVals, n2) : s;
        }

        @Override
        public int get(String string, int n2) throws IOException {
            int n3 = this.getFieldOffset(string, Integer.TYPE);
            return n3 >= 0 ? Bits.getInt(this.primVals, n3) : n2;
        }

        @Override
        public float get(String string, float f2) throws IOException {
            int n2 = this.getFieldOffset(string, Float.TYPE);
            return n2 >= 0 ? Bits.getFloat(this.primVals, n2) : f2;
        }

        @Override
        public long get(String string, long l) throws IOException {
            int n2 = this.getFieldOffset(string, Long.TYPE);
            return n2 >= 0 ? Bits.getLong(this.primVals, n2) : l;
        }

        @Override
        public double get(String string, double d) throws IOException {
            int n2 = this.getFieldOffset(string, Double.TYPE);
            return n2 >= 0 ? Bits.getDouble(this.primVals, n2) : d;
        }

        @Override
        public Object get(String string, Object object) throws IOException {
            int n2 = this.getFieldOffset(string, Object.class);
            if (n2 >= 0) {
                int n3 = this.objHandles[n2];
                ((GetFieldImpl)((Object)((Object)this))).this$0.handles.markDependency(((GetFieldImpl)((Object)((Object)this))).this$0.passHandle, n3);
                return ((GetFieldImpl)((Object)((Object)this))).this$0.handles.lookupException(n3) == null ? a.arrayLoad((Object[])this.objVals, (int)n2) : null;
            }
            return object;
        }

        void readFields() throws IOException {
            ((GetFieldImpl)((Object)((Object)this))).this$0.bin.readFully(this.primVals, 0, this.primVals.length, false);
            int n2 = ((GetFieldImpl)((Object)((Object)this))).this$0.passHandle;
            Object[] objectArray = this.desc.getFields(false);
            int n3 = a.arrayLength((Object[])objectArray) - a.arrayLength((Object[])this.objVals);
            for (int i = 0; i < a.arrayLength((Object[])this.objVals); ++i) {
                a.arrayStore((Object[])this.objVals, (int)i, (Object)((GetFieldImpl)((Object)((Object)this))).this$0.readObject0(((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n3 + i)), ObjectStreamField.class)).isUnshared()));
                ((GetFieldImpl)this).objHandles[i] = ((GetFieldImpl)((Object)((Object)this))).this$0.passHandle;
            }
            ObjectInputStream.access$002(((GetFieldImpl)((Object)((Object)this))).this$0, n2);
        }

        private int getFieldOffset(String string, Class clazz) {
            ObjectStreamField objectStreamField = this.desc.getField(string, clazz);
            if (objectStreamField != null) {
                return objectStreamField.getOffset();
            }
            if (this.desc.getLocalDesc().getField(string, clazz) != null) {
                return -1;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("no such field " + string + " with type " + clazz));
        }

        private static /* synthetic */ void _jr$ip$desc(GetFieldImpl getFieldImpl, ObjectStreamClass objectStreamClass) {
            getFieldImpl.desc = objectStreamClass;
        }

        private static /* synthetic */ void _jr$ip$primVals(GetFieldImpl getFieldImpl, byte[] byArray) {
            getFieldImpl.primVals = byArray;
        }

        private static /* synthetic */ void _jr$ip$objVals(GetFieldImpl getFieldImpl, Object[] objectArray) {
            getFieldImpl.objVals = objectArray;
        }

        private static /* synthetic */ void _jr$ip$objHandles(GetFieldImpl getFieldImpl, int[] nArray) {
            getFieldImpl.objHandles = nArray;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ObjectInputStream objectInputStream) {
            ((GetFieldImpl)((Object)object)).this$0 = objectInputStream;
        }

        protected /* synthetic */ GetFieldImpl(h h2) {
            super(h2);
        }
    }

    private static class HandleTable
    extends h {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep;
        int size;

        HandleTable(int n2) {
            this.lowDep = -1;
            this.size = 0;
            this.status = new byte[n2];
            this.entries = new Object[n2];
            this.deps = new HandleList[n2];
        }

        int assign(Object object) {
            if (((HandleTable)((Object)((Object)this))).size >= a.arrayLength((Object[])((HandleTable)((Object)((Object)this))).entries)) {
                this.grow();
            }
            ((HandleTable)((Object)((Object)((Object)this)))).status[((HandleTable)((Object)((Object)((Object)this)))).size] = 2;
            a.arrayStore((Object[])((HandleTable)((Object)((Object)this))).entries, (int)((HandleTable)((Object)((Object)this))).size, (Object)object);
            HandleTable handleTable = this;
            int n2 = ((HandleTable)((Object)((Object)handleTable))).size;
            ((HandleTable)((Object)((Object)handleTable))).size = n2 + 1;
            return n2;
        }

        void markDependency(int n2, int n3) {
            if (n2 == -1 || n3 == -1) {
                return;
            }
            block0 : switch (((HandleTable)((Object)((Object)this))).status[n2]) {
                case 2: {
                    switch (((HandleTable)((Object)((Object)this))).status[n3]) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            this.markException(n2, (ClassNotFoundException)g.convertForCast((Object)a.arrayLoad((Object[])((HandleTable)((Object)((Object)this))).entries, (int)n3), ClassNotFoundException.class));
                            break block0;
                        }
                        case 2: {
                            if ((HandleList)((Object)g.convertForCast((Object)a.arrayLoad((Object[])((HandleTable)((Object)((Object)this))).deps, (int)n3), HandleList.class)) == null) {
                                a.arrayStore((Object[])((HandleTable)((Object)((Object)this))).deps, (int)n3, (Object)((Object)new HandleList()));
                            }
                            ((HandleList)((Object)g.convertForCast((Object)a.arrayLoad((Object[])((HandleTable)((Object)((Object)this))).deps, (int)n3), HandleList.class))).add(n2);
                            if (((HandleTable)((Object)((Object)this))).lowDep >= 0 && ((HandleTable)((Object)((Object)this))).lowDep <= n3) break block0;
                            ((HandleTable)((Object)((Object)this))).lowDep = n3;
                            break block0;
                        }
                        default: {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                        }
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                }
            }
        }

        void markException(int n2, ClassNotFoundException classNotFoundException) {
            switch (((HandleTable)((Object)((Object)this))).status[n2]) {
                case 2: {
                    ((HandleTable)((Object)((Object)((Object)this)))).status[n2] = 3;
                    a.arrayStore((Object[])((HandleTable)((Object)((Object)this))).entries, (int)n2, (Object)classNotFoundException);
                    HandleList handleList = (HandleList)((Object)g.convertForCast((Object)a.arrayLoad((Object[])((HandleTable)((Object)((Object)this))).deps, (int)n2), HandleList.class));
                    if (handleList == null) break;
                    int n3 = handleList.size();
                    for (int i = 0; i < n3; ++i) {
                        this.markException(handleList.get(i), classNotFoundException);
                    }
                    a.arrayStore((Object[])((HandleTable)((Object)((Object)this))).deps, (int)n2, null);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                }
            }
        }

        void finish(int n2) {
            int n3;
            if (((HandleTable)((Object)((Object)this))).lowDep < 0) {
                n3 = n2 + 1;
            } else if (((HandleTable)((Object)((Object)this))).lowDep >= n2) {
                n3 = ((HandleTable)((Object)((Object)this))).size;
                ((HandleTable)((Object)((Object)this))).lowDep = -1;
            } else {
                return;
            }
            block4: for (int i = n2; i < n3; ++i) {
                switch (((HandleTable)((Object)((Object)this))).status[i]) {
                    case 2: {
                        ((HandleTable)((Object)((Object)((Object)this)))).status[i] = 1;
                        a.arrayStore((Object[])((HandleTable)((Object)((Object)this))).deps, (int)i, null);
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        continue block4;
                    }
                    default: {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                    }
                }
            }
        }

        void setObject(int n2, Object object) {
            switch (((HandleTable)((Object)((Object)this))).status[n2]) {
                case 1: 
                case 2: {
                    a.arrayStore((Object[])((HandleTable)((Object)((Object)this))).entries, (int)n2, (Object)object);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                }
            }
        }

        Object lookupObject(int n2) {
            return n2 != -1 && ((HandleTable)((Object)((Object)this))).status[n2] != 3 ? a.arrayLoad((Object[])((HandleTable)((Object)((Object)this))).entries, (int)n2) : null;
        }

        ClassNotFoundException lookupException(int n2) {
            return n2 != -1 && ((HandleTable)((Object)((Object)this))).status[n2] == 3 ? (ClassNotFoundException)g.convertForCast((Object)a.arrayLoad((Object[])((HandleTable)((Object)((Object)this))).entries, (int)n2), ClassNotFoundException.class) : null;
        }

        void clear() {
            Arrays.fill(((HandleTable)((Object)((Object)this))).status, 0, ((HandleTable)((Object)((Object)this))).size, (byte)0);
            Arrays.fill(((HandleTable)((Object)((Object)this))).entries, 0, ((HandleTable)((Object)((Object)this))).size, null);
            Arrays.fill((Object[])((HandleTable)((Object)((Object)this))).deps, 0, ((HandleTable)((Object)((Object)this))).size, null);
            ((HandleTable)((Object)((Object)this))).lowDep = -1;
            ((HandleTable)((Object)((Object)this))).size = 0;
        }

        int size() {
            return ((HandleTable)((Object)((Object)this))).size;
        }

        private void grow() {
            int n2 = (a.arrayLength((Object[])((HandleTable)((Object)((Object)this))).entries) << 1) + 1;
            byte[] byArray = new byte[n2];
            Object[] objectArray = new Object[n2];
            HandleList[] handleListArray = new HandleList[n2];
            a.arraycopy((Object)((HandleTable)((Object)((Object)this))).status, (int)0, (Object)byArray, (int)0, (int)((HandleTable)((Object)((Object)this))).size);
            a.arraycopy((Object)((HandleTable)((Object)((Object)this))).entries, (int)0, (Object)objectArray, (int)0, (int)((HandleTable)((Object)((Object)this))).size);
            a.arraycopy((Object)((HandleTable)((Object)((Object)this))).deps, (int)0, (Object)handleListArray, (int)0, (int)((HandleTable)((Object)((Object)this))).size);
            ((HandleTable)((Object)((Object)this))).status = byArray;
            ((HandleTable)((Object)((Object)this))).entries = objectArray;
            ((HandleTable)((Object)((Object)this))).deps = handleListArray;
        }

        protected /* synthetic */ HandleTable(h h2) {
            super(h2);
        }

        private static class HandleList
        extends h {
            private int[] list;
            private int size;

            public HandleList() {
                this.list = new int[4];
                this.size = 0;
            }

            public void add(int n2) {
                if (this.size >= this.list.length) {
                    int[] nArray = new int[this.list.length << 1];
                    a.arraycopy((Object)this.list, (int)0, (Object)nArray, (int)0, (int)this.list.length);
                    this.list = nArray;
                }
                int[] nArray = this.list;
                HandleList handleList = this;
                int n3 = handleList.size;
                handleList.size = n3 + 1;
                nArray[n3] = n2;
            }

            public int get(int n2) {
                if (n2 >= this.size) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException());
                }
                return this.list[n2];
            }

            public int size() {
                return this.size;
            }

            protected /* synthetic */ HandleList(h h2) {
                super(h2);
            }
        }
    }

    private static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb;

        PeekInputStream(InputStream inputStream) {
            this.peekb = -1;
            this.in = inputStream;
        }

        int peek() throws IOException {
            int n2;
            if (this.peekb >= 0) {
                n2 = this.peekb;
            } else {
                int n3 = this.in.read();
                n2 = n3;
                this.peekb = n3;
            }
            return n2;
        }

        @Override
        public int read() throws IOException {
            if (this.peekb >= 0) {
                int n2 = this.peekb;
                this.peekb = -1;
                return n2;
            }
            return this.in.read();
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (n3 == 0) {
                return 0;
            }
            if (this.peekb < 0) {
                return this.in.read(byArray, n2, n3);
            }
            byArray[n2++] = (byte)this.peekb;
            this.peekb = -1;
            int n4 = this.in.read(byArray, n2, --n3);
            return n4 >= 0 ? n4 + 1 : 1;
        }

        void readFully(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            for (int i = 0; i < n3; i += n4) {
                n4 = this.read(byArray, n2 + i, n3 - i);
                if (n4 >= 0) continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException());
            }
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n2 = 0;
            if (this.peekb >= 0) {
                this.peekb = -1;
                ++n2;
                --l;
            }
            return (long)n2 + this.skip(l);
        }

        @Override
        public int available() throws IOException {
            return this.in.available() + (this.peekb >= 0 ? 1 : 0);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        private static /* synthetic */ void _jr$ip$in(PeekInputStream peekInputStream, InputStream inputStream) {
            peekInputStream.in = inputStream;
        }

        protected /* synthetic */ PeekInputStream(h h2) {
            super(h2);
        }
    }

    private static class ValidationList
    extends h {
        private Callback list;

        ValidationList() {
        }

        void register(ObjectInputValidation objectInputValidation, int n2) throws InvalidObjectException {
            if (objectInputValidation == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("null callback"));
            }
            Callback callback = null;
            Callback callback2 = this.list;
            while (callback2 != null && n2 < ((Callback)((Object)((Object)callback2))).priority) {
                callback = callback2;
                callback2 = ((Callback)((Object)((Object)callback2))).next;
            }
            AccessControlContext accessControlContext = AccessController.getContext();
            if (callback != null) {
                ((Callback)((Object)((Object)callback))).next = new Callback(objectInputValidation, n2, callback2, accessControlContext);
            } else {
                this.list = new Callback(objectInputValidation, n2, this.list, accessControlContext);
            }
        }

        void doCallbacks() throws InvalidObjectException {
            try {
                while (this.list != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws InvalidObjectException {
                            list.obj.validateObject();
                            return null;
                        }
                    }, ((Callback)((Object)((Object)this.list))).acc);
                    this.list = ((Callback)((Object)((Object)this.list))).next;
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.list = null;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InvalidObjectException)g.convertForCast((Object)privilegedActionException.getException(), InvalidObjectException.class)));
            }
        }

        public void clear() {
            this.list = null;
        }

        static /* synthetic */ Callback access$400(ValidationList validationList) {
            return validationList.list;
        }

        protected /* synthetic */ ValidationList(h h2) {
            super(h2);
        }

        private static class Callback
        extends h {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;
            final AccessControlContext acc;

            Callback(ObjectInputValidation objectInputValidation, int n2, Callback callback, AccessControlContext accessControlContext) {
                this.obj = objectInputValidation;
                this.priority = n2;
                this.next = callback;
                this.acc = accessControlContext;
            }

            static /* synthetic */ ObjectInputValidation _jr$ig$obj(Object object) {
                return ((Callback)((Object)object)).obj;
            }

            static /* synthetic */ void _jr$ip$obj(Object object, ObjectInputValidation objectInputValidation) {
                ((Callback)((Object)object)).obj = objectInputValidation;
            }

            static /* synthetic */ void _jr$ip$priority(Object object, int n2) {
                ((Callback)((Object)object)).priority = n2;
            }

            static /* synthetic */ void _jr$ip$acc(Object object, AccessControlContext accessControlContext) {
                ((Callback)((Object)object)).acc = accessControlContext;
            }

            protected /* synthetic */ Callback(h h2) {
                super(h2);
            }
        }
    }
}

