/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.an;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.n;
import com.zeroturnaround.jrebelbase.facade.w;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.Bits;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.SerialCallbackContext;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.reflect.misc.ReflectUtil;
import sun.security.action.GetBooleanAction;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private SerialCallbackContext curContext;
    private PutFieldImpl curPut;
    private final DebugTraceInfoStack debugInfoStack;
    private static final boolean extendedDebugInfo = (Boolean)g.convertForCast(AccessController.doPrivileged(new GetBooleanAction("sun.io.serialization.extendedDebugInfo")), Boolean.class);

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.protocol = 2;
        this.verifySubclass();
        this.bout = new BlockDataOutputStream(outputStream);
        this.handles = new HandleTable(10, 3.0f);
        this.subs = new ReplaceTable(10, 3.0f);
        this.enableOverride = false;
        this.writeStreamHeader();
        this.bout.setBlockDataMode(true);
        this.debugInfoStack = extendedDebugInfo ? new DebugTraceInfoStack() : null;
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        this.protocol = 2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bout = null;
        this.handles = null;
        this.subs = null;
        this.enableOverride = true;
        this.debugInfoStack = null;
    }

    public void useProtocolVersion(int n2) throws IOException {
        if (this.handles.size() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("stream non-empty"));
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.protocol = n2;
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("unknown version: " + n2));
            }
        }
    }

    @Override
    public final void writeObject(Object object) throws IOException {
        if (this.enableOverride) {
            this.writeObjectOverride(object);
            return;
        }
        try {
            this.writeObject0(object, false);
        }
        catch (IOException iOException) {
            if (this.depth == 0) {
                this.writeFatalException(iOException);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
    }

    protected void writeObjectOverride(Object object) throws IOException {
    }

    public void writeUnshared(Object object) throws IOException {
        try {
            this.writeObject0(object, true);
        }
        catch (IOException iOException) {
            if (this.depth == 0) {
                this.writeFatalException(iOException);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
    }

    public void defaultWriteObject() throws IOException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        if (serialCallbackContext == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotActiveException("not in call to writeObject"));
        }
        Object object = serialCallbackContext.getObj();
        ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
        this.bout.setBlockDataMode(false);
        this.defaultWriteFields(object, objectStreamClass);
        this.bout.setBlockDataMode(true);
    }

    public PutField putFields() throws IOException {
        if (this.curPut == null) {
            SerialCallbackContext serialCallbackContext = this.curContext;
            if (serialCallbackContext == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotActiveException("not in call to writeObject"));
            }
            Object object = serialCallbackContext.getObj();
            ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
            this.curPut = new PutFieldImpl(this, objectStreamClass);
        }
        return this.curPut;
    }

    public void writeFields() throws IOException {
        if (this.curPut == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotActiveException("no current PutField object"));
        }
        this.bout.setBlockDataMode(false);
        this.curPut.writeFields();
        this.bout.setBlockDataMode(true);
    }

    public void reset() throws IOException {
        if (this.depth != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("stream active"));
        }
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(121);
        this.clear();
        this.bout.setBlockDataMode(true);
    }

    protected void annotateClass(Class<?> clazz) throws IOException {
    }

    protected void annotateProxyClass(Class<?> clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl == this.enableReplace) {
            return bl;
        }
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableReplace = bl;
        return !this.enableReplace;
    }

    protected void writeStreamHeader() throws IOException {
        this.bout.writeShort(-21267);
        this.bout.writeShort(5);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        objectStreamClass.writeNonProxy(this);
    }

    @Override
    public void write(int n2) throws IOException {
        this.bout.write(n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.bout.write(byArray, 0, byArray.length, false);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        int n4 = n2 + n3;
        if (n2 < 0 || n3 < 0 || n4 > byArray.length || n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        this.bout.write(byArray, n2, n3, false);
    }

    @Override
    public void flush() throws IOException {
        this.bout.flush();
    }

    protected void drain() throws IOException {
        this.bout.drain();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.clear();
        this.bout.close();
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.bout.writeBoolean(bl);
    }

    @Override
    public void writeByte(int n2) throws IOException {
        this.bout.writeByte(n2);
    }

    @Override
    public void writeShort(int n2) throws IOException {
        this.bout.writeShort(n2);
    }

    @Override
    public void writeChar(int n2) throws IOException {
        this.bout.writeChar(n2);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.bout.writeInt(n2);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.bout.writeLong(l);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.bout.writeFloat(f2);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.bout.writeDouble(d);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.bout.writeBytes(string);
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.bout.writeChars(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.bout.writeUTF(string);
    }

    int getProtocolVersion() {
        return this.protocol;
    }

    void writeTypeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
        } else {
            int n2 = this.handles.lookup(string);
            if (n2 != -1) {
                this.writeHandle(n2);
            } else {
                this.writeString(string, false);
            }
        }
    }

    private void verifySubclass() {
        Class<?> clazz = this.getClass();
        if (!f.ifAcmp(clazz, ObjectOutputStream.class)) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        ObjectStreamClass.WeakClassKey weakClassKey = new ObjectStreamClass.WeakClassKey(clazz, Caches.subclassAuditsQueue);
        Boolean bl = (Boolean)g.convertForCast(Caches.subclassAudits.get((Object)weakClassKey), Boolean.class);
        if (bl == null) {
            bl = ObjectOutputStream.auditSubclass(clazz);
            Caches.subclassAudits.putIfAbsent(weakClassKey, bl);
        }
        if (bl.booleanValue()) {
            return;
        }
        securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class clazz) {
        Boolean bl = (Boolean)g.convertForCast((Object)AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = clazz; cl != ObjectOutputStream.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("writeUnshared", new Class[]{Object.class});
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            cl.getDeclaredMethod("putFields", null);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }), Boolean.class);
        return bl;
    }

    private void clear() {
        this.subs.clear();
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject0(Object clazz, boolean bl) throws IOException {
        ObjectStreamClass objectStreamClass;
        Class<?> clazz2;
        boolean bl2;
        block26: {
            block29: {
                block28: {
                    int n2;
                    block27: {
                        ObjectOutputStream objectOutputStream;
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        clazz = an.forceStateMigrate((Object)clazz, (boolean)true);
                                        bl2 = this.bout.setBlockDataMode(false);
                                        ObjectOutputStream objectOutputStream2 = this;
                                        objectOutputStream2.depth = objectOutputStream2.depth + 1;
                                        clazz = this.subs.lookup(clazz);
                                        if (clazz != null) break block22;
                                        this.writeNull();
                                        ObjectOutputStream objectOutputStream3 = this;
                                        objectOutputStream3.depth = objectOutputStream3.depth - 1;
                                        this.bout.setBlockDataMode(bl2);
                                        return;
                                    }
                                    if (bl || (n2 = this.handles.lookup(clazz)) == -1) break block23;
                                    this.writeHandle(n2);
                                    ObjectOutputStream objectOutputStream4 = this;
                                    objectOutputStream4.depth = objectOutputStream4.depth - 1;
                                    this.bout.setBlockDataMode(bl2);
                                    return;
                                }
                                if (!(clazz instanceof Class)) break block24;
                                this.writeClass(clazz, bl);
                                ObjectOutputStream objectOutputStream5 = this;
                                objectOutputStream5.depth = objectOutputStream5.depth - 1;
                                this.bout.setBlockDataMode(bl2);
                                return;
                            }
                            if (!(g.convertForInstanceOf((Object)clazz, ObjectStreamClass.class) instanceof ObjectStreamClass)) break block25;
                            this.writeClassDesc((ObjectStreamClass)g.convertForCast((Object)clazz, ObjectStreamClass.class), bl);
                            ObjectOutputStream objectOutputStream6 = this;
                            objectOutputStream6.depth = objectOutputStream6.depth - 1;
                            this.bout.setBlockDataMode(bl2);
                            return;
                        }
                        try {
                            Class<?> clazz3;
                            Class<?> clazz4 = clazz;
                            clazz2 = clazz.getClass();
                            while ((objectStreamClass = ObjectStreamClass.lookup(clazz2, true)).hasWriteReplaceMethod() && (clazz = objectStreamClass.invokeWriteReplace(clazz)) != null && f.ifAcmp(clazz3 = clazz.getClass(), clazz2)) {
                                clazz2 = clazz3;
                            }
                            if (this.enableReplace) {
                                clazz3 = this.replaceObject(clazz);
                                if (f.ifAcmp(clazz3, (Object)clazz) && clazz3 != null) {
                                    clazz2 = clazz3.getClass();
                                    objectStreamClass = ObjectStreamClass.lookup(clazz2, true);
                                }
                                clazz = clazz3;
                            }
                            if (!f.ifAcmp((Object)clazz, (Object)clazz4)) break block26;
                            this.subs.assign(clazz4, clazz);
                            if (clazz != null) break block27;
                            this.writeNull();
                            objectOutputStream = this;
                        }
                        catch (Throwable throwable) {
                            ObjectOutputStream objectOutputStream7 = this;
                            objectOutputStream7.depth = objectOutputStream7.depth - 1;
                            this.bout.setBlockDataMode(bl2);
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                        objectOutputStream.depth = objectOutputStream.depth - 1;
                        this.bout.setBlockDataMode(bl2);
                        return;
                    }
                    if (bl || (n2 = this.handles.lookup(clazz)) == -1) break block28;
                    this.writeHandle(n2);
                    ObjectOutputStream objectOutputStream = this;
                    objectOutputStream.depth = objectOutputStream.depth - 1;
                    this.bout.setBlockDataMode(bl2);
                    return;
                }
                if (!(clazz instanceof Class)) break block29;
                this.writeClass(clazz, bl);
                ObjectOutputStream objectOutputStream = this;
                objectOutputStream.depth = objectOutputStream.depth - 1;
                this.bout.setBlockDataMode(bl2);
                return;
            }
            if (!(g.convertForInstanceOf(clazz, ObjectStreamClass.class) instanceof ObjectStreamClass)) break block26;
            this.writeClassDesc((ObjectStreamClass)g.convertForCast(clazz, ObjectStreamClass.class), bl);
            ObjectOutputStream objectOutputStream = this;
            objectOutputStream.depth = objectOutputStream.depth - 1;
            this.bout.setBlockDataMode(bl2);
            return;
        }
        if (clazz instanceof String) {
            this.writeString((String)((Object)clazz), bl);
        } else if (ai.getCurrentClass(clazz2).isArray()) {
            this.writeArray(clazz, objectStreamClass, bl);
        } else if (clazz instanceof Enum) {
            this.writeEnum((Enum)((Object)clazz), objectStreamClass, bl);
        } else if (g.convertForInstanceOf(clazz, Serializable.class) instanceof Serializable) {
            this.writeOrdinaryObject(clazz, objectStreamClass, bl);
        } else {
            if (extendedDebugInfo) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotSerializableException(x.getName(clazz2) + "\n" + this.debugInfoStack.toString()));
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NotSerializableException(x.getName(clazz2)));
        }
        ObjectOutputStream objectOutputStream = this;
        objectOutputStream.depth = objectOutputStream.depth - 1;
        this.bout.setBlockDataMode(bl2);
    }

    private void writeNull() throws IOException {
        this.bout.writeByte(112);
    }

    private void writeHandle(int n2) throws IOException {
        this.bout.writeByte(113);
        this.bout.writeInt(0x7E0000 + n2);
    }

    private void writeClass(Class clazz, boolean bl) throws IOException {
        this.bout.writeByte(118);
        this.writeClassDesc(ObjectStreamClass.lookup(clazz, true), false);
        this.handles.assign(bl ? null : clazz);
    }

    private void writeClassDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        int n2;
        if (objectStreamClass == null) {
            this.writeNull();
        } else if (!bl && (n2 = this.handles.lookup(objectStreamClass)) != -1) {
            this.writeHandle(n2);
        } else if (objectStreamClass.isProxy()) {
            this.writeProxyDesc(objectStreamClass, bl);
        } else {
            this.writeNonProxyDesc(objectStreamClass, bl);
        }
    }

    private boolean isCustomSubclass() {
        return f.ifAcmp((Object)((Object)this.getClass().getClassLoader()), (Object)((Object)ObjectOutputStream.class.getClassLoader()));
    }

    private void writeProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(125);
        this.handles.assign(bl ? null : objectStreamClass);
        Class<?> clazz = objectStreamClass.forClass();
        Class[] classArray = n.filterInterfaces((Class[])x.getInterfaces(clazz));
        this.bout.writeInt(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            this.bout.writeUTF(x.getName((Class)classArray[i]));
        }
        this.bout.setBlockDataMode(true);
        if (this.isCustomSubclass()) {
            ReflectUtil.checkPackageAccess(clazz);
        }
        this.annotateProxyClass(clazz);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(objectStreamClass.getSuperDesc(), false);
    }

    private void writeNonProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(114);
        this.handles.assign(bl ? null : objectStreamClass);
        if (this.protocol == 1) {
            objectStreamClass.writeNonProxy(this);
        } else {
            this.writeClassDescriptor(objectStreamClass);
        }
        Class<?> clazz = objectStreamClass.forClass();
        this.bout.setBlockDataMode(true);
        if (this.isCustomSubclass()) {
            ReflectUtil.checkPackageAccess(clazz);
        }
        this.annotateClass(clazz);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(objectStreamClass.getSuperDesc(), false);
    }

    private void writeString(String string, boolean bl) throws IOException {
        this.handles.assign(bl ? null : string);
        long l = this.bout.getUTFLength(string);
        if (l <= 65535L) {
            this.bout.writeByte(116);
            this.bout.writeUTF(string, l);
        } else {
            this.bout.writeByte(124);
            this.bout.writeLongUTF(string, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArray(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(117);
        this.writeClassDesc(objectStreamClass, false);
        this.handles.assign(bl ? null : object);
        Class<?> clazz = ai.getCurrentClass(objectStreamClass.forClass()).getComponentType();
        if (ai.getCurrentClass(clazz).isPrimitive()) {
            if (!f.ifAcmp(clazz, Integer.TYPE)) {
                int[] nArray = (int[])object;
                this.bout.writeInt(nArray.length);
                this.bout.writeInts(nArray, 0, nArray.length);
                return;
            } else if (!f.ifAcmp(clazz, Byte.TYPE)) {
                byte[] byArray = (byte[])object;
                this.bout.writeInt(byArray.length);
                this.bout.write(byArray, 0, byArray.length, true);
                return;
            } else if (!f.ifAcmp(clazz, Long.TYPE)) {
                long[] lArray = (long[])object;
                this.bout.writeInt(lArray.length);
                this.bout.writeLongs(lArray, 0, lArray.length);
                return;
            } else if (!f.ifAcmp(clazz, Float.TYPE)) {
                float[] fArray = (float[])object;
                this.bout.writeInt(fArray.length);
                this.bout.writeFloats(fArray, 0, fArray.length);
                return;
            } else if (!f.ifAcmp(clazz, Double.TYPE)) {
                double[] dArray = (double[])object;
                this.bout.writeInt(dArray.length);
                this.bout.writeDoubles(dArray, 0, dArray.length);
                return;
            } else if (!f.ifAcmp(clazz, Short.TYPE)) {
                short[] sArray = (short[])object;
                this.bout.writeInt(sArray.length);
                this.bout.writeShorts(sArray, 0, sArray.length);
                return;
            } else if (!f.ifAcmp(clazz, Character.TYPE)) {
                char[] cArray = (char[])object;
                this.bout.writeInt(cArray.length);
                this.bout.writeChars(cArray, 0, cArray.length);
                return;
            } else {
                if (f.ifAcmp(clazz, Boolean.TYPE)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                boolean[] blArray = (boolean[])object;
                this.bout.writeInt(blArray.length);
                this.bout.writeBooleans(blArray, 0, blArray.length);
            }
            return;
        }
        Object[] objectArray = (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)object, Object[].class)), Object[].class);
        int n2 = a.arrayLength((Object[])objectArray);
        this.bout.writeInt(n2);
        if (extendedDebugInfo) {
            this.debugInfoStack.push("array (class \"" + x.getName(object.getClass()) + "\", size: " + n2 + ")");
        }
        try {
            for (int i = 0; i < n2; ++i) {
                if (extendedDebugInfo) {
                    this.debugInfoStack.push("element of array (index: " + i + ")");
                }
                try {
                    this.writeObject0(a.arrayLoad((Object[])objectArray, (int)i), false);
                    if (!extendedDebugInfo) continue;
                    this.debugInfoStack.pop();
                    continue;
                }
                catch (Throwable throwable) {
                    if (!extendedDebugInfo) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    this.debugInfoStack.pop();
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            if (!extendedDebugInfo) return;
            this.debugInfoStack.pop();
            return;
        }
        catch (Throwable throwable) {
            if (!extendedDebugInfo) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            this.debugInfoStack.pop();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    private void writeEnum(Enum enum_, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(126);
        ObjectStreamClass objectStreamClass2 = objectStreamClass.getSuperDesc();
        this.writeClassDesc(!f.ifAcmp(objectStreamClass2.forClass(), Enum.class) ? objectStreamClass : objectStreamClass2, false);
        this.handles.assign(bl ? null : enum_);
        this.writeString(((Enum)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)enum_)).name(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOrdinaryObject(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        if (extendedDebugInfo) {
            this.debugInfoStack.push((this.depth == 1 ? "root " : "") + "object (class \"" + x.getName(object.getClass()) + "\", " + object.toString() + ")");
        }
        try {
            objectStreamClass.checkSerialize();
            this.bout.writeByte(115);
            this.writeClassDesc(objectStreamClass, false);
            this.handles.assign(bl ? null : object);
            if (objectStreamClass.isExternalizable() && !objectStreamClass.isProxy()) {
                this.writeExternalData((Externalizable)g.convertForCast((Object)object, Externalizable.class));
            } else {
                this.writeSerialData(object, objectStreamClass);
            }
            if (extendedDebugInfo) {
                this.debugInfoStack.pop();
            }
        }
        catch (Throwable throwable) {
            if (extendedDebugInfo) {
                this.debugInfoStack.pop();
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternalData(Externalizable externalizable) throws IOException {
        SerialCallbackContext serialCallbackContext;
        PutFieldImpl putFieldImpl;
        block6: {
            putFieldImpl = this.curPut;
            this.curPut = null;
            if (extendedDebugInfo) {
                this.debugInfoStack.push("writeExternal data");
            }
            serialCallbackContext = this.curContext;
            try {
                this.curContext = null;
                if (this.protocol == 1) {
                    externalizable.writeExternal(this);
                    break block6;
                }
                this.bout.setBlockDataMode(true);
                externalizable.writeExternal(this);
                this.bout.setBlockDataMode(false);
                this.bout.writeByte(120);
            }
            catch (Throwable throwable) {
                this.curContext = serialCallbackContext;
                if (extendedDebugInfo) {
                    this.debugInfoStack.pop();
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        this.curContext = serialCallbackContext;
        if (extendedDebugInfo) {
            this.debugInfoStack.pop();
        }
        this.curPut = putFieldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        for (int i = 0; i < a.arrayLength((Object[])classDataSlotArray); ++i) {
            ObjectStreamClass objectStreamClass2;
            block6: {
                objectStreamClass2 = ObjectStreamClass.ClassDataSlot._jr$ig$desc((Object)((ObjectStreamClass.ClassDataSlot)((Object)g.convertForCast((Object)a.arrayLoad((Object[])classDataSlotArray, (int)i), ObjectStreamClass.ClassDataSlot.class))));
                if (!objectStreamClass2.hasWriteObjectMethod()) break block6;
                PutFieldImpl putFieldImpl = this.curPut;
                this.curPut = null;
                SerialCallbackContext serialCallbackContext = this.curContext;
                if (extendedDebugInfo) {
                    this.debugInfoStack.push("custom writeObject data (class \"" + objectStreamClass2.getName() + "\")");
                }
                try {
                    this.curContext = new SerialCallbackContext(object, objectStreamClass2);
                    this.bout.setBlockDataMode(true);
                    objectStreamClass2.invokeWriteObject(object, this);
                    this.bout.setBlockDataMode(false);
                    this.bout.writeByte(120);
                    this.curContext.setUsed();
                }
                catch (Throwable throwable) {
                    this.curContext.setUsed();
                    this.curContext = serialCallbackContext;
                    if (extendedDebugInfo) {
                        this.debugInfoStack.pop();
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                this.curContext = serialCallbackContext;
                if (extendedDebugInfo) {
                    this.debugInfoStack.pop();
                }
                this.curPut = putFieldImpl;
                continue;
            }
            this.defaultWriteFields(object, objectStreamClass2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultWriteFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Class<?> clazz = objectStreamClass.forClass();
        if (clazz != null && object != null && !x.isInstance(clazz, (Object)object)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClassCastException());
        }
        objectStreamClass.checkDefaultSerialize();
        int n2 = objectStreamClass.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < n2) {
            this.primVals = new byte[n2];
        }
        objectStreamClass.getPrimFieldValues(object, this.primVals);
        this.bout.write(this.primVals, 0, n2, false);
        Object[] objectArray = objectStreamClass.getFields(false);
        Object[] objectArray2 = new Object[objectStreamClass.getNumObjFields()];
        int n3 = a.arrayLength((Object[])objectArray) - a.arrayLength((Object[])objectArray2);
        objectStreamClass.getObjFieldValues(object, objectArray2);
        for (int i = 0; i < a.arrayLength((Object[])objectArray2); ++i) {
            if (extendedDebugInfo) {
                this.debugInfoStack.push("field (class \"" + objectStreamClass.getName() + "\", name: \"" + ((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n3 + i)), ObjectStreamField.class)).getName() + "\", type: \"" + ((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n3 + i)), ObjectStreamField.class)).getType() + "\")");
            }
            try {
                this.writeObject0(a.arrayLoad((Object[])objectArray2, (int)i), ((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n3 + i)), ObjectStreamField.class)).isUnshared());
                if (!extendedDebugInfo) continue;
                this.debugInfoStack.pop();
                continue;
            }
            catch (Throwable throwable) {
                if (extendedDebugInfo) {
                    this.debugInfoStack.pop();
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatalException(IOException iOException) throws IOException {
        this.clear();
        boolean bl = this.bout.setBlockDataMode(false);
        try {
            this.bout.writeByte(123);
            this.writeObject0(iOException, false);
            this.clear();
        }
        catch (Throwable throwable) {
            this.bout.setBlockDataMode(bl);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.bout.setBlockDataMode(bl);
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    private static /* synthetic */ void _jr$ip$bout(ObjectOutputStream objectOutputStream, BlockDataOutputStream blockDataOutputStream) {
        objectOutputStream.bout = blockDataOutputStream;
    }

    private static /* synthetic */ void _jr$ip$handles(ObjectOutputStream objectOutputStream, HandleTable handleTable) {
        objectOutputStream.handles = handleTable;
    }

    private static /* synthetic */ void _jr$ip$subs(ObjectOutputStream objectOutputStream, ReplaceTable replaceTable) {
        objectOutputStream.subs = replaceTable;
    }

    private static /* synthetic */ void _jr$ip$enableOverride(ObjectOutputStream objectOutputStream, boolean bl) {
        objectOutputStream.enableOverride = bl;
    }

    private static /* synthetic */ void _jr$ip$debugInfoStack(ObjectOutputStream objectOutputStream, DebugTraceInfoStack debugTraceInfoStack) {
        objectOutputStream.debugInfoStack = debugTraceInfoStack;
    }

    protected /* synthetic */ ObjectOutputStream(h h2) {
        super(h2);
    }

    private static class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf;
        private final byte[] hbuf;
        private final char[] cbuf;
        private boolean blkmode;
        private int pos;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream outputStream) {
            this.buf = new byte[1024];
            this.hbuf = new byte[5];
            this.cbuf = new char[256];
            this.blkmode = false;
            this.pos = 0;
            this.out = outputStream;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean bl) throws IOException {
            if (this.blkmode == bl) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = bl;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        @Override
        public void write(int n2) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            byte[] byArray = this.buf;
            BlockDataOutputStream blockDataOutputStream = this;
            int n3 = blockDataOutputStream.pos;
            blockDataOutputStream.pos = n3 + 1;
            byArray[n3] = (byte)n2;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length, false);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.write(byArray, n2, n3, false);
        }

        @Override
        public void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        void write(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
            if (!bl && !this.blkmode) {
                this.drain();
                this.out.write(byArray, n2, n3);
                return;
            }
            while (n3 > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                if (n3 >= 1024 && !bl && this.pos == 0) {
                    this.writeBlockHeader(1024);
                    this.out.write(byArray, n2, 1024);
                    n2 += 1024;
                    n3 -= 1024;
                    continue;
                }
                int n4 = Math.min(n3, 1024 - this.pos);
                a.arraycopy((Object)byArray, (int)n2, (Object)this.buf, (int)this.pos, (int)n4);
                BlockDataOutputStream blockDataOutputStream = this;
                blockDataOutputStream.pos = blockDataOutputStream.pos + n4;
                n2 += n4;
                n3 -= n4;
            }
        }

        void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int n2) throws IOException {
            if (n2 <= 255) {
                ((BlockDataOutputStream)this).hbuf[0] = 119;
                ((BlockDataOutputStream)this).hbuf[1] = (byte)n2;
                this.out.write(this.hbuf, 0, 2);
            } else {
                ((BlockDataOutputStream)this).hbuf[0] = 122;
                Bits.putInt(this.hbuf, 1, n2);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        @Override
        public void writeBoolean(boolean bl) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            byte[] byArray = this.buf;
            BlockDataOutputStream blockDataOutputStream = this;
            int n2 = blockDataOutputStream.pos;
            blockDataOutputStream.pos = n2 + 1;
            Bits.putBoolean(byArray, n2, bl);
        }

        @Override
        public void writeByte(int n2) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            byte[] byArray = this.buf;
            BlockDataOutputStream blockDataOutputStream = this;
            int n3 = blockDataOutputStream.pos;
            blockDataOutputStream.pos = n3 + 1;
            byArray[n3] = (byte)n2;
        }

        @Override
        public void writeChar(int n2) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putChar(this.buf, this.pos, (char)n2);
                BlockDataOutputStream blockDataOutputStream = this;
                blockDataOutputStream.pos = blockDataOutputStream.pos + 2;
            } else {
                this.dout.writeChar(n2);
            }
        }

        @Override
        public void writeShort(int n2) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putShort(this.buf, this.pos, (short)n2);
                BlockDataOutputStream blockDataOutputStream = this;
                blockDataOutputStream.pos = blockDataOutputStream.pos + 2;
            } else {
                this.dout.writeShort(n2);
            }
        }

        @Override
        public void writeInt(int n2) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putInt(this.buf, this.pos, n2);
                BlockDataOutputStream blockDataOutputStream = this;
                blockDataOutputStream.pos = blockDataOutputStream.pos + 4;
            } else {
                this.dout.writeInt(n2);
            }
        }

        @Override
        public void writeFloat(float f2) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putFloat(this.buf, this.pos, f2);
                BlockDataOutputStream blockDataOutputStream = this;
                blockDataOutputStream.pos = blockDataOutputStream.pos + 4;
            } else {
                this.dout.writeFloat(f2);
            }
        }

        @Override
        public void writeLong(long l) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putLong(this.buf, this.pos, l);
                BlockDataOutputStream blockDataOutputStream = this;
                blockDataOutputStream.pos = blockDataOutputStream.pos + 8;
            } else {
                this.dout.writeLong(l);
            }
        }

        @Override
        public void writeDouble(double d) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putDouble(this.buf, this.pos, d);
                BlockDataOutputStream blockDataOutputStream = this;
                blockDataOutputStream.pos = blockDataOutputStream.pos + 8;
            } else {
                this.dout.writeDouble(d);
            }
        }

        @Override
        public void writeBytes(String string) throws IOException {
            int n2;
            int n3 = string.length();
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n3; i += n2) {
                if (n4 >= n5) {
                    n4 = 0;
                    n5 = Math.min(n3 - i, 256);
                    string.getChars(i, i + n5, this.cbuf, 0);
                }
                if (this.pos >= 1024) {
                    this.drain();
                }
                n2 = Math.min(n5 - n4, 1024 - this.pos);
                int n6 = this.pos + n2;
                while (this.pos < n6) {
                    byte[] byArray = this.buf;
                    BlockDataOutputStream blockDataOutputStream = this;
                    int n7 = blockDataOutputStream.pos;
                    blockDataOutputStream.pos = n7 + 1;
                    byArray[n7] = (byte)this.cbuf[n4++];
                }
            }
        }

        @Override
        public void writeChars(String string) throws IOException {
            int n2;
            int n3 = string.length();
            for (int i = 0; i < n3; i += n2) {
                n2 = Math.min(n3 - i, 256);
                string.getChars(i, i + n2, this.cbuf, 0);
                this.writeChars(this.cbuf, 0, n2);
            }
        }

        @Override
        public void writeUTF(String string) throws IOException {
            this.writeUTF(string, this.getUTFLength(string));
        }

        void writeBooleans(boolean[] blArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int n5 = Math.min(n4, n2 + (1024 - this.pos));
                while (n2 < n5) {
                    byte[] byArray = this.buf;
                    BlockDataOutputStream blockDataOutputStream = this;
                    int n6 = blockDataOutputStream.pos;
                    blockDataOutputStream.pos = n6 + 1;
                    Bits.putBoolean(byArray, n6, blArray[n2++]);
                }
            }
        }

        void writeChars(char[] cArray, int n2, int n3) throws IOException {
            int n4 = 1022;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 1;
                    int n7 = Math.min(n5, n2 + n6);
                    while (n2 < n7) {
                        Bits.putChar(this.buf, this.pos, cArray[n2++]);
                        BlockDataOutputStream blockDataOutputStream = this;
                        blockDataOutputStream.pos = blockDataOutputStream.pos + 2;
                    }
                    continue;
                }
                this.dout.writeChar(cArray[n2++]);
            }
        }

        void writeShorts(short[] sArray, int n2, int n3) throws IOException {
            int n4 = 1022;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 1;
                    int n7 = Math.min(n5, n2 + n6);
                    while (n2 < n7) {
                        Bits.putShort(this.buf, this.pos, sArray[n2++]);
                        BlockDataOutputStream blockDataOutputStream = this;
                        blockDataOutputStream.pos = blockDataOutputStream.pos + 2;
                    }
                    continue;
                }
                this.dout.writeShort(sArray[n2++]);
            }
        }

        void writeInts(int[] nArray, int n2, int n3) throws IOException {
            int n4 = 1020;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 2;
                    int n7 = Math.min(n5, n2 + n6);
                    while (n2 < n7) {
                        Bits.putInt(this.buf, this.pos, nArray[n2++]);
                        BlockDataOutputStream blockDataOutputStream = this;
                        blockDataOutputStream.pos = blockDataOutputStream.pos + 4;
                    }
                    continue;
                }
                this.dout.writeInt(nArray[n2++]);
            }
        }

        void writeFloats(float[] fArray, int n2, int n3) throws IOException {
            int n4 = 1020;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 2;
                    int n7 = Math.min(n5 - n2, n6);
                    ObjectOutputStream.floatsToBytes(fArray, n2, this.buf, this.pos, n7);
                    n2 += n7;
                    BlockDataOutputStream blockDataOutputStream = this;
                    blockDataOutputStream.pos = blockDataOutputStream.pos + (n7 << 2);
                    continue;
                }
                this.dout.writeFloat(fArray[n2++]);
            }
        }

        void writeLongs(long[] lArray, int n2, int n3) throws IOException {
            int n4 = 1016;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 3;
                    int n7 = Math.min(n5, n2 + n6);
                    while (n2 < n7) {
                        Bits.putLong(this.buf, this.pos, lArray[n2++]);
                        BlockDataOutputStream blockDataOutputStream = this;
                        blockDataOutputStream.pos = blockDataOutputStream.pos + 8;
                    }
                    continue;
                }
                this.dout.writeLong(lArray[n2++]);
            }
        }

        void writeDoubles(double[] dArray, int n2, int n3) throws IOException {
            int n4 = 1016;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 3;
                    int n7 = Math.min(n5 - n2, n6);
                    ObjectOutputStream.doublesToBytes(dArray, n2, this.buf, this.pos, n7);
                    n2 += n7;
                    BlockDataOutputStream blockDataOutputStream = this;
                    blockDataOutputStream.pos = blockDataOutputStream.pos + (n7 << 3);
                    continue;
                }
                this.dout.writeDouble(dArray[n2++]);
            }
        }

        long getUTFLength(String string) {
            int n2;
            int n3 = string.length();
            long l = 0L;
            for (int i = 0; i < n3; i += n2) {
                n2 = Math.min(n3 - i, 256);
                string.getChars(i, i + n2, this.cbuf, 0);
                for (int k = 0; k < n2; ++k) {
                    char c = this.cbuf[k];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++l;
                        continue;
                    }
                    if (c > '\u07ff') {
                        l += 3L;
                        continue;
                    }
                    l += 2L;
                }
            }
            return l;
        }

        void writeUTF(String string, long l) throws IOException {
            if (l > 65535L) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UTFDataFormatException());
            }
            this.writeShort((int)l);
            if (l == (long)string.length()) {
                this.writeBytes(string);
            } else {
                this.writeUTFBody(string);
            }
        }

        void writeLongUTF(String string) throws IOException {
            this.writeLongUTF(string, this.getUTFLength(string));
        }

        void writeLongUTF(String string, long l) throws IOException {
            this.writeLong(l);
            if (l == (long)string.length()) {
                this.writeBytes(string);
            } else {
                this.writeUTFBody(string);
            }
        }

        private void writeUTFBody(String string) throws IOException {
            int n2;
            int n3 = 1021;
            int n4 = string.length();
            for (int i = 0; i < n4; i += n2) {
                n2 = Math.min(n4 - i, 256);
                string.getChars(i, i + n2, this.cbuf, 0);
                for (int k = 0; k < n2; ++k) {
                    char c = this.cbuf[k];
                    if (this.pos <= n3) {
                        if (c <= '\u007f' && c != '\u0000') {
                            byte[] byArray = this.buf;
                            BlockDataOutputStream blockDataOutputStream = this;
                            int n5 = blockDataOutputStream.pos;
                            blockDataOutputStream.pos = n5 + 1;
                            byArray[n5] = (byte)c;
                            continue;
                        }
                        if (c > '\u07ff') {
                            ((BlockDataOutputStream)this).buf[((BlockDataOutputStream)this).pos + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                            ((BlockDataOutputStream)this).buf[((BlockDataOutputStream)this).pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                            ((BlockDataOutputStream)this).buf[((BlockDataOutputStream)this).pos + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                            BlockDataOutputStream blockDataOutputStream = this;
                            blockDataOutputStream.pos = blockDataOutputStream.pos + 3;
                            continue;
                        }
                        ((BlockDataOutputStream)this).buf[((BlockDataOutputStream)this).pos + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                        ((BlockDataOutputStream)this).buf[((BlockDataOutputStream)this).pos + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                        BlockDataOutputStream blockDataOutputStream = this;
                        blockDataOutputStream.pos = blockDataOutputStream.pos + 2;
                        continue;
                    }
                    if (c <= '\u007f' && c != '\u0000') {
                        this.write(c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.write(0xE0 | c >> 12 & 0xF);
                        this.write(0x80 | c >> 6 & 0x3F);
                        this.write(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.write(0xC0 | c >> 6 & 0x1F);
                    this.write(0x80 | c >> 0 & 0x3F);
                }
            }
        }

        private static /* synthetic */ void _jr$ip$buf(BlockDataOutputStream blockDataOutputStream, byte[] byArray) {
            blockDataOutputStream.buf = byArray;
        }

        private static /* synthetic */ void _jr$ip$hbuf(BlockDataOutputStream blockDataOutputStream, byte[] byArray) {
            blockDataOutputStream.hbuf = byArray;
        }

        private static /* synthetic */ void _jr$ip$cbuf(BlockDataOutputStream blockDataOutputStream, char[] cArray) {
            blockDataOutputStream.cbuf = cArray;
        }

        private static /* synthetic */ void _jr$ip$out(BlockDataOutputStream blockDataOutputStream, OutputStream outputStream) {
            blockDataOutputStream.out = outputStream;
        }

        private static /* synthetic */ void _jr$ip$dout(BlockDataOutputStream blockDataOutputStream, DataOutputStream dataOutputStream) {
            blockDataOutputStream.dout = dataOutputStream;
        }

        protected /* synthetic */ BlockDataOutputStream(h h2) {
            super(h2);
        }
    }

    private static class Caches
    extends h {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<ObjectStreamClass.WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }

        protected /* synthetic */ Caches(h h2) {
            super(h2);
        }
    }

    private static class DebugTraceInfoStack
    extends h {
        private final List<String> stack;

        DebugTraceInfoStack() {
            this.stack = new ArrayList<String>();
        }

        void clear() {
            this.stack.clear();
        }

        void pop() {
            this.stack.remove(this.stack.size() - 1);
        }

        void push(String string) {
            this.stack.add("\t- " + string);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.stack.isEmpty()) {
                for (int i = this.stack.size(); i > 0; --i) {
                    stringBuilder.append((String)this.stack.get(i - 1) + (i != 1 ? "\n" : ""));
                }
            }
            return stringBuilder.toString();
        }

        private static /* synthetic */ void _jr$ip$stack(DebugTraceInfoStack debugTraceInfoStack, List list) {
            debugTraceInfoStack.stack = list;
        }

        protected /* synthetic */ DebugTraceInfoStack(h h2) {
            super(h2);
        }
    }

    private static class HandleTable
    extends h {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int n2, float f2) {
            this.loadFactor = f2;
            this.spine = new int[n2];
            this.next = new int[n2];
            this.objs = new Object[n2];
            this.threshold = (int)((float)n2 * f2);
            this.clear();
        }

        int assign(Object object) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(object, this.size);
            HandleTable handleTable = this;
            int n2 = handleTable.size;
            handleTable.size = n2 + 1;
            return n2;
        }

        int lookup(Object object) {
            if (this.size == 0) {
                return -1;
            }
            int n2 = this.hash(object) % this.spine.length;
            int n3 = this.spine[n2];
            while (n3 >= 0) {
                if (!f.ifAcmp((Object)a.arrayLoad((Object[])this.objs, (int)n3), (Object)object)) {
                    return n3;
                }
                n3 = this.next[n3];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object object, int n2) {
            int n3 = this.hash(object) % this.spine.length;
            a.arrayStore((Object[])this.objs, (int)n2, (Object)object);
            ((HandleTable)this).next[n2] = this.spine[n3];
            ((HandleTable)this).spine[n3] = n2;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(a.arrayLoad((Object[])this.objs, (int)i), i);
            }
        }

        private void growEntries() {
            int n2 = (this.next.length << 1) + 1;
            int[] nArray = new int[n2];
            a.arraycopy((Object)this.next, (int)0, (Object)nArray, (int)0, (int)this.size);
            this.next = nArray;
            Object[] objectArray = new Object[n2];
            a.arraycopy((Object)this.objs, (int)0, (Object)objectArray, (int)0, (int)this.size);
            this.objs = objectArray;
        }

        private int hash(Object object) {
            return w.getIdentityHashCode((Object)object) & Integer.MAX_VALUE;
        }

        private static /* synthetic */ void _jr$ip$loadFactor(HandleTable handleTable, float f2) {
            handleTable.loadFactor = f2;
        }

        protected /* synthetic */ HandleTable(h h2) {
            super(h2);
        }
    }

    public static abstract class PutField
    extends h {
        public PutField() {
        }

        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;

        protected /* synthetic */ PutField(h h2) {
            super(h2);
        }
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;
        final /* synthetic */ ObjectOutputStream this$0;

        PutFieldImpl(ObjectOutputStream objectOutputStream, ObjectStreamClass objectStreamClass) {
            this.this$0 = objectOutputStream;
            this.desc = objectStreamClass;
            this.primVals = new byte[objectStreamClass.getPrimDataSize()];
            this.objVals = new Object[objectStreamClass.getNumObjFields()];
        }

        @Override
        public void put(String string, boolean bl) {
            Bits.putBoolean(this.primVals, this.getFieldOffset(string, Boolean.TYPE), bl);
        }

        @Override
        public void put(String string, byte by) {
            ((PutFieldImpl)this).primVals[this.getFieldOffset((String)string, Byte.TYPE)] = by;
        }

        @Override
        public void put(String string, char c) {
            Bits.putChar(this.primVals, this.getFieldOffset(string, Character.TYPE), c);
        }

        @Override
        public void put(String string, short s) {
            Bits.putShort(this.primVals, this.getFieldOffset(string, Short.TYPE), s);
        }

        @Override
        public void put(String string, int n2) {
            Bits.putInt(this.primVals, this.getFieldOffset(string, Integer.TYPE), n2);
        }

        @Override
        public void put(String string, float f2) {
            Bits.putFloat(this.primVals, this.getFieldOffset(string, Float.TYPE), f2);
        }

        @Override
        public void put(String string, long l) {
            Bits.putLong(this.primVals, this.getFieldOffset(string, Long.TYPE), l);
        }

        @Override
        public void put(String string, double d) {
            Bits.putDouble(this.primVals, this.getFieldOffset(string, Double.TYPE), d);
        }

        @Override
        public void put(String string, Object object) {
            a.arrayStore((Object[])this.objVals, (int)this.getFieldOffset(string, Object.class), (Object)object);
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            if (f.ifAcmp((Object)((PutFieldImpl)((Object)((Object)this))).this$0, (Object)objectOutput)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("wrong stream"));
            }
            objectOutput.write(this.primVals, 0, this.primVals.length);
            Object[] objectArray = this.desc.getFields(false);
            int n2 = a.arrayLength((Object[])objectArray) - a.arrayLength((Object[])this.objVals);
            for (int i = 0; i < a.arrayLength((Object[])this.objVals); ++i) {
                if (((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n2 + i)), ObjectStreamField.class)).isUnshared()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("cannot write unshared object"));
                }
                objectOutput.writeObject(a.arrayLoad((Object[])this.objVals, (int)i));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeFields() throws IOException {
            ((PutFieldImpl)((Object)((Object)this))).this$0.bout.write(this.primVals, 0, this.primVals.length, false);
            Object[] objectArray = this.desc.getFields(false);
            int n2 = a.arrayLength((Object[])objectArray) - a.arrayLength((Object[])this.objVals);
            for (int i = 0; i < a.arrayLength((Object[])this.objVals); ++i) {
                if (extendedDebugInfo) {
                    ((PutFieldImpl)((Object)((Object)this))).this$0.debugInfoStack.push("field (class \"" + this.desc.getName() + "\", name: \"" + ((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n2 + i)), ObjectStreamField.class)).getName() + "\", type: \"" + ((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n2 + i)), ObjectStreamField.class)).getType() + "\")");
                }
                try {
                    ((PutFieldImpl)((Object)((Object)this))).this$0.writeObject0(a.arrayLoad((Object[])this.objVals, (int)i), ((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n2 + i)), ObjectStreamField.class)).isUnshared());
                }
                catch (Throwable throwable) {
                    if (extendedDebugInfo) {
                        ((PutFieldImpl)((Object)((Object)this))).this$0.debugInfoStack.pop();
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                if (!extendedDebugInfo) continue;
                ((PutFieldImpl)((Object)((Object)this))).this$0.debugInfoStack.pop();
            }
        }

        private int getFieldOffset(String string, Class clazz) {
            ObjectStreamField objectStreamField = this.desc.getField(string, clazz);
            if (objectStreamField == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("no such field " + string + " with type " + clazz));
            }
            return objectStreamField.getOffset();
        }

        private static /* synthetic */ void _jr$ip$desc(PutFieldImpl putFieldImpl, ObjectStreamClass objectStreamClass) {
            putFieldImpl.desc = objectStreamClass;
        }

        private static /* synthetic */ void _jr$ip$primVals(PutFieldImpl putFieldImpl, byte[] byArray) {
            putFieldImpl.primVals = byArray;
        }

        private static /* synthetic */ void _jr$ip$objVals(PutFieldImpl putFieldImpl, Object[] objectArray) {
            putFieldImpl.objVals = objectArray;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ObjectOutputStream objectOutputStream) {
            ((PutFieldImpl)((Object)object)).this$0 = objectOutputStream;
        }

        protected /* synthetic */ PutFieldImpl(h h2) {
            super(h2);
        }
    }

    private static class ReplaceTable
    extends h {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int n2, float f2) {
            this.htab = new HandleTable(n2, f2);
            this.reps = new Object[n2];
        }

        void assign(Object object, Object object2) {
            int n2 = this.htab.assign(object);
            while (n2 >= a.arrayLength((Object[])this.reps)) {
                this.grow();
            }
            a.arrayStore((Object[])this.reps, (int)n2, (Object)object2);
        }

        Object lookup(Object object) {
            int n2 = this.htab.lookup(object);
            return n2 >= 0 ? a.arrayLoad((Object[])this.reps, (int)n2) : object;
        }

        void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] objectArray = new Object[(a.arrayLength((Object[])this.reps) << 1) + 1];
            a.arraycopy((Object)this.reps, (int)0, (Object)objectArray, (int)0, (int)a.arrayLength((Object[])this.reps));
            this.reps = objectArray;
        }

        private static /* synthetic */ void _jr$ip$htab(ReplaceTable replaceTable, HandleTable handleTable) {
            replaceTable.htab = handleTable;
        }

        protected /* synthetic */ ReplaceTable(h h2) {
            super(h2);
        }
    }
}

