/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.an;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.n;
import com.zeroturnaround.jrebelbase.facade.w;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.Bits;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.ReflectionFactory;
import sun.reflect.misc.ReflectUtil;

public class ObjectStreamClass
extends h
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private static final ReflectionFactory reflFactory = (ReflectionFactory)g.convertForCast(AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction()), ReflectionFactory.class);
    private Class<?> cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean isEnum;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData;
    private ClassNotFoundException resolveEx;
    private ExceptionInfo deserializeEx;
    private ExceptionInfo serializeEx;
    private ExceptionInfo defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor cons;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;

    private static native void initNative();

    public static ObjectStreamClass lookup(Class<?> clazz) {
        return ObjectStreamClass.lookup(clazz, false);
    }

    public static ObjectStreamClass lookupAny(Class<?> clazz) {
        return ObjectStreamClass.lookup(clazz, true);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        if (this.suid == null) {
            this.suid = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    return ObjectStreamClass.computeDefaultSUID(ObjectStreamClass.this.cl);
                }
            });
        }
        return this.suid;
    }

    @CallerSensitive
    public Class<?> forClass() {
        Class clazz;
        if (this.cl == null) {
            return null;
        }
        if (System.getSecurityManager() != null && ReflectUtil.needsPackageAccessCheck((clazz = Reflection.getCallerClass()).getClassLoader(), this.cl.getClassLoader())) {
            ReflectUtil.checkPackageAccess(this.cl);
        }
        return this.cl;
    }

    public ObjectStreamField[] getFields() {
        return this.getFields(true);
    }

    public ObjectStreamField getField(String string) {
        return this.getField(string, null);
    }

    public String toString() {
        return this.name + ": static final long serialVersionUID = " + this.getSerialVersionUID() + "L;";
    }

    static ObjectStreamClass lookup(Class<?> clazz, boolean bl) {
        clazz = com.zeroturnaround.jrebelbase.facade.h.getCurrentClass(clazz);
        if (!bl && !x.isAssignableFrom(Serializable.class, (Class)clazz)) {
            return null;
        }
        ObjectStreamClass.processQueue(Caches.localDescsQueue, Caches.localDescs);
        WeakClassKey weakClassKey = new WeakClassKey(clazz, Caches.localDescsQueue);
        Reference reference = (Reference)((Object)g.convertForCast(Caches.localDescs.get((Object)weakClassKey), Reference.class));
        Object object = null;
        if (reference != null) {
            object = reference.get();
        }
        EntryFuture entryFuture = null;
        if (object == null) {
            EntryFuture entryFuture2 = new EntryFuture();
            SoftReference<EntryFuture> softReference = new SoftReference<EntryFuture>(entryFuture2);
            do {
                if (reference != null) {
                    Caches.localDescs.remove((Object)weakClassKey, (Object)reference);
                }
                if ((reference = (Reference)((Object)g.convertForCast(Caches.localDescs.putIfAbsent(weakClassKey, softReference), Reference.class))) == null) continue;
                object = reference.get();
            } while (reference != null && object == null);
            if (object == null) {
                entryFuture = entryFuture2;
            }
        }
        if (g.convertForInstanceOf(object, ObjectStreamClass.class) instanceof ObjectStreamClass) {
            return (ObjectStreamClass)g.convertForCast(object, ObjectStreamClass.class);
        }
        if (g.convertForInstanceOf(object, EntryFuture.class) instanceof EntryFuture) {
            entryFuture = (EntryFuture)((Object)g.convertForCast(object, EntryFuture.class));
            object = !f.ifAcmp((Object)entryFuture.getOwner(), (Object)Thread.currentThread()) ? null : entryFuture.get();
        }
        if (object == null) {
            try {
                object = new ObjectStreamClass(clazz);
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            if (entryFuture.set(object)) {
                Caches.localDescs.put(weakClassKey, new SoftReference<Object>(object));
            } else {
                object = entryFuture.get();
            }
        }
        if (g.convertForInstanceOf(object, ObjectStreamClass.class) instanceof ObjectStreamClass) {
            return (ObjectStreamClass)g.convertForCast((Object)object, ObjectStreamClass.class);
        }
        if (g.convertForInstanceOf((Object)object, RuntimeException.class) instanceof RuntimeException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)object, RuntimeException.class)));
        }
        if (g.convertForInstanceOf((Object)object, Error.class) instanceof Error) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((Error)g.convertForCast((Object)object, Error.class)));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("unexpected entry: " + object));
    }

    private ObjectStreamClass(Class<?> clazz) {
        this.hasBlockExternalData = true;
        this.cl = clazz;
        this.name = x.getName(clazz);
        this.isProxy = Proxy.isProxyClass(clazz);
        this.isEnum = x.isAssignableFrom(Enum.class, clazz);
        this.serializable = x.isAssignableFrom(Serializable.class, clazz);
        this.externalizable = x.isAssignableFrom(Externalizable.class, clazz);
        Class clazz2 = x.getSuperclass(clazz);
        this.superDesc = clazz2 != null ? ObjectStreamClass.lookup(clazz2, false) : null;
        this.localDesc = this;
        if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction(this, clazz){
                final /* synthetic */ Class val$cl;
                final /* synthetic */ ObjectStreamClass this$0;
                {
                    this.this$0 = objectStreamClass;
                    this.val$cl = clazz;
                }

                public Void run() {
                    if (this.this$0.isEnum) {
                        ObjectStreamClass.access$502(this.this$0, 0L);
                        ObjectStreamClass.access$602(this.this$0, NO_FIELDS);
                        return null;
                    }
                    if (ai.getCurrentClass((Class)(this).val$cl).isArray()) {
                        ObjectStreamClass.access$602(this.this$0, NO_FIELDS);
                        return null;
                    }
                    ObjectStreamClass.access$502(this.this$0, ObjectStreamClass.getDeclaredSUID((this).val$cl));
                    try {
                        ObjectStreamClass.access$602(this.this$0, ObjectStreamClass.getSerialFields((this).val$cl));
                        this.this$0.computeFieldOffsets();
                    }
                    catch (InvalidClassException invalidClassException) {
                        ObjectStreamClass.access$1002(this.this$0, ObjectStreamClass.access$1102(this.this$0, new ExceptionInfo(InvalidClassException._jr$ig$classname((Object)invalidClassException), invalidClassException.getMessage())));
                        ObjectStreamClass.access$602(this.this$0, NO_FIELDS);
                    }
                    if (this.this$0.externalizable) {
                        ObjectStreamClass.access$1302(this.this$0, ObjectStreamClass.getExternalizableConstructor((this).val$cl));
                    } else {
                        ObjectStreamClass.access$1302(this.this$0, ObjectStreamClass.getSerializableConstructor((this).val$cl));
                        Class clazz = (this).val$cl;
                        Object[] objectArray = new Class[1];
                        a.arrayStore((Object[])objectArray, (int)0, ObjectOutputStream.class);
                        ObjectStreamClass.access$1602(this.this$0, ObjectStreamClass.getPrivateMethod(clazz, "writeObject", (Class[])objectArray, Void.TYPE));
                        Class clazz2 = (this).val$cl;
                        Object[] objectArray2 = new Class[1];
                        a.arrayStore((Object[])objectArray2, (int)0, ObjectInputStream.class);
                        ObjectStreamClass.access$1802(this.this$0, ObjectStreamClass.getPrivateMethod(clazz2, "readObject", (Class[])objectArray2, Void.TYPE));
                        ObjectStreamClass.access$1902(this.this$0, ObjectStreamClass.getPrivateMethod((this).val$cl, "readObjectNoData", null, Void.TYPE));
                        ObjectStreamClass.access$2002(this.this$0, this.this$0.writeObjectMethod != null);
                    }
                    ObjectStreamClass.access$2102(this.this$0, ObjectStreamClass.getInheritableMethod((this).val$cl, "writeReplace", null, Object.class));
                    ObjectStreamClass.access$2302(this.this$0, ObjectStreamClass.getInheritableMethod((this).val$cl, "readResolve", null, Object.class));
                    return null;
                }

                static /* synthetic */ void _jr$ip$val$cl(Object object, Class clazz) {
                    (object).val$cl = clazz;
                }

                static /* synthetic */ ObjectStreamClass _jr$ig$this$0(Object object) {
                    return (object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, ObjectStreamClass objectStreamClass) {
                    (object).this$0 = objectStreamClass;
                }
            });
        } else {
            this.suid = 0L;
            this.fields = NO_FIELDS;
        }
        try {
            this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this);
        }
        catch (InvalidClassException invalidClassException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        if (this.deserializeEx == null) {
            if (this.isEnum) {
                this.deserializeEx = new ExceptionInfo(this.name, "enum type");
            } else if (this.cons == null) {
                this.deserializeEx = new ExceptionInfo(this.name, "no valid constructor");
            }
        }
        for (int i = 0; i < a.arrayLength((Object[])this.fields); ++i) {
            if (((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])this.fields, (int)i), ObjectStreamField.class)).getField() != null) continue;
            this.defaultSerializeEx = new ExceptionInfo(this.name, "unmatched serializable field(s) declared");
        }
    }

    ObjectStreamClass() {
        this.hasBlockExternalData = true;
    }

    void initProxy(Class<?> clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass;
        this.isProxy = true;
        this.serializable = true;
        this.suid = 0L;
        this.fields = ObjectStreamClass.NO_FIELDS;
        if (clazz != null) {
            this.localDesc = ObjectStreamClass.lookup(clazz, true);
            if (!this.localDesc.isProxy) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException("cannot bind proxy descriptor to a non-proxy class"));
            }
            this.name = this.localDesc.name;
            this.externalizable = this.localDesc.externalizable;
            this.cons = this.localDesc.cons;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.deserializeEx = this.localDesc.deserializeEx;
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
    }

    void initNonProxy(ObjectStreamClass objectStreamClass, Class<?> clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass2) throws InvalidClassException {
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass2;
        this.name = objectStreamClass.name;
        this.suid = objectStreamClass.getSerialVersionUID();
        this.isProxy = false;
        this.isEnum = objectStreamClass.isEnum;
        this.serializable = objectStreamClass.serializable;
        this.externalizable = objectStreamClass.externalizable;
        this.hasBlockExternalData = objectStreamClass.hasBlockExternalData;
        this.hasWriteObjectData = objectStreamClass.hasWriteObjectData;
        this.fields = objectStreamClass.fields;
        this.primDataSize = objectStreamClass.primDataSize;
        this.numObjFields = objectStreamClass.numObjFields;
        if (clazz != null) {
            this.localDesc = ObjectStreamClass.lookup(clazz, true);
            if (this.localDesc.isProxy) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException("cannot bind non-proxy descriptor to a proxy class"));
            }
            if (this.isEnum != this.localDesc.isEnum) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(this.isEnum ? "cannot bind enum descriptor to a non-enum class" : "cannot bind non-enum descriptor to an enum class"));
            }
            if (this.serializable == this.localDesc.serializable && !ai.getCurrentClass(clazz).isArray() && this.suid.longValue() != this.localDesc.getSerialVersionUID()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(this.localDesc.name, "local class incompatible: stream classdesc serialVersionUID = " + this.suid + ", local class serialVersionUID = " + this.localDesc.getSerialVersionUID()));
            }
            if (!ObjectStreamClass.classNamesEqual(this.name, this.localDesc.name)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(this.localDesc.name, "local class name incompatible with stream class name \"" + this.name + "\""));
            }
            if (!this.isEnum) {
                if (this.serializable == this.localDesc.serializable && this.externalizable != this.localDesc.externalizable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(this.localDesc.name, "Serializable incompatible with Externalizable"));
                }
                if (this.serializable != this.localDesc.serializable || this.externalizable != this.localDesc.externalizable || !this.serializable && !this.externalizable) {
                    this.deserializeEx = new ExceptionInfo(this.localDesc.name, "class invalid for deserialization");
                }
            }
            this.cons = this.localDesc.cons;
            this.writeObjectMethod = this.localDesc.writeObjectMethod;
            this.readObjectMethod = this.localDesc.readObjectMethod;
            this.readObjectNoDataMethod = this.localDesc.readObjectNoDataMethod;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            if (this.deserializeEx == null) {
                this.deserializeEx = this.localDesc.deserializeEx;
            }
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
        this.fields = this.fieldRefl.getFields();
    }

    void readNonProxy(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        this.name = objectInputStream.readUTF();
        this.suid = objectInputStream.readLong();
        this.isProxy = false;
        byte by = objectInputStream.readByte();
        this.hasWriteObjectData = (by & 1) != 0;
        this.hasBlockExternalData = (by & 8) != 0;
        this.externalizable = (by & 4) != 0;
        boolean bl2 = bl = (by & 2) != 0;
        if (this.externalizable && bl) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(this.name, "serializable and externalizable flags conflict"));
        }
        this.serializable = this.externalizable || bl;
        this.isEnum = (by & 0x10) != 0;
        if (this.isEnum && this.suid != 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(this.name, "enum descriptor has non-zero serialVersionUID: " + this.suid));
        }
        int n2 = objectInputStream.readShort();
        if (this.isEnum && n2 != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(this.name, "enum descriptor has non-zero field count: " + n2));
        }
        this.fields = n2 > 0 ? new ObjectStreamField[n2] : ObjectStreamClass.NO_FIELDS;
        for (int i = 0; i < n2; ++i) {
            char c = (char)objectInputStream.readByte();
            String string = objectInputStream.readUTF();
            String string2 = c == 'L' || c == '[' ? objectInputStream.readTypeString() : new String(new char[]{c});
            try {
                a.arrayStore((Object[])this.fields, (int)i, (Object)new ObjectStreamField(string, string2, false));
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new InvalidClassException(this.name, "invalid descriptor for field " + string).initCause(runtimeException), IOException.class)));
            }
        }
        this.computeFieldOffsets();
    }

    void writeNonProxy(ObjectOutputStream objectOutputStream) throws IOException {
        int n2;
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeLong(this.getSerialVersionUID());
        int n3 = 0;
        if (this.externalizable) {
            n3 = (byte)(n3 | 4);
            n2 = objectOutputStream.getProtocolVersion();
            if (n2 != 1) {
                n3 = (byte)(n3 | 8);
            }
        } else if (this.serializable) {
            n3 = (byte)(n3 | 2);
        }
        if (this.hasWriteObjectData) {
            n3 = (byte)(n3 | 1);
        }
        if (this.isEnum) {
            n3 = (byte)(n3 | 0x10);
        }
        objectOutputStream.writeByte(n3);
        objectOutputStream.writeShort(a.arrayLength((Object[])this.fields));
        for (n2 = 0; n2 < a.arrayLength((Object[])this.fields); ++n2) {
            ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])this.fields, (int)n2), ObjectStreamField.class);
            objectOutputStream.writeByte(objectStreamField.getTypeCode());
            objectOutputStream.writeUTF(objectStreamField.getName());
            if (objectStreamField.isPrimitive()) continue;
            objectOutputStream.writeTypeString(objectStreamField.getTypeString());
        }
    }

    ClassNotFoundException getResolveException() {
        return this.resolveEx;
    }

    void checkDeserialize() throws InvalidClassException {
        if (this.deserializeEx != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)this.deserializeEx.newInvalidClassException());
        }
    }

    void checkSerialize() throws InvalidClassException {
        if (this.serializeEx != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)this.serializeEx.newInvalidClassException());
        }
    }

    void checkDefaultSerialize() throws InvalidClassException {
        if (this.defaultSerializeEx != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)this.defaultSerializeEx.newInvalidClassException());
        }
    }

    ObjectStreamClass getSuperDesc() {
        return this.superDesc;
    }

    ObjectStreamClass getLocalDesc() {
        return this.localDesc;
    }

    ObjectStreamField[] getFields(boolean bl) {
        return bl ? (ObjectStreamField[])g.convertForCast((Object)a.cloneArray((Object)this.fields), ObjectStreamField[].class) : this.fields;
    }

    ObjectStreamField getField(String string, Class<?> clazz) {
        for (int i = 0; i < a.arrayLength((Object[])this.fields); ++i) {
            ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])this.fields, (int)i), ObjectStreamField.class);
            if (!objectStreamField.getName().equals(string)) continue;
            if (clazz == null || !f.ifAcmp(clazz, Object.class) && !objectStreamField.isPrimitive()) {
                return objectStreamField;
            }
            Class<?> clazz2 = objectStreamField.getType();
            if (clazz2 == null || !x.isAssignableFrom(clazz, clazz2)) continue;
            return objectStreamField;
        }
        return null;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    boolean isEnum() {
        return this.isEnum;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean hasBlockExternalData() {
        return this.hasBlockExternalData;
    }

    boolean hasWriteObjectData() {
        return this.hasWriteObjectData;
    }

    boolean isInstantiable() {
        return this.cons != null;
    }

    boolean hasWriteObjectMethod() {
        return this.writeObjectMethod != null;
    }

    boolean hasReadObjectMethod() {
        return this.readObjectMethod != null;
    }

    boolean hasReadObjectNoDataMethod() {
        return this.readObjectNoDataMethod != null;
    }

    boolean hasWriteReplaceMethod() {
        return this.writeReplaceMethod != null;
    }

    boolean hasReadResolveMethod() {
        return this.readResolveMethod != null;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        if (this.cons != null) {
            try {
                return this.cons.newInstance(new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    void invokeWriteObject(Object object, ObjectOutputStream objectOutputStream) throws IOException, UnsupportedOperationException {
        if (this.writeObjectMethod != null) {
            try {
                Method method = this.writeObjectMethod;
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)objectOutputStream);
                method.invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (g.convertForInstanceOf((Object)throwable, IOException.class) instanceof IOException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)throwable, IOException.class)));
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
    }

    void invokeReadObject(Object object, ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        if (this.readObjectMethod != null) {
            try {
                Method method = this.readObjectMethod;
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)objectInputStream);
                method.invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (g.convertForInstanceOf((Object)throwable, ClassNotFoundException.class) instanceof ClassNotFoundException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((ClassNotFoundException)g.convertForCast((Object)throwable, ClassNotFoundException.class)));
                }
                if (g.convertForInstanceOf((Object)throwable, IOException.class) instanceof IOException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)throwable, IOException.class)));
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
    }

    void invokeReadObjectNoData(Object object) throws IOException, UnsupportedOperationException {
        if (this.readObjectNoDataMethod != null) {
            try {
                this.readObjectNoDataMethod.invoke(object, (Object[])g.convertForCast(null, Object[].class));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (g.convertForInstanceOf((Object)throwable, ObjectStreamException.class) instanceof ObjectStreamException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((ObjectStreamException)g.convertForCast((Object)throwable, ObjectStreamException.class)));
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
    }

    Object invokeWriteReplace(Object object) throws IOException, UnsupportedOperationException {
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(object, (Object[])g.convertForCast(null, Object[].class));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (g.convertForInstanceOf((Object)throwable, ObjectStreamException.class) instanceof ObjectStreamException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((ObjectStreamException)g.convertForCast((Object)throwable, ObjectStreamException.class)));
                }
                ObjectStreamClass.throwMiscException(throwable);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    Object invokeReadResolve(Object object) throws IOException, UnsupportedOperationException {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(object, (Object[])g.convertForCast(null, Object[].class));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (g.convertForInstanceOf((Object)throwable, ObjectStreamException.class) instanceof ObjectStreamException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((ObjectStreamException)g.convertForCast((Object)throwable, ObjectStreamException.class)));
                }
                ObjectStreamClass.throwMiscException(throwable);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayout0();
        }
        return this.dataLayout;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        ArrayList<ClassDataSlot> arrayList = new ArrayList<ClassDataSlot>();
        Class clazz = this.cl;
        Class clazz2 = this.cl;
        while (clazz2 != null && x.isAssignableFrom(Serializable.class, (Class)clazz2)) {
            clazz2 = x.getSuperclass((Class)clazz2);
        }
        HashSet<String> hashSet = new HashSet<String>(3);
        h h2 = this;
        while (h2 != null) {
            if (hashSet.contains(((ObjectStreamClass)h2).name)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException("Circular reference."));
            }
            hashSet.add(((ObjectStreamClass)h2).name);
            String string = ((ObjectStreamClass)h2).cl != null ? x.getName((Class)((ObjectStreamClass)h2).cl) : ((ObjectStreamClass)h2).name;
            Class clazz3 = null;
            Class clazz4 = clazz;
            while (f.ifAcmp((Object)clazz4, (Object)clazz2)) {
                if (string.equals(x.getName((Class)clazz4))) {
                    clazz3 = clazz4;
                    break;
                }
                clazz4 = x.getSuperclass((Class)clazz4);
            }
            if (clazz3 != null) {
                clazz4 = clazz;
                while (f.ifAcmp((Object)clazz4, (Object)clazz3)) {
                    arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup(clazz4, true), false));
                    clazz4 = x.getSuperclass((Class)clazz4);
                }
                clazz = x.getSuperclass((Class)clazz3);
            }
            arrayList.add(new ClassDataSlot(h2.getVariantFor(clazz3), true));
            h2 = ((ObjectStreamClass)h2).superDesc;
        }
        h2 = clazz;
        while (f.ifAcmp((Object)h2, (Object)clazz2)) {
            arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup(h2, true), false));
            h2 = x.getSuperclass((Class)h2);
        }
        Collections.reverse(arrayList);
        return (ClassDataSlot[])g.convertForCast((Object)arrayList.toArray(new ClassDataSlot[arrayList.size()]), ClassDataSlot[].class);
    }

    int getPrimDataSize() {
        return this.primDataSize;
    }

    int getNumObjFields() {
        return this.numObjFields;
    }

    void getPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.getPrimFieldValues(object, byArray);
    }

    void setPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.setPrimFieldValues(object, byArray);
    }

    void getObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.getObjFieldValues(object, objectArray);
    }

    void setObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.setObjFieldValues(object, objectArray);
    }

    private void computeFieldOffsets() throws InvalidClassException {
        this.primDataSize = 0;
        this.numObjFields = 0;
        int n2 = -1;
        block7: for (int i = 0; i < a.arrayLength((Object[])this.fields); ++i) {
            ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])this.fields, (int)i), ObjectStreamField.class);
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ObjectStreamClass objectStreamClass = this;
                    int n3 = objectStreamClass.primDataSize;
                    objectStreamClass.primDataSize = n3 + 1;
                    objectStreamField.setOffset(n3);
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    objectStreamField.setOffset(this.primDataSize);
                    ObjectStreamClass objectStreamClass = this;
                    objectStreamClass.primDataSize = objectStreamClass.primDataSize + 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    objectStreamField.setOffset(this.primDataSize);
                    ObjectStreamClass objectStreamClass = this;
                    objectStreamClass.primDataSize = objectStreamClass.primDataSize + 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    objectStreamField.setOffset(this.primDataSize);
                    ObjectStreamClass objectStreamClass = this;
                    objectStreamClass.primDataSize = objectStreamClass.primDataSize + 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    ObjectStreamClass objectStreamClass = this;
                    int n4 = objectStreamClass.numObjFields;
                    objectStreamClass.numObjFields = n4 + 1;
                    objectStreamField.setOffset(n4);
                    if (n2 != -1) continue block7;
                    n2 = i;
                    continue block7;
                }
                default: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                }
            }
        }
        if (n2 != -1 && n2 + this.numObjFields != a.arrayLength((Object[])this.fields)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(this.name, "illegal field order"));
        }
    }

    private ObjectStreamClass getVariantFor(Class<?> clazz) throws InvalidClassException {
        if (!f.ifAcmp((Object)this.cl, clazz)) {
            return this;
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        if (this.isProxy) {
            objectStreamClass.initProxy(clazz, null, this.superDesc);
        } else {
            objectStreamClass.initNonProxy(this, clazz, null, this.superDesc);
        }
        return objectStreamClass;
    }

    private static Constructor getExternalizableConstructor(Class<?> clazz) {
        try {
            aj aj2 = ai.convertArgs(clazz, (Class[])null);
            Constructor constructor = aj2.clazz.getDeclaredConstructor(aj2.args);
            constructor.setAccessible(true);
            return (constructor.getModifiers() & 1) != 0 ? constructor : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Constructor getSerializableConstructor(Class<?> clazz) {
        Class clazz2 = clazz;
        while (x.isAssignableFrom(Serializable.class, clazz2)) {
            if ((clazz2 = x.getSuperclass(clazz2)) != null) continue;
            return null;
        }
        try {
            aj aj2 = ai.convertArgs((Class)clazz2, (Class[])null);
            Constructor constructor = aj2.clazz.getDeclaredConstructor(aj2.args);
            int n2 = constructor.getModifiers();
            if ((n2 & 2) != 0 || (n2 & 5) == 0 && !ObjectStreamClass.packageEquals(clazz, clazz2)) {
                return null;
            }
            constructor = reflFactory.newConstructorForSerialization(clazz, constructor);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getInheritableMethod(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2) {
        Method method = null;
        Class clazz3 = clazz;
        while (clazz3 != null) {
            try {
                aj aj2 = ai.convertArgsAndName(clazz3, (String)string, (Class[])classArray);
                method = aj2.clazz.getDeclaredMethod(aj2.name, aj2.args);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz3 = x.getSuperclass(clazz3);
            }
        }
        if (method == null || f.ifAcmp(method.getReturnType(), clazz2)) {
            return null;
        }
        method.setAccessible(true);
        int n2 = method.getModifiers();
        if ((n2 & 0x408) != 0) {
            return null;
        }
        if ((n2 & 5) != 0) {
            return method;
        }
        if ((n2 & 2) != 0) {
            return !f.ifAcmp((Object)clazz, (Object)clazz3) ? method : null;
        }
        return ObjectStreamClass.packageEquals(clazz, clazz3) ? method : null;
    }

    private static Method getPrivateMethod(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2) {
        try {
            aj aj2 = ai.convertArgsAndName(clazz, (String)string, (Class[])classArray);
            Method method = aj2.clazz.getDeclaredMethod(aj2.name, aj2.args);
            method.setAccessible(true);
            int n2 = method.getModifiers();
            return !f.ifAcmp(method.getReturnType(), clazz2) && (n2 & 8) == 0 && (n2 & 2) != 0 ? method : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static boolean packageEquals(Class<?> clazz, Class<?> clazz2) {
        return !f.ifAcmp((Object)((Object)clazz.getClassLoader()), (Object)((Object)clazz2.getClassLoader())) && ObjectStreamClass.getPackageName(clazz).equals(ObjectStreamClass.getPackageName(clazz2));
    }

    private static String getPackageName(Class<?> clazz) {
        String string = x.getName(clazz);
        int n2 = string.lastIndexOf(91);
        if (n2 >= 0) {
            string = string.substring(n2 + 2);
        }
        return (n2 = string.lastIndexOf(46)) >= 0 ? string.substring(0, n2) : "";
    }

    private static boolean classNamesEqual(String string, String string2) {
        string = string.substring(string.lastIndexOf(46) + 1);
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        return string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getClassSignature(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        while (ai.getCurrentClass(clazz).isArray()) {
            stringBuilder.append('[');
            clazz = ai.getCurrentClass(clazz).getComponentType();
        }
        if (ai.getCurrentClass(clazz).isPrimitive()) {
            if (!f.ifAcmp(clazz, Integer.TYPE)) {
                stringBuilder.append('I');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Byte.TYPE)) {
                stringBuilder.append('B');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Long.TYPE)) {
                stringBuilder.append('J');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Float.TYPE)) {
                stringBuilder.append('F');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Double.TYPE)) {
                stringBuilder.append('D');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Short.TYPE)) {
                stringBuilder.append('S');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Character.TYPE)) {
                stringBuilder.append('C');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Boolean.TYPE)) {
                stringBuilder.append('Z');
                return stringBuilder.toString();
            } else {
                if (f.ifAcmp(clazz, Void.TYPE)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                stringBuilder.append('V');
            }
            return stringBuilder.toString();
        } else {
            stringBuilder.append('L' + x.getName(clazz).replace('.', '/') + ';');
        }
        return stringBuilder.toString();
    }

    private static String getMethodSignature(Class<?>[] classArray, Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(ObjectStreamClass.getClassSignature(classArray[i]));
        }
        stringBuilder.append(')');
        stringBuilder.append(ObjectStreamClass.getClassSignature(clazz));
        return stringBuilder.toString();
    }

    private static void throwMiscException(Throwable throwable) throws IOException {
        if (g.convertForInstanceOf((Object)throwable, RuntimeException.class) instanceof RuntimeException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)throwable, RuntimeException.class)));
        }
        if (g.convertForInstanceOf((Object)throwable, Error.class) instanceof Error) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((Error)g.convertForCast((Object)throwable, Error.class)));
        }
        IOException iOException = new IOException("unexpected exception type");
        iOException.initCause(throwable);
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
    }

    private static ObjectStreamField[] getSerialFields(Class<?> clazz) throws InvalidClassException {
        Object[] objectArray;
        if (x.isAssignableFrom(Serializable.class, clazz) && !x.isAssignableFrom(Externalizable.class, clazz) && !Proxy.isProxyClass(clazz) && !ai.getCurrentClass(clazz).isInterface()) {
            objectArray = ObjectStreamClass.getDeclaredSerialFields(clazz);
            if (objectArray == null) {
                objectArray = ObjectStreamClass.getDefaultSerialFields(clazz);
            }
            Arrays.sort(objectArray);
        } else {
            objectArray = NO_FIELDS;
        }
        return objectArray;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class<?> clazz) throws InvalidClassException {
        Object[] objectArray;
        ObjectStreamField[] objectStreamFieldArray = null;
        try {
            objectArray = ai.getCurrentClass(clazz).getDeclaredField("serialPersistentFields");
            int n2 = 26;
            if ((objectArray.getModifiers() & n2) == n2) {
                objectArray.setAccessible(true);
                objectStreamFieldArray = (ObjectStreamField[])g.convertForCast((Object)((ObjectStreamField[])g.convertForCast((Object)objectArray.get(null), ObjectStreamField[].class)), ObjectStreamField[].class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectStreamFieldArray == null) {
            return null;
        }
        if (a.arrayLength(objectStreamFieldArray) == 0) {
            return NO_FIELDS;
        }
        objectArray = new ObjectStreamField[a.arrayLength(objectStreamFieldArray)];
        HashSet<String> hashSet = new HashSet<String>(a.arrayLength(objectStreamFieldArray));
        for (int i = 0; i < a.arrayLength(objectStreamFieldArray); ++i) {
            ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad(objectStreamFieldArray, (int)i), ObjectStreamField.class);
            String string = objectStreamField.getName();
            if (hashSet.contains(string)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException("multiple serializable fields named " + string));
            }
            hashSet.add(string);
            try {
                Field field = ai.getCurrentClass(clazz).getDeclaredField(string);
                if (!f.ifAcmp(field.getType(), objectStreamField.getType()) && (field.getModifiers() & 8) == 0) {
                    a.arrayStore((Object[])objectArray, (int)i, (Object)new ObjectStreamField(field, objectStreamField.isUnshared(), true));
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if ((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ObjectStreamField.class) != null) continue;
            a.arrayStore((Object[])objectArray, (int)i, (Object)new ObjectStreamField(string, objectStreamField.getType(), objectStreamField.isUnshared()));
        }
        return objectArray;
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class<?> clazz) {
        int n2;
        Object[] objectArray = ai.getCurrentClass(clazz).getDeclaredFields();
        ArrayList<ObjectStreamField> arrayList = new ArrayList<ObjectStreamField>();
        int n3 = 136;
        for (n2 = 0; n2 < a.arrayLength((Object[])objectArray); ++n2) {
            if ((((Field)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Field.class)).getModifiers() & n3) != 0) continue;
            arrayList.add(new ObjectStreamField((Field)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Field.class), false, true));
        }
        n2 = arrayList.size();
        return n2 == 0 ? NO_FIELDS : (ObjectStreamField[])g.convertForCast((Object)arrayList.toArray(new ObjectStreamField[n2]), ObjectStreamField[].class);
    }

    private static Long getDeclaredSUID(Class<?> clazz) {
        try {
            Field field = ai.getCurrentClass(clazz).getDeclaredField("serialVersionUID");
            int n2 = 24;
            if ((field.getModifiers() & n2) == n2) {
                field.setAccessible(true);
                return field.getLong(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static long computeDefaultSUID(Class<?> clazz) {
        if (!x.isAssignableFrom(Serializable.class, clazz) || Proxy.isProxyClass(clazz)) {
            return 0L;
        }
        try {
            int n2;
            int n3;
            MemberSignature[] memberSignatureArray;
            int n4;
            Object[] objectArray;
            h[] hArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(x.getName(clazz));
            int n5 = ai.getCurrentClass(clazz).getModifiers() & 0x611;
            Method[] methodArray = ai.getCurrentClass(clazz).getDeclaredMethods();
            if ((n5 & 0x200) != 0) {
                n5 = methodArray.length > 0 ? n5 | 0x400 : n5 & 0xFFFFFBFF;
            }
            dataOutputStream.writeInt(n5);
            if (!ai.getCurrentClass(clazz).isArray()) {
                hArray = n.filterInterfaces((Class[])x.getInterfaces(clazz));
                objectArray = new String[hArray.length];
                for (n4 = 0; n4 < hArray.length; ++n4) {
                    objectArray[n4] = x.getName((Class)hArray[n4]);
                }
                Arrays.sort(objectArray);
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    dataOutputStream.writeUTF((String)objectArray[n4]);
                }
            }
            hArray = ai.getCurrentClass(clazz).getDeclaredFields();
            objectArray = new MemberSignature[a.arrayLength((Object[])hArray)];
            for (n4 = 0; n4 < a.arrayLength((Object[])hArray); ++n4) {
                a.arrayStore((Object[])objectArray, (int)n4, (Object)((Object)new MemberSignature((Field)g.convertForCast((Object)a.arrayLoad((Object[])hArray, (int)n4), Field.class))));
            }
            Arrays.sort(objectArray, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    return ms1.name.compareTo(ms2.name);
                }
            });
            for (n4 = 0; n4 < a.arrayLength((Object[])objectArray); ++n4) {
                memberSignatureArray = (MemberSignature[])g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n4), MemberSignature.class);
                n3 = ((MemberSignature)((Object)memberSignatureArray)).member.getModifiers() & 0xDF;
                if ((n3 & 2) != 0 && (n3 & 0x88) != 0) continue;
                dataOutputStream.writeUTF(((MemberSignature)((Object)memberSignatureArray)).name);
                dataOutputStream.writeInt(n3);
                dataOutputStream.writeUTF(((MemberSignature)((Object)memberSignatureArray)).signature);
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            Constructor<?>[] constructorArray = ai.getCurrentClass(clazz).getDeclaredConstructors();
            memberSignatureArray = new MemberSignature[constructorArray.length];
            for (n3 = 0; n3 < constructorArray.length; ++n3) {
                a.arrayStore((Object[])memberSignatureArray, (int)n3, (Object)((Object)new MemberSignature(constructorArray[n3])));
            }
            Arrays.sort(memberSignatureArray, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    return ms1.signature.compareTo(ms2.signature);
                }
            });
            for (n3 = 0; n3 < a.arrayLength((Object[])memberSignatureArray); ++n3) {
                MemberSignature memberSignature = (MemberSignature)((Object)g.convertForCast((Object)a.arrayLoad((Object[])memberSignatureArray, (int)n3), MemberSignature.class));
                int n6 = ((MemberSignature)((Object)((Object)memberSignature))).member.getModifiers() & 0xD3F;
                if ((n6 & 2) != 0) continue;
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(n6);
                dataOutputStream.writeUTF(((MemberSignature)((Object)((Object)memberSignature))).signature.replace('/', '.'));
            }
            MemberSignature[] memberSignatureArray2 = new MemberSignature[methodArray.length];
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                a.arrayStore((Object[])memberSignatureArray2, (int)n2, (Object)((Object)new MemberSignature(methodArray[n2])));
            }
            Arrays.sort(memberSignatureArray2, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    int comp = ms1.name.compareTo(ms2.name);
                    if (comp == 0) {
                        comp = ms1.signature.compareTo(ms2.signature);
                    }
                    return comp;
                }
            });
            for (n2 = 0; n2 < a.arrayLength((Object[])memberSignatureArray2); ++n2) {
                MemberSignature memberSignature = (MemberSignature)((Object)g.convertForCast((Object)a.arrayLoad((Object[])memberSignatureArray2, (int)n2), MemberSignature.class));
                int n7 = ((MemberSignature)((Object)((Object)memberSignature))).member.getModifiers() & 0xD3F;
                if ((n7 & 2) != 0) continue;
                dataOutputStream.writeUTF(((MemberSignature)((Object)((Object)memberSignature))).name);
                dataOutputStream.writeInt(n7);
                dataOutputStream.writeUTF(((MemberSignature)((Object)((Object)memberSignature))).signature.replace('/', '.'));
            }
            dataOutputStream.flush();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
            long l = 0L;
            for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                l = l << 8 | (long)(byArray[i] & 0xFF);
            }
            return l;
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SecurityException(noSuchAlgorithmException.getMessage()));
        }
    }

    private static native boolean hasStaticInitializer(Class<?> var0);

    private static FieldReflector getReflector(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        Class clazz = objectStreamClass != null && a.arrayLength((Object[])objectStreamFieldArray) > 0 ? objectStreamClass.cl : null;
        ObjectStreamClass.processQueue(Caches.reflectorsQueue, Caches.reflectors);
        FieldReflectorKey fieldReflectorKey = new FieldReflectorKey(clazz, objectStreamFieldArray, Caches.reflectorsQueue);
        Reference reference = (Reference)((Object)g.convertForCast(Caches.reflectors.get((Object)fieldReflectorKey), Reference.class));
        Object object = null;
        if (reference != null) {
            object = reference.get();
        }
        EntryFuture entryFuture = null;
        if (object == null) {
            EntryFuture entryFuture2 = new EntryFuture();
            SoftReference<EntryFuture> softReference = new SoftReference<EntryFuture>(entryFuture2);
            do {
                if (reference != null) {
                    Caches.reflectors.remove((Object)fieldReflectorKey, (Object)reference);
                }
                if ((reference = (Reference)((Object)g.convertForCast(Caches.reflectors.putIfAbsent(fieldReflectorKey, softReference), Reference.class))) == null) continue;
                object = reference.get();
            } while (reference != null && object == null);
            if (object == null) {
                entryFuture = entryFuture2;
            }
        }
        if (g.convertForInstanceOf(object, FieldReflector.class) instanceof FieldReflector) {
            return (FieldReflector)((Object)g.convertForCast(object, FieldReflector.class));
        }
        if (g.convertForInstanceOf(object, EntryFuture.class) instanceof EntryFuture) {
            object = ((EntryFuture)((Object)g.convertForCast(object, EntryFuture.class))).get();
        } else if (object == null) {
            try {
                object = new FieldReflector(ObjectStreamClass.matchFields(objectStreamFieldArray, objectStreamClass));
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            entryFuture.set(object);
            Caches.reflectors.put(fieldReflectorKey, new SoftReference<Object>(object));
        }
        if (g.convertForInstanceOf(object, FieldReflector.class) instanceof FieldReflector) {
            return (FieldReflector)((Object)g.convertForCast((Object)object, FieldReflector.class));
        }
        if (g.convertForInstanceOf((Object)object, InvalidClassException.class) instanceof InvalidClassException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InvalidClassException)g.convertForCast((Object)object, InvalidClassException.class)));
        }
        if (g.convertForInstanceOf((Object)object, RuntimeException.class) instanceof RuntimeException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)object, RuntimeException.class)));
        }
        if (g.convertForInstanceOf((Object)object, Error.class) instanceof Error) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((Error)g.convertForCast((Object)object, Error.class)));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("unexpected entry: " + object));
    }

    private static ObjectStreamField[] matchFields(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        Object[] objectArray = objectStreamClass != null ? objectStreamClass.fields : NO_FIELDS;
        Object[] objectArray2 = new ObjectStreamField[a.arrayLength((Object[])objectStreamFieldArray)];
        for (int i = 0; i < a.arrayLength((Object[])objectStreamFieldArray); ++i) {
            ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectStreamFieldArray, (int)i), ObjectStreamField.class);
            ObjectStreamField objectStreamField2 = null;
            for (int k = 0; k < a.arrayLength((Object[])objectArray); ++k) {
                ObjectStreamField objectStreamField3 = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)k), ObjectStreamField.class);
                if (!objectStreamField.getName().equals(objectStreamField3.getName())) continue;
                if ((objectStreamField.isPrimitive() || objectStreamField3.isPrimitive()) && objectStreamField.getTypeCode() != objectStreamField3.getTypeCode()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidClassException(objectStreamClass.name, "incompatible types for field " + objectStreamField.getName()));
                }
                objectStreamField2 = objectStreamField3.getField() != null ? new ObjectStreamField(objectStreamField3.getField(), objectStreamField3.isUnshared(), false) : new ObjectStreamField(objectStreamField3.getName(), objectStreamField3.getSignature(), objectStreamField3.isUnshared());
            }
            if (objectStreamField2 == null) {
                objectStreamField2 = new ObjectStreamField(objectStreamField.getName(), objectStreamField.getSignature(), false);
            }
            objectStreamField2.setOffset(objectStreamField.getOffset());
            a.arrayStore((Object[])objectArray2, (int)i, (Object)objectStreamField2);
        }
        return objectArray2;
    }

    static void processQueue(ReferenceQueue<Class<?>> referenceQueue, ConcurrentMap<? extends WeakReference<Class<?>>, ?> concurrentMap) {
        Reference reference;
        while ((reference = referenceQueue.poll()) != null) {
            concurrentMap.remove((Object)reference);
        }
    }

    static /* synthetic */ Class access$000(ObjectStreamClass objectStreamClass) {
        return objectStreamClass.cl;
    }

    static /* synthetic */ long access$100(Class clazz) {
        return ObjectStreamClass.computeDefaultSUID(clazz);
    }

    static /* synthetic */ Long access$502(ObjectStreamClass objectStreamClass, Long l) {
        Long l2 = l;
        objectStreamClass.suid = l2;
        return l2;
    }

    static /* synthetic */ ObjectStreamField[] access$602(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static /* synthetic */ ExceptionInfo access$1002(ObjectStreamClass objectStreamClass, ExceptionInfo exceptionInfo) {
        ExceptionInfo exceptionInfo2 = exceptionInfo;
        objectStreamClass.serializeEx = exceptionInfo2;
        return exceptionInfo2;
    }

    static /* synthetic */ ExceptionInfo access$1102(ObjectStreamClass objectStreamClass, ExceptionInfo exceptionInfo) {
        ExceptionInfo exceptionInfo2 = exceptionInfo;
        objectStreamClass.deserializeEx = exceptionInfo2;
        return exceptionInfo2;
    }

    static /* synthetic */ Constructor access$1302(ObjectStreamClass objectStreamClass, Constructor constructor) {
        Constructor constructor2 = constructor;
        objectStreamClass.cons = constructor2;
        return constructor2;
    }

    static /* synthetic */ Method access$1602(ObjectStreamClass objectStreamClass, Method method) {
        Method method2 = method;
        objectStreamClass.writeObjectMethod = method2;
        return method2;
    }

    static /* synthetic */ Method access$1802(ObjectStreamClass objectStreamClass, Method method) {
        Method method2 = method;
        objectStreamClass.readObjectMethod = method2;
        return method2;
    }

    static /* synthetic */ Method access$1902(ObjectStreamClass objectStreamClass, Method method) {
        Method method2 = method;
        objectStreamClass.readObjectNoDataMethod = method2;
        return method2;
    }

    static /* synthetic */ boolean access$2002(ObjectStreamClass objectStreamClass, boolean bl) {
        boolean bl2 = bl;
        objectStreamClass.hasWriteObjectData = bl2;
        return bl2;
    }

    static /* synthetic */ Method access$2102(ObjectStreamClass objectStreamClass, Method method) {
        Method method2 = method;
        objectStreamClass.writeReplaceMethod = method2;
        return method2;
    }

    static /* synthetic */ Method access$2302(ObjectStreamClass objectStreamClass, Method method) {
        Method method2 = method;
        objectStreamClass.readResolveMethod = method2;
        return method2;
    }

    static {
        ObjectStreamClass.initNative();
    }

    private static /* synthetic */ void _jr$ip$defaultSerializeEx(ObjectStreamClass objectStreamClass, ExceptionInfo exceptionInfo) {
        objectStreamClass.defaultSerializeEx = exceptionInfo;
    }

    protected /* synthetic */ ObjectStreamClass(h h2) {
        super(h2);
    }

    private static class Caches
    extends h {
        static final ConcurrentMap<WeakClassKey, Reference<?>> localDescs = new ConcurrentHashMap();
        static final ConcurrentMap<FieldReflectorKey, Reference<?>> reflectors = new ConcurrentHashMap();
        private static final ReferenceQueue<Class<?>> localDescsQueue = new ReferenceQueue();
        private static final ReferenceQueue<Class<?>> reflectorsQueue = new ReferenceQueue();

        private Caches() {
        }

        protected /* synthetic */ Caches(h h2) {
            super(h2);
        }
    }

    static class ClassDataSlot
    extends h {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass objectStreamClass, boolean bl) {
            this.desc = objectStreamClass;
            this.hasData = bl;
        }

        static /* synthetic */ ObjectStreamClass _jr$ig$desc(Object object) {
            return ((ClassDataSlot)((Object)object)).desc;
        }

        static /* synthetic */ void _jr$ip$desc(Object object, ObjectStreamClass objectStreamClass) {
            ((ClassDataSlot)((Object)object)).desc = objectStreamClass;
        }

        static /* synthetic */ boolean _jr$ig$hasData(Object object) {
            return ((ClassDataSlot)((Object)object)).hasData;
        }

        static /* synthetic */ void _jr$ip$hasData(Object object, boolean bl) {
            ((ClassDataSlot)((Object)object)).hasData = bl;
        }

        protected /* synthetic */ ClassDataSlot(h h2) {
            super(h2);
        }
    }

    private static class EntryFuture
    extends h {
        private static final Object unset = new Object();
        private final Thread owner;
        private Object entry;

        private EntryFuture() {
            this.owner = Thread.currentThread();
            this.entry = unset;
        }

        @af(modifiers=32)
        boolean set(Object object) {
            Object object2 = ah.getMonitor((Object)((Object)this));
            synchronized (object2) {
                try {
                    if (f.ifAcmp((Object)this.entry, (Object)unset)) {
                        return false;
                    }
                    this.entry = object;
                    ah.getMonitor((Object)((Object)this)).notifyAll();
                    return true;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @af(modifiers=32)
        Object get() {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    boolean bl = false;
                    while (!f.ifAcmp((Object)this.entry, (Object)unset)) {
                        try {
                            ah.getMonitor((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
                    }
                    return this.entry;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        Thread getOwner() {
            return this.owner;
        }

        private static /* synthetic */ void _jr$ip$owner(EntryFuture entryFuture, Thread thread) {
            entryFuture.owner = thread;
        }

        protected /* synthetic */ EntryFuture(h h2) {
            super(h2);
        }
    }

    private static class ExceptionInfo
    extends h {
        private final String className;
        private final String message;

        ExceptionInfo(String string, String string2) {
            this.className = string;
            this.message = string2;
        }

        InvalidClassException newInvalidClassException() {
            return new InvalidClassException(this.className, this.message);
        }

        private static /* synthetic */ void _jr$ip$className(ExceptionInfo exceptionInfo, String string) {
            exceptionInfo.className = string;
        }

        private static /* synthetic */ void _jr$ip$message(ExceptionInfo exceptionInfo, String string) {
            exceptionInfo.message = string;
        }

        protected /* synthetic */ ExceptionInfo(h h2) {
            super(h2);
        }
    }

    private static class FieldReflector
    extends h {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private final long[] readKeys;
        private final long[] writeKeys;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class<?>[] types;

        FieldReflector(ObjectStreamField[] objectStreamFieldArray) {
            this.fields = objectStreamFieldArray;
            int n2 = a.arrayLength((Object[])objectStreamFieldArray);
            this.readKeys = new long[n2];
            this.writeKeys = new long[n2];
            this.offsets = new int[n2];
            this.typeCodes = new char[n2];
            ArrayList arrayList = new ArrayList();
            HashSet<Long> hashSet = new HashSet<Long>();
            for (int i = 0; i < n2; ++i) {
                long l;
                ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectStreamFieldArray, (int)i), ObjectStreamField.class);
                Field field = objectStreamField.getField();
                this.readKeys[i] = l = field != null ? unsafe.objectFieldOffset(field) : -1L;
                this.writeKeys[i] = hashSet.add(l) ? l : -1L;
                this.offsets[i] = objectStreamField.getOffset();
                this.typeCodes[i] = objectStreamField.getTypeCode();
                if (objectStreamField.isPrimitive()) continue;
                arrayList.add(field != null ? field.getType() : null);
            }
            this.types = arrayList.toArray(new Class[arrayList.size()]);
            this.numPrimFields = n2 - a.arrayLength((Object[])this.types);
        }

        ObjectStreamField[] getFields() {
            return this.fields;
        }

        void getPrimFieldValues(Object object, byte[] byArray) {
            if ((object = an.forceStateMigrate((Object)object, (boolean)true)) == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long l = this.readKeys[i];
                int n2 = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        Bits.putBoolean(byArray, n2, unsafe.getBoolean(object, l));
                        continue block10;
                    }
                    case 'B': {
                        byArray[n2] = unsafe.getByte(object, l);
                        continue block10;
                    }
                    case 'C': {
                        Bits.putChar(byArray, n2, unsafe.getChar(object, l));
                        continue block10;
                    }
                    case 'S': {
                        Bits.putShort(byArray, n2, unsafe.getShort(object, l));
                        continue block10;
                    }
                    case 'I': {
                        Bits.putInt(byArray, n2, unsafe.getInt(object, l));
                        continue block10;
                    }
                    case 'F': {
                        Bits.putFloat(byArray, n2, unsafe.getFloat(object, l));
                        continue block10;
                    }
                    case 'J': {
                        Bits.putLong(byArray, n2, unsafe.getLong(object, l));
                        continue block10;
                    }
                    case 'D': {
                        Bits.putDouble(byArray, n2, unsafe.getDouble(object, l));
                        continue block10;
                    }
                    default: {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                    }
                }
            }
        }

        void setPrimFieldValues(Object object, byte[] byArray) {
            if ((object = an.forceStateMigrate((Object)object, (boolean)true)) == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long l = this.writeKeys[i];
                if (l == -1L) continue;
                int n2 = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        unsafe.putBoolean(object, l, Bits.getBoolean(byArray, n2));
                        continue block10;
                    }
                    case 'B': {
                        unsafe.putByte(object, l, byArray[n2]);
                        continue block10;
                    }
                    case 'C': {
                        unsafe.putChar(object, l, Bits.getChar(byArray, n2));
                        continue block10;
                    }
                    case 'S': {
                        unsafe.putShort(object, l, Bits.getShort(byArray, n2));
                        continue block10;
                    }
                    case 'I': {
                        unsafe.putInt(object, l, Bits.getInt(byArray, n2));
                        continue block10;
                    }
                    case 'F': {
                        unsafe.putFloat(object, l, Bits.getFloat(byArray, n2));
                        continue block10;
                    }
                    case 'J': {
                        unsafe.putLong(object, l, Bits.getLong(byArray, n2));
                        continue block10;
                    }
                    case 'D': {
                        unsafe.putDouble(object, l, Bits.getDouble(byArray, n2));
                        continue block10;
                    }
                    default: {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                    }
                }
            }
        }

        void getObjFieldValues(Object object, Object[] objectArray) {
            if ((object = an.forceStateMigrate((Object)object, (boolean)true)) == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            block3: for (int i = this.numPrimFields; i < a.arrayLength((Object[])this.fields); ++i) {
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        a.arrayStore((Object[])objectArray, (int)this.offsets[i], (Object)unsafe.getObject(object, this.readKeys[i]));
                        continue block3;
                    }
                    default: {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                    }
                }
            }
        }

        void setObjFieldValues(Object object, Object[] objectArray) {
            if ((object = an.forceStateMigrate((Object)object, (boolean)true)) == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            block3: for (int i = this.numPrimFields; i < a.arrayLength((Object[])this.fields); ++i) {
                long l = this.writeKeys[i];
                if (l == -1L) continue;
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        Object object2 = a.arrayLoad((Object[])objectArray, (int)this.offsets[i]);
                        if (object2 != null && !x.isInstance((Class)((Class)a.arrayLoad((Object[])this.types, (int)(i - this.numPrimFields))), (Object)object2)) {
                            Field field = ((ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])this.fields, (int)i), ObjectStreamField.class)).getField();
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ClassCastException("cannot assign instance of " + x.getName(object2.getClass()) + " to field " + x.getName(field.getDeclaringClass()) + "." + field.getName() + " of type " + x.getName(field.getType()) + " in instance of " + x.getName(object.getClass())));
                        }
                        unsafe.putObject(object, l, object2);
                        continue block3;
                    }
                    default: {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                    }
                }
            }
        }

        private static /* synthetic */ void _jr$ip$fields(FieldReflector fieldReflector, ObjectStreamField[] objectStreamFieldArray) {
            fieldReflector.fields = objectStreamFieldArray;
        }

        private static /* synthetic */ void _jr$ip$numPrimFields(FieldReflector fieldReflector, int n2) {
            fieldReflector.numPrimFields = n2;
        }

        private static /* synthetic */ void _jr$ip$readKeys(FieldReflector fieldReflector, long[] lArray) {
            fieldReflector.readKeys = lArray;
        }

        private static /* synthetic */ void _jr$ip$writeKeys(FieldReflector fieldReflector, long[] lArray) {
            fieldReflector.writeKeys = lArray;
        }

        private static /* synthetic */ void _jr$ip$offsets(FieldReflector fieldReflector, int[] nArray) {
            fieldReflector.offsets = nArray;
        }

        private static /* synthetic */ void _jr$ip$typeCodes(FieldReflector fieldReflector, char[] cArray) {
            fieldReflector.typeCodes = cArray;
        }

        private static /* synthetic */ void _jr$ip$types(FieldReflector fieldReflector, Class[] classArray) {
            fieldReflector.types = classArray;
        }

        protected /* synthetic */ FieldReflector(h h2) {
            super(h2);
        }
    }

    private static class FieldReflectorKey
    extends WeakReference<Class<?>> {
        private final String sigs;
        private final int hash;
        private final boolean nullClass;

        FieldReflectorKey(Class<?> clazz, ObjectStreamField[] objectStreamFieldArray, ReferenceQueue<Class<?>> referenceQueue) {
            super(clazz, referenceQueue);
            this.nullClass = clazz == null;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < a.arrayLength((Object[])objectStreamFieldArray); ++i) {
                ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)a.arrayLoad((Object[])objectStreamFieldArray, (int)i), ObjectStreamField.class);
                stringBuilder.append(objectStreamField.getName()).append(objectStreamField.getSignature());
            }
            this.sigs = stringBuilder.toString();
            this.hash = w.getIdentityHashCode(clazz) + this.sigs.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)object, (Object)((Object)this))) {
                return true;
            }
            if (g.convertForInstanceOf((Object)object, FieldReflectorKey.class) instanceof FieldReflectorKey) {
                Class clazz;
                FieldReflectorKey fieldReflectorKey = (FieldReflectorKey)((Object)g.convertForCast((Object)object, FieldReflectorKey.class));
                return (this.nullClass ? fieldReflectorKey.nullClass : (clazz = (Class)this.get()) != null && !f.ifAcmp((Object)clazz, fieldReflectorKey.get())) && this.sigs.equals(fieldReflectorKey.sigs);
            }
            return false;
        }

        private static /* synthetic */ void _jr$ip$sigs(FieldReflectorKey fieldReflectorKey, String string) {
            fieldReflectorKey.sigs = string;
        }

        private static /* synthetic */ void _jr$ip$hash(FieldReflectorKey fieldReflectorKey, int n2) {
            fieldReflectorKey.hash = n2;
        }

        private static /* synthetic */ void _jr$ip$nullClass(FieldReflectorKey fieldReflectorKey, boolean bl) {
            fieldReflectorKey.nullClass = bl;
        }

        protected /* synthetic */ FieldReflectorKey(h h2) {
            super(h2);
        }
    }

    private static class MemberSignature
    extends h {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = ObjectStreamClass.getClassSignature(field.getType());
        }

        public MemberSignature(Constructor constructor) {
            this.member = constructor;
            this.name = constructor.getName();
            this.signature = ObjectStreamClass.getMethodSignature(constructor.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method method) {
            this.member = method;
            this.name = method.getName();
            this.signature = ObjectStreamClass.getMethodSignature(method.getParameterTypes(), method.getReturnType());
        }

        public static /* synthetic */ void _jr$ip$member(Object object, Member member) {
            ((MemberSignature)((Object)object)).member = member;
        }

        public static /* synthetic */ void _jr$ip$name(Object object, String string) {
            ((MemberSignature)((Object)object)).name = string;
        }

        public static /* synthetic */ void _jr$ip$signature(Object object, String string) {
            ((MemberSignature)((Object)object)).signature = string;
        }

        protected /* synthetic */ MemberSignature(h h2) {
            super(h2);
        }
    }

    static class WeakClassKey
    extends WeakReference<Class<?>> {
        private final int hash;

        WeakClassKey(Class<?> clazz, ReferenceQueue<Class<?>> referenceQueue) {
            super(clazz, referenceQueue);
            this.hash = w.getIdentityHashCode(clazz);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)object, (Object)((Object)this))) {
                return true;
            }
            if (g.convertForInstanceOf((Object)object, WeakClassKey.class) instanceof WeakClassKey) {
                Object t = this.get();
                return t != null && !f.ifAcmp(t, ((WeakClassKey)((Object)g.convertForCast((Object)object, WeakClassKey.class))).get());
            }
            return false;
        }

        private static /* synthetic */ void _jr$ip$hash(WeakClassKey weakClassKey, int n2) {
            weakClassKey.hash = n2;
        }

        protected /* synthetic */ WeakClassKey(h h2) {
            super(h2);
        }
    }
}

