/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.lang.reflect.Field;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public class ObjectStreamField
extends h
implements Comparable {
    private final String name;
    private final String signature;
    private final Class<?> type;
    private final boolean unshared;
    private final Field field;
    private int offset;

    public ObjectStreamField(String string, Class<?> clazz) {
        this(string, clazz, false);
    }

    public ObjectStreamField(String string, Class<?> clazz, boolean bl) {
        this.offset = 0;
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.name = string;
        this.type = clazz;
        this.unshared = bl;
        this.signature = ObjectStreamField.getClassSignature(clazz).intern();
        this.field = null;
    }

    ObjectStreamField(String string, String string2, boolean bl) {
        this.offset = 0;
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.name = string;
        this.signature = string2.intern();
        this.unshared = bl;
        this.field = null;
        switch (string2.charAt(0)) {
            case 'Z': {
                this.type = Boolean.TYPE;
                break;
            }
            case 'B': {
                this.type = Byte.TYPE;
                break;
            }
            case 'C': {
                this.type = Character.TYPE;
                break;
            }
            case 'S': {
                this.type = Short.TYPE;
                break;
            }
            case 'I': {
                this.type = Integer.TYPE;
                break;
            }
            case 'J': {
                this.type = Long.TYPE;
                break;
            }
            case 'F': {
                this.type = Float.TYPE;
                break;
            }
            case 'D': {
                this.type = Double.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.type = Object.class;
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("illegal signature"));
            }
        }
    }

    ObjectStreamField(Field field, boolean bl, boolean bl2) {
        this.offset = 0;
        this.field = field;
        this.unshared = bl;
        this.name = field.getName();
        Class<?> clazz = field.getType();
        this.type = bl2 || ai.getCurrentClass(clazz).isPrimitive() ? clazz : Object.class;
        this.signature = ObjectStreamField.getClassSignature(clazz).intern();
    }

    public String getName() {
        return this.name;
    }

    @CallerSensitive
    public Class<?> getType() {
        Class clazz;
        if (System.getSecurityManager() != null && ReflectUtil.needsPackageAccessCheck((clazz = Reflection.getCallerClass()).getClassLoader(), this.type.getClassLoader())) {
            ReflectUtil.checkPackageAccess(this.type);
        }
        return this.type;
    }

    public char getTypeCode() {
        return this.signature.charAt(0);
    }

    public String getTypeString() {
        return this.isPrimitive() ? null : this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int n) {
        this.offset = n;
    }

    public boolean isPrimitive() {
        char c = this.signature.charAt(0);
        return c != 'L' && c != '[';
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public int compareTo(Object object) {
        ObjectStreamField objectStreamField = (ObjectStreamField)g.convertForCast((Object)object, ObjectStreamField.class);
        boolean bl = this.isPrimitive();
        if (bl != objectStreamField.isPrimitive()) {
            return bl ? -1 : 1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    public String toString() {
        return this.signature + ' ' + this.name;
    }

    Field getField() {
        return this.field;
    }

    String getSignature() {
        return this.signature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getClassSignature(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        while (ai.getCurrentClass(clazz).isArray()) {
            stringBuilder.append('[');
            clazz = ai.getCurrentClass(clazz).getComponentType();
        }
        if (ai.getCurrentClass(clazz).isPrimitive()) {
            if (!f.ifAcmp(clazz, Integer.TYPE)) {
                stringBuilder.append('I');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Byte.TYPE)) {
                stringBuilder.append('B');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Long.TYPE)) {
                stringBuilder.append('J');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Float.TYPE)) {
                stringBuilder.append('F');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Double.TYPE)) {
                stringBuilder.append('D');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Short.TYPE)) {
                stringBuilder.append('S');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Character.TYPE)) {
                stringBuilder.append('C');
                return stringBuilder.toString();
            } else if (!f.ifAcmp(clazz, Boolean.TYPE)) {
                stringBuilder.append('Z');
                return stringBuilder.toString();
            } else {
                if (f.ifAcmp(clazz, Void.TYPE)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
                stringBuilder.append('V');
            }
            return stringBuilder.toString();
        } else {
            stringBuilder.append('L' + x.getName(clazz).replace('.', '/') + ';');
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void _jr$ip$name(ObjectStreamField objectStreamField, String string) {
        objectStreamField.name = string;
    }

    private static /* synthetic */ void _jr$ip$signature(ObjectStreamField objectStreamField, String string) {
        objectStreamField.signature = string;
    }

    private static /* synthetic */ void _jr$ip$type(ObjectStreamField objectStreamField, Class clazz) {
        objectStreamField.type = clazz;
    }

    private static /* synthetic */ void _jr$ip$unshared(ObjectStreamField objectStreamField, boolean bl) {
        objectStreamField.unshared = bl;
    }

    private static /* synthetic */ void _jr$ip$field(ObjectStreamField objectStreamField, Field field) {
        objectStreamField.field = field;
    }

    protected /* synthetic */ ObjectStreamField(h h2) {
        super(h2);
    }
}

