/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Formatter;
import java.util.Locale;

public class PrintStream
extends FilterOutputStream
implements Appendable,
Closeable {
    private final boolean autoFlush;
    private boolean trouble;
    private Formatter formatter;
    private BufferedWriter textOut;
    private OutputStreamWriter charOut;
    private boolean closing;

    private static <T> T requireNonNull(T t, String string) {
        if (t == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException(string));
        }
        return t;
    }

    private static Charset toCharset(String string) throws UnsupportedEncodingException {
        PrintStream.requireNonNull(string, "charsetName");
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedEncodingException(string));
        }
    }

    private PrintStream(boolean bl, OutputStream outputStream) {
        super(outputStream);
        this.trouble = false;
        this.closing = false;
        this.autoFlush = bl;
        this.charOut = new OutputStreamWriter(this);
        this.textOut = new BufferedWriter(this.charOut);
    }

    private PrintStream(boolean bl, OutputStream outputStream, Charset charset) {
        super(outputStream);
        this.trouble = false;
        this.closing = false;
        this.autoFlush = bl;
        this.charOut = new OutputStreamWriter((OutputStream)this, charset);
        this.textOut = new BufferedWriter(this.charOut);
    }

    private PrintStream(boolean bl, Charset charset, OutputStream outputStream) throws UnsupportedEncodingException {
        this(bl, outputStream, charset);
    }

    public PrintStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintStream(OutputStream outputStream, boolean bl) {
        this(bl, (OutputStream)g.convertForCast((Object)PrintStream.requireNonNull(outputStream, "Null output stream"), OutputStream.class));
    }

    public PrintStream(OutputStream outputStream, boolean bl, String string) throws UnsupportedEncodingException {
        this(bl, (OutputStream)g.convertForCast((Object)PrintStream.requireNonNull(outputStream, "Null output stream"), OutputStream.class), PrintStream.toCharset(string));
    }

    public PrintStream(String string) throws FileNotFoundException {
        this(false, new FileOutputStream(string));
    }

    public PrintStream(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(false, PrintStream.toCharset(string2), new FileOutputStream(string));
    }

    public PrintStream(File file) throws FileNotFoundException {
        this(false, new FileOutputStream(file));
    }

    public PrintStream(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(false, PrintStream.toCharset(string), new FileOutputStream(file));
    }

    private void ensureOpen() throws IOException {
        if (PrintStream._jr$ig$out(this) == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                try {
                    this.ensureOpen();
                    PrintStream._jr$ig$out(this).flush();
                }
                catch (IOException iOException) {
                    this.trouble = true;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (!this.closing) {
                    this.closing = true;
                    try {
                        this.textOut.close();
                        PrintStream._jr$ig$out(this).close();
                    }
                    catch (IOException iOException) {
                        this.trouble = true;
                    }
                    this.textOut = null;
                    this.charOut = null;
                    PrintStream._jr$ip$out(this, null);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public boolean checkError() {
        if (PrintStream._jr$ig$out(this) != null) {
            this.flush();
        }
        if (g.convertForInstanceOf((Object)PrintStream._jr$ig$out(this), PrintStream.class) instanceof PrintStream) {
            PrintStream printStream = (PrintStream)g.convertForCast((Object)PrintStream._jr$ig$out(this), PrintStream.class);
            return printStream.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n2) {
        try {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    this.ensureOpen();
                    PrintStream._jr$ig$out(this).write(n2);
                    if (n2 == 10 && this.autoFlush) {
                        PrintStream._jr$ig$out(this).flush();
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n2, int n3) {
        try {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    this.ensureOpen();
                    PrintStream._jr$ig$out(this).write(byArray, n2, n3);
                    if (this.autoFlush) {
                        PrintStream._jr$ig$out(this).flush();
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(char[] cArray) {
        try {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    this.ensureOpen();
                    this.textOut.write(cArray);
                    this.textOut.flushBuffer();
                    this.charOut.flushBuffer();
                    if (this.autoFlush) {
                        for (int i = 0; i < cArray.length; ++i) {
                            if (cArray[i] != '\n') continue;
                            PrintStream._jr$ig$out(this).flush();
                        }
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String string) {
        try {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    this.ensureOpen();
                    this.textOut.write(string);
                    this.textOut.flushBuffer();
                    this.charOut.flushBuffer();
                    if (this.autoFlush && string.indexOf(10) >= 0) {
                        PrintStream._jr$ig$out(this).flush();
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    this.ensureOpen();
                    this.textOut.newLine();
                    this.textOut.flushBuffer();
                    this.charOut.flushBuffer();
                    if (this.autoFlush) {
                        PrintStream._jr$ig$out(this).flush();
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n2) {
        this.write(String.valueOf(n2));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f2) {
        this.write(String.valueOf(f2));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.print(bl);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.print(c);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.print(n2);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.print(l);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.print(f2);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.print(d);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.print(cArray);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.print(string);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        String string = String.valueOf(object);
        Object object2 = ah.getMonitor((Object)this);
        synchronized (object2) {
            try {
                this.print(string);
                this.newLine();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public PrintStream printf(String string, Object ... objectArray) {
        return this.format(string, objectArray);
    }

    public PrintStream printf(Locale locale, String string, Object ... objectArray) {
        return this.format(locale, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream format(String string, Object ... objectArray) {
        try {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    this.ensureOpen();
                    if (this.formatter == null || f.ifAcmp((Object)this.formatter.locale(), (Object)Locale.getDefault())) {
                        this.formatter = new Formatter((Appendable)this);
                    }
                    this.formatter.format(Locale.getDefault(), string, objectArray);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream format(Locale locale, String string, Object ... objectArray) {
        try {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    this.ensureOpen();
                    if (this.formatter == null || f.ifAcmp((Object)this.formatter.locale(), (Object)locale)) {
                        this.formatter = new Formatter(this, locale);
                    }
                    this.formatter.format(locale, string, objectArray);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        if (charSequence == null) {
            this.print("null");
        } else {
            this.print(charSequence.toString());
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence, int n2, int n3) {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        this.write(charSequence2.subSequence(n2, n3).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    private static /* synthetic */ void _jr$ip$autoFlush(PrintStream printStream, boolean bl) {
        printStream.autoFlush = bl;
    }

    protected /* synthetic */ PrintStream(h h2) {
        super(h2);
    }
}

