/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import sun.security.action.GetPropertyAction;

public class PrintWriter
extends Writer {
    protected Writer out;
    private final boolean autoFlush;
    private boolean trouble;
    private Formatter formatter;
    private PrintStream psOut;
    private final String lineSeparator;

    private static Charset toCharset(String string) throws UnsupportedEncodingException {
        Objects.requireNonNull(string, "charsetName");
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedEncodingException(string));
        }
    }

    public PrintWriter(Writer writer) {
        this(writer, false);
    }

    public PrintWriter(Writer writer, boolean bl) {
        super((Object)writer);
        this.trouble = false;
        this.psOut = null;
        this.out = writer;
        this.autoFlush = bl;
        this.lineSeparator = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public PrintWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintWriter(OutputStream outputStream, boolean bl) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), bl);
        if (g.convertForInstanceOf((Object)outputStream, PrintStream.class) instanceof PrintStream) {
            this.psOut = (PrintStream)g.convertForCast((Object)outputStream, PrintStream.class);
        }
    }

    public PrintWriter(String string) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))), false);
    }

    private PrintWriter(Charset charset, File file) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset)), false);
    }

    public PrintWriter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(PrintWriter.toCharset(string2), new File(string));
    }

    public PrintWriter(File file) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))), false);
    }

    public PrintWriter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(PrintWriter.toCharset(string), file);
    }

    private void ensureOpen() throws IOException {
        if (((PrintWriter)this).out == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
            synchronized (object) {
                try {
                    this.ensureOpen();
                    ((PrintWriter)this).out.flush();
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
            synchronized (object) {
                try {
                    if (((PrintWriter)this).out == null) {
                        return;
                    }
                    ((PrintWriter)this).out.close();
                    ((PrintWriter)this).out = null;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public boolean checkError() {
        if (((PrintWriter)this).out != null) {
            this.flush();
        }
        if (g.convertForInstanceOf((Object)((PrintWriter)this).out, PrintWriter.class) instanceof PrintWriter) {
            PrintWriter printWriter = (PrintWriter)g.convertForCast((Object)((PrintWriter)this).out, PrintWriter.class);
            return printWriter.checkError();
        }
        if (this.psOut != null) {
            return this.psOut.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n2) {
        try {
            Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
            synchronized (object) {
                try {
                    this.ensureOpen();
                    ((PrintWriter)this).out.write(n2);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n2, int n3) {
        try {
            Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
            synchronized (object) {
                try {
                    this.ensureOpen();
                    ((PrintWriter)this).out.write(cArray, n2, n3);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n2, int n3) {
        try {
            Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
            synchronized (object) {
                try {
                    this.ensureOpen();
                    ((PrintWriter)this).out.write(string, n2, n3);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
            synchronized (object) {
                try {
                    this.ensureOpen();
                    ((PrintWriter)this).out.write(this.lineSeparator);
                    if (this.autoFlush) {
                        ((PrintWriter)this).out.flush();
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c2) {
        this.write(c2);
    }

    public void print(int n2) {
        this.write(String.valueOf(n2));
    }

    public void print(long l2) {
        this.write(String.valueOf(l2));
    }

    public void print(float f2) {
        this.write(String.valueOf(f2));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.print(bl);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c2) {
        Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.print(c2);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n2) {
        Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.print(n2);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l2) {
        Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.print(l2);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f2) {
        Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.print(f2);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.print(d);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.print(cArray);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object) {
            try {
                this.print(string);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        String string = String.valueOf(object);
        Object object2 = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
        synchronized (object2) {
            try {
                this.print(string);
                this.println();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public PrintWriter printf(String string, Object ... objectArray) {
        return this.format(string, objectArray);
    }

    public PrintWriter printf(Locale locale, String string, Object ... objectArray) {
        return this.format(locale, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter format(String string, Object ... objectArray) {
        try {
            Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
            synchronized (object) {
                try {
                    this.ensureOpen();
                    if (this.formatter == null || f.ifAcmp((Object)this.formatter.locale(), (Object)Locale.getDefault())) {
                        this.formatter = new Formatter(this);
                    }
                    this.formatter.format(Locale.getDefault(), string, objectArray);
                    if (this.autoFlush) {
                        ((PrintWriter)this).out.flush();
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter format(Locale locale, String string, Object ... objectArray) {
        try {
            Object object = ah.getMonitor((Object)PrintWriter._jr$ig$lock(this));
            synchronized (object) {
                try {
                    this.ensureOpen();
                    if (this.formatter == null || f.ifAcmp((Object)this.formatter.locale(), (Object)locale)) {
                        this.formatter = new Formatter(this, locale);
                    }
                    this.formatter.format(locale, string, objectArray);
                    if (this.autoFlush) {
                        ((PrintWriter)this).out.flush();
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this;
    }

    @Override
    public PrintWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    @Override
    public PrintWriter append(CharSequence charSequence, int n2, int n3) {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        this.write(charSequence2.subSequence(n2, n3).toString());
        return this;
    }

    @Override
    public PrintWriter append(char c2) {
        this.write(c2);
        return this;
    }

    private static /* synthetic */ void _jr$ip$autoFlush(PrintWriter printWriter, boolean bl) {
        printWriter.autoFlush = bl;
    }

    private static /* synthetic */ void _jr$ip$psOut(PrintWriter printWriter, PrintStream printStream) {
        printWriter.psOut = printStream;
    }

    private static /* synthetic */ void _jr$ip$lineSeparator(PrintWriter printWriter, String string) {
        printWriter.lineSeparator = string;
    }

    protected /* synthetic */ PrintWriter(h h2) {
        super(h2);
    }
}

