/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.h;
import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;
import sun.security.action.GetPropertyAction;

class Win32FileSystem
extends FileSystem {
    private final char slash;
    private final char altSlash;
    private final char semicolon;
    private static String[] driveDirCache = new String[26];
    private ExpiringCache cache;
    private ExpiringCache prefixCache;

    public Win32FileSystem() {
        this.cache = new ExpiringCache();
        this.prefixCache = new ExpiringCache();
        this.slash = ((String)AccessController.doPrivileged(new GetPropertyAction("file.separator"))).charAt(0);
        this.semicolon = ((String)AccessController.doPrivileged(new GetPropertyAction("path.separator"))).charAt(0);
        this.altSlash = (char)(this.slash == '\\' ? 47 : 92);
    }

    private boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private String slashify(String string) {
        if (string.length() > 0 && string.charAt(0) != this.slash) {
            return this.slash + string;
        }
        return string;
    }

    @Override
    public char getSeparator() {
        return this.slash;
    }

    @Override
    public char getPathSeparator() {
        return this.semicolon;
    }

    private int normalizePrefix(String string, int n2, StringBuffer stringBuffer) {
        char c;
        int n3;
        for (n3 = 0; n3 < n2 && this.isSlash(string.charAt(n3)); ++n3) {
        }
        if (n2 - n3 >= 2 && this.isLetter(c = string.charAt(n3)) && string.charAt(n3 + 1) == ':') {
            stringBuffer.append(c);
            stringBuffer.append(':');
            n3 += 2;
        } else {
            n3 = 0;
            if (n2 >= 2 && this.isSlash(string.charAt(0)) && this.isSlash(string.charAt(1))) {
                n3 = 1;
                stringBuffer.append(this.slash);
            }
        }
        return n3;
    }

    private String normalize(String string, int n2, int n3) {
        int n4;
        if (n2 == 0) {
            return string;
        }
        if (n3 < 3) {
            n3 = 0;
        }
        char c = this.slash;
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (n3 == 0) {
            n4 = this.normalizePrefix(string, n2, stringBuffer);
        } else {
            n4 = n3;
            stringBuffer.append(string.substring(0, n3));
        }
        while (n4 < n2) {
            char c2;
            if (this.isSlash(c2 = string.charAt(n4++))) {
                while (n4 < n2 && this.isSlash(string.charAt(n4))) {
                    ++n4;
                }
                if (n4 == n2) {
                    int n5 = stringBuffer.length();
                    if (n5 == 2 && stringBuffer.charAt(1) == ':') {
                        stringBuffer.append(c);
                        break;
                    }
                    if (n5 == 0) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (n5 != 1 || !this.isSlash(stringBuffer.charAt(0))) break;
                    stringBuffer.append(c);
                    break;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c2);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    @Override
    public String normalize(String string) {
        int n2 = string.length();
        char c = this.slash;
        char c2 = this.altSlash;
        char c3 = '\u0000';
        for (int i = 0; i < n2; ++i) {
            char c4 = string.charAt(i);
            if (c4 == c2) {
                return this.normalize(string, n2, c3 == c ? i - 1 : i);
            }
            if (c4 == c && c3 == c && i > 1) {
                return this.normalize(string, n2, i - 1);
            }
            if (c4 == ':' && i > 1) {
                return this.normalize(string, n2, 0);
            }
            c3 = c4;
        }
        if (c3 == c) {
            return this.normalize(string, n2, n2 - 1);
        }
        return string;
    }

    @Override
    public int prefixLength(String string) {
        char c;
        char c2 = this.slash;
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        char c3 = string.charAt(0);
        char c4 = c = n2 > 1 ? string.charAt(1) : (char)'\u0000';
        if (c3 == c2) {
            if (c == c2) {
                return 2;
            }
            return 1;
        }
        if (this.isLetter(c3) && c == ':') {
            if (n2 > 2 && string.charAt(2) == c2) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public String resolve(String string, String string2) {
        int n2 = string.length();
        if (n2 == 0) {
            return string2;
        }
        int n3 = string2.length();
        if (n3 == 0) {
            return string;
        }
        String string3 = string2;
        int n4 = 0;
        int n5 = n2;
        if (n3 > 1 && string3.charAt(0) == this.slash && n3 == (n4 = string3.charAt(1) == this.slash ? 2 : 1)) {
            if (string.charAt(n2 - 1) == this.slash) {
                return string.substring(0, n2 - 1);
            }
            return string;
        }
        if (string.charAt(n2 - 1) == this.slash) {
            --n5;
        }
        int n6 = n5 + n3 - n4;
        char[] cArray = null;
        if (string2.charAt(n4) == this.slash) {
            cArray = new char[n6];
            string.getChars(0, n5, cArray, 0);
            string2.getChars(n4, n3, cArray, n5);
        } else {
            cArray = new char[n6 + 1];
            string.getChars(0, n5, cArray, 0);
            cArray[n5] = this.slash;
            string2.getChars(n4, n3, cArray, n5 + 1);
        }
        return new String(cArray);
    }

    @Override
    public String getDefaultParent() {
        return "" + this.slash;
    }

    @Override
    public String fromURIPath(String string) {
        String string2 = string;
        if (string2.length() > 2 && string2.charAt(2) == ':') {
            if ((string2 = string2.substring(1)).length() > 3 && string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else if (string2.length() > 1 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Override
    public boolean isAbsolute(File file) {
        int n2 = file.getPrefixLength();
        return n2 == 2 && file.getPath().charAt(0) == this.slash || n2 == 3;
    }

    protected native String getDriveDirectory(int var1);

    private static int driveIndex(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        return -1;
    }

    private String getDriveDirectory(char c) {
        int n2 = Win32FileSystem.driveIndex(c);
        if (n2 < 0) {
            return null;
        }
        String string = (String)a.arrayLoad((Object[])driveDirCache, (int)n2);
        if (string != null) {
            return string;
        }
        string = this.getDriveDirectory(n2 + 1);
        a.arrayStore((Object[])driveDirCache, (int)n2, (Object)string);
        return string;
    }

    private String getUserPath() {
        return this.normalize(System.getProperty("user.dir"));
    }

    private String getDrive(String string) {
        int n2 = this.prefixLength(string);
        return n2 == 3 ? string.substring(0, 2) : null;
    }

    @Override
    public String resolve(File file) {
        String string = file.getPath();
        int n2 = file.getPrefixLength();
        if (n2 == 2 && string.charAt(0) == this.slash) {
            return string;
        }
        if (n2 == 3) {
            return string;
        }
        if (n2 == 0) {
            return this.getUserPath() + this.slashify(string);
        }
        if (n2 == 1) {
            String string2 = this.getUserPath();
            String string3 = this.getDrive(string2);
            if (string3 != null) {
                return string3 + string;
            }
            return string2 + string;
        }
        if (n2 == 2) {
            String string4 = this.getUserPath();
            String string5 = this.getDrive(string4);
            if (string5 != null && string.startsWith(string5)) {
                return string4 + this.slashify(string.substring(2));
            }
            char c = string.charAt(0);
            String string6 = this.getDriveDirectory(c);
            if (string6 != null) {
                String string7 = "" + c + ':' + string6 + this.slashify(string.substring(2));
                SecurityManager securityManager = System.getSecurityManager();
                try {
                    if (securityManager != null) {
                        securityManager.checkRead(string7);
                    }
                }
                catch (SecurityException securityException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SecurityException("Cannot resolve path " + string));
                }
                return string7;
            }
            return c + ":" + this.slashify(string.substring(2));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("Unresolvable path: " + string));
    }

    @Override
    public String canonicalize(String string) throws IOException {
        int n2 = string.length();
        if (n2 == 2 && this.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            char c = string.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return string;
            }
            return "" + (char)(c - 32) + ':';
        }
        if (n2 == 3 && this.isLetter(string.charAt(0)) && string.charAt(1) == ':' && string.charAt(2) == '\\') {
            char c = string.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return string;
            }
            return "" + (char)(c - 32) + ':' + '\\';
        }
        if (!useCanonCaches) {
            return this.canonicalize0(string);
        }
        String string2 = this.cache.get(string);
        if (string2 == null) {
            Object object;
            String string3 = null;
            String string4 = null;
            if (useCanonPrefixCache && (string3 = Win32FileSystem.parentOrNull(string)) != null && (string4 = this.prefixCache.get(string3)) != null) {
                object = string.substring(1 + string3.length());
                string2 = this.canonicalizeWithPrefix(string4, (String)object);
                this.cache.put(string3 + File.separatorChar + (String)object, string2);
            }
            if (string2 == null) {
                string2 = this.canonicalize0(string);
                this.cache.put(string, string2);
                if (useCanonPrefixCache && string3 != null && (string4 = Win32FileSystem.parentOrNull(string2)) != null && ((File)(object = new File(string2))).exists() && !((File)object).isDirectory()) {
                    this.prefixCache.put(string3, string4);
                }
            }
        }
        return string2;
    }

    protected native String canonicalize0(String var1) throws IOException;

    protected String canonicalizeWithPrefix(String string, String string2) throws IOException {
        return this.canonicalizeWithPrefix0(string, string + File.separatorChar + string2);
    }

    protected native String canonicalizeWithPrefix0(String var1, String var2) throws IOException;

    static String parentOrNull(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        char c = File.separatorChar;
        char c2 = '/';
        int n3 = 0;
        int n4 = 0;
        for (int i = n2 = string.length() - 1; i > 0; --i) {
            char c3 = string.charAt(i);
            if (c3 == '.') {
                if (++n3 >= 2) {
                    return null;
                }
                if (n4 != 0) continue;
                return null;
            }
            if (c3 == c) {
                if (n3 == 1 && n4 == 0) {
                    return null;
                }
                if (i == 0 || i >= n2 - 1 || string.charAt(i - 1) == c || string.charAt(i - 1) == c2) {
                    return null;
                }
                return string.substring(0, i);
            }
            if (c3 == c2) {
                return null;
            }
            if (c3 == '*' || c3 == '?') {
                return null;
            }
            ++n4;
            n3 = 0;
        }
        return null;
    }

    @Override
    public native int getBooleanAttributes(File var1);

    @Override
    public native boolean checkAccess(File var1, int var2);

    @Override
    public native long getLastModifiedTime(File var1);

    @Override
    public native long getLength(File var1);

    @Override
    public native boolean setPermission(File var1, int var2, boolean var3, boolean var4);

    @Override
    public native boolean createFileExclusively(String var1) throws IOException;

    @Override
    public boolean delete(File file) {
        this.cache.clear();
        this.prefixCache.clear();
        return this.delete0(file);
    }

    protected native boolean delete0(File var1);

    @Override
    public native String[] list(File var1);

    @Override
    public native boolean createDirectory(File var1);

    @Override
    public boolean rename(File file, File file2) {
        this.cache.clear();
        this.prefixCache.clear();
        return this.rename0(file, file2);
    }

    protected native boolean rename0(File var1, File var2);

    @Override
    public native boolean setLastModifiedTime(File var1, long var2);

    @Override
    public native boolean setReadOnly(File var1);

    private boolean access(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(string);
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static native int listRoots0();

    @Override
    public File[] listRoots() {
        int n2 = Win32FileSystem.listRoots0();
        int n3 = 0;
        for (int i = 0; i < 26; ++i) {
            if ((n2 >> i & 1) == 0) continue;
            if (!this.access((char)(65 + i) + ":" + this.slash)) {
                n2 &= ~(1 << i);
                continue;
            }
            ++n3;
        }
        Object[] objectArray = new File[n3];
        int n4 = 0;
        char c = this.slash;
        for (int i = 0; i < 26; ++i) {
            if ((n2 >> i & 1) == 0) continue;
            a.arrayStore((Object[])objectArray, (int)n4++, (Object)new File((char)(65 + i) + ":" + c));
        }
        return objectArray;
    }

    @Override
    public long getSpace(File file, int n2) {
        if (file.exists()) {
            File file2 = file.isDirectory() ? file : file.getParentFile();
            return this.getSpace0(file2, n2);
        }
        return 0L;
    }

    private native long getSpace0(File var1, int var2);

    @Override
    public int compare(File file, File file2) {
        return file.getPath().compareToIgnoreCase(file2.getPath());
    }

    @Override
    public int hashCode(File file) {
        return file.getPath().toLowerCase(Locale.ENGLISH).hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        Win32FileSystem.initIDs();
    }

    private static /* synthetic */ void _jr$ip$slash(Win32FileSystem win32FileSystem, char c) {
        win32FileSystem.slash = c;
    }

    private static /* synthetic */ void _jr$ip$altSlash(Win32FileSystem win32FileSystem, char c) {
        win32FileSystem.altSlash = c;
    }

    private static /* synthetic */ void _jr$ip$semicolon(Win32FileSystem win32FileSystem, char c) {
        win32FileSystem.semicolon = c;
    }

    private static /* synthetic */ void _jr$ip$cache(Win32FileSystem win32FileSystem, ExpiringCache expiringCache) {
        win32FileSystem.cache = expiringCache;
    }

    private static /* synthetic */ void _jr$ip$prefixCache(Win32FileSystem win32FileSystem, ExpiringCache expiringCache) {
        win32FileSystem.prefixCache = expiringCache;
    }

    protected /* synthetic */ Win32FileSystem(h h2) {
        super(h2);
    }
}

