/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public abstract class ClassValue
extends h {
    private static final Entry<?>[] EMPTY_CACHE;
    final int hashCodeForCache;
    private static final AtomicInteger nextHashCode;
    private static final int HASH_INCREMENT = 1640531527;
    static final int HASH_MASK = 0x3FFFFFFF;
    final Identity identity;
    private volatile Version<T> version;
    private static final Object CRITICAL_SECTION;

    protected ClassValue() {
        this.hashCodeForCache = nextHashCode.getAndAdd(1640531527) & 0x3FFFFFFF;
        this.identity = new Identity();
        this.version = new Version(this);
    }

    protected abstract T computeValue(Class<?> var1);

    public T get(Class<?> clazz) {
        Entry<?>[] entryArray = ClassValue.getCacheCarefully(clazz);
        Entry entry = ClassValueMap.probeHomeLocation(entryArray, this);
        if (this.match(entry)) {
            return entry.value();
        }
        return this.getFromBackup(entryArray, clazz);
    }

    public void remove(Class<?> clazz) {
        ClassValueMap classValueMap = ClassValue.getMap(clazz);
        classValueMap.removeEntry(this);
    }

    void put(Class<?> clazz, T t) {
        ClassValueMap classValueMap = ClassValue.getMap(clazz);
        classValueMap.changeEntry(this, t);
    }

    private static Entry<?>[] getCacheCarefully(Class<?> clazz) {
        ClassValueMap classValueMap = clazz.classValueMap;
        if (classValueMap == null) {
            return EMPTY_CACHE;
        }
        Entry<?>[] entryArray = classValueMap.getCache();
        return entryArray;
    }

    private T getFromBackup(Entry<?>[] entryArray, Class<?> clazz) {
        Entry entry = ClassValueMap.probeBackupLocations(entryArray, this);
        if (entry != null) {
            return entry.value();
        }
        return this.getFromHashMap(clazz);
    }

    Entry<T> castEntry(Entry<?> entry) {
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getFromHashMap(Class<?> clazz) {
        Entry entry;
        ClassValueMap classValueMap = ClassValue.getMap(clazz);
        do {
            if (!(entry = classValueMap.startEntry(this)).isPromise()) {
                return entry.value();
            }
            try {
                entry = ClassValue.makeEntry(entry.version(), this.computeValue(clazz));
                entry = classValueMap.finishEntry(this, entry);
            }
            catch (Throwable throwable) {
                entry = classValueMap.finishEntry(this, entry);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        } while (entry == null);
        return entry.value();
    }

    boolean match(Entry<?> entry) {
        return entry != null && !f.ifAcmp(entry.get(), (Object)((Object)this.version));
    }

    Version<T> version() {
        return this.version;
    }

    void bumpVersion() {
        this.version = new Version(this);
    }

    private static ClassValueMap getMap(Class<?> clazz) {
        ClassValueMap classValueMap = clazz.classValueMap;
        if (classValueMap != null) {
            return classValueMap;
        }
        return ClassValue.initializeMap(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassValueMap initializeMap(Class<?> clazz) {
        ClassValueMap classValueMap;
        Object object = ah.getMonitor((Object)CRITICAL_SECTION);
        synchronized (object) {
            try {
                classValueMap = clazz.classValueMap;
                if (classValueMap == null) {
                    clazz.classValueMap = classValueMap = new ClassValueMap(clazz);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return classValueMap;
    }

    static <T> Entry<T> makeEntry(Version<T> version, T t) {
        return new Entry<T>(version, t);
    }

    static {
        Entry[] entryArray = new Entry[1];
        a.arrayStore((Object[])entryArray, (int)0, null);
        EMPTY_CACHE = entryArray;
        nextHashCode = new AtomicInteger();
        CRITICAL_SECTION = new Object();
    }

    static /* synthetic */ void _jr$ip$hashCodeForCache(Object object, int n2) {
        ((ClassValue)((Object)object)).hashCodeForCache = n2;
    }

    static /* synthetic */ void _jr$ip$identity(Object object, Identity identity) {
        ((ClassValue)((Object)object)).identity = identity;
    }

    protected /* synthetic */ ClassValue(h h2) {
        super(h2);
    }

    static class ClassValueMap
    extends WeakHashMap<Identity, Entry<?>> {
        private final Class<?> type;
        private Entry<?>[] cacheArray;
        private int cacheLoad;
        private int cacheLoadLimit;
        private static final int INITIAL_ENTRIES = 32;
        private static final int CACHE_LOAD_LIMIT = 67;
        private static final int PROBE_LIMIT = 6;

        ClassValueMap(Class<?> clazz) {
            this.type = clazz;
            this.sizeCache(32);
        }

        Entry<?>[] getCache() {
            return this.cacheArray;
        }

        @af(modifiers=32)
        <T> Entry<T> startEntry(ClassValue<T> classValue) {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    Entry entry = (Entry)((Object)g.convertForCast(this.get((Object)((ClassValue)((Object)classValue)).identity), Entry.class));
                    Version version = classValue.version();
                    if (entry == null) {
                        entry = version.promise();
                        this.put(((ClassValue)((Object)classValue)).identity, entry);
                        return entry;
                    }
                    if (entry.isPromise()) {
                        if (f.ifAcmp(entry.version(), version)) {
                            entry = version.promise();
                            this.put(((ClassValue)((Object)classValue)).identity, entry);
                        }
                        return entry;
                    }
                    if (f.ifAcmp(entry.version(), version)) {
                        entry = entry.refreshVersion(version);
                        this.put(((ClassValue)((Object)classValue)).identity, entry);
                    }
                    this.checkCacheLoad();
                    this.addToCache(classValue, entry);
                    return entry;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @af(modifiers=32)
        <T> Entry<T> finishEntry(ClassValue<T> classValue, Entry<T> entry) {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    Entry entry2 = (Entry)((Object)g.convertForCast(this.get((Object)((ClassValue)((Object)classValue)).identity), Entry.class));
                    if (!f.ifAcmp(entry, (Object)((Object)entry2))) {
                        if (!$assertionsDisabled && !entry.isPromise()) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                        }
                        this.remove((Object)((ClassValue)((Object)classValue)).identity);
                        return null;
                    }
                    if (entry2 != null && entry2.isPromise() && !f.ifAcmp(entry2.version(), entry.version())) {
                        Version version = classValue.version();
                        if (f.ifAcmp(entry.version(), version)) {
                            entry = entry.refreshVersion(version);
                        }
                        this.put(((ClassValue)((Object)classValue)).identity, entry);
                        this.checkCacheLoad();
                        this.addToCache(classValue, entry);
                        return entry;
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @af(modifiers=32)
        void removeEntry(ClassValue<?> classValue) {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    if (this.remove((Object)((ClassValue)((Object)classValue)).identity) != null) {
                        classValue.bumpVersion();
                        this.removeStaleEntries(classValue);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @af(modifiers=32)
        <T> void changeEntry(ClassValue<T> classValue, T t) {
            Object object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    Entry entry = (Entry)((Object)g.convertForCast(this.get((Object)((ClassValue)((Object)classValue)).identity), Entry.class));
                    Version version = classValue.version();
                    if (entry != null) {
                        if (!f.ifAcmp(entry.version(), version) && !f.ifAcmp(entry.value(), t)) {
                            return;
                        }
                        classValue.bumpVersion();
                        this.removeStaleEntries(classValue);
                    }
                    Entry entry2 = ClassValue.makeEntry(version, t);
                    this.put(((ClassValue)((Object)classValue)).identity, entry2);
                    this.checkCacheLoad();
                    this.addToCache(classValue, entry2);
                    return;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        static Entry<?> loadFromCache(Entry<?>[] entryArray, int n2) {
            return (Entry)((Object)g.convertForCast((Object)a.arrayLoad(entryArray, (int)(n2 & a.arrayLength(entryArray) - 1)), Entry.class));
        }

        static <T> Entry<T> probeHomeLocation(Entry<?>[] entryArray, ClassValue<T> classValue) {
            return classValue.castEntry(ClassValueMap.loadFromCache(entryArray, ((ClassValue)((Object)classValue)).hashCodeForCache));
        }

        static <T> Entry<T> probeBackupLocations(Entry<?>[] entryArray, ClassValue<T> classValue) {
            Entry entry;
            int n2 = a.arrayLength(entryArray) - 1;
            int n3 = ((ClassValue)((Object)classValue)).hashCodeForCache & n2;
            Entry<?> entry2 = (Entry<?>)((Object)g.convertForCast((Object)a.arrayLoad(entryArray, (int)n3), Entry.class));
            if (entry2 == null) {
                return null;
            }
            int n4 = -1;
            for (int i = n3 + 1; i < n3 + 6 && (entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad(entryArray, (int)(i & n2)), Entry.class))) != null; ++i) {
                if (classValue.match(entry)) {
                    a.arrayStore(entryArray, (int)n3, (Object)((Object)entry));
                    if (n4 >= 0) {
                        a.arrayStore(entryArray, (int)(i & n2), Entry.DEAD_ENTRY);
                    } else {
                        n4 = i;
                    }
                    a.arrayStore(entryArray, (int)(n4 & n2), ClassValueMap.entryDislocation(entryArray, n4, entry2) < 6 ? entry2 : Entry.DEAD_ENTRY);
                    return classValue.castEntry(entry);
                }
                if (entry.isLive() || n4 >= 0) continue;
                n4 = i;
            }
            return null;
        }

        private static int entryDislocation(Entry<?>[] entryArray, int n2, Entry<?> entry) {
            ClassValue<?> classValue = entry.classValueOrNull();
            if (classValue == null) {
                return 0;
            }
            int n3 = a.arrayLength(entryArray) - 1;
            return n2 - ((ClassValue)((Object)classValue)).hashCodeForCache & n3;
        }

        private void sizeCache(int n2) {
            if (!$assertionsDisabled && (n2 & n2 - 1) != 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            this.cacheLoad = 0;
            this.cacheLoadLimit = (int)((double)n2 * 67.0 / 100.0);
            this.cacheArray = new Entry[n2];
        }

        private void checkCacheLoad() {
            if (this.cacheLoad >= this.cacheLoadLimit) {
                this.reduceCacheLoad();
            }
        }

        private void reduceCacheLoad() {
            this.removeStaleEntries();
            if (this.cacheLoad < this.cacheLoadLimit) {
                return;
            }
            Entry<?>[] entryArray = this.getCache();
            if (a.arrayLength(entryArray) > 0x3FFFFFFF) {
                return;
            }
            this.sizeCache(a.arrayLength(entryArray) * 2);
            Entry<?>[] entryArray2 = entryArray;
            int n2 = a.arrayLength(entryArray2);
            for (int i = 0; i < n2; ++i) {
                Entry entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad(entryArray2, (int)i), Entry.class));
                if (entry == null || !entry.isLive()) continue;
                this.addToCache(entry);
            }
        }

        private void removeStaleEntries(Entry<?>[] entryArray, int n2, int n3) {
            int n4 = a.arrayLength(entryArray) - 1;
            int n5 = 0;
            for (int i = n2; i < n2 + n3; ++i) {
                Entry entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad(entryArray, (int)(i & n4)), Entry.class));
                if (entry == null || entry.isLive()) continue;
                Entry<?> entry2 = null;
                entry2 = this.findReplacement(entryArray, i);
                a.arrayStore(entryArray, (int)(i & n4), entry2);
                if (entry2 != null) continue;
                ++n5;
            }
            this.cacheLoad = Math.max(0, this.cacheLoad - n5);
        }

        private Entry<?> findReplacement(Entry<?>[] entryArray, int n2) {
            Entry entry;
            Entry entry2 = null;
            int n3 = -1;
            int n4 = 0;
            int n5 = a.arrayLength(entryArray) - 1;
            for (int i = n2 + 1; i < n2 + 6 && (entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad(entryArray, (int)(i & n5)), Entry.class))) != null; ++i) {
                int n6;
                int n7;
                if (!entry.isLive() || (n7 = ClassValueMap.entryDislocation(entryArray, i, entry)) == 0 || (n6 = i - n7) > n2) continue;
                if (n6 == n2) {
                    n3 = 1;
                    n4 = i;
                    entry2 = entry;
                    continue;
                }
                if (n3 > 0) continue;
                n3 = 0;
                n4 = i;
                entry2 = entry;
            }
            if (n3 >= 0) {
                if ((Entry)((Object)g.convertForCast((Object)a.arrayLoad(entryArray, (int)(n4 + 1 & n5)), Entry.class)) != null) {
                    a.arrayStore(entryArray, (int)(n4 & n5), Entry.DEAD_ENTRY);
                } else {
                    a.arrayStore(entryArray, (int)(n4 & n5), null);
                    ClassValueMap classValueMap = this;
                    classValueMap.cacheLoad = classValueMap.cacheLoad - 1;
                }
            }
            return entry2;
        }

        private void removeStaleEntries(ClassValue<?> classValue) {
            this.removeStaleEntries(this.getCache(), ((ClassValue)((Object)classValue)).hashCodeForCache, 6);
        }

        private void removeStaleEntries() {
            Entry<?>[] entryArray = this.getCache();
            this.removeStaleEntries(entryArray, 0, a.arrayLength(entryArray) + 6 - 1);
        }

        private <T> void addToCache(Entry<T> entry) {
            ClassValue<T> classValue = entry.classValueOrNull();
            if (classValue != null) {
                this.addToCache(classValue, entry);
            }
        }

        private <T> void addToCache(ClassValue<T> classValue, Entry<T> entry) {
            int n2;
            Entry<?>[] entryArray = this.getCache();
            int n3 = a.arrayLength(entryArray) - 1;
            int n4 = ((ClassValue)((Object)classValue)).hashCodeForCache & n3;
            Entry<?> entry2 = this.placeInCache(entryArray, n4, entry, false);
            if (entry2 == null) {
                return;
            }
            int n5 = ClassValueMap.entryDislocation(entryArray, n4, entry2);
            for (int i = n2 = n4 - n5; i < n2 + 6; ++i) {
                if (this.placeInCache(entryArray, i & n3, entry2, true) != null) continue;
                return;
            }
        }

        private Entry<?> placeInCache(Entry<?>[] entryArray, int n2, Entry<?> entry, boolean bl) {
            Entry entry2 = this.overwrittenEntry((Entry)((Object)g.convertForCast((Object)a.arrayLoad(entryArray, (int)n2), Entry.class)));
            if (bl && entry2 != null) {
                return entry;
            }
            a.arrayStore(entryArray, (int)n2, entry);
            return entry2;
        }

        private <T> Entry<T> overwrittenEntry(Entry<T> entry) {
            if (entry == null) {
                ClassValueMap classValueMap = this;
                classValueMap.cacheLoad = classValueMap.cacheLoad + 1;
            } else if (entry.isLive()) {
                return entry;
            }
            return null;
        }

        private static /* synthetic */ Class _jr$ig$type(ClassValueMap classValueMap) {
            return classValueMap.type;
        }

        private static /* synthetic */ void _jr$ip$type(ClassValueMap classValueMap, Class clazz) {
            classValueMap.type = clazz;
        }

        protected /* synthetic */ ClassValueMap(h h2) {
            super(h2);
        }
    }

    static class Entry<T>
    extends WeakReference<Version<T>> {
        final Object value;
        static final Entry<?> DEAD_ENTRY = new Entry<Object>(null, null);

        Entry(Version<T> version, T t) {
            super(version);
            this.value = t;
        }

        private void assertNotPromise() {
            if (!$assertionsDisabled && this.isPromise()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
        }

        Entry(Version<T> version) {
            super(version);
            this.value = this;
        }

        T value() {
            this.assertNotPromise();
            return (T)((Entry)((Object)((Object)this))).value;
        }

        boolean isPromise() {
            return !f.ifAcmp((Object)((Entry)((Object)((Object)this))).value, (Object)((Object)this));
        }

        Version<T> version() {
            return (Version)((Object)g.convertForCast(this.get(), Version.class));
        }

        ClassValue<T> classValueOrNull() {
            Version<T> version = this.version();
            return version == null ? null : version.classValue();
        }

        boolean isLive() {
            Version<T> version = this.version();
            if (version == null) {
                return false;
            }
            if (version.isLive()) {
                return true;
            }
            this.clear();
            return false;
        }

        Entry<T> refreshVersion(Version<T> version) {
            this.assertNotPromise();
            Entry<Object> entry = new Entry<Object>(version, ((Entry)((Object)((Object)this))).value);
            this.clear();
            return entry;
        }

        static /* synthetic */ void _jr$ip$value(Object object, Object object2) {
            ((Entry)((Object)object)).value = object2;
        }

        protected /* synthetic */ Entry(h h2) {
            super(h2);
        }
    }

    static class Identity
    extends h {
        Identity() {
        }

        protected /* synthetic */ Identity(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static class Version
    extends h {
        private final ClassValue<T> classValue;
        private final Entry<T> promise;

        Version(ClassValue<T> classValue) {
            this.promise = new Entry(this);
            this.classValue = classValue;
        }

        ClassValue<T> classValue() {
            return this.classValue;
        }

        Entry<T> promise() {
            return this.promise;
        }

        boolean isLive() {
            return !f.ifAcmp(this.classValue.version(), (Object)((Object)this));
        }

        private static /* synthetic */ void _jr$ip$classValue(Version version, ClassValue classValue) {
            version.classValue = classValue;
        }

        private static /* synthetic */ void _jr$ip$promise(Version version, Entry entry) {
            version.promise = entry;
        }

        protected /* synthetic */ Version(h h2) {
            super(h2);
        }
    }
}

