/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.FloatingDecimal;
import sun.misc.FpUtils;

public final class Double
extends Number
implements Comparable<Double> {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_NORMAL = 2.2250738585072014E-308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final int SIZE = 64;
    public static final Class<Double> TYPE = Class.getPrimitiveClass("double");
    private final double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public static String toString(double d) {
        return new FloatingDecimal(d).toJavaFormatString();
    }

    public static String toHexString(double d) {
        if (!FpUtils.isFinite(d)) {
            return Double.toString(d);
        }
        StringBuffer stringBuffer = new StringBuffer(24);
        if (FpUtils.rawCopySign(1.0, d) == -1.0) {
            stringBuffer.append("-");
        }
        stringBuffer.append("0x");
        d = Math.abs(d);
        if (d == 0.0) {
            stringBuffer.append("0.0p0");
        } else {
            boolean bl = d < Double.MIN_NORMAL;
            long l = Double.doubleToLongBits(d) & 0xFFFFFFFFFFFFFL | 0x1000000000000000L;
            stringBuffer.append(bl ? "0." : "1.");
            String string = Long.toHexString(l).substring(3, 16);
            stringBuffer.append(string.equals("0000000000000") ? "0" : string.replaceFirst("0{1,12}$", ""));
            stringBuffer.append("p" + (bl ? -1022 : FpUtils.getExponent(d)));
        }
        return stringBuffer.toString();
    }

    public static Double valueOf(String string) throws NumberFormatException {
        return new Double(FloatingDecimal.readJavaFormatString(string).doubleValue());
    }

    public static Double valueOf(double d) {
        return new Double(d);
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).doubleValue();
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) throws NumberFormatException {
        this(Double.valueOf(string));
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof Double && Double.doubleToLongBits(((Double)object).value) == Double.doubleToLongBits(this.value);
    }

    public static long doubleToLongBits(double d) {
        long l = Double.doubleToRawLongBits(d);
        if ((l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) != 0L) {
            l = 9221120237041090560L;
        }
        return l;
    }

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    @Override
    public int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public static int compare(double d, double d2) {
        long l;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        long l2 = Double.doubleToLongBits(d);
        return l2 == (l = Double.doubleToLongBits(d2)) ? 0 : (l2 < l ? -1 : 1);
    }

    private static /* synthetic */ double _jr$ig$value(Double d) {
        return d.value;
    }

    private static /* synthetic */ void _jr$ip$value(Double d, double d2) {
        d.value = d2;
    }
}

