/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.FloatingDecimal;
import sun.misc.FpUtils;

public final class Float
extends Number
implements Comparable<Float> {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int SIZE = 32;
    public static final Class<Float> TYPE = Class.getPrimitiveClass("float");
    private final float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public static String toString(float f2) {
        return new FloatingDecimal(f2).toJavaFormatString();
    }

    public static String toHexString(float f2) {
        if (Math.abs(f2) < Float.MIN_NORMAL && f2 != 0.0f) {
            String string = Double.toHexString(FpUtils.scalb((double)f2, -896));
            return string.replaceFirst("p-1022$", "p-126");
        }
        return Double.toHexString(f2);
    }

    public static Float valueOf(String string) throws NumberFormatException {
        return new Float(FloatingDecimal.readJavaFormatString(string).floatValue());
    }

    public static Float valueOf(float f2) {
        return new Float(f2);
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).floatValue();
    }

    public static boolean isNaN(float f2) {
        return f2 != f2;
    }

    public static boolean isInfinite(float f2) {
        return f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY;
    }

    public Float(float f2) {
        this.value = f2;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) throws NumberFormatException {
        this(Float.valueOf(string).floatValue());
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof Float && Float.floatToIntBits(((Float)object).value) == Float.floatToIntBits(this.value);
    }

    public static int floatToIntBits(float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        if ((n2 & 0x7F800000) == 2139095040 && (n2 & 0x7FFFFF) != 0) {
            n2 = 2143289344;
        }
        return n2;
    }

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    @Override
    public int compareTo(Float f2) {
        return Float.compare(this.value, f2.value);
    }

    public static int compare(float f2, float f3) {
        int n2;
        if (f2 < f3) {
            return -1;
        }
        if (f2 > f3) {
            return 1;
        }
        int n3 = Float.floatToIntBits(f2);
        return n3 == (n2 = Float.floatToIntBits(f3)) ? 0 : (n3 < n2 ? -1 : 1);
    }

    private static /* synthetic */ float _jr$ig$value(Float f2) {
        return f2.value;
    }

    private static /* synthetic */ void _jr$ip$value(Float f2, float f3) {
        f2.value = f3;
    }
}

