/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.zeroturnaround.jrebelbase.h;

public final class Long
extends Number
implements Comparable<Long> {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    private static final long serialVersionUID = 4290774380558885855L;

    public static String toString(long l, int n2) {
        boolean bl;
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return Long.toString(l);
        }
        char[] cArray = new char[65];
        int n3 = 64;
        boolean bl2 = bl = l < 0L;
        if (!bl) {
            l = -l;
        }
        while (l <= (long)(-n2)) {
            cArray[n3--] = Integer.digits[(int)(-(l % (long)n2))];
            l /= (long)n2;
        }
        cArray[n3] = Integer.digits[(int)(-l)];
        if (bl) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, 65 - n3);
    }

    public static String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    public static String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    private static String toUnsignedString(long l, int n2) {
        char[] cArray = new char[64];
        int n3 = 64;
        int n4 = 1 << n2;
        long l2 = n4 - 1;
        do {
            cArray[--n3] = Integer.digits[(int)(l & l2)];
        } while ((l >>>= n2) != 0L);
        return new String(cArray, n3, 64 - n3);
    }

    public static String toString(long l) {
        if (l == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        int n2 = l < 0L ? Long.stringSize(-l) + 1 : Long.stringSize(l);
        char[] cArray = new char[n2];
        Long.getChars(l, n2, cArray);
        return new String(cArray, true);
    }

    static void getChars(long l, int n2, char[] cArray) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = 0;
        if (l < 0L) {
            n6 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n4 = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            l = l2;
            cArray[--n5] = Integer.DigitOnes[n4];
            cArray[--n5] = Integer.DigitTens[n4];
        }
        int n7 = (int)l;
        while (n7 >= 65536) {
            n3 = n7 / 100;
            n4 = n7 - ((n3 << 6) + (n3 << 5) + (n3 << 2));
            n7 = n3;
            cArray[--n5] = Integer.DigitOnes[n4];
            cArray[--n5] = Integer.DigitTens[n4];
        }
        do {
            n3 = n7 * 52429 >>> 19;
            n4 = n7 - ((n3 << 3) + (n3 << 1));
            cArray[--n5] = Integer.digits[n4];
        } while ((n7 = n3) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    static int stringSize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 = 10L * l2;
        }
        return 19;
    }

    public static long parseLong(String string, int n2) throws NumberFormatException {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("null"));
        }
        if (n2 < 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("radix " + n2 + " less than Character.MIN_RADIX"));
        }
        if (n2 > 36) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("radix " + n2 + " greater than Character.MAX_RADIX"));
        }
        long l = 0L;
        boolean bl = false;
        int n3 = 0;
        int n4 = string.length();
        long l2 = -9223372036854775807L;
        if (n4 > 0) {
            char c = string.charAt(0);
            if (c < '0') {
                if (c == '-') {
                    bl = true;
                    l2 = Long.MIN_VALUE;
                } else if (c != '+') {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)NumberFormatException.forInputString(string));
                }
                if (n4 == 1) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)NumberFormatException.forInputString(string));
                }
                ++n3;
            }
            long l3 = l2 / (long)n2;
            while (n3 < n4) {
                int n5;
                if ((n5 = Character.digit(string.charAt(n3++), n2)) < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)NumberFormatException.forInputString(string));
                }
                if (l < l3) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)NumberFormatException.forInputString(string));
                }
                if ((l *= (long)n2) < l2 + (long)n5) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)NumberFormatException.forInputString(string));
                }
                l -= (long)n5;
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)NumberFormatException.forInputString(string));
        }
        return bl ? l : -l;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static Long valueOf(String string, int n2) throws NumberFormatException {
        return Long.parseLong(string, n2);
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static Long valueOf(long l) {
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new Long(l);
    }

    public static Long decode(String string) throws NumberFormatException {
        Long l;
        int n2 = 10;
        int n3 = 0;
        boolean bl = false;
        if (string.length() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Zero length string"));
        }
        char c = string.charAt(0);
        if (c == '-') {
            bl = true;
            ++n3;
        } else if (c == '+') {
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        if (string.startsWith("-", n3) || string.startsWith("+", n3)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Sign character in wrong position"));
        }
        try {
            l = Long.valueOf(string.substring(n3), n2);
            l = bl ? Long.valueOf(-l.longValue()) : l;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl ? "-" + string.substring(n3) : string.substring(n3);
            l = Long.valueOf(string2, n2);
        }
        return l;
    }

    public Long(long l) {
        this.value = l;
    }

    public Long(String string) throws NumberFormatException {
        this.value = Long.parseLong(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof Long) {
            return this.value == (Long)object;
        }
        return false;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long getLong(String string, long l) {
        Long l2 = Long.getLong(string, null);
        return l2 == null ? Long.valueOf(l) : l2;
    }

    public static Long getLong(String string, Long l) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Long.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    @Override
    public int compareTo(Long l) {
        return Long.compare(this.value, l.value);
    }

    public static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public static long highestOneBit(long l) {
        l |= l >> 1;
        l |= l >> 2;
        l |= l >> 4;
        l |= l >> 8;
        l |= l >> 16;
        l |= l >> 32;
        return l - (l >>> 1);
    }

    public static long lowestOneBit(long l) {
        return l & -l;
    }

    public static int numberOfLeadingZeros(long l) {
        if (l == 0L) {
            return 64;
        }
        int n2 = 1;
        int n3 = (int)(l >>> 32);
        if (n3 == 0) {
            n2 += 32;
            n3 = (int)l;
        }
        if (n3 >>> 16 == 0) {
            n2 += 16;
            n3 <<= 16;
        }
        if (n3 >>> 24 == 0) {
            n2 += 8;
            n3 <<= 8;
        }
        if (n3 >>> 28 == 0) {
            n2 += 4;
            n3 <<= 4;
        }
        if (n3 >>> 30 == 0) {
            n2 += 2;
            n3 <<= 2;
        }
        return n2 -= n3 >>> 31;
    }

    public static int numberOfTrailingZeros(long l) {
        int n2;
        if (l == 0L) {
            return 64;
        }
        int n3 = 63;
        int n4 = (int)l;
        if (n4 != 0) {
            n3 -= 32;
            n2 = n4;
        } else {
            n2 = (int)(l >>> 32);
        }
        n4 = n2 << 16;
        if (n4 != 0) {
            n3 -= 16;
            n2 = n4;
        }
        if ((n4 = n2 << 8) != 0) {
            n3 -= 8;
            n2 = n4;
        }
        if ((n4 = n2 << 4) != 0) {
            n3 -= 4;
            n2 = n4;
        }
        if ((n4 = n2 << 2) != 0) {
            n3 -= 2;
            n2 = n4;
        }
        return n3 - (n2 << 1 >>> 31);
    }

    public static int bitCount(long l) {
        l -= l >>> 1 & 0x5555555555555555L;
        l = (l & 0x3333333333333333L) + (l >>> 2 & 0x3333333333333333L);
        l = l + (l >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l += l >>> 8;
        l += l >>> 16;
        l += l >>> 32;
        return (int)l & 0x7F;
    }

    public static long rotateLeft(long l, int n2) {
        return l << n2 | l >>> -n2;
    }

    public static long rotateRight(long l, int n2) {
        return l >>> n2 | l << -n2;
    }

    public static long reverse(long l) {
        l = (l & 0x5555555555555555L) << 1 | l >>> 1 & 0x5555555555555555L;
        l = (l & 0x3333333333333333L) << 2 | l >>> 2 & 0x3333333333333333L;
        l = (l & 0xF0F0F0F0F0F0F0FL) << 4 | l >>> 4 & 0xF0F0F0F0F0F0F0FL;
        l = (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
        l = l << 48 | (l & 0xFFFF0000L) << 16 | l >>> 16 & 0xFFFF0000L | l >>> 48;
        return l;
    }

    public static int signum(long l) {
        return (int)(l >> 63 | -l >>> 63);
    }

    public static long reverseBytes(long l) {
        l = (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
        return l << 48 | (l & 0xFFFF0000L) << 16 | l >>> 16 & 0xFFFF0000L | l >>> 48;
    }

    private static /* synthetic */ long _jr$ig$value(Long l) {
        return l.value;
    }

    private static /* synthetic */ void _jr$ip$value(Long l, long l2) {
        l.value = l2;
    }

    private static class LongCache
    extends h {
        static final Long[] cache = new Long[256];

        private LongCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                LongCache.cache[i] = new Long(i - 128);
            }
        }

        protected /* synthetic */ LongCache(h h2) {
            super(h2);
        }
    }
}

