/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ProcessBuilder
extends h {
    private List<String> command;
    private File directory;
    private Map<String, String> environment;
    private boolean redirectErrorStream;
    private Redirect[] redirects;

    public ProcessBuilder(List<String> list) {
        if (list == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.command = list;
    }

    public ProcessBuilder(String ... stringArray) {
        this.command = new ArrayList<String>(a.arrayLength((Object[])stringArray));
        Object[] objectArray = stringArray;
        int n = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n; ++i) {
            String string = (String)a.arrayLoad((Object[])objectArray, (int)i);
            this.command.add(string);
        }
    }

    public ProcessBuilder command(List<String> list) {
        if (list == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.command = list;
        return this;
    }

    public ProcessBuilder command(String ... stringArray) {
        this.command = new ArrayList<String>(a.arrayLength((Object[])stringArray));
        Object[] objectArray = stringArray;
        int n = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n; ++i) {
            String string = (String)a.arrayLoad((Object[])objectArray, (int)i);
            this.command.add(string);
        }
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Map<String, String> environment() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv.*"));
        }
        if (this.environment == null) {
            this.environment = ProcessEnvironment.environment();
        }
        if (!$assertionsDisabled && this.environment == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return this.environment;
    }

    ProcessBuilder environment(String[] stringArray) {
        if (!$assertionsDisabled && this.environment != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (stringArray != null) {
            this.environment = ProcessEnvironment.emptyEnvironment(a.arrayLength((Object[])stringArray));
            if (!$assertionsDisabled && this.environment == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            Object[] objectArray = stringArray;
            int n = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n; ++i) {
                int n2;
                String string = (String)a.arrayLoad((Object[])objectArray, (int)i);
                if (string.indexOf(0) != -1) {
                    string = string.replaceFirst("\u0000.*", "");
                }
                if ((n2 = string.indexOf(61, 1)) == -1) continue;
                this.environment.put(string.substring(0, n2), string.substring(n2 + 1));
            }
        }
        return this;
    }

    public File directory() {
        return this.directory;
    }

    public ProcessBuilder directory(File file) {
        this.directory = file;
        return this;
    }

    private Redirect[] redirects() {
        if (this.redirects == null) {
            Redirect[] redirectArray = new Redirect[3];
            a.arrayStore((Object[])redirectArray, (int)0, (Object)((Object)Redirect.PIPE));
            a.arrayStore((Object[])redirectArray, (int)1, (Object)((Object)Redirect.PIPE));
            a.arrayStore((Object[])redirectArray, (int)2, (Object)((Object)Redirect.PIPE));
            this.redirects = redirectArray;
        }
        return this.redirects;
    }

    public ProcessBuilder redirectInput(Redirect redirect) {
        if (!f.ifAcmp((Object)((Object)redirect.type()), (Object)((Object)Redirect.Type.WRITE)) || !f.ifAcmp((Object)((Object)redirect.type()), (Object)((Object)Redirect.Type.APPEND))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Redirect invalid for reading: " + (Object)((Object)redirect)));
        }
        a.arrayStore((Object[])this.redirects(), (int)0, (Object)((Object)redirect));
        return this;
    }

    public ProcessBuilder redirectOutput(Redirect redirect) {
        if (!f.ifAcmp((Object)((Object)redirect.type()), (Object)((Object)Redirect.Type.READ))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Redirect invalid for writing: " + (Object)((Object)redirect)));
        }
        a.arrayStore((Object[])this.redirects(), (int)1, (Object)((Object)redirect));
        return this;
    }

    public ProcessBuilder redirectError(Redirect redirect) {
        if (!f.ifAcmp((Object)((Object)redirect.type()), (Object)((Object)Redirect.Type.READ))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Redirect invalid for writing: " + (Object)((Object)redirect)));
        }
        a.arrayStore((Object[])this.redirects(), (int)2, (Object)((Object)redirect));
        return this;
    }

    public ProcessBuilder redirectInput(File file) {
        return this.redirectInput(Redirect.from(file));
    }

    public ProcessBuilder redirectOutput(File file) {
        return this.redirectOutput(Redirect.to(file));
    }

    public ProcessBuilder redirectError(File file) {
        return this.redirectError(Redirect.to(file));
    }

    public Redirect redirectInput() {
        return this.redirects == null ? Redirect.PIPE : (Redirect)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.redirects, (int)0), Redirect.class));
    }

    public Redirect redirectOutput() {
        return this.redirects == null ? Redirect.PIPE : (Redirect)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.redirects, (int)1), Redirect.class));
    }

    public Redirect redirectError() {
        return this.redirects == null ? Redirect.PIPE : (Redirect)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.redirects, (int)2), Redirect.class));
    }

    public ProcessBuilder inheritIO() {
        Arrays.fill((Object[])this.redirects(), (Object)Redirect.INHERIT);
        return this;
    }

    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    public ProcessBuilder redirectErrorStream(boolean bl) {
        this.redirectErrorStream = bl;
        return this;
    }

    public Process start() throws IOException {
        Object[] objectArray = this.command.toArray(new String[this.command.size()]);
        Object object = objectArray = (String[])a.cloneArray((Object)objectArray);
        int n = a.arrayLength((Object[])object);
        for (int i = 0; i < n; ++i) {
            String string = (String)a.arrayLoad((Object[])object, (int)i);
            if (string != null) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        object = (String)a.arrayLoad((Object[])objectArray, (int)0);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec((String)object);
        }
        String string = this.directory == null ? null : this.directory.toString();
        try {
            return ProcessImpl.start((String[])objectArray, this.environment, string, this.redirects, this.redirectErrorStream);
        }
        catch (IOException | IllegalArgumentException exception) {
            String string2 = ": " + exception.getMessage();
            Exception exception2 = exception;
            if (g.convertForInstanceOf((Object)exception, IOException.class) instanceof IOException && securityManager != null) {
                try {
                    securityManager.checkRead((String)object);
                }
                catch (AccessControlException accessControlException) {
                    string2 = "";
                    exception2 = accessControlException;
                }
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Cannot run program \"" + (String)object + "\"" + (string == null ? "" : " (in directory \"" + string + "\")") + string2, exception2));
        }
    }

    private static /* synthetic */ List _jr$ig$command(ProcessBuilder processBuilder) {
        return processBuilder.command;
    }

    private static /* synthetic */ void _jr$ip$command(ProcessBuilder processBuilder, List list) {
        processBuilder.command = list;
    }

    private static /* synthetic */ File _jr$ig$directory(ProcessBuilder processBuilder) {
        return processBuilder.directory;
    }

    private static /* synthetic */ void _jr$ip$directory(ProcessBuilder processBuilder, File file) {
        processBuilder.directory = file;
    }

    private static /* synthetic */ Map _jr$ig$environment(ProcessBuilder processBuilder) {
        return processBuilder.environment;
    }

    private static /* synthetic */ void _jr$ip$environment(ProcessBuilder processBuilder, Map map) {
        processBuilder.environment = map;
    }

    private static /* synthetic */ boolean _jr$ig$redirectErrorStream(ProcessBuilder processBuilder) {
        return processBuilder.redirectErrorStream;
    }

    private static /* synthetic */ void _jr$ip$redirectErrorStream(ProcessBuilder processBuilder, boolean bl) {
        processBuilder.redirectErrorStream = bl;
    }

    private static /* synthetic */ Redirect[] _jr$ig$redirects(ProcessBuilder processBuilder) {
        return processBuilder.redirects;
    }

    private static /* synthetic */ void _jr$ip$redirects(ProcessBuilder processBuilder, Redirect[] redirectArray) {
        processBuilder.redirects = redirectArray;
    }

    static class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }

        protected /* synthetic */ NullInputStream(h h2) {
            super(h2);
        }
    }

    static class NullOutputStream
    extends OutputStream {
        static final NullOutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }

        protected /* synthetic */ NullOutputStream(h h2) {
            super(h2);
        }
    }

    public static abstract class Redirect
    extends h {
        public static final Redirect PIPE = new Redirect(){

            @Override
            public Type type() {
                return Type.PIPE;
            }

            public String toString() {
                return this.type().toString();
            }
        };
        public static final Redirect INHERIT = new Redirect(){

            @Override
            public Type type() {
                return Type.INHERIT;
            }

            public String toString() {
                return this.type().toString();
            }
        };

        public abstract Type type();

        public File file() {
            return null;
        }

        boolean append() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        public static Redirect from(File file) {
            if (file == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            return new Redirect(file){

                @Override
                public Type type() {
                    return Type.WRITE;
                }

                public String toString() {
                    return this.type().toString();
                }

                @Override
                public File file() {
                    return NULL_FILE;
                }

                @Override
                boolean append() {
                    return false;
                }
            };
        }

        public static Redirect to(final File file) {
            if (file == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.READ;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to read from file \"" + file + "\"";
                }
            };
        }

        public static Redirect appendTo(final File file) {
            if (file == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.WRITE;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to write to file \"" + file + "\"";
                }

                @Override
                boolean append() {
                    return false;
                }
            };
        }

        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)object, (Object)((Object)this))) {
                return true;
            }
            if (!(g.convertForInstanceOf((Object)object, Redirect.class) instanceof Redirect)) {
                return false;
            }
            Redirect redirect = (Redirect)((Object)g.convertForCast((Object)object, Redirect.class));
            if (f.ifAcmp((Object)((Object)redirect.type()), (Object)((Object)this.type()))) {
                return false;
            }
            if (!$assertionsDisabled && this.file() == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            return this.file().equals(redirect.file());
        }

        public int hashCode() {
            File file = this.file();
            if (file == null) {
                return super.hashCode();
            }
            return file.hashCode();
        }

        private Redirect() {
        }

        protected /* synthetic */ Redirect(h h2) {
            super(h2);
        }

        public static enum Type {
            PIPE,
            INHERIT,
            READ,
            WRITE,
            APPEND;

        }
    }
}

