/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class ProcessEnvironment
extends HashMap<String, String> {
    static final int MIN_NAME_LENGTH = 1;
    private static final NameComparator nameComparator;
    private static final EntryComparator entryComparator;
    private static final ProcessEnvironment theEnvironment;
    private static final Map<String, String> theUnmodifiableEnvironment;
    private static final Map<String, String> theCaseInsensitiveEnvironment;

    private static String validateName(String string) {
        if (string.indexOf(61, 1) != -1 || string.indexOf(0) != -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid environment variable name: \"" + string + "\""));
        }
        return string;
    }

    private static String validateValue(String string) {
        if (string.indexOf(0) != -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid environment variable value: \"" + string + "\""));
        }
        return string;
    }

    private static String nonNullString(Object object) {
        if (object == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return (String)object;
    }

    @Override
    public String put(String string, String string2) {
        return super.put(ProcessEnvironment.validateName(string), ProcessEnvironment.validateValue(string2));
    }

    @Override
    public String get(Object object) {
        return (String)super.get(ProcessEnvironment.nonNullString(object));
    }

    @Override
    public boolean containsKey(Object object) {
        return super.containsKey(ProcessEnvironment.nonNullString(object));
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(ProcessEnvironment.nonNullString(object));
    }

    @Override
    public String remove(Object object) {
        return (String)super.remove(ProcessEnvironment.nonNullString(object));
    }

    @Override
    public Set<String> keySet() {
        return new CheckedKeySet(super.keySet());
    }

    @Override
    public Collection<String> values() {
        return new CheckedValues(super.values());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new CheckedEntrySet(super.entrySet());
    }

    private ProcessEnvironment() {
    }

    private ProcessEnvironment(int n2) {
        super(n2);
    }

    static String getenv(String string) {
        return theCaseInsensitiveEnvironment.get(string);
    }

    static Map<String, String> getenv() {
        return theUnmodifiableEnvironment;
    }

    static Map<String, String> environment() {
        return (Map)g.convertForCast((Object)theEnvironment.clone(), Map.class);
    }

    static Map<String, String> emptyEnvironment(int n2) {
        return new ProcessEnvironment(n2);
    }

    private static native String environmentBlock();

    String toEnvironmentBlock() {
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.entrySet());
        Collections.sort(arrayList, entryComparator);
        StringBuilder stringBuilder = new StringBuilder(this.size() * 30);
        int n2 = -1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (n2 < 0 && (n2 = nameComparator.compare(string, "SystemRoot")) > 0) {
                ProcessEnvironment.addToEnvIfSet(stringBuilder, "SystemRoot");
            }
            ProcessEnvironment.addToEnv(stringBuilder, string, string2);
        }
        if (n2 < 0) {
            ProcessEnvironment.addToEnvIfSet(stringBuilder, "SystemRoot");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('\u0000');
        }
        stringBuilder.append('\u0000');
        return stringBuilder.toString();
    }

    private static void addToEnvIfSet(StringBuilder stringBuilder, String string) {
        String string2 = ProcessEnvironment.getenv(string);
        if (string2 != null) {
            ProcessEnvironment.addToEnv(stringBuilder, string, string2);
        }
    }

    private static void addToEnv(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string).append('=').append(string2).append('\u0000');
    }

    static String toEnvironmentBlock(Map<String, String> map) {
        return map == null ? null : ((ProcessEnvironment)map).toEnvironmentBlock();
    }

    static {
        int n2;
        int n3;
        nameComparator = new NameComparator();
        entryComparator = new EntryComparator();
        theEnvironment = new ProcessEnvironment();
        theUnmodifiableEnvironment = Collections.unmodifiableMap(theEnvironment);
        String string = ProcessEnvironment.environmentBlock();
        int n4 = 0;
        while ((n3 = string.indexOf(0, n4)) != -1 && (n2 = string.indexOf(61, n4 + 1)) != -1) {
            if (n2 < n3) {
                theEnvironment.put(string.substring(n4, n2), string.substring(n2 + 1, n3));
            }
            n4 = n3 + 1;
        }
        theCaseInsensitiveEnvironment = new TreeMap<String, String>(nameComparator);
        theCaseInsensitiveEnvironment.putAll(theEnvironment);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class CheckedEntry
    extends h
    implements Map.Entry {
        private final Map.Entry<String, String> e;

        public CheckedEntry(Map.Entry<String, String> entry) {
            this.e = entry;
        }

        public String getKey() {
            return (String)this.e.getKey();
        }

        public String getValue() {
            return (String)this.e.getValue();
        }

        public String setValue(String string) {
            return this.e.setValue(ProcessEnvironment.validateValue(string));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public boolean equals(Object object) {
            return this.e.equals(object);
        }

        @Override
        public int hashCode() {
            return this.e.hashCode();
        }

        private static /* synthetic */ void _jr$ip$e(CheckedEntry checkedEntry, Map.Entry entry) {
            checkedEntry.e = entry;
        }

        protected /* synthetic */ CheckedEntry(h h2) {
            super(h2);
        }
    }

    private static class CheckedEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private final Set<Map.Entry<String, String>> s;

        public CheckedEntrySet(Set<Map.Entry<String, String>> set) {
            this.s = set;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator(this){
                Iterator<Map.Entry<String, String>> i;
                final /* synthetic */ CheckedEntrySet this$0;
                {
                    this.this$0 = checkedEntrySet;
                    this.i = this.this$0.s.iterator();
                }

                @Override
                public boolean hasNext() {
                    return (this).i.hasNext();
                }

                public Map.Entry<String, String> next() {
                    return new CheckedEntry((Map.Entry)g.convertForCast((this).i.next(), Map.Entry.class));
                }

                @Override
                public void remove() {
                    (this).i.remove();
                }

                static /* synthetic */ void _jr$ip$i(Object object, Iterator iterator) {
                    (object).i = iterator;
                }

                static /* synthetic */ CheckedEntrySet _jr$ig$this$0(Object object) {
                    return (object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, CheckedEntrySet checkedEntrySet) {
                    (object).this$0 = checkedEntrySet;
                }
            };
        }

        private static Map.Entry<String, String> checkedEntry(Object object) {
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            ProcessEnvironment.nonNullString(entry.getKey());
            ProcessEnvironment.nonNullString(entry.getValue());
            return entry;
        }

        @Override
        public boolean contains(Object object) {
            return this.s.contains(CheckedEntrySet.checkedEntry(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.s.remove(CheckedEntrySet.checkedEntry(object));
        }

        private static /* synthetic */ void _jr$ip$s(CheckedEntrySet checkedEntrySet, Set set) {
            checkedEntrySet.s = set;
        }

        protected /* synthetic */ CheckedEntrySet(h h2) {
            super(h2);
        }
    }

    private static class CheckedKeySet
    extends AbstractSet<String> {
        private final Set<String> s;

        public CheckedKeySet(Set<String> set) {
            this.s = set;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.s.iterator();
        }

        @Override
        public boolean contains(Object object) {
            return this.s.contains(ProcessEnvironment.nonNullString(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.s.remove(ProcessEnvironment.nonNullString(object));
        }

        private static /* synthetic */ void _jr$ip$s(CheckedKeySet checkedKeySet, Set set) {
            checkedKeySet.s = set;
        }

        protected /* synthetic */ CheckedKeySet(h h2) {
            super(h2);
        }
    }

    private static class CheckedValues
    extends AbstractCollection<String> {
        private final Collection<String> c;

        public CheckedValues(Collection<String> collection) {
            this.c = collection;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.c.iterator();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(ProcessEnvironment.nonNullString(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.c.remove(ProcessEnvironment.nonNullString(object));
        }

        private static /* synthetic */ void _jr$ip$c(CheckedValues checkedValues, Collection collection) {
            checkedValues.c = collection;
        }

        protected /* synthetic */ CheckedValues(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static final class EntryComparator
    extends h
    implements Comparator {
        private EntryComparator() {
        }

        public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
            return nameComparator.compare(entry.getKey(), entry2.getKey());
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static final class NameComparator
    extends h
    implements Comparator {
        private NameComparator() {
        }

        public int compare(String string, String string2) {
            int n2 = string.length();
            int n3 = string2.length();
            int n4 = Math.min(n2, n3);
            for (int i = 0; i < n4; ++i) {
                char c;
                char c2 = string.charAt(i);
                if (c2 == (c = string2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c))) continue;
                return c2 - c;
            }
            return n2 - n3;
        }
    }
}

