/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.zeroturnaround.jrebelbase.h;
import java.util.Random;
import sun.misc.FpUtils;

public final class StrictMath
extends h {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static Random randomNumberGenerator;
    private static long negativeZeroFloatBits;
    private static long negativeZeroDoubleBits;

    private StrictMath() {
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan(double var0);

    public static strictfp double toRadians(double d) {
        return d / 180.0 * Math.PI;
    }

    public static strictfp double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double log10(double var0);

    public static native double sqrt(double var0);

    public static native double cbrt(double var0);

    public static native double IEEEremainder(double var0, double var2);

    public static double ceil(double d) {
        return StrictMath.floorOrCeil(d, -0.0, 1.0, 1.0);
    }

    public static double floor(double d) {
        return StrictMath.floorOrCeil(d, -1.0, 0.0, -1.0);
    }

    private static double floorOrCeil(double d, double d2, double d3, double d4) {
        int n2 = Math.getExponent(d);
        if (n2 < 0) {
            return d == 0.0 ? d : (d < 0.0 ? d2 : d3);
        }
        if (n2 >= 52) {
            return d;
        }
        if (!($assertionsDisabled || n2 >= 0 && n2 <= 51)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        long l2 = 0xFFFFFFFFFFFFFL >> n2;
        long l3 = Double.doubleToRawLongBits(d);
        if ((l2 & l3) == 0L) {
            return d;
        }
        double d5 = Double.longBitsToDouble(l3 & (l2 ^ 0xFFFFFFFFFFFFFFFFL));
        if (d4 * d > 0.0) {
            d5 += d4;
        }
        return d5;
    }

    public static double rint(double d) {
        double d2 = 4.503599627370496E15;
        double d3 = FpUtils.rawCopySign(1.0, d);
        if ((d = Math.abs(d)) < d2) {
            d = d2 + d - d2;
        }
        return d3 * d;
    }

    public static native double atan2(double var0, double var2);

    public static native double pow(double var0, double var2);

    public static int round(float f2) {
        return Math.round(f2);
    }

    public static long round(double d) {
        return Math.round(d);
    }

    private static synchronized Random initRNG() {
        Random random = randomNumberGenerator;
        return random == null ? (randomNumberGenerator = new Random()) : random;
    }

    public static double random() {
        Random random = randomNumberGenerator;
        if (random == null) {
            random = StrictMath.initRNG();
        }
        return random.nextDouble();
    }

    public static int abs(int n2) {
        return n2 < 0 ? -n2 : n2;
    }

    public static long abs(long l2) {
        return l2 < 0L ? -l2 : l2;
    }

    public static float abs(float f2) {
        return f2 <= 0.0f ? 0.0f - f2 : f2;
    }

    public static double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static int max(int n2, int n3) {
        return n2 >= n3 ? n2 : n3;
    }

    public static long max(long l2, long l3) {
        return l2 >= l3 ? l2 : l3;
    }

    public static float max(float f2, float f3) {
        if (f2 != f2) {
            return f2;
        }
        if (f2 == 0.0f && f3 == 0.0f && (long)Float.floatToRawIntBits(f2) == negativeZeroFloatBits) {
            return f3;
        }
        return f2 >= f3 ? f2 : f3;
    }

    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToRawLongBits(d) == negativeZeroDoubleBits) {
            return d2;
        }
        return d >= d2 ? d : d2;
    }

    public static int min(int n2, int n3) {
        return n2 <= n3 ? n2 : n3;
    }

    public static long min(long l2, long l3) {
        return l2 <= l3 ? l2 : l3;
    }

    public static float min(float f2, float f3) {
        if (f2 != f2) {
            return f2;
        }
        if (f2 == 0.0f && f3 == 0.0f && (long)Float.floatToRawIntBits(f3) == negativeZeroFloatBits) {
            return f3;
        }
        return f2 <= f3 ? f2 : f3;
    }

    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToRawLongBits(d2) == negativeZeroDoubleBits) {
            return d2;
        }
        return d <= d2 ? d : d2;
    }

    public static double ulp(double d) {
        return FpUtils.ulp(d);
    }

    public static float ulp(float f2) {
        return FpUtils.ulp(f2);
    }

    public static double signum(double d) {
        return FpUtils.signum(d);
    }

    public static float signum(float f2) {
        return FpUtils.signum(f2);
    }

    public static native double sinh(double var0);

    public static native double cosh(double var0);

    public static native double tanh(double var0);

    public static native double hypot(double var0, double var2);

    public static native double expm1(double var0);

    public static native double log1p(double var0);

    public static double copySign(double d, double d2) {
        return FpUtils.copySign(d, d2);
    }

    public static float copySign(float f2, float f3) {
        return FpUtils.copySign(f2, f3);
    }

    public static int getExponent(float f2) {
        return FpUtils.getExponent(f2);
    }

    public static int getExponent(double d) {
        return FpUtils.getExponent(d);
    }

    public static double nextAfter(double d, double d2) {
        return FpUtils.nextAfter(d, d2);
    }

    public static float nextAfter(float f2, double d) {
        return FpUtils.nextAfter(f2, d);
    }

    public static double nextUp(double d) {
        return FpUtils.nextUp(d);
    }

    public static float nextUp(float f2) {
        return FpUtils.nextUp(f2);
    }

    public static double scalb(double d, int n2) {
        return FpUtils.scalb(d, n2);
    }

    public static float scalb(float f2, int n2) {
        return FpUtils.scalb(f2, n2);
    }

    static {
        negativeZeroFloatBits = Float.floatToRawIntBits(-0.0f);
        negativeZeroDoubleBits = Double.doubleToRawLongBits(-0.0);
    }
}

