/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.PrintStream;
import java.util.Arrays;
import sun.misc.VM;

public class ThreadGroup
extends h
implements Thread.UncaughtExceptionHandler {
    private final ThreadGroup parent;
    String name;
    int maxPriority;
    boolean destroyed;
    boolean daemon;
    boolean vmAllowSuspension;
    int nUnstartedThreads;
    int nthreads;
    Thread[] threads;
    int ngroups;
    ThreadGroup[] groups;

    private ThreadGroup() {
        this.nUnstartedThreads = 0;
        this.name = "system";
        this.maxPriority = 10;
        this.parent = null;
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        this(ThreadGroup.checkParentAccess(threadGroup), threadGroup, string);
    }

    private ThreadGroup(Void void_, ThreadGroup threadGroup, String string) {
        this.nUnstartedThreads = 0;
        this.name = string;
        this.maxPriority = threadGroup.maxPriority;
        this.daemon = threadGroup.daemon;
        this.vmAllowSuspension = threadGroup.vmAllowSuspension;
        this.parent = threadGroup;
        threadGroup.add(this);
    }

    private static Void checkParentAccess(ThreadGroup threadGroup) {
        threadGroup.checkAccess();
        return null;
    }

    public final String getName() {
        return ((ThreadGroup)this).name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    public final int getMaxPriority() {
        return ((ThreadGroup)this).maxPriority;
    }

    public final boolean isDaemon() {
        return ((ThreadGroup)this).daemon;
    }

    @af(modifiers=33)
    public boolean isDestroyed() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return ((ThreadGroup)this).destroyed;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        ((ThreadGroup)this).daemon = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int n2) {
        Object[] objectArray;
        int n3;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.checkAccess();
                if (n2 < 1 || n2 > 10) {
                    return;
                }
                ((ThreadGroup)this).maxPriority = this.parent != null ? Math.min(n2, ((ThreadGroup)this.parent).maxPriority) : n2;
                n3 = ((ThreadGroup)this).ngroups;
                objectArray = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n3), ThreadGroup[].class) : null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        for (int i = 0; i < n3; ++i) {
            ((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ThreadGroup.class)).setMaxPriority(n2);
        }
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (!f.ifAcmp((Object)threadGroup, (Object)this)) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        Object[] objectArray;
        int n2;
        int n3;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    return 0;
                }
                n3 = ((ThreadGroup)this).nthreads;
                n2 = ((ThreadGroup)this).ngroups;
                objectArray = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n2), ThreadGroup[].class) : null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        for (int i = 0; i < n2; ++i) {
            n3 += ((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ThreadGroup.class)).activeCount();
        }
        return n3;
    }

    public int enumerate(Thread[] threadArray) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, true);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(Thread[] threadArray, int n2, boolean bl) {
        int n3 = 0;
        ThreadGroup[] threadGroupArray = null;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    return 0;
                }
                int n4 = ((ThreadGroup)this).nthreads;
                if (n4 > a.arrayLength((Object[])threadArray) - n2) {
                    n4 = a.arrayLength((Object[])threadArray) - n2;
                }
                for (int i = 0; i < n4; ++i) {
                    if (!((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)i), Thread.class))._jr$jnim$isAlive()) continue;
                    a.arrayStore((Object[])threadArray, (int)n2++, (Object)((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)i), Thread.class)));
                }
                if (bl) {
                    n3 = ((ThreadGroup)this).ngroups;
                    threadGroupArray = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n3), ThreadGroup[].class) : null;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                n2 = ((ThreadGroup)g.convertForCast((Object)a.arrayLoad(threadGroupArray, (int)i), ThreadGroup.class)).enumerate(threadArray, n2, true);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        Object[] objectArray;
        int n2;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    return 0;
                }
                n2 = ((ThreadGroup)this).ngroups;
                objectArray = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n2), ThreadGroup[].class) : null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        int n3 = n2;
        for (int i = 0; i < n2; ++i) {
            n3 += ((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ThreadGroup.class)).activeGroupCount();
        }
        return n3;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, true);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(ThreadGroup[] threadGroupArray, int n2, boolean bl) {
        int n3 = 0;
        ThreadGroup[] threadGroupArray2 = null;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    return 0;
                }
                int n4 = ((ThreadGroup)this).ngroups;
                if (n4 > a.arrayLength((Object[])threadGroupArray) - n2) {
                    n4 = a.arrayLength((Object[])threadGroupArray) - n2;
                }
                if (n4 > 0) {
                    a.arraycopy((Object)((ThreadGroup)this).groups, (int)0, (Object)threadGroupArray, (int)n2, (int)n4);
                    n2 += n4;
                }
                if (bl) {
                    n3 = ((ThreadGroup)this).ngroups;
                    threadGroupArray2 = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n3), ThreadGroup[].class) : null;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                n2 = ((ThreadGroup)g.convertForCast((Object)a.arrayLoad(threadGroupArray2, (int)i), ThreadGroup.class)).enumerate(threadGroupArray, n2, true);
            }
        }
        return n2;
    }

    @Deprecated
    public final void stop() {
        if (this.stopOrSuspend(false)) {
            Thread.currentThread().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        Object[] objectArray;
        int n2;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.checkAccess();
                for (int i = 0; i < ((ThreadGroup)this).nthreads; ++i) {
                    ((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)i), Thread.class)).interrupt();
                }
                n2 = ((ThreadGroup)this).ngroups;
                objectArray = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n2), ThreadGroup[].class) : null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        for (int i = 0; i < n2; ++i) {
            ((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ThreadGroup.class)).interrupt();
        }
    }

    @Deprecated
    public final void suspend() {
        if (this.stopOrSuspend(true)) {
            Thread.currentThread().suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopOrSuspend(boolean bl) {
        int n2;
        boolean bl2 = false;
        Thread thread = Thread.currentThread();
        Object[] objectArray = null;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.checkAccess();
                for (int i = 0; i < ((ThreadGroup)this).nthreads; ++i) {
                    if (!f.ifAcmp((Object)((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)i), Thread.class)), (Object)thread)) {
                        bl2 = true;
                        continue;
                    }
                    if (bl) {
                        ((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)i), Thread.class)).suspend();
                        continue;
                    }
                    ((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)i), Thread.class)).stop();
                }
                n2 = ((ThreadGroup)this).ngroups;
                if (((ThreadGroup)this).groups != null) {
                    objectArray = (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n2), ThreadGroup[].class);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        for (int i = 0; i < n2; ++i) {
            bl2 = ((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ThreadGroup.class)).stopOrSuspend(bl) || bl2;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        Object[] objectArray;
        int n2;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.checkAccess();
                for (int i = 0; i < ((ThreadGroup)this).nthreads; ++i) {
                    ((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)i), Thread.class)).resume();
                }
                n2 = ((ThreadGroup)this).ngroups;
                objectArray = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n2), ThreadGroup[].class) : null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        for (int i = 0; i < n2; ++i) {
            ((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ThreadGroup.class)).resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        Object[] objectArray;
        int n2;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.checkAccess();
                if (((ThreadGroup)this).destroyed || ((ThreadGroup)this).nthreads > 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalThreadStateException());
                }
                n2 = ((ThreadGroup)this).ngroups;
                objectArray = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n2), ThreadGroup[].class) : null;
                if (this.parent != null) {
                    ((ThreadGroup)this).destroyed = true;
                    ((ThreadGroup)this).ngroups = 0;
                    ((ThreadGroup)this).groups = null;
                    ((ThreadGroup)this).nthreads = 0;
                    ((ThreadGroup)this).threads = null;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        for (int i = 0; i < n2; ++i) {
            ((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ThreadGroup.class)).destroy();
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void add(ThreadGroup threadGroup) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalThreadStateException());
                }
                if (((ThreadGroup)this).groups == null) {
                    ((ThreadGroup)this).groups = new ThreadGroup[4];
                } else if (((ThreadGroup)this).ngroups == a.arrayLength((Object[])((ThreadGroup)this).groups)) {
                    ((ThreadGroup)this).groups = (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, ((ThreadGroup)this).ngroups * 2), ThreadGroup[].class);
                }
                a.arrayStore((Object[])((ThreadGroup)this).groups, (int)((ThreadGroup)this).ngroups, (Object)threadGroup);
                ThreadGroup threadGroup2 = this;
                ((ThreadGroup)threadGroup2).ngroups = ((ThreadGroup)threadGroup2).ngroups + 1;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup threadGroup) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    return;
                }
                for (int i = 0; i < ((ThreadGroup)this).ngroups; ++i) {
                    if (f.ifAcmp((Object)((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).groups, (int)i), ThreadGroup.class)), (Object)threadGroup)) continue;
                    ThreadGroup threadGroup2 = this;
                    ((ThreadGroup)threadGroup2).ngroups = ((ThreadGroup)threadGroup2).ngroups - 1;
                    a.arraycopy((Object)((ThreadGroup)this).groups, (int)(i + 1), (Object)((ThreadGroup)this).groups, (int)i, (int)(((ThreadGroup)this).ngroups - i));
                    a.arrayStore((Object[])((ThreadGroup)this).groups, (int)((ThreadGroup)this).ngroups, null);
                    break;
                }
                if (((ThreadGroup)this).nthreads == 0) {
                    ah.getMonitor((Object)this).notifyAll();
                }
                if (((ThreadGroup)this).daemon && ((ThreadGroup)this).nthreads == 0 && ((ThreadGroup)this).nUnstartedThreads == 0 && ((ThreadGroup)this).ngroups == 0) {
                    this.destroy();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnstarted() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalThreadStateException());
                }
                ThreadGroup threadGroup = this;
                ((ThreadGroup)threadGroup).nUnstartedThreads = ((ThreadGroup)threadGroup).nUnstartedThreads + 1;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Thread thread) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalThreadStateException());
                }
                if (((ThreadGroup)this).threads == null) {
                    ((ThreadGroup)this).threads = new Thread[4];
                } else if (((ThreadGroup)this).nthreads == a.arrayLength((Object[])((ThreadGroup)this).threads)) {
                    ((ThreadGroup)this).threads = (Thread[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).threads, ((ThreadGroup)this).nthreads * 2), Thread[].class);
                }
                a.arrayStore((Object[])((ThreadGroup)this).threads, (int)((ThreadGroup)this).nthreads, (Object)thread);
                ThreadGroup threadGroup = this;
                ((ThreadGroup)threadGroup).nthreads = ((ThreadGroup)threadGroup).nthreads + 1;
                ThreadGroup threadGroup2 = this;
                ((ThreadGroup)threadGroup2).nUnstartedThreads = ((ThreadGroup)threadGroup2).nUnstartedThreads - 1;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadStartFailed(Thread thread) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.remove(thread);
                ThreadGroup threadGroup = this;
                ((ThreadGroup)threadGroup).nUnstartedThreads = ((ThreadGroup)threadGroup).nUnstartedThreads + 1;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadTerminated(Thread thread) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.remove(thread);
                if (((ThreadGroup)this).nthreads == 0) {
                    ah.getMonitor((Object)this).notifyAll();
                }
                if (((ThreadGroup)this).daemon && ((ThreadGroup)this).nthreads == 0 && ((ThreadGroup)this).nUnstartedThreads == 0 && ((ThreadGroup)this).ngroups == 0) {
                    this.destroy();
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Thread thread) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (((ThreadGroup)this).destroyed) {
                    return;
                }
                for (int i = 0; i < ((ThreadGroup)this).nthreads; ++i) {
                    if (f.ifAcmp((Object)((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)i), Thread.class)), (Object)thread)) continue;
                    Thread[] threadArray = ((ThreadGroup)this).threads;
                    Thread[] threadArray2 = ((ThreadGroup)this).threads;
                    ThreadGroup threadGroup = this;
                    int n2 = ((ThreadGroup)threadGroup).nthreads - 1;
                    ((ThreadGroup)threadGroup).nthreads = n2;
                    a.arraycopy((Object)threadArray, (int)(i + 1), (Object)threadArray2, (int)i, (int)(n2 - i));
                    a.arrayStore((Object[])((ThreadGroup)this).threads, (int)((ThreadGroup)this).nthreads, null);
                    break;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void list() {
        this.list(System.out, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void list(PrintStream printStream, int n2) {
        Object[] objectArray;
        int n3;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    printStream.print(" ");
                }
                printStream.println(this);
                n2 += 4;
                for (n4 = 0; n4 < ((ThreadGroup)this).nthreads; ++n4) {
                    for (int i = 0; i < n2; ++i) {
                        printStream.print(" ");
                    }
                    printStream.println((Thread)g.convertForCast((Object)a.arrayLoad((Object[])((ThreadGroup)this).threads, (int)n4), Thread.class));
                }
                n3 = ((ThreadGroup)this).ngroups;
                objectArray = ((ThreadGroup)this).groups != null ? (ThreadGroup[])g.convertForCast((Object)Arrays.copyOf(((ThreadGroup)this).groups, n3), ThreadGroup[].class) : null;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        for (int i = 0; i < n3; ++i) {
            ((ThreadGroup)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), ThreadGroup.class)).list(printStream, n2);
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        } else {
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.uncaughtException(thread, throwable);
            } else if (!(g.convertForInstanceOf((Object)throwable, ThreadDeath.class) instanceof ThreadDeath)) {
                System.err.print("Exception in thread \"" + thread.getName() + "\" ");
                throwable.printStackTrace(System.err);
            }
        }
    }

    @Deprecated
    public boolean allowThreadSuspension(boolean bl) {
        ((ThreadGroup)this).vmAllowSuspension = bl;
        if (!bl) {
            VM.unsuspendSomeThreads();
        }
        return true;
    }

    public String toString() {
        return x.getName(this.getClass()) + "[name=" + this.getName() + ",maxpri=" + ((ThreadGroup)this).maxPriority + "]";
    }

    private static /* synthetic */ void _jr$ip$parent(ThreadGroup threadGroup, ThreadGroup threadGroup2) {
        threadGroup.parent = threadGroup2;
    }

    static /* synthetic */ void _jr$ip$name(Object object, String string) {
        ((ThreadGroup)object).name = string;
    }

    static /* synthetic */ boolean _jr$ig$vmAllowSuspension(Object object) {
        return ((ThreadGroup)object).vmAllowSuspension;
    }

    protected /* synthetic */ ThreadGroup(h h2) {
        super(h2);
    }
}

