/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.Invokers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodTypeForm;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

public final class MethodType
implements Serializable {
    private static final long serialVersionUID = 292L;
    private final Class<?> rtype;
    private final Class<?>[] ptypes;
    private MethodTypeForm form;
    private MethodType wrapAlt;
    private Invokers invokers;
    static final int MAX_JVM_ARITY = 255;
    static final int MAX_MH_ARITY = 254;
    static final int MAX_MH_INVOKER_ARITY = 253;
    static final WeakInternSet internTable = new WeakInternSet();
    static final Class<?>[] NO_PTYPES = new Class[0];
    private static final MethodType[] objectOnlyTypes = new MethodType[20];
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final long rtypeOffset;
    private static final long ptypesOffset;

    private MethodType(Class<?> clazz, Class<?>[] classArray) {
        MethodType.checkRtype(clazz);
        MethodType.checkPtypes(classArray);
        this.rtype = clazz;
        this.ptypes = classArray;
    }

    MethodTypeForm form() {
        return this.form;
    }

    Class<?> rtype() {
        return this.rtype;
    }

    Class<?>[] ptypes() {
        return this.ptypes;
    }

    void setForm(MethodTypeForm methodTypeForm) {
        this.form = methodTypeForm;
    }

    private static void checkRtype(Class<?> clazz) {
        ((Object)clazz).equals(clazz);
    }

    private static int checkPtype(Class<?> clazz) {
        clazz.getClass();
        if (clazz == Void.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("parameter type cannot be void");
        }
        if (clazz == Double.TYPE || clazz == Long.TYPE) {
            return 1;
        }
        return 0;
    }

    private static int checkPtypes(Class<?>[] classArray) {
        int n2 = 0;
        for (Class<?> clazz : classArray) {
            n2 += MethodType.checkPtype(clazz);
        }
        MethodType.checkSlotCount(classArray.length + n2);
        return n2;
    }

    static void checkSlotCount(int n2) {
        if ((n2 & 0xFF) != n2) {
            throw MethodHandleStatics.newIllegalArgumentException("bad parameter count " + n2);
        }
    }

    private static IndexOutOfBoundsException newIndexOutOfBoundsException(Object object) {
        if (object instanceof Integer) {
            object = "bad index: " + object;
        }
        return new IndexOutOfBoundsException(object.toString());
    }

    public static MethodType methodType(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.makeImpl(clazz, classArray, false);
    }

    public static MethodType methodType(Class<?> clazz, List<Class<?>> list) {
        boolean bl = false;
        return MethodType.makeImpl(clazz, MethodType.listToArray(list), bl);
    }

    private static Class<?>[] listToArray(List<Class<?>> list) {
        MethodType.checkSlotCount(list.size());
        return list.toArray(NO_PTYPES);
    }

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        Class[] classArray2 = new Class[1 + classArray.length];
        classArray2[0] = clazz2;
        System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        return MethodType.makeImpl(clazz, classArray2, true);
    }

    public static MethodType methodType(Class<?> clazz) {
        return MethodType.makeImpl(clazz, NO_PTYPES, true);
    }

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2) {
        return MethodType.makeImpl(clazz, new Class[]{clazz2}, true);
    }

    public static MethodType methodType(Class<?> clazz, MethodType methodType) {
        return MethodType.makeImpl(clazz, methodType.ptypes, true);
    }

    static MethodType makeImpl(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        MethodTypeForm methodTypeForm;
        MethodType methodType;
        MethodType methodType2;
        if (classArray.length == 0) {
            classArray = NO_PTYPES;
            bl = true;
        }
        if ((methodType2 = internTable.get(methodType = new MethodType(clazz, classArray))) != null) {
            return methodType2;
        }
        if (!bl) {
            methodType = new MethodType(clazz, (Class[])classArray.clone());
        }
        methodType.form = methodTypeForm = MethodTypeForm.findForm(methodType);
        return internTable.add(methodType);
    }

    public static MethodType genericMethodType(int n2, boolean bl) {
        MethodType methodType;
        MethodType.checkSlotCount(n2);
        int n3 = !bl ? 0 : 1;
        int n4 = n2 * 2 + n3;
        if (n4 < objectOnlyTypes.length && (methodType = objectOnlyTypes[n4]) != null) {
            return methodType;
        }
        Object[] objectArray = new Class[n2 + n3];
        Arrays.fill(objectArray, Object.class);
        if (n3 != 0) {
            objectArray[n2] = Object[].class;
        }
        methodType = MethodType.makeImpl(Object.class, objectArray, true);
        if (n4 < objectOnlyTypes.length) {
            MethodType.objectOnlyTypes[n4] = methodType;
        }
        return methodType;
    }

    public static MethodType genericMethodType(int n2) {
        return MethodType.genericMethodType(n2, false);
    }

    public MethodType changeParameterType(int n2, Class<?> clazz) {
        if (this.parameterType(n2) == clazz) {
            return this;
        }
        MethodType.checkPtype(clazz);
        Class[] classArray = (Class[])this.ptypes.clone();
        classArray[n2] = clazz;
        return MethodType.makeImpl(this.rtype, classArray, true);
    }

    public MethodType insertParameterTypes(int n2, Class<?> ... classArray) {
        int n3 = this.ptypes.length;
        if (n2 < 0 || n2 > n3) {
            throw MethodType.newIndexOutOfBoundsException(n2);
        }
        int n4 = MethodType.checkPtypes(classArray);
        MethodType.checkSlotCount(this.parameterSlotCount() + classArray.length + n4);
        int n5 = classArray.length;
        if (n5 == 0) {
            return this;
        }
        Class<?>[] classArray2 = Arrays.copyOfRange(this.ptypes, 0, n3 + n5);
        System.arraycopy(classArray2, n2, classArray2, n2 + n5, n3 - n2);
        System.arraycopy(classArray, 0, classArray2, n2, n5);
        return MethodType.makeImpl(this.rtype, classArray2, true);
    }

    public MethodType appendParameterTypes(Class<?> ... classArray) {
        return this.insertParameterTypes(this.parameterCount(), classArray);
    }

    public MethodType insertParameterTypes(int n2, List<Class<?>> list) {
        return this.insertParameterTypes(n2, MethodType.listToArray(list));
    }

    public MethodType appendParameterTypes(List<Class<?>> list) {
        return this.insertParameterTypes(this.parameterCount(), list);
    }

    MethodType replaceParameterTypes(int n2, int n3, Class<?> ... classArray) {
        if (n2 == n3) {
            return this.insertParameterTypes(n2, classArray);
        }
        int n4 = this.ptypes.length;
        if (0 > n2 || n2 > n3 || n3 > n4) {
            throw MethodType.newIndexOutOfBoundsException("start=" + n2 + " end=" + n3);
        }
        int n5 = classArray.length;
        if (n5 == 0) {
            return this.dropParameterTypes(n2, n3);
        }
        return this.dropParameterTypes(n2, n3).insertParameterTypes(n2, classArray);
    }

    public MethodType dropParameterTypes(int n2, int n3) {
        Class<?>[] classArray;
        int n4 = this.ptypes.length;
        if (0 > n2 || n2 > n3 || n3 > n4) {
            throw MethodType.newIndexOutOfBoundsException("start=" + n2 + " end=" + n3);
        }
        if (n2 == n3) {
            return this;
        }
        if (n2 == 0) {
            classArray = n3 == n4 ? NO_PTYPES : Arrays.copyOfRange(this.ptypes, n3, n4);
        } else if (n3 == n4) {
            classArray = Arrays.copyOfRange(this.ptypes, 0, n2);
        } else {
            int n5 = n4 - n3;
            classArray = Arrays.copyOfRange(this.ptypes, 0, n2 + n5);
            System.arraycopy(this.ptypes, n3, classArray, n2, n5);
        }
        return MethodType.makeImpl(this.rtype, classArray, true);
    }

    public MethodType changeReturnType(Class<?> clazz) {
        if (this.returnType() == clazz) {
            return this;
        }
        return MethodType.makeImpl(clazz, this.ptypes, true);
    }

    public boolean hasPrimitives() {
        return this.form.hasPrimitives();
    }

    public boolean hasWrappers() {
        return this.unwrap() != this;
    }

    public MethodType erase() {
        return this.form.erasedType();
    }

    MethodType basicType() {
        return this.form.basicType();
    }

    MethodType invokerType() {
        return this.insertParameterTypes(0, MethodHandle.class);
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.parameterCount());
    }

    public MethodType wrap() {
        return this.hasPrimitives() ? MethodType.wrapWithPrims(this) : this;
    }

    public MethodType unwrap() {
        MethodType methodType = !this.hasPrimitives() ? this : MethodType.wrapWithPrims(this);
        return MethodType.unwrapWithNoPrims(methodType);
    }

    private static MethodType wrapWithPrims(MethodType methodType) {
        assert (methodType.hasPrimitives());
        MethodType methodType2 = methodType.wrapAlt;
        if (methodType2 == null) {
            methodType2 = MethodTypeForm.canonicalize(methodType, 2, 2);
            assert (methodType2 != null);
            methodType.wrapAlt = methodType2;
        }
        return methodType2;
    }

    private static MethodType unwrapWithNoPrims(MethodType methodType) {
        assert (!methodType.hasPrimitives());
        MethodType methodType2 = methodType.wrapAlt;
        if (methodType2 == null) {
            methodType2 = MethodTypeForm.canonicalize(methodType, 3, 3);
            if (methodType2 == null) {
                methodType2 = methodType;
            }
            methodType.wrapAlt = methodType2;
        }
        return methodType2;
    }

    public Class<?> parameterType(int n2) {
        return this.ptypes[n2];
    }

    public int parameterCount() {
        return this.ptypes.length;
    }

    public Class<?> returnType() {
        return this.rtype;
    }

    public List<Class<?>> parameterList() {
        return Collections.unmodifiableList(Arrays.asList(this.ptypes));
    }

    Class<?> lastParameterType() {
        int n2 = this.ptypes.length;
        return n2 == 0 ? Void.TYPE : this.ptypes[n2 - 1];
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof MethodType && this.equals((MethodType)object);
    }

    private boolean equals(MethodType methodType) {
        return this.rtype == methodType.rtype && a.trueEquals((Object[])this.ptypes, (Object[])methodType.ptypes);
    }

    public int hashCode() {
        int n2 = 31 + ((Object)this.rtype).hashCode();
        for (Class<?> clazz : this.ptypes) {
            n2 = 31 * n2 + ((Object)clazz).hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.ptypes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.ptypes[i].getSimpleName());
        }
        stringBuilder.append(")");
        stringBuilder.append(this.rtype.getSimpleName());
        return stringBuilder.toString();
    }

    boolean isViewableAs(MethodType methodType) {
        if (!VerifyType.isNullConversion(this.returnType(), methodType.returnType())) {
            return false;
        }
        int n2 = this.parameterCount();
        if (n2 != methodType.parameterCount()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (VerifyType.isNullConversion(methodType.parameterType(i), this.parameterType(i))) continue;
            return false;
        }
        return true;
    }

    boolean isCastableTo(MethodType methodType) {
        int n2 = this.parameterCount();
        return n2 == methodType.parameterCount();
    }

    boolean isConvertibleTo(MethodType methodType) {
        if (!MethodType.canConvert(this.returnType(), methodType.returnType())) {
            return false;
        }
        int n2 = this.parameterCount();
        if (n2 != methodType.parameterCount()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (MethodType.canConvert(methodType.parameterType(i), this.parameterType(i))) continue;
            return false;
        }
        return true;
    }

    static boolean canConvert(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2 || clazz2 == Object.class) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return true;
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            if (clazz2.isPrimitive()) {
                return Wrapper.forPrimitiveType(clazz2).isConvertibleFrom(wrapper);
            }
            return x.isAssignableFrom(clazz2, wrapper.wrapperType());
        }
        if (clazz2.isPrimitive()) {
            if (clazz2 == Void.TYPE) {
                return true;
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
            if (x.isAssignableFrom(clazz, wrapper.wrapperType())) {
                return true;
            }
            return Wrapper.isWrapperType(clazz) && wrapper.isConvertibleFrom(Wrapper.forWrapperType(clazz));
        }
        return true;
    }

    int parameterSlotCount() {
        return this.form.parameterSlotCount();
    }

    Invokers invokers() {
        Invokers invokers = this.invokers;
        if (invokers != null) {
            return invokers;
        }
        this.invokers = invokers = new Invokers(this);
        return invokers;
    }

    int parameterSlotDepth(int n2) {
        if (n2 < 0 || n2 > this.ptypes.length) {
            this.parameterType(n2);
        }
        return this.form.parameterToArgSlot(n2 - 1);
    }

    int returnSlotCount() {
        return this.form.returnSlotCount();
    }

    public static MethodType fromMethodDescriptorString(String string, ClassLoader classLoader) throws IllegalArgumentException, TypeNotPresentException {
        if (!string.startsWith("(") || string.indexOf(41) < 0 || string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("not a method descriptor: " + string);
        }
        List<Class<?>> list = BytecodeDescriptor.parseMethod(string, classLoader);
        Class<?> clazz = list.remove(list.size() - 1);
        MethodType.checkSlotCount(list.size());
        Class<?>[] classArray = MethodType.listToArray(list);
        return MethodType.makeImpl(clazz, classArray, true);
    }

    public String toMethodDescriptorString() {
        return BytecodeDescriptor.unparse(this);
    }

    static String toFieldDescriptorString(Class<?> clazz) {
        return BytecodeDescriptor.unparse(clazz);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.returnType());
        objectOutputStream.writeObject(this.parameterArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Class clazz = (Class)objectInputStream.readObject();
        Class[] classArray = (Class[])objectInputStream.readObject();
        MethodType.checkRtype(clazz);
        MethodType.checkPtypes(classArray);
        classArray = (Class[])classArray.clone();
        this.MethodType_init(clazz, classArray);
    }

    private MethodType() {
        this.rtype = null;
        this.ptypes = null;
    }

    private void MethodType_init(Class<?> clazz, Class<?>[] classArray) {
        MethodType.checkRtype(clazz);
        MethodType.checkPtypes(classArray);
        MethodHandleStatics.UNSAFE.putObject((Object)this, rtypeOffset, clazz);
        MethodHandleStatics.UNSAFE.putObject((Object)this, ptypesOffset, classArray);
    }

    private Object readResolve() {
        return MethodType.methodType(this.rtype, this.ptypes);
    }

    static {
        try {
            rtypeOffset = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodType.class.getDeclaredField("rtype"));
            ptypesOffset = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodType.class.getDeclaredField("ptypes"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private static /* synthetic */ Class _jr$ig$rtype(MethodType methodType) {
        return methodType.rtype;
    }

    private static /* synthetic */ void _jr$ip$rtype(MethodType methodType, Class clazz) {
        methodType.rtype = clazz;
    }

    private static /* synthetic */ Class[] _jr$ig$ptypes(MethodType methodType) {
        return methodType.ptypes;
    }

    private static /* synthetic */ void _jr$ip$ptypes(MethodType methodType, Class[] classArray) {
        methodType.ptypes = classArray;
    }

    private static /* synthetic */ MethodTypeForm _jr$ig$form(MethodType methodType) {
        return methodType.form;
    }

    private static /* synthetic */ void _jr$ip$form(MethodType methodType, MethodTypeForm methodTypeForm) {
        methodType.form = methodTypeForm;
    }

    private static /* synthetic */ MethodType _jr$ig$wrapAlt(MethodType methodType) {
        return methodType.wrapAlt;
    }

    private static /* synthetic */ void _jr$ip$wrapAlt(MethodType methodType, MethodType methodType2) {
        methodType.wrapAlt = methodType2;
    }

    private static /* synthetic */ Invokers _jr$ig$invokers(MethodType methodType) {
        return methodType.invokers;
    }

    private static /* synthetic */ void _jr$ip$invokers(MethodType methodType, Invokers invokers) {
        methodType.invokers = invokers;
    }

    private static class WeakInternSet
    extends h {
        private static final int DEFAULT_INITIAL_CAPACITY = 16;
        private static final int MAXIMUM_CAPACITY = 0x40000000;
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private Entry[] table;
        private int size;
        private int threshold;
        private final float loadFactor;
        private final ReferenceQueue<Object> queue;

        private Entry[] newTable(int n2) {
            return new Entry[n2];
        }

        WeakInternSet() {
            this.queue = new ReferenceQueue();
            this.loadFactor = 0.75f;
            this.threshold = 16;
            this.table = this.newTable(16);
        }

        private static int hash(int n2) {
            n2 ^= n2 >>> 20 ^ n2 >>> 12;
            return n2 ^ n2 >>> 7 ^ n2 >>> 4;
        }

        private static boolean eq(Object object, Object object2) {
            return !f.ifAcmp((Object)object, (Object)object2) || object.equals(object2);
        }

        private static int indexFor(int n2, int n3) {
            return n2 & n3 - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expungeStaleEntries() {
            Reference reference;
            while ((reference = this.queue.poll()) != null) {
                Object object = ah.getMonitor((Object)((Object)this.queue));
                synchronized (object) {
                    try {
                        Entry entry;
                        Entry entry2 = (Entry)((Object)g.convertForCast(reference, Entry.class));
                        int n2 = WeakInternSet.indexFor(((Entry)((Object)((Object)entry2))).hash, a.arrayLength((Object[])this.table));
                        Entry entry3 = entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.table, (int)n2), Entry.class));
                        while (entry3 != null) {
                            Entry entry4 = ((Entry)((Object)((Object)entry3))).next;
                            if (!f.ifAcmp((Object)((Object)entry3), (Object)((Object)entry2))) {
                                if (!f.ifAcmp((Object)((Object)entry), (Object)((Object)entry2))) {
                                    a.arrayStore((Object[])this.table, (int)n2, (Object)((Object)entry4));
                                } else {
                                    ((Entry)((Object)((Object)entry))).next = entry4;
                                }
                                ((Entry)((Object)((Object)entry2))).next = null;
                                WeakInternSet weakInternSet = this;
                                weakInternSet.size = weakInternSet.size - 1;
                                break;
                            }
                            entry = entry3;
                            entry3 = entry4;
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
        }

        private Entry[] getTable() {
            this.expungeStaleEntries();
            return this.table;
        }

        @af(modifiers=32)
        MethodType get(MethodType methodType) {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    int n2 = WeakInternSet.hash(methodType.hashCode());
                    Entry[] entryArray = this.getTable();
                    int n3 = WeakInternSet.indexFor(n2, a.arrayLength((Object[])entryArray));
                    Entry entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad((Object[])entryArray, (int)n3), Entry.class));
                    while (entry != null) {
                        MethodType methodType2;
                        if (((Entry)((Object)((Object)entry))).hash == n2 && WeakInternSet.eq(methodType, methodType2 = (MethodType)g.convertForCast(entry.get(), MethodType.class))) {
                            return methodType2;
                        }
                        entry = ((Entry)((Object)((Object)entry))).next;
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        @af(modifiers=32)
        MethodType add(MethodType methodType) {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    int n2 = WeakInternSet.hash(methodType.hashCode());
                    Entry[] entryArray = this.getTable();
                    int n3 = WeakInternSet.indexFor(n2, a.arrayLength((Object[])entryArray));
                    Entry entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad((Object[])entryArray, (int)n3), Entry.class));
                    while (entry != null) {
                        MethodType methodType2;
                        if (n2 == ((Entry)((Object)((Object)entry))).hash && WeakInternSet.eq(methodType, methodType2 = (MethodType)g.convertForCast(entry.get(), MethodType.class))) {
                            return methodType2;
                        }
                        entry = ((Entry)((Object)((Object)entry))).next;
                    }
                    entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad((Object[])entryArray, (int)n3), Entry.class));
                    a.arrayStore((Object[])entryArray, (int)n3, (Object)((Object)new Entry(methodType, this.queue, n2, entry)));
                    WeakInternSet weakInternSet = this;
                    int n4 = weakInternSet.size + 1;
                    weakInternSet.size = n4;
                    if (n4 >= this.threshold) {
                        this.resize(a.arrayLength((Object[])entryArray) * 2);
                    }
                    return methodType;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        private void resize(int n2) {
            Entry[] entryArray = this.getTable();
            int n3 = a.arrayLength((Object[])entryArray);
            if (n3 == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            Entry[] entryArray2 = this.newTable(n2);
            this.transfer(entryArray, entryArray2);
            this.table = entryArray2;
            if (this.size >= this.threshold / 2) {
                this.threshold = (int)((float)n2 * this.loadFactor);
            } else {
                this.expungeStaleEntries();
                this.transfer(entryArray2, entryArray);
                this.table = entryArray;
            }
        }

        private void transfer(Entry[] entryArray, Entry[] entryArray2) {
            for (int i = 0; i < a.arrayLength((Object[])entryArray); ++i) {
                Entry entry = (Entry)((Object)g.convertForCast((Object)a.arrayLoad((Object[])entryArray, (int)i), Entry.class));
                a.arrayStore((Object[])entryArray, (int)i, null);
                while (entry != null) {
                    Entry entry2 = ((Entry)((Object)((Object)entry))).next;
                    MethodType methodType = (MethodType)g.convertForCast(entry.get(), MethodType.class);
                    if (methodType == null) {
                        ((Entry)((Object)((Object)entry))).next = null;
                        WeakInternSet weakInternSet = this;
                        weakInternSet.size = weakInternSet.size - 1;
                    } else {
                        int n2 = WeakInternSet.indexFor(((Entry)((Object)((Object)entry))).hash, a.arrayLength((Object[])entryArray2));
                        ((Entry)((Object)((Object)entry))).next = (Entry)((Object)g.convertForCast((Object)a.arrayLoad((Object[])entryArray2, (int)n2), Entry.class));
                        a.arrayStore((Object[])entryArray2, (int)n2, (Object)((Object)entry));
                    }
                    entry = entry2;
                }
            }
        }

        private static /* synthetic */ void _jr$ip$loadFactor(WeakInternSet weakInternSet, float f2) {
            weakInternSet.loadFactor = f2;
        }

        private static /* synthetic */ void _jr$ip$queue(WeakInternSet weakInternSet, ReferenceQueue referenceQueue) {
            weakInternSet.queue = referenceQueue;
        }

        protected /* synthetic */ WeakInternSet(h h2) {
            super(h2);
        }

        private static class Entry
        extends WeakReference<MethodType> {
            final int hash;
            Entry next;

            Entry(MethodType methodType, ReferenceQueue<Object> referenceQueue, int n2, Entry entry) {
                super(methodType, referenceQueue);
                this.hash = n2;
                this.next = entry;
            }

            static /* synthetic */ void _jr$ip$hash(Object object, int n2) {
                ((Entry)((Object)object)).hash = n2;
            }

            protected /* synthetic */ Entry(h h2) {
                super(h2);
            }
        }
    }
}

