/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformComponent;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import sun.management.ManagementFactoryHelper;

public class ManagementFactory
extends h {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    private static MBeanServer platformMBeanServer;
    private static final String NOTIF_EMITTER = "javax.management.NotificationEmitter";

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactoryHelper.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementFactoryHelper.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementFactoryHelper.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactoryHelper.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementFactoryHelper.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementFactoryHelper.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactoryHelper.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementFactoryHelper.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactoryHelper.getGarbageCollectorMXBeans();
    }

    public static synchronized MBeanServer getPlatformMBeanServer() {
        Object[] objectArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            objectArray = new MBeanServerPermission("createMBeanServer");
            securityManager.checkPermission((Permission)objectArray);
        }
        if (platformMBeanServer == null) {
            platformMBeanServer = MBeanServerFactory.createMBeanServer();
            objectArray = PlatformComponent.values();
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                PlatformComponent platformComponent = (PlatformComponent)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), PlatformComponent.class);
                List list = platformComponent.getMXBeans(platformComponent.getMXBeanInterface());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PlatformManagedObject platformManagedObject = (PlatformManagedObject)g.convertForCast(iterator.next(), PlatformManagedObject.class);
                    if (platformMBeanServer.isRegistered(platformManagedObject.getObjectName())) continue;
                    ManagementFactory.addMXBean(platformMBeanServer, platformManagedObject);
                }
            }
        }
        return platformMBeanServer;
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        Class<T> clazz2 = clazz;
        ClassLoader classLoader = (ClassLoader)((Object)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), ClassLoader.class));
        if (classLoader != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string + " is not a platform MXBean"));
        }
        try {
            ObjectName objectName = new ObjectName(string);
            String string2 = x.getName(clazz2);
            if (!mBeanServerConnection.isInstanceOf(objectName, string2)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string + " is not an instance of " + clazz2));
            }
            boolean bl = mBeanServerConnection.isInstanceOf(objectName, NOTIF_EMITTER);
            return JMX.newMXBeanProxy(mBeanServerConnection, objectName, clazz, bl);
        }
        catch (InstanceNotFoundException | MalformedObjectNameException operationsException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(operationsException));
        }
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> clazz) {
        PlatformComponent platformComponent = PlatformComponent.getPlatformComponent(clazz);
        if (platformComponent == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(x.getName(clazz) + " is not a platform management interface"));
        }
        if (!platformComponent.isSingleton()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(x.getName(clazz) + " can have zero or more than one instances"));
        }
        return (T)platformComponent.getSingletonMXBean(clazz);
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> clazz) {
        PlatformComponent platformComponent = PlatformComponent.getPlatformComponent(clazz);
        if (platformComponent == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(x.getName(clazz) + " is not a platform management interface"));
        }
        return Collections.unmodifiableList(platformComponent.getMXBeans(clazz));
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        PlatformComponent platformComponent = PlatformComponent.getPlatformComponent(clazz);
        if (platformComponent == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(x.getName(clazz) + " is not a platform management interface"));
        }
        if (!platformComponent.isSingleton()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(x.getName(clazz) + " can have zero or more than one instances"));
        }
        return (T)platformComponent.getSingletonMXBean(mBeanServerConnection, clazz);
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        PlatformComponent platformComponent = PlatformComponent.getPlatformComponent(clazz);
        if (platformComponent == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(x.getName(clazz) + " is not a platform management interface"));
        }
        return Collections.unmodifiableList(platformComponent.getMXBeans(mBeanServerConnection, clazz));
    }

    public static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        HashSet<Class> hashSet = new HashSet<Class>();
        Object[] objectArray = PlatformComponent.values();
        int n2 = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n2; ++i) {
            PlatformComponent platformComponent = (PlatformComponent)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), PlatformComponent.class);
            hashSet.add(platformComponent.getMXBeanInterface());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static void addMXBean(MBeanServer mBeanServer, PlatformManagedObject platformManagedObject) {
        try {
            AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(privilegedActionException.getException()));
        }
    }

    protected /* synthetic */ ManagementFactory(h h2) {
        super(h2);
    }
}

