/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;

final class Finalizer
extends FinalReference {
    private static ReferenceQueue queue = new ReferenceQueue();
    private static Finalizer unfinalized = null;
    private static final Object lock = new Object();
    private Finalizer next = null;
    private Finalizer prev = null;

    static native void invokeFinalizeMethod(Object var0) throws Throwable;

    private boolean hasBeenFinalized() {
        return !f.ifAcmp((Object)((Object)this.next), (Object)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = ah.getMonitor((Object)lock);
        synchronized (object) {
            try {
                if (unfinalized != null) {
                    this.next = unfinalized;
                    Finalizer.unfinalized.prev = this;
                }
                unfinalized = this;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = ah.getMonitor((Object)lock);
        synchronized (object) {
            try {
                if (!f.ifAcmp((Object)((Object)unfinalized), (Object)((Object)this))) {
                    unfinalized = this.next != null ? this.next : this.prev;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                if (this.prev != null) {
                    this.prev.next = this.next;
                }
                this.next = this;
                this.prev = this;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private Finalizer(Object object) {
        super(object, queue);
        this.add();
    }

    static void register(Object object) {
        new Finalizer(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer() {
        Finalizer finalizer = this;
        synchronized (finalizer) {
            try {
                if (this.hasBeenFinalized()) {
                    // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var1_1 /* !! */ )] (shouldn't be in output)
                    return;
                }
                this.remove();
                // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var1_1 /* !! */ )] (shouldn't be in output)
            }
            catch (Throwable throwable) {
                // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var1_1 /* !! */ )] (shouldn't be in output)
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            try {
                finalizer = this.get();
                if (finalizer != null && !(finalizer instanceof Enum)) {
                    Finalizer.invokeFinalizeMethod((Object)finalizer);
                    finalizer = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            super.clear();
            return;
        }
    }

    private static void forkSecondaryFinalizer(final Runnable runnable) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                ThreadGroup tg;
                ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                while (tgn != null) {
                    tg = tgn;
                    tgn = tg.getParent();
                }
                Thread sft = new Thread(tg, runnable, "Secondary finalizer", 0L, false);
                sft.start();
                try {
                    sft.join();
                }
                catch (InterruptedException x2) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
        });
    }

    static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){
            private volatile boolean running;

            @Override
            public void run() {
                Finalizer f2;
                if (this.running) {
                    return;
                }
                JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
                this.running = true;
                while ((f2 = (Finalizer)queue.poll()) != null) {
                    f2.runFinalizer(jla);
                }
            }
        });
    }

    static void runAllFinalizers() {
        Finalizer.forkSecondaryFinalizer((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Object access$200() {
        return lock;
    }

    static /* synthetic */ Finalizer access$300() {
        return unfinalized;
    }

    static /* synthetic */ Finalizer access$302(Finalizer finalizer) {
        unfinalized = finalizer;
        return unfinalized;
    }

    static /* synthetic */ Finalizer access$400(Finalizer finalizer) {
        return finalizer.next;
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        h h2 = threadGroup;
        while (h2 != null) {
            threadGroup = h2;
            h2 = threadGroup.getParent();
        }
        h2 = new FinalizerThread(threadGroup);
        h2.setPriority(8);
        h2.setDaemon(true);
        h2.start();
    }

    private static /* synthetic */ Finalizer _jr$ig$next(Finalizer finalizer) {
        return finalizer.next;
    }

    private static /* synthetic */ void _jr$ip$next(Finalizer finalizer, Finalizer finalizer2) {
        finalizer.next = finalizer2;
    }

    private static /* synthetic */ Finalizer _jr$ig$prev(Finalizer finalizer) {
        return finalizer.prev;
    }

    private static /* synthetic */ void _jr$ip$prev(Finalizer finalizer, Finalizer finalizer2) {
        finalizer.prev = finalizer2;
    }

    private static class FinalizerThread
    extends Thread {
        private volatile boolean running;

        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }

        @Override
        public void run() {
            if (this.running) {
                return;
            }
            this.running = true;
            while (true) {
                try {
                    while (true) {
                        Finalizer finalizer = (Finalizer)queue.remove();
                        finalizer.runFinalizer();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        protected /* synthetic */ FinalizerThread(h h2) {
            super(h2);
        }
    }
}

