/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.StreamCorruptedException;
import java.math.BitSieve;
import java.math.MutableBigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import sun.misc.Unsafe;

public class BigInteger
extends Number
implements Comparable<BigInteger> {
    final int signum;
    final int[] mag;
    @Deprecated
    private int bitCount;
    @Deprecated
    private int bitLength;
    @Deprecated
    private int lowestSetBit;
    @Deprecated
    private int firstNonzeroIntNum;
    static final long LONG_MASK = 0xFFFFFFFFL;
    private static long[] bitsPerDigit;
    private static final int SMALL_PRIME_THRESHOLD = 95;
    private static final int DEFAULT_PRIME_CERTAINTY = 100;
    private static final BigInteger SMALL_PRIME_PRODUCT;
    private static volatile Random staticRandom;
    private static final int MAX_CONSTANT = 16;
    private static BigInteger[] posConst;
    private static BigInteger[] negConst;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger TWO;
    public static final BigInteger TEN;
    static int[] bnExpModThreshTable;
    private static String[] zeros;
    private static int[] digitsPerLong;
    private static BigInteger[] longRadix;
    private static int[] digitsPerInt;
    private static int[] intRadix;
    private static final long serialVersionUID = -8287574255936472291L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final Unsafe unsafe;
    private static final long signumOffset;
    private static final long magOffset;

    public BigInteger(byte[] byArray) {
        if (byArray.length == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Zero length BigInteger"));
        }
        if (byArray[0] < 0) {
            this.mag = BigInteger.makePositive(byArray);
            this.signum = -1;
        } else {
            this.mag = BigInteger.stripLeadingZeroBytes(byArray);
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    private BigInteger(int[] nArray) {
        if (nArray.length == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Zero length BigInteger"));
        }
        if (nArray[0] < 0) {
            this.mag = BigInteger.makePositive(nArray);
            this.signum = -1;
        } else {
            this.mag = BigInteger.trustedStripLeadingZeroInts(nArray);
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    public BigInteger(int n2, byte[] byArray) {
        this.mag = BigInteger.stripLeadingZeroBytes(byArray);
        if (n2 < -1 || n2 > 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Invalid signum value"));
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (n2 == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("signum-magnitude mismatch"));
            }
            this.signum = n2;
        }
    }

    private BigInteger(int n2, int[] nArray) {
        this.mag = BigInteger.stripLeadingZeroInts(nArray);
        if (n2 < -1 || n2 > 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Invalid signum value"));
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (n2 == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("signum-magnitude mismatch"));
            }
            this.signum = n2;
        }
    }

    public BigInteger(String string, int n2) {
        int n3;
        int n4 = 0;
        int n5 = string.length();
        if (n2 < 2 || n2 > 36) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Radix out of range"));
        }
        if (n5 == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Zero length BigInteger"));
        }
        int n6 = 1;
        int n7 = string.lastIndexOf(45);
        if (n7 + (n3 = string.lastIndexOf(43)) <= -1) {
            if (n7 == 0 || n3 == 0) {
                n4 = 1;
                if (n5 == 1) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Zero length BigInteger"));
                }
            }
            if (n7 == 0) {
                n6 = -1;
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Illegal embedded sign character"));
        }
        while (n4 < n5 && Character.digit(string.charAt(n4), n2) == 0) {
            ++n4;
        }
        if (n4 == n5) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int n8 = n5 - n4;
        this.signum = n6;
        int n9 = (int)(((long)n8 * bitsPerDigit[n2] >>> 10) + 1L);
        int n10 = n9 + 31 >>> 5;
        int[] nArray = new int[n10];
        int n11 = n8 % digitsPerInt[n2];
        if (n11 == 0) {
            n11 = digitsPerInt[n2];
        }
        String string2 = string.substring(n4, n4 += n11);
        nArray[n10 - 1] = Integer.parseInt(string2, n2);
        if (nArray[n10 - 1] < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Illegal digit"));
        }
        int n12 = intRadix[n2];
        int n13 = 0;
        while (n4 < n5) {
            if ((n13 = Integer.parseInt(string2 = string.substring(n4, n4 += digitsPerInt[n2]), n2)) < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Illegal digit"));
            }
            BigInteger.destructiveMulAdd(nArray, n12, n13);
        }
        this.mag = BigInteger.trustedStripLeadingZeroInts(nArray);
    }

    BigInteger(char[] cArray) {
        int n2;
        int n3 = 0;
        int n4 = cArray.length;
        int n5 = 1;
        if (cArray[0] == '-') {
            if (n4 == 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Zero length BigInteger"));
            }
            n5 = -1;
            n3 = 1;
        } else if (cArray[0] == '+') {
            if (n4 == 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException("Zero length BigInteger"));
            }
            n3 = 1;
        }
        while (n3 < n4 && Character.digit(cArray[n3], 10) == 0) {
            ++n3;
        }
        if (n3 == n4) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int n6 = n4 - n3;
        this.signum = n5;
        if (n4 < 10) {
            n2 = 1;
        } else {
            int n7 = (int)(((long)n6 * bitsPerDigit[10] >>> 10) + 1L);
            n2 = n7 + 31 >>> 5;
        }
        int[] nArray = new int[n2];
        int n8 = n6 % digitsPerInt[10];
        if (n8 == 0) {
            n8 = digitsPerInt[10];
        }
        nArray[n2 - 1] = this.parseInt(cArray, n3, n3 += n8);
        while (n3 < n4) {
            int n9 = this.parseInt(cArray, n3, n3 += digitsPerInt[10]);
            BigInteger.destructiveMulAdd(nArray, intRadix[10], n9);
        }
        this.mag = BigInteger.trustedStripLeadingZeroInts(nArray);
    }

    private int parseInt(char[] cArray, int n2, int n3) {
        int n4;
        if ((n4 = Character.digit(cArray[n2++], 10)) == -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException(new String(cArray)));
        }
        for (int i = n2; i < n3; ++i) {
            int n5 = Character.digit(cArray[i], 10);
            if (n5 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NumberFormatException(new String(cArray)));
            }
            n4 = 10 * n4 + n5;
        }
        return n4;
    }

    private static void destructiveMulAdd(int[] nArray, int n2, int n3) {
        long l = (long)n2 & 0xFFFFFFFFL;
        long l2 = (long)n3 & 0xFFFFFFFFL;
        int n4 = nArray.length;
        long l3 = 0L;
        long l4 = 0L;
        for (int i = n4 - 1; i >= 0; --i) {
            l3 = l * ((long)nArray[i] & 0xFFFFFFFFL) + l4;
            nArray[i] = (int)l3;
            l4 = l3 >>> 32;
        }
        long l5 = ((long)nArray[n4 - 1] & 0xFFFFFFFFL) + l2;
        nArray[n4 - 1] = (int)l5;
        l4 = l5 >>> 32;
        for (int i = n4 - 2; i >= 0; --i) {
            l5 = ((long)nArray[i] & 0xFFFFFFFFL) + l4;
            nArray[i] = (int)l5;
            l4 = l5 >>> 32;
        }
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(int n2, Random random) {
        this(1, BigInteger.randomBits(n2, random));
    }

    private static byte[] randomBits(int n2, Random random) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("numBits must be non-negative"));
        }
        int n3 = (int)(((long)n2 + 7L) / 8L);
        byte[] byArray = new byte[n3];
        if (n3 > 0) {
            random.nextBytes(byArray);
            int n4 = 8 * n3 - n2;
            byArray[0] = (byte)(byArray[0] & (1 << 8 - n4) - 1);
        }
        return byArray;
    }

    public BigInteger(int n2, int n3, Random random) {
        if (n2 < 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("bitLength < 2"));
        }
        BigInteger bigInteger = n2 < 95 ? BigInteger.smallPrime(n2, n3, random) : BigInteger.largePrime(n2, n3, random);
        this.signum = 1;
        this.mag = bigInteger.mag;
    }

    public static BigInteger probablePrime(int n2, Random random) {
        if (n2 < 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("bitLength < 2"));
        }
        return n2 < 95 ? BigInteger.smallPrime(n2, 100, random) : BigInteger.largePrime(n2, 100, random);
    }

    /*
     * Unable to fully structure code
     */
    private static BigInteger smallPrime(int var0, int var1_1, Random var2_2) {
        var3_3 = var0 + 31 >>> 5;
        var4_4 = new int[var3_3];
        var5_5 = 1 << (var0 + 31 & 31);
        var6_6 = (var5_5 << 1) - 1;
        while (true) {
            for (var7_8 = 0; var7_8 < var3_3; ++var7_8) {
                var4_4[var7_8] = var2_2.nextInt();
            }
            var4_4[0] = var4_4[0] & var6_6 | var5_5;
            if (var0 > 2) {
                v0 = var3_3 - 1;
                var4_4[v0] = var4_4[v0] | 1;
            }
            var7_7 = new BigInteger(var4_4, 1);
            if (var0 > 6 && ((var8_9 = var7_7.remainder(BigInteger.SMALL_PRIME_PRODUCT).longValue()) % 3L == 0L || var8_9 % 5L == 0L || var8_9 % 7L == 0L || var8_9 % 11L == 0L || var8_9 % 13L == 0L || var8_9 % 17L == 0L || var8_9 % 19L == 0L || var8_9 % 23L == 0L || var8_9 % 29L == 0L || var8_9 % 31L == 0L || var8_9 % 37L == 0L || var8_9 % 41L == 0L)) ** continue;
            if (var0 < 4) {
                return var7_7;
            }
            if (var7_7.primeToCertainty(var1_1, var2_2)) break;
        }
        return var7_7;
    }

    private static BigInteger largePrime(int n2, int n3, Random random) {
        BigInteger bigInteger = new BigInteger(n2, random).setBit(n2 - 1);
        int[] nArray = ((BigInteger)bigInteger).mag;
        int n4 = ((BigInteger)bigInteger).mag.length - 1;
        nArray[n4] = nArray[n4] & 0xFFFFFFFE;
        int n5 = n2 / 20 * 64;
        BitSieve bitSieve = new BitSieve(bigInteger, n5);
        BigInteger bigInteger2 = bitSieve.retrieve(bigInteger, n3, random);
        while (bigInteger2 == null || bigInteger2.bitLength() != n2) {
            if ((bigInteger = bigInteger.add(BigInteger.valueOf(2 * n5))).bitLength() != n2) {
                bigInteger = new BigInteger(n2, random).setBit(n2 - 1);
            }
            int[] nArray2 = ((BigInteger)bigInteger).mag;
            int n6 = ((BigInteger)bigInteger).mag.length - 1;
            nArray2[n6] = nArray2[n6] & 0xFFFFFFFE;
            bitSieve = new BitSieve(bigInteger, n5);
            bigInteger2 = bitSieve.retrieve(bigInteger, n3, random);
        }
        return bigInteger2;
    }

    public BigInteger nextProbablePrime() {
        if (((BigInteger)this).signum < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("start < 0: " + this));
        }
        if (((BigInteger)this).signum == 0 || this.equals(ONE)) {
            return TWO;
        }
        BigInteger bigInteger = this.add(ONE);
        if (bigInteger.bitLength() < 95) {
            if (!bigInteger.testBit(0)) {
                bigInteger = bigInteger.add(ONE);
            }
            while (true) {
                long l;
                if (bigInteger.bitLength() > 6 && ((l = bigInteger.remainder(SMALL_PRIME_PRODUCT).longValue()) % 3L == 0L || l % 5L == 0L || l % 7L == 0L || l % 11L == 0L || l % 13L == 0L || l % 17L == 0L || l % 19L == 0L || l % 23L == 0L || l % 29L == 0L || l % 31L == 0L || l % 37L == 0L || l % 41L == 0L)) {
                    bigInteger = bigInteger.add(TWO);
                    continue;
                }
                if (bigInteger.bitLength() < 4) {
                    return bigInteger;
                }
                if (bigInteger.primeToCertainty(100, null)) {
                    return bigInteger;
                }
                bigInteger = bigInteger.add(TWO);
            }
        }
        if (bigInteger.testBit(0)) {
            bigInteger = bigInteger.subtract(ONE);
        }
        int n2 = bigInteger.bitLength() / 20 * 64;
        BitSieve bitSieve;
        BigInteger bigInteger2;
        while ((bigInteger2 = (bitSieve = new BitSieve(bigInteger, n2)).retrieve(bigInteger, 100, null)) == null) {
            bigInteger = bigInteger.add(BigInteger.valueOf(2 * n2));
        }
        return bigInteger2;
    }

    boolean primeToCertainty(int n2, Random random) {
        int n3 = 0;
        int n4 = (Math.min(n2, 0x7FFFFFFE) + 1) / 2;
        int n5 = this.bitLength();
        if (n5 < 100) {
            n3 = 50;
            n3 = n4 < n3 ? n4 : n3;
            return this.passesMillerRabin(n3, random);
        }
        n3 = n5 < 256 ? 27 : (n5 < 512 ? 15 : (n5 < 768 ? 8 : (n5 < 1024 ? 4 : 2)));
        n3 = n4 < n3 ? n4 : n3;
        return this.passesMillerRabin(n3, random) && this.passesLucasLehmer();
    }

    private boolean passesLucasLehmer() {
        BigInteger bigInteger = this.add(ONE);
        int n2 = 5;
        while (BigInteger.jacobiSymbol(n2, this) != -1) {
            n2 = n2 < 0 ? Math.abs(n2) + 2 : -(n2 + 2);
        }
        BigInteger bigInteger2 = BigInteger.lucasLehmerSequence(n2, bigInteger, this);
        return bigInteger2.mod(this).equals(ZERO);
    }

    private static int jacobiSymbol(int n2, BigInteger bigInteger) {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = 1;
        int n5 = ((BigInteger)bigInteger).mag[((BigInteger)bigInteger).mag.length - 1];
        if (n2 < 0) {
            n2 = -n2;
            n3 = n5 & 7;
            if (n3 == 3 || n3 == 7) {
                n4 = -n4;
            }
        }
        while ((n2 & 3) == 0) {
            n2 >>= 2;
        }
        if ((n2 & 1) == 0) {
            n2 >>= 1;
            if (((n5 ^ n5 >> 1) & 2) != 0) {
                n4 = -n4;
            }
        }
        if (n2 == 1) {
            return n4;
        }
        if ((n2 & n5 & 2) != 0) {
            n4 = -n4;
        }
        for (n5 = bigInteger.mod(BigInteger.valueOf(n2)).intValue(); n5 != 0; n5 %= n2) {
            while ((n5 & 3) == 0) {
                n5 >>= 2;
            }
            if ((n5 & 1) == 0) {
                n5 >>= 1;
                if (((n2 ^ n2 >> 1) & 2) != 0) {
                    n4 = -n4;
                }
            }
            if (n5 == 1) {
                return n4;
            }
            if (!$assertionsDisabled && n5 >= n2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            n5 = n2;
            n3 = n5;
            if ((n5 & (n2 = n3) & 2) == 0) continue;
            n4 = -n4;
        }
        return 0;
    }

    private static BigInteger lucasLehmerSequence(int n2, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = BigInteger.valueOf(n2);
        BigInteger bigInteger4 = ONE;
        BigInteger bigInteger5 = ONE;
        for (int i = bigInteger.bitLength() - 2; i >= 0; --i) {
            BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5).mod(bigInteger2);
            BigInteger bigInteger7 = bigInteger5.square().add(bigInteger3.multiply(bigInteger4.square())).mod(bigInteger2);
            if (bigInteger7.testBit(0)) {
                bigInteger7 = bigInteger7.subtract(bigInteger2);
            }
            bigInteger7 = bigInteger7.shiftRight(1);
            bigInteger4 = bigInteger6;
            bigInteger5 = bigInteger7;
            if (!bigInteger.testBit(i)) continue;
            bigInteger6 = bigInteger4.add(bigInteger5).mod(bigInteger2);
            if (bigInteger6.testBit(0)) {
                bigInteger6 = bigInteger6.subtract(bigInteger2);
            }
            bigInteger6 = bigInteger6.shiftRight(1);
            bigInteger7 = bigInteger5.add(bigInteger3.multiply(bigInteger4)).mod(bigInteger2);
            if (bigInteger7.testBit(0)) {
                bigInteger7 = bigInteger7.subtract(bigInteger2);
            }
            bigInteger7 = bigInteger7.shiftRight(1);
            bigInteger4 = bigInteger6;
            bigInteger5 = bigInteger7;
        }
        return bigInteger4;
    }

    private static Random getSecureRandom() {
        if (staticRandom == null) {
            staticRandom = new SecureRandom();
        }
        return staticRandom;
    }

    private boolean passesMillerRabin(int n2, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger = this.subtract(ONE);
        int n3 = bigInteger2.getLowestSetBit();
        bigInteger2 = bigInteger2.shiftRight(n3);
        if (random == null) {
            random = BigInteger.getSecureRandom();
        }
        for (int i = 0; i < n2; ++i) {
            BigInteger bigInteger3;
            while ((bigInteger3 = new BigInteger(this.bitLength(), random)).compareTo(ONE) <= 0 || bigInteger3.compareTo(this) >= 0) {
            }
            int n4 = 0;
            BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, this);
            while (!(n4 == 0 && bigInteger4.equals(ONE) || bigInteger4.equals(bigInteger))) {
                if (n4 > 0 && bigInteger4.equals(ONE) || ++n4 == n3) {
                    return false;
                }
                bigInteger4 = bigInteger4.modPow(TWO, this);
            }
        }
        return true;
    }

    BigInteger(int[] nArray, int n2) {
        this.signum = nArray.length == 0 ? 0 : n2;
        this.mag = nArray;
    }

    private BigInteger(byte[] byArray, int n2) {
        this.signum = byArray.length == 0 ? 0 : n2;
        this.mag = BigInteger.stripLeadingZeroBytes(byArray);
    }

    public static BigInteger valueOf(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l > 0L && l <= 16L) {
            return (BigInteger)g.convertForCast((Object)a.arrayLoad((Object[])posConst, (int)((int)l)), BigInteger.class);
        }
        if (l < 0L && l >= -16L) {
            return (BigInteger)g.convertForCast((Object)a.arrayLoad((Object[])negConst, (int)((int)(-l))), BigInteger.class);
        }
        return new BigInteger(l);
    }

    private BigInteger(long l) {
        if (l < 0L) {
            l = -l;
            this.signum = -1;
        } else {
            this.signum = 1;
        }
        int n2 = (int)(l >>> 32);
        if (n2 == 0) {
            this.mag = new int[1];
            this.mag[0] = (int)l;
        } else {
            this.mag = new int[2];
            this.mag[0] = n2;
            this.mag[1] = (int)l;
        }
    }

    private static BigInteger valueOf(int[] nArray) {
        return nArray[0] > 0 ? new BigInteger(nArray, 1) : new BigInteger(nArray);
    }

    public BigInteger add(BigInteger bigInteger) {
        if (((BigInteger)bigInteger).signum == 0) {
            return this;
        }
        if (((BigInteger)this).signum == 0) {
            return bigInteger;
        }
        if (((BigInteger)bigInteger).signum == ((BigInteger)this).signum) {
            return new BigInteger(BigInteger.add(((BigInteger)this).mag, ((BigInteger)bigInteger).mag), ((BigInteger)this).signum);
        }
        int n2 = this.compareMagnitude(bigInteger);
        if (n2 == 0) {
            return ZERO;
        }
        int[] nArray = n2 > 0 ? BigInteger.subtract(((BigInteger)this).mag, ((BigInteger)bigInteger).mag) : BigInteger.subtract(((BigInteger)bigInteger).mag, ((BigInteger)this).mag);
        nArray = BigInteger.trustedStripLeadingZeroInts(nArray);
        return new BigInteger(nArray, n2 == ((BigInteger)this).signum ? 1 : -1);
    }

    private static int[] add(int[] nArray, int[] nArray2) {
        boolean bl;
        if (nArray.length < nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int[] nArray4 = new int[n2];
        long l = 0L;
        while (n3 > 0) {
            l = ((long)nArray[--n2] & 0xFFFFFFFFL) + ((long)nArray2[--n3] & 0xFFFFFFFFL) + (l >>> 32);
            nArray4[n2] = (int)l;
        }
        boolean bl2 = bl = l >>> 32 != 0L;
        while (n2 > 0 && bl) {
            nArray4[--n2] = nArray[n2] + 1;
            bl = nArray4[--n2] == 0;
        }
        while (n2 > 0) {
            nArray4[--n2] = nArray[n2];
        }
        if (bl) {
            int[] nArray5 = new int[nArray4.length + 1];
            a.arraycopy((Object)nArray4, (int)0, (Object)nArray5, (int)1, (int)nArray4.length);
            nArray5[0] = 1;
            return nArray5;
        }
        return nArray4;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        if (((BigInteger)bigInteger).signum == 0) {
            return this;
        }
        if (((BigInteger)this).signum == 0) {
            return bigInteger.negate();
        }
        if (((BigInteger)bigInteger).signum != ((BigInteger)this).signum) {
            return new BigInteger(BigInteger.add(((BigInteger)this).mag, ((BigInteger)bigInteger).mag), ((BigInteger)this).signum);
        }
        int n2 = this.compareMagnitude(bigInteger);
        if (n2 == 0) {
            return ZERO;
        }
        int[] nArray = n2 > 0 ? BigInteger.subtract(((BigInteger)this).mag, ((BigInteger)bigInteger).mag) : BigInteger.subtract(((BigInteger)bigInteger).mag, ((BigInteger)this).mag);
        nArray = BigInteger.trustedStripLeadingZeroInts(nArray);
        return new BigInteger(nArray, n2 == ((BigInteger)this).signum ? 1 : -1);
    }

    private static int[] subtract(int[] nArray, int[] nArray2) {
        boolean bl;
        int n2 = nArray.length;
        int[] nArray3 = new int[n2];
        int n3 = nArray2.length;
        long l = 0L;
        while (n3 > 0) {
            l = ((long)nArray[--n2] & 0xFFFFFFFFL) - ((long)nArray2[--n3] & 0xFFFFFFFFL) + (l >> 32);
            nArray3[n2] = (int)l;
        }
        boolean bl2 = bl = l >> 32 != 0L;
        while (n2 > 0 && bl) {
            nArray3[--n2] = nArray[n2] - 1;
            bl = nArray3[--n2] == -1;
        }
        while (n2 > 0) {
            nArray3[--n2] = nArray[n2];
        }
        return nArray3;
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (((BigInteger)bigInteger).signum == 0 || ((BigInteger)this).signum == 0) {
            return ZERO;
        }
        int[] nArray = this.multiplyToLen(((BigInteger)this).mag, ((BigInteger)this).mag.length, ((BigInteger)bigInteger).mag, ((BigInteger)bigInteger).mag.length, null);
        nArray = BigInteger.trustedStripLeadingZeroInts(nArray);
        return new BigInteger(nArray, ((BigInteger)this).signum == ((BigInteger)bigInteger).signum ? 1 : -1);
    }

    BigInteger multiply(long l) {
        long l2;
        int n2;
        int n3;
        if (l == 0L || ((BigInteger)this).signum == 0) {
            return ZERO;
        }
        if (l == Long.MIN_VALUE) {
            return this.multiply(BigInteger.valueOf(l));
        }
        int n4 = n3 = l > 0L ? ((BigInteger)this).signum : -((BigInteger)this).signum;
        if (l < 0L) {
            l = -l;
        }
        long l3 = l >>> 32;
        long l4 = l & 0xFFFFFFFFL;
        int n5 = ((BigInteger)this).mag.length;
        int[] nArray = ((BigInteger)this).mag;
        int[] nArray2 = l3 == 0L ? new int[n5 + 1] : new int[n5 + 2];
        long l5 = 0L;
        int n6 = nArray2.length - 1;
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            l2 = ((long)nArray[n2] & 0xFFFFFFFFL) * l4 + l5;
            nArray2[n6--] = (int)l2;
            l5 = l2 >>> 32;
        }
        nArray2[n6] = (int)l5;
        if (l3 != 0L) {
            l5 = 0L;
            n6 = nArray2.length - 2;
            for (n2 = n5 - 1; n2 >= 0; --n2) {
                l2 = ((long)nArray[n2] & 0xFFFFFFFFL) * l3 + ((long)nArray2[n6] & 0xFFFFFFFFL) + l5;
                nArray2[n6--] = (int)l2;
                l5 = l2 >>> 32;
            }
            nArray2[0] = (int)l5;
        }
        if (l5 == 0L) {
            nArray2 = Arrays.copyOfRange(nArray2, 1, nArray2.length);
        }
        return new BigInteger(nArray2, n3);
    }

    private int[] multiplyToLen(int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3) {
        int n4 = n2 - 1;
        int n5 = n3 - 1;
        if (nArray3 == null || nArray3.length < n2 + n3) {
            nArray3 = new int[n2 + n3];
        }
        long l = 0L;
        int n6 = n5;
        int n7 = n5 + 1 + n4;
        while (n6 >= 0) {
            long l2 = ((long)nArray2[n6] & 0xFFFFFFFFL) * ((long)nArray[n4] & 0xFFFFFFFFL) + l;
            nArray3[n7] = (int)l2;
            l = l2 >>> 32;
            --n6;
            --n7;
        }
        nArray3[n4] = (int)l;
        for (n6 = n4 - 1; n6 >= 0; --n6) {
            l = 0L;
            n7 = n5;
            int n8 = n5 + 1 + n6;
            while (n7 >= 0) {
                long l3 = ((long)nArray2[n7] & 0xFFFFFFFFL) * ((long)nArray[n6] & 0xFFFFFFFFL) + ((long)nArray3[n8] & 0xFFFFFFFFL) + l;
                nArray3[n8] = (int)l3;
                l = l3 >>> 32;
                --n7;
                --n8;
            }
            nArray3[n6] = (int)l;
        }
        return nArray3;
    }

    private BigInteger square() {
        if (((BigInteger)this).signum == 0) {
            return ZERO;
        }
        int[] nArray = BigInteger.squareToLen(((BigInteger)this).mag, ((BigInteger)this).mag.length, null);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(nArray), 1);
    }

    private static final int[] squareToLen(int[] nArray, int n2, int[] nArray2) {
        int n3;
        int n4 = n2 << 1;
        if (nArray2 == null || nArray2.length < n4) {
            nArray2 = new int[n4];
        }
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            long l = (long)nArray[n3] & 0xFFFFFFFFL;
            long l2 = l * l;
            nArray2[n6++] = n5 << 31 | (int)(l2 >>> 33);
            nArray2[n6++] = (int)(l2 >>> 1);
            n5 = (int)l2;
        }
        n3 = n2;
        n6 = 1;
        while (n3 > 0) {
            int n7 = nArray[n3 - 1];
            n7 = BigInteger.mulAdd(nArray2, nArray, n6, n3 - 1, n7);
            BigInteger.addOne(nArray2, n6 - 1, n3, n7);
            --n3;
            n6 += 2;
        }
        BigInteger.primitiveLeftShift(nArray2, n4, 1);
        int n8 = n4 - 1;
        nArray2[n8] = nArray2[n8] | nArray[n2 - 1] & 1;
        return nArray2;
    }

    public BigInteger divide(BigInteger bigInteger) {
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(((BigInteger)this).mag);
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(((BigInteger)bigInteger).mag);
        mutableBigInteger2.divide(mutableBigInteger3, mutableBigInteger);
        return mutableBigInteger.toBigInteger(((BigInteger)this).signum == ((BigInteger)bigInteger).signum ? 1 : -1);
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        Object[] objectArray = new BigInteger[2];
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(((BigInteger)this).mag);
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(((BigInteger)bigInteger).mag);
        MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divide(mutableBigInteger3, mutableBigInteger);
        a.arrayStore((Object[])objectArray, (int)0, (Object)mutableBigInteger.toBigInteger(((BigInteger)this).signum == ((BigInteger)bigInteger).signum ? 1 : -1));
        a.arrayStore((Object[])objectArray, (int)1, (Object)mutableBigInteger4.toBigInteger(((BigInteger)this).signum));
        return objectArray;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(((BigInteger)this).mag);
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(((BigInteger)bigInteger).mag);
        return mutableBigInteger2.divide(mutableBigInteger3, mutableBigInteger).toBigInteger(((BigInteger)this).signum);
    }

    public BigInteger pow(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("Negative exponent"));
        }
        if (((BigInteger)this).signum == 0) {
            return n2 == 0 ? ONE : this;
        }
        int n3 = ((BigInteger)this).signum < 0 && (n2 & 1) == 1 ? -1 : 1;
        int[] nArray = ((BigInteger)this).mag;
        int[] nArray2 = new int[]{1};
        while (n2 != 0) {
            if ((n2 & 1) == 1) {
                nArray2 = this.multiplyToLen(nArray2, nArray2.length, nArray, nArray.length, null);
                nArray2 = BigInteger.trustedStripLeadingZeroInts(nArray2);
            }
            if ((n2 >>>= 1) == 0) continue;
            nArray = BigInteger.squareToLen(nArray, nArray.length, null);
            nArray = BigInteger.trustedStripLeadingZeroInts(nArray);
        }
        return new BigInteger(nArray2, n3);
    }

    public BigInteger gcd(BigInteger bigInteger) {
        if (((BigInteger)bigInteger).signum == 0) {
            return this.abs();
        }
        if (((BigInteger)this).signum == 0) {
            return bigInteger.abs();
        }
        MutableBigInteger mutableBigInteger = new MutableBigInteger(this);
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(bigInteger);
        MutableBigInteger mutableBigInteger3 = mutableBigInteger.hybridGCD(mutableBigInteger2);
        return mutableBigInteger3.toBigInteger(1);
    }

    static int bitLengthForInt(int n2) {
        return 32 - Integer.numberOfLeadingZeros(n2);
    }

    private static int[] leftShift(int[] nArray, int n2, int n3) {
        int n4 = n3 >>> 5;
        int n5 = n3 & 0x1F;
        int n6 = BigInteger.bitLengthForInt(nArray[0]);
        if (n3 <= 32 - n6) {
            BigInteger.primitiveLeftShift(nArray, n2, n5);
            return nArray;
        }
        if (n5 <= 32 - n6) {
            int[] nArray2 = new int[n4 + n2];
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            BigInteger.primitiveLeftShift(nArray2, nArray2.length, n5);
            return nArray2;
        }
        int[] nArray3 = new int[n4 + n2 + 1];
        for (int i = 0; i < n2; ++i) {
            nArray3[i] = nArray[i];
        }
        BigInteger.primitiveRightShift(nArray3, nArray3.length, 32 - n5);
        return nArray3;
    }

    static void primitiveRightShift(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = 32 - n3;
        int n6 = nArray[n4];
        for (n4 = n2 - 1; n4 > 0; --n4) {
            int n7 = n6;
            n6 = nArray[n4 - 1];
            nArray[n4] = n6 << n5 | n7 >>> n3;
        }
        nArray[0] = nArray[0] >>> n3;
    }

    static void primitiveLeftShift(int[] nArray, int n2, int n3) {
        int n4;
        if (n2 == 0 || n3 == 0) {
            return;
        }
        int n5 = 32 - n3;
        int n6 = nArray[n4];
        int n7 = n4 + n2 - 1;
        for (n4 = 0; n4 < n7; ++n4) {
            int n8 = n6;
            n6 = nArray[n4 + 1];
            nArray[n4] = n8 << n3 | n6 >>> n5;
        }
        int n9 = n2 - 1;
        nArray[n9] = nArray[n9] << n3;
    }

    private static int bitLength(int[] nArray, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return (n2 - 1 << 5) + BigInteger.bitLengthForInt(nArray[0]);
    }

    public BigInteger abs() {
        return ((BigInteger)this).signum >= 0 ? this : this.negate();
    }

    public BigInteger negate() {
        return new BigInteger(((BigInteger)this).mag, -((BigInteger)this).signum);
    }

    public int signum() {
        return ((BigInteger)this).signum;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (((BigInteger)bigInteger).signum <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("BigInteger: modulus not positive"));
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        return ((BigInteger)bigInteger2).signum >= 0 ? bigInteger2 : bigInteger2.add(bigInteger);
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        if (((BigInteger)bigInteger2).signum <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("BigInteger: modulus not positive"));
        }
        if (((BigInteger)bigInteger).signum == 0) {
            return bigInteger2.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ONE)) {
            return bigInteger2.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ZERO) && ((BigInteger)bigInteger).signum >= 0) {
            return ZERO;
        }
        if (this.equals((BigInteger)g.convertForCast((Object)a.arrayLoad((Object[])negConst, (int)1), BigInteger.class)) && !bigInteger.testBit(0)) {
            return bigInteger2.equals(ONE) ? ZERO : ONE;
        }
        boolean bl = ((BigInteger)bigInteger).signum < 0;
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        BigInteger bigInteger5 = bigInteger4 = ((BigInteger)this).signum < 0 || this.compareTo(bigInteger2) >= 0 ? this.mod(bigInteger2) : this;
        if (bigInteger2.testBit(0)) {
            bigInteger3 = bigInteger4.oddModPow(bigInteger, bigInteger2);
        } else {
            int n2 = bigInteger2.getLowestSetBit();
            BigInteger bigInteger6 = bigInteger2.shiftRight(n2);
            BigInteger bigInteger7 = ONE.shiftLeft(n2);
            BigInteger bigInteger8 = ((BigInteger)this).signum < 0 || this.compareTo(bigInteger6) >= 0 ? this.mod(bigInteger6) : this;
            BigInteger bigInteger9 = bigInteger6.equals(ONE) ? ZERO : bigInteger8.oddModPow(bigInteger, bigInteger6);
            BigInteger bigInteger10 = bigInteger4.modPow2(bigInteger, n2);
            BigInteger bigInteger11 = bigInteger7.modInverse(bigInteger6);
            BigInteger bigInteger12 = bigInteger6.modInverse(bigInteger7);
            bigInteger3 = bigInteger9.multiply(bigInteger7).multiply(bigInteger11).add(bigInteger10.multiply(bigInteger6).multiply(bigInteger12)).mod(bigInteger2);
        }
        return bl ? bigInteger3.modInverse(bigInteger2) : bigInteger3;
    }

    private BigInteger oddModPow(BigInteger bigInteger, BigInteger bigInteger2) {
        int n2;
        int n3;
        int n4;
        int[] nArray;
        int n5;
        if (bigInteger.equals(ONE)) {
            return this;
        }
        if (((BigInteger)this).signum == 0) {
            return ZERO;
        }
        int[] nArray2 = (int[])((BigInteger)this).mag.clone();
        int[] nArray3 = ((BigInteger)bigInteger).mag;
        int[] nArray4 = ((BigInteger)bigInteger2).mag;
        int n6 = nArray4.length;
        int n7 = 0;
        int n8 = BigInteger.bitLength(nArray3, nArray3.length);
        if (n8 != 17 || nArray3[0] != 65537) {
            while (n8 > bnExpModThreshTable[n7]) {
                ++n7;
            }
        }
        int n9 = 1 << n7;
        int[][] nArrayArray = new int[n9][];
        for (n5 = 0; n5 < n9; ++n5) {
            nArrayArray[n5] = new int[n6];
        }
        n5 = -MutableBigInteger.inverseMod32(nArray4[n6 - 1]);
        int[] nArray5 = BigInteger.leftShift(nArray2, nArray2.length, n6 << 5);
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(nArray5);
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(nArray4);
        MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divide(mutableBigInteger3, mutableBigInteger);
        nArrayArray[0] = mutableBigInteger4.toIntArray();
        if (nArrayArray[0].length < n6) {
            int n10 = n6 - nArrayArray[0].length;
            nArray = new int[n6];
            for (n4 = 0; n4 < nArrayArray[0].length; ++n4) {
                nArray[n4 + n10] = nArrayArray[0][n4];
            }
            nArrayArray[0] = nArray;
        }
        int[] nArray6 = BigInteger.squareToLen(nArrayArray[0], n6, null);
        nArray6 = BigInteger.montReduce(nArray6, nArray4, n6, n5);
        nArray = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray[n4] = nArray6[n4];
        }
        for (n4 = 1; n4 < n9; ++n4) {
            int[] nArray7 = this.multiplyToLen(nArray, n6, nArrayArray[n4 - 1], n6, null);
            nArrayArray[n4] = BigInteger.montReduce(nArray7, nArray4, n6, n5);
        }
        n4 = 1 << (n8 - 1 & 0x1F);
        int n11 = 0;
        int n12 = nArray3.length;
        int n13 = 0;
        for (n3 = 0; n3 <= n7; ++n3) {
            n11 = n11 << 1 | ((nArray3[n13] & n4) != 0 ? 1 : 0);
            if ((n4 >>>= 1) != 0) continue;
            ++n13;
            n4 = Integer.MIN_VALUE;
            --n12;
        }
        n3 = n8--;
        boolean bl = true;
        n3 = n8 - n7;
        while ((n11 & 1) == 0) {
            n11 >>>= 1;
            ++n3;
        }
        int[] nArray8 = nArrayArray[n11 >>> 1];
        n11 = 0;
        if (n3 == n8) {
            bl = false;
        }
        while (true) {
            --n8;
            n11 <<= 1;
            if (n12 != 0) {
                n11 |= (nArray3[n13] & n4) != 0 ? 1 : 0;
                if ((n4 >>>= 1) == 0) {
                    ++n13;
                    n4 = Integer.MIN_VALUE;
                    --n12;
                }
            }
            if ((n11 & n9) != 0) {
                n3 = n8 - n7;
                while ((n11 & 1) == 0) {
                    n11 >>>= 1;
                    ++n3;
                }
                nArray8 = nArrayArray[n11 >>> 1];
                n11 = 0;
            }
            if (n8 == n3) {
                if (bl) {
                    nArray6 = (int[])nArray8.clone();
                    bl = false;
                } else {
                    nArray = nArray6;
                    nArray5 = this.multiplyToLen(nArray, n6, nArray8, n6, nArray5);
                    nArray5 = BigInteger.montReduce(nArray5, nArray4, n6, n5);
                    nArray = nArray5;
                    nArray5 = nArray6;
                    nArray6 = nArray;
                }
            }
            if (n8 == 0) break;
            if (bl) continue;
            nArray = nArray6;
            nArray5 = BigInteger.squareToLen(nArray, n6, nArray5);
            nArray5 = BigInteger.montReduce(nArray5, nArray4, n6, n5);
            nArray = nArray5;
            nArray5 = nArray6;
            nArray6 = nArray;
        }
        int[] nArray9 = new int[2 * n6];
        for (n2 = 0; n2 < n6; ++n2) {
            nArray9[n2 + n6] = nArray6[n2];
        }
        nArray6 = BigInteger.montReduce(nArray9, nArray4, n6, n5);
        nArray9 = new int[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            nArray9[n2] = nArray6[n2];
        }
        return new BigInteger(1, nArray9);
    }

    private static int[] montReduce(int[] nArray, int[] nArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        int n6 = 0;
        do {
            int n7 = nArray[nArray.length - 1 - n6];
            int n8 = BigInteger.mulAdd(nArray, nArray2, n6, n2, n3 * n7);
            n4 += BigInteger.addOne(nArray, n6, n2, n8);
            ++n6;
        } while (--n5 > 0);
        while (n4 > 0) {
            n4 += BigInteger.subN(nArray, nArray2, n2);
        }
        while (BigInteger.intArrayCmpToLen(nArray, nArray2, n2) >= 0) {
            BigInteger.subN(nArray, nArray2, n2);
        }
        return nArray;
    }

    private static int intArrayCmpToLen(int[] nArray, int[] nArray2, int n2) {
        for (int i = 0; i < n2; ++i) {
            long l = (long)nArray[i] & 0xFFFFFFFFL;
            long l2 = (long)nArray2[i] & 0xFFFFFFFFL;
            if (l < l2) {
                return -1;
            }
            if (l <= l2) continue;
            return 1;
        }
        return 0;
    }

    private static int subN(int[] nArray, int[] nArray2, int n2) {
        long l = 0L;
        while (--n2 >= 0) {
            l = ((long)nArray[n2] & 0xFFFFFFFFL) - ((long)nArray2[n2] & 0xFFFFFFFFL) + (l >> 32);
            nArray[n2] = (int)l;
        }
        return (int)(l >> 32);
    }

    static int mulAdd(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        long l = (long)n4 & 0xFFFFFFFFL;
        long l2 = 0L;
        n2 = nArray.length - n2 - 1;
        for (int i = n3 - 1; i >= 0; --i) {
            long l3 = ((long)nArray2[i] & 0xFFFFFFFFL) * l + ((long)nArray[n2] & 0xFFFFFFFFL) + l2;
            nArray[n2--] = (int)l3;
            l2 = l3 >>> 32;
        }
        return (int)l2;
    }

    static int addOne(int[] nArray, int n2, int n3, int n4) {
        n2 = nArray.length - 1 - n3 - n2;
        long l = ((long)nArray[n2] & 0xFFFFFFFFL) + ((long)n4 & 0xFFFFFFFFL);
        nArray[n2] = (int)l;
        if (l >>> 32 == 0L) {
            return 0;
        }
        while (--n3 >= 0) {
            if (--n2 < 0) {
                return 1;
            }
            int n5 = n2;
            nArray[n5] = nArray[n5] + 1;
            if (nArray[n2] == 0) continue;
            return 0;
        }
        return 1;
    }

    private BigInteger modPow2(BigInteger bigInteger, int n2) {
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        BigInteger bigInteger3 = this.mod2(n2);
        int n3 = 0;
        int n4 = bigInteger.bitLength();
        if (this.testBit(0)) {
            int n5 = n4 = n2 - 1 < n4 ? n2 - 1 : n4;
        }
        while (n3 < n4) {
            if (bigInteger.testBit(n3)) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod2(n2);
            }
            if (++n3 >= n4) continue;
            bigInteger3 = bigInteger3.square().mod2(n2);
        }
        return bigInteger2;
    }

    private BigInteger mod2(int n2) {
        int n3;
        if (this.bitLength() <= n2) {
            return this;
        }
        int n4 = n2 + 31 >>> 5;
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = ((BigInteger)this).mag[n3 + (((BigInteger)this).mag.length - n4)];
        }
        n3 = (n4 << 5) - n2;
        nArray[0] = (int)((long)nArray[0] & (1L << 32 - n3) - 1L);
        return nArray[0] == 0 ? new BigInteger(1, nArray) : new BigInteger(nArray, 1);
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        if (((BigInteger)bigInteger).signum != 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("BigInteger: modulus not positive"));
        }
        if (bigInteger.equals(ONE)) {
            return ZERO;
        }
        BigInteger bigInteger2 = this;
        if (((BigInteger)this).signum < 0 || this.compareMagnitude(bigInteger) >= 0) {
            bigInteger2 = this.mod(bigInteger);
        }
        if (bigInteger2.equals(ONE)) {
            return ONE;
        }
        MutableBigInteger mutableBigInteger = new MutableBigInteger(bigInteger2);
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(bigInteger);
        MutableBigInteger mutableBigInteger3 = mutableBigInteger.mutableModInverse(mutableBigInteger2);
        return mutableBigInteger3.toBigInteger(1);
    }

    public BigInteger shiftLeft(int n2) {
        if (((BigInteger)this).signum == 0) {
            return ZERO;
        }
        if (n2 == 0) {
            return this;
        }
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("Shift distance of Integer.MIN_VALUE not supported."));
            }
            return this.shiftRight(-n2);
        }
        int n3 = n2 >>> 5;
        int n4 = n2 & 0x1F;
        int n5 = ((BigInteger)this).mag.length;
        int[] nArray = null;
        if (n4 == 0) {
            nArray = new int[n5 + n3];
            for (int i = 0; i < n5; ++i) {
                nArray[i] = ((BigInteger)this).mag[i];
            }
        } else {
            int n6 = 0;
            int n7 = 32 - n4;
            int n8 = ((BigInteger)this).mag[0] >>> n7;
            if (n8 != 0) {
                nArray = new int[n5 + n3 + 1];
                nArray[n6++] = n8;
            } else {
                nArray = new int[n5 + n3];
            }
            int n9 = 0;
            while (n9 < n5 - 1) {
                nArray[n6++] = ((BigInteger)this).mag[n9++] << n4 | ((BigInteger)this).mag[n9] >>> n7;
            }
            nArray[n6] = ((BigInteger)this).mag[n9] << n4;
        }
        return new BigInteger(nArray, ((BigInteger)this).signum);
    }

    public BigInteger shiftRight(int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 == 0) {
            return this;
        }
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("Shift distance of Integer.MIN_VALUE not supported."));
            }
            return this.shiftLeft(-n2);
        }
        int n6 = n2 >>> 5;
        int n7 = n2 & 0x1F;
        int n8 = ((BigInteger)this).mag.length;
        int[] nArray = null;
        if (n6 >= n8) {
            return ((BigInteger)this).signum >= 0 ? ZERO : (BigInteger)g.convertForCast((Object)a.arrayLoad((Object[])negConst, (int)1), BigInteger.class);
        }
        if (n7 == 0) {
            n5 = n8 - n6;
            nArray = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = ((BigInteger)this).mag[n4];
            }
        } else {
            n5 = 0;
            n4 = ((BigInteger)this).mag[0] >>> n7;
            if (n4 != 0) {
                nArray = new int[n8 - n6];
                nArray[n5++] = n4;
            } else {
                nArray = new int[n8 - n6 - 1];
            }
            n3 = 32 - n7;
            int n9 = 0;
            while (n9 < n8 - n6 - 1) {
                nArray[n5++] = ((BigInteger)this).mag[n9++] << n3 | ((BigInteger)this).mag[n9] >>> n7;
            }
        }
        if (((BigInteger)this).signum < 0) {
            n5 = 0;
            n3 = n8 - n6;
            for (n4 = n8 - 1; n4 >= n3 && n5 == 0; --n4) {
                n5 = ((BigInteger)this).mag[n4] != 0 ? 1 : 0;
            }
            if (n5 == 0 && n7 != 0) {
                int n10 = n5 = ((BigInteger)this).mag[n8 - n6 - 1] << 32 - n7 != 0 ? 1 : 0;
            }
            if (n5 != 0) {
                nArray = this.javaIncrement(nArray);
            }
        }
        return new BigInteger(nArray, ((BigInteger)this).signum);
    }

    int[] javaIncrement(int[] nArray) {
        int n2 = 0;
        int n3 = nArray.length - 1;
        while (n3 >= 0 && n2 == 0) {
            int n4 = n3--;
            int n5 = nArray[n4] + 1;
            nArray[n4] = n5;
            n2 = n5;
        }
        if (n2 == 0) {
            nArray = new int[nArray.length + 1];
            nArray[0] = 1;
        }
        return nArray;
    }

    public BigInteger and(BigInteger bigInteger) {
        int[] nArray = new int[Math.max(this.intLength(), bigInteger.intLength())];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getInt(nArray.length - i - 1) & bigInteger.getInt(nArray.length - i - 1);
        }
        return BigInteger.valueOf(nArray);
    }

    public BigInteger or(BigInteger bigInteger) {
        int[] nArray = new int[Math.max(this.intLength(), bigInteger.intLength())];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getInt(nArray.length - i - 1) | bigInteger.getInt(nArray.length - i - 1);
        }
        return BigInteger.valueOf(nArray);
    }

    public BigInteger xor(BigInteger bigInteger) {
        int[] nArray = new int[Math.max(this.intLength(), bigInteger.intLength())];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getInt(nArray.length - i - 1) ^ bigInteger.getInt(nArray.length - i - 1);
        }
        return BigInteger.valueOf(nArray);
    }

    public BigInteger not() {
        int[] nArray = new int[this.intLength()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ~this.getInt(nArray.length - i - 1);
        }
        return BigInteger.valueOf(nArray);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        int[] nArray = new int[Math.max(this.intLength(), bigInteger.intLength())];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getInt(nArray.length - i - 1) & ~bigInteger.getInt(nArray.length - i - 1);
        }
        return BigInteger.valueOf(nArray);
    }

    public boolean testBit(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("Negative bit address"));
        }
        return (this.getInt(n2 >>> 5) & 1 << (n2 & 0x1F)) != 0;
    }

    public BigInteger setBit(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("Negative bit address"));
        }
        int n3 = n2 >>> 5;
        int[] nArray = new int[Math.max(this.intLength(), n3 + 2)];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[nArray.length - i - 1] = this.getInt(i);
        }
        int n4 = nArray.length - n3 - 1;
        nArray[n4] = nArray[n4] | 1 << (n2 & 0x1F);
        return BigInteger.valueOf(nArray);
    }

    public BigInteger clearBit(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("Negative bit address"));
        }
        int n3 = n2 >>> 5;
        int[] nArray = new int[Math.max(this.intLength(), (n2 + 1 >>> 5) + 1)];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[nArray.length - i - 1] = this.getInt(i);
        }
        int n4 = nArray.length - n3 - 1;
        nArray[n4] = nArray[n4] & ~(1 << (n2 & 0x1F));
        return BigInteger.valueOf(nArray);
    }

    public BigInteger flipBit(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArithmeticException("Negative bit address"));
        }
        int n3 = n2 >>> 5;
        int[] nArray = new int[Math.max(this.intLength(), n3 + 2)];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[nArray.length - i - 1] = this.getInt(i);
        }
        int n4 = nArray.length - n3 - 1;
        nArray[n4] = nArray[n4] ^ 1 << (n2 & 0x1F);
        return BigInteger.valueOf(nArray);
    }

    public int getLowestSetBit() {
        int n2 = this.lowestSetBit - 2;
        if (n2 == -2) {
            n2 = 0;
            if (((BigInteger)this).signum == 0) {
                --n2;
            } else {
                int n3;
                int n4 = 0;
                while ((n3 = this.getInt(n4)) == 0) {
                    ++n4;
                }
                n2 += (n4 << 5) + Integer.numberOfTrailingZeros(n3);
            }
            this.lowestSetBit = n2 + 2;
        }
        return n2;
    }

    public int bitLength() {
        int n2 = this.bitLength - 1;
        if (n2 == -1) {
            int[] nArray = ((BigInteger)this).mag;
            int n3 = nArray.length;
            if (n3 == 0) {
                n2 = 0;
            } else {
                int n4 = (n3 - 1 << 5) + BigInteger.bitLengthForInt(((BigInteger)this).mag[0]);
                if (((BigInteger)this).signum < 0) {
                    boolean bl = Integer.bitCount(((BigInteger)this).mag[0]) == 1;
                    for (int i = 1; i < n3 && bl; ++i) {
                        bl = ((BigInteger)this).mag[i] == 0;
                    }
                    n2 = bl ? n4 - 1 : n4;
                } else {
                    n2 = n4;
                }
            }
            this.bitLength = n2 + 1;
        }
        return n2;
    }

    public int bitCount() {
        int n2 = this.bitCount - 1;
        if (n2 == -1) {
            int n3;
            n2 = 0;
            for (n3 = 0; n3 < ((BigInteger)this).mag.length; ++n3) {
                n2 += Integer.bitCount(((BigInteger)this).mag[n3]);
            }
            if (((BigInteger)this).signum < 0) {
                n3 = 0;
                int n4 = ((BigInteger)this).mag.length - 1;
                while (((BigInteger)this).mag[n4] == 0) {
                    n3 += 32;
                    --n4;
                }
                n2 += (n3 += Integer.numberOfTrailingZeros(((BigInteger)this).mag[n4])) - 1;
            }
            this.bitCount = n2 + 1;
        }
        return n2;
    }

    public boolean isProbablePrime(int n2) {
        if (n2 <= 0) {
            return true;
        }
        BigInteger bigInteger = this.abs();
        if (bigInteger.equals(TWO)) {
            return true;
        }
        if (!bigInteger.testBit(0) || bigInteger.equals(ONE)) {
            return false;
        }
        return bigInteger.primeToCertainty(n2, null);
    }

    @Override
    public int compareTo(BigInteger bigInteger) {
        if (((BigInteger)this).signum == ((BigInteger)bigInteger).signum) {
            switch (((BigInteger)this).signum) {
                case 1: {
                    return this.compareMagnitude(bigInteger);
                }
                case -1: {
                    return bigInteger.compareMagnitude(this);
                }
            }
            return 0;
        }
        return ((BigInteger)this).signum > ((BigInteger)bigInteger).signum ? 1 : -1;
    }

    final int compareMagnitude(BigInteger bigInteger) {
        int[] nArray;
        int n2;
        int[] nArray2 = ((BigInteger)this).mag;
        int n3 = nArray2.length;
        if (n3 < (n2 = (nArray = ((BigInteger)bigInteger).mag).length)) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray2[i];
            int n5 = nArray[i];
            if (n4 == n5) continue;
            return ((long)n4 & 0xFFFFFFFFL) < ((long)n5 & 0xFFFFFFFFL) ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        int[] nArray;
        if (!f.ifAcmp((Object)object, (Object)this)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, BigInteger.class) instanceof BigInteger)) {
            return false;
        }
        BigInteger bigInteger = (BigInteger)g.convertForCast((Object)object, BigInteger.class);
        if (((BigInteger)bigInteger).signum != ((BigInteger)this).signum) {
            return false;
        }
        int[] nArray2 = ((BigInteger)this).mag;
        int n2 = nArray2.length;
        if (n2 != (nArray = ((BigInteger)bigInteger).mag).length) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public BigInteger min(BigInteger bigInteger) {
        return this.compareTo(bigInteger) < 0 ? this : bigInteger;
    }

    public BigInteger max(BigInteger bigInteger) {
        return this.compareTo(bigInteger) > 0 ? this : bigInteger;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i = 0; i < ((BigInteger)this).mag.length; ++i) {
            n2 = (int)((long)(31 * n2) + ((long)((BigInteger)this).mag[i] & 0xFFFFFFFFL));
        }
        return n2 * ((BigInteger)this).signum;
    }

    public String toString(int n2) {
        h h2;
        if (((BigInteger)this).signum == 0) {
            return "0";
        }
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        int n3 = (4 * ((BigInteger)this).mag.length + 6) / 7;
        String[] stringArray = new String[n3];
        BigInteger bigInteger = this.abs();
        int n4 = 0;
        while (((BigInteger)bigInteger).signum != 0) {
            h2 = (BigInteger)g.convertForCast((Object)a.arrayLoad((Object[])longRadix, (int)n2), BigInteger.class);
            MutableBigInteger mutableBigInteger = new MutableBigInteger();
            MutableBigInteger mutableBigInteger2 = new MutableBigInteger(((BigInteger)bigInteger).mag);
            MutableBigInteger mutableBigInteger3 = new MutableBigInteger(((BigInteger)h2).mag);
            MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divide(mutableBigInteger3, mutableBigInteger);
            BigInteger bigInteger2 = mutableBigInteger.toBigInteger(((BigInteger)bigInteger).signum * ((BigInteger)h2).signum);
            BigInteger bigInteger3 = mutableBigInteger4.toBigInteger(((BigInteger)bigInteger).signum * ((BigInteger)h2).signum);
            stringArray[n4++] = Long.toString(bigInteger3.longValue(), n2);
            bigInteger = bigInteger2;
        }
        h2 = new StringBuilder(n4 * digitsPerLong[n2] + 1);
        if (((BigInteger)this).signum < 0) {
            h2.append('-');
        }
        h2.append(stringArray[n4 - 1]);
        for (int i = n4 - 2; i >= 0; --i) {
            int n5 = digitsPerLong[n2] - stringArray[i].length();
            if (n5 != 0) {
                h2.append(zeros[n5]);
            }
            h2.append(stringArray[i]);
        }
        return h2.toString();
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        int n2 = this.bitLength() / 8 + 1;
        byte[] byArray = new byte[n2];
        int n3 = 4;
        int n4 = 0;
        int n5 = 0;
        for (int i = n2 - 1; i >= 0; --i) {
            if (n3 == 4) {
                n4 = this.getInt(n5++);
                n3 = 1;
            } else {
                n4 >>>= 8;
                ++n3;
            }
            byArray[i] = (byte)n4;
        }
        return byArray;
    }

    @Override
    public int intValue() {
        int n2 = 0;
        n2 = this.getInt(0);
        return n2;
    }

    @Override
    public long longValue() {
        long l = 0L;
        for (int i = 1; i >= 0; --i) {
            l = (l << 32) + ((long)this.getInt(i) & 0xFFFFFFFFL);
        }
        return l;
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    private static int[] stripLeadingZeroInts(int[] nArray) {
        int n2;
        int n3 = nArray.length;
        for (n2 = 0; n2 < n3 && nArray[n2] == 0; ++n2) {
        }
        return Arrays.copyOfRange(nArray, n2, n3);
    }

    private static int[] trustedStripLeadingZeroInts(int[] nArray) {
        int n2;
        int n3 = nArray.length;
        for (n2 = 0; n2 < n3 && nArray[n2] == 0; ++n2) {
        }
        return n2 == 0 ? nArray : Arrays.copyOfRange(nArray, n2, n3);
    }

    private static int[] stripLeadingZeroBytes(byte[] byArray) {
        int n2;
        int n3 = byArray.length;
        for (n2 = 0; n2 < n3 && byArray[n2] == 0; ++n2) {
        }
        int n4 = n3 - n2 + 3 >>> 2;
        int[] nArray = new int[n4];
        int n5 = n3 - 1;
        for (int i = n4 - 1; i >= 0; --i) {
            nArray[i] = byArray[n5--] & 0xFF;
            int n6 = n5 - n2 + 1;
            int n7 = Math.min(3, n6);
            for (int k = 8; k <= n7 << 3; k += 8) {
                int n8 = i;
                nArray[n8] = nArray[n8] | (byArray[n5--] & 0xFF) << k;
            }
        }
        return nArray;
    }

    private static int[] makePositive(byte[] byArray) {
        int n2;
        int n3;
        int n4;
        int n5 = byArray.length;
        for (n4 = 0; n4 < n5 && byArray[n4] == -1; ++n4) {
        }
        for (n3 = n4; n3 < n5 && byArray[n3] == 0; ++n3) {
        }
        int n6 = n3 == n5 ? 1 : 0;
        int n7 = (n5 - n4 + n6 + 3) / 4;
        int[] nArray = new int[n7];
        int n8 = n5 - 1;
        for (n2 = n7 - 1; n2 >= 0; --n2) {
            int n9;
            nArray[n2] = byArray[n8--] & 0xFF;
            int n10 = Math.min(3, n8 - n4 + 1);
            if (n10 < 0) {
                n10 = 0;
            }
            for (n9 = 8; n9 <= 8 * n10; n9 += 8) {
                int n11 = n2;
                nArray[n11] = nArray[n11] | (byArray[n8--] & 0xFF) << n9;
            }
            n9 = -1 >>> 8 * (3 - n10);
            nArray[n2] = ~nArray[n2] & n9;
        }
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            nArray[n2] = (int)(((long)nArray[n2] & 0xFFFFFFFFL) + 1L);
            if (nArray[n2] != 0) break;
        }
        return nArray;
    }

    private static int[] makePositive(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < nArray.length && nArray[n5] == -1; ++n5) {
        }
        for (n4 = n5; n4 < nArray.length && nArray[n4] == 0; ++n4) {
        }
        int n6 = n4 == nArray.length ? 1 : 0;
        int[] nArray2 = new int[nArray.length - n5 + n6];
        for (n3 = n5; n3 < nArray.length; ++n3) {
            nArray2[n3 - n5 + n6] = ~nArray[n3];
        }
        n3 = nArray2.length - 1;
        do {
            n2 = n3--;
        } while ((nArray2[n2] = nArray2[n2] + 1) == 0);
        return nArray2;
    }

    private int intLength() {
        return (this.bitLength() >>> 5) + 1;
    }

    private int signBit() {
        return ((BigInteger)this).signum < 0 ? 1 : 0;
    }

    private int signInt() {
        return ((BigInteger)this).signum < 0 ? -1 : 0;
    }

    private int getInt(int n2) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= ((BigInteger)this).mag.length) {
            return this.signInt();
        }
        int n3 = ((BigInteger)this).mag[((BigInteger)this).mag.length - n2 - 1];
        return ((BigInteger)this).signum >= 0 ? n3 : (n2 <= this.firstNonzeroIntNum() ? -n3 : ~n3);
    }

    private int firstNonzeroIntNum() {
        int n2 = this.firstNonzeroIntNum - 2;
        if (n2 == -2) {
            int n3;
            n2 = 0;
            int n4 = ((BigInteger)this).mag.length;
            for (n3 = n4 - 1; n3 >= 0 && ((BigInteger)this).mag[n3] == 0; --n3) {
            }
            n2 = n4 - n3 - 1;
            this.firstNonzeroIntNum = n2 + 2;
        }
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        int n2 = getField.get("signum", -2);
        byte[] byArray = (byte[])getField.get("magnitude", null);
        if (n2 < -1 || n2 > 1) {
            String string = "BigInteger: Invalid signum value";
            if (getField.defaulted("signum")) {
                string = "BigInteger: Signum not present in stream";
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException(string));
        }
        if (byArray.length == 0 != (n2 == 0)) {
            String string = "BigInteger: signum-magnitude mismatch";
            if (getField.defaulted("magnitude")) {
                string = "BigInteger: Magnitude not present in stream";
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new StreamCorruptedException(string));
        }
        unsafe.putIntVolatile(this, signumOffset, n2);
        unsafe.putObjectVolatile(this, magOffset, BigInteger.stripLeadingZeroBytes(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("signum", ((BigInteger)this).signum);
        putField.put("magnitude", this.magSerializedForm());
        putField.put("bitCount", -1);
        putField.put("bitLength", -1);
        putField.put("lowestSetBit", -2);
        putField.put("firstNonzeroByteNum", -2);
        objectOutputStream.writeFields();
    }

    private byte[] magSerializedForm() {
        int n2 = ((BigInteger)this).mag.length;
        int n3 = n2 == 0 ? 0 : (n2 - 1 << 5) + BigInteger.bitLengthForInt(((BigInteger)this).mag[0]);
        int n4 = n3 + 7 >>> 3;
        byte[] byArray = new byte[n4];
        int n5 = 4;
        int n6 = n2 - 1;
        int n7 = 0;
        for (int i = n4 - 1; i >= 0; --i) {
            if (n5 == 4) {
                n7 = ((BigInteger)this).mag[n6--];
                n5 = 1;
            } else {
                n7 >>>= 8;
                ++n5;
            }
            byArray[i] = (byte)n7;
        }
        return byArray;
    }

    static {
        int n2;
        bitsPerDigit = new long[]{0L, 0L, 1024L, 1624L, 2048L, 2378L, 2648L, 2875L, 3072L, 3247L, 3402L, 3543L, 3672L, 3790L, 3899L, 4001L, 4096L, 4186L, 4271L, 4350L, 4426L, 4498L, 4567L, 4633L, 4696L, 4756L, 4814L, 4870L, 4923L, 4975L, 5025L, 5074L, 5120L, 5166L, 5210L, 5253L, 5295L};
        SMALL_PRIME_PRODUCT = BigInteger.valueOf(152125131763605L);
        posConst = new BigInteger[17];
        negConst = new BigInteger[17];
        for (n2 = 1; n2 <= 16; ++n2) {
            int[] nArray = new int[]{n2};
            a.arrayStore((Object[])posConst, (int)n2, (Object)new BigInteger(nArray, 1));
            a.arrayStore((Object[])negConst, (int)n2, (Object)new BigInteger(nArray, -1));
        }
        ZERO = new BigInteger(new int[0], 0);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        TEN = BigInteger.valueOf(10L);
        bnExpModThreshTable = new int[]{7, 25, 81, 241, 673, 1793, Integer.MAX_VALUE};
        zeros = new String[64];
        BigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        for (n2 = 0; n2 < 63; ++n2) {
            BigInteger.zeros[n2] = zeros[63].substring(0, n2);
        }
        digitsPerLong = new int[]{0, 0, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
        Object[] objectArray = new BigInteger[37];
        a.arrayStore((Object[])objectArray, (int)0, null);
        a.arrayStore((Object[])objectArray, (int)1, null);
        a.arrayStore((Object[])objectArray, (int)2, (Object)BigInteger.valueOf(0x4000000000000000L));
        a.arrayStore((Object[])objectArray, (int)3, (Object)BigInteger.valueOf(4052555153018976267L));
        a.arrayStore((Object[])objectArray, (int)4, (Object)BigInteger.valueOf(0x4000000000000000L));
        a.arrayStore((Object[])objectArray, (int)5, (Object)BigInteger.valueOf(7450580596923828125L));
        a.arrayStore((Object[])objectArray, (int)6, (Object)BigInteger.valueOf(4738381338321616896L));
        a.arrayStore((Object[])objectArray, (int)7, (Object)BigInteger.valueOf(3909821048582988049L));
        a.arrayStore((Object[])objectArray, (int)8, (Object)BigInteger.valueOf(0x1000000000000000L));
        a.arrayStore((Object[])objectArray, (int)9, (Object)BigInteger.valueOf(1350851717672992089L));
        a.arrayStore((Object[])objectArray, (int)10, (Object)BigInteger.valueOf(1000000000000000000L));
        a.arrayStore((Object[])objectArray, (int)11, (Object)BigInteger.valueOf(5559917313492231481L));
        a.arrayStore((Object[])objectArray, (int)12, (Object)BigInteger.valueOf(2218611106740436992L));
        a.arrayStore((Object[])objectArray, (int)13, (Object)BigInteger.valueOf(8650415919381337933L));
        a.arrayStore((Object[])objectArray, (int)14, (Object)BigInteger.valueOf(2177953337809371136L));
        a.arrayStore((Object[])objectArray, (int)15, (Object)BigInteger.valueOf(6568408355712890625L));
        a.arrayStore((Object[])objectArray, (int)16, (Object)BigInteger.valueOf(0x1000000000000000L));
        a.arrayStore((Object[])objectArray, (int)17, (Object)BigInteger.valueOf(2862423051509815793L));
        a.arrayStore((Object[])objectArray, (int)18, (Object)BigInteger.valueOf(6746640616477458432L));
        a.arrayStore((Object[])objectArray, (int)19, (Object)BigInteger.valueOf(799006685782884121L));
        a.arrayStore((Object[])objectArray, (int)20, (Object)BigInteger.valueOf(1638400000000000000L));
        a.arrayStore((Object[])objectArray, (int)21, (Object)BigInteger.valueOf(3243919932521508681L));
        a.arrayStore((Object[])objectArray, (int)22, (Object)BigInteger.valueOf(6221821273427820544L));
        a.arrayStore((Object[])objectArray, (int)23, (Object)BigInteger.valueOf(504036361936467383L));
        a.arrayStore((Object[])objectArray, (int)24, (Object)BigInteger.valueOf(876488338465357824L));
        a.arrayStore((Object[])objectArray, (int)25, (Object)BigInteger.valueOf(1490116119384765625L));
        a.arrayStore((Object[])objectArray, (int)26, (Object)BigInteger.valueOf(2481152873203736576L));
        a.arrayStore((Object[])objectArray, (int)27, (Object)BigInteger.valueOf(4052555153018976267L));
        a.arrayStore((Object[])objectArray, (int)28, (Object)BigInteger.valueOf(6502111422497947648L));
        a.arrayStore((Object[])objectArray, (int)29, (Object)BigInteger.valueOf(353814783205469041L));
        a.arrayStore((Object[])objectArray, (int)30, (Object)BigInteger.valueOf(531441000000000000L));
        a.arrayStore((Object[])objectArray, (int)31, (Object)BigInteger.valueOf(787662783788549761L));
        a.arrayStore((Object[])objectArray, (int)32, (Object)BigInteger.valueOf(0x1000000000000000L));
        a.arrayStore((Object[])objectArray, (int)33, (Object)BigInteger.valueOf(1667889514952984961L));
        a.arrayStore((Object[])objectArray, (int)34, (Object)BigInteger.valueOf(2386420683693101056L));
        a.arrayStore((Object[])objectArray, (int)35, (Object)BigInteger.valueOf(3379220508056640625L));
        a.arrayStore((Object[])objectArray, (int)36, (Object)BigInteger.valueOf(4738381338321616896L));
        longRadix = objectArray;
        digitsPerInt = new int[]{0, 0, 30, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
        intRadix = new int[]{0, 0, 0x40000000, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};
        Object[] objectArray2 = new ObjectStreamField[6];
        a.arrayStore((Object[])objectArray2, (int)0, (Object)new ObjectStreamField("signum", Integer.TYPE));
        a.arrayStore((Object[])objectArray2, (int)1, (Object)new ObjectStreamField("magnitude", byte[].class));
        a.arrayStore((Object[])objectArray2, (int)2, (Object)new ObjectStreamField("bitCount", Integer.TYPE));
        a.arrayStore((Object[])objectArray2, (int)3, (Object)new ObjectStreamField("bitLength", Integer.TYPE));
        a.arrayStore((Object[])objectArray2, (int)4, (Object)new ObjectStreamField("firstNonzeroByteNum", Integer.TYPE));
        a.arrayStore((Object[])objectArray2, (int)5, (Object)new ObjectStreamField("lowestSetBit", Integer.TYPE));
        serialPersistentFields = objectArray2;
        unsafe = Unsafe.getUnsafe();
        try {
            signumOffset = unsafe.objectFieldOffset(ai.getCurrentClass(BigInteger.class).getDeclaredField("signum"));
            magOffset = unsafe.objectFieldOffset(ai.getCurrentClass(BigInteger.class).getDeclaredField("mag"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
    }

    static /* synthetic */ void _jr$ip$signum(Object object, int n2) {
        ((BigInteger)object).signum = n2;
    }

    static /* synthetic */ void _jr$ip$mag(Object object, int[] nArray) {
        ((BigInteger)object).mag = nArray;
    }

    protected /* synthetic */ BigInteger(h h2) {
        super(h2);
    }
}

