/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetAddressContainer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.UnknownHostException;
import java.security.AccessController;
import sun.net.ConnectionResetException;
import sun.net.NetHooks;
import sun.net.ResourceManager;
import sun.security.action.LoadLibraryAction;

abstract class AbstractPlainSocketImpl
extends SocketImpl {
    int timeout;
    private int trafficClass;
    private boolean shut_rd;
    private boolean shut_wr;
    private SocketInputStream socketInputStream;
    protected int fdUseCount;
    protected final Object fdLock;
    protected boolean closePending;
    private int CONNECTION_NOT_RESET;
    private int CONNECTION_RESET_PENDING;
    private int CONNECTION_RESET;
    private int resetState;
    private final Object resetLock;
    protected boolean stream;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;

    AbstractPlainSocketImpl() {
        this.shut_rd = false;
        this.shut_wr = false;
        this.socketInputStream = null;
        this.fdUseCount = 0;
        this.fdLock = new Object();
        this.closePending = false;
        this.CONNECTION_NOT_RESET = 0;
        this.CONNECTION_RESET_PENDING = 1;
        this.CONNECTION_RESET = 2;
        this.resetLock = new Object();
    }

    @Override
    @af(modifiers=36)
    protected void create(boolean bl) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                ((AbstractPlainSocketImpl)this).stream = bl;
                if (!bl) {
                    ResourceManager.beforeUdpCreate();
                    AbstractPlainSocketImpl._jr$ip$fd(this, new FileDescriptor());
                    try {
                        this.socketCreate(false);
                    }
                    catch (IOException iOException) {
                        ResourceManager.afterUdpClose();
                        AbstractPlainSocketImpl._jr$ip$fd(this, null);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
                    }
                } else {
                    AbstractPlainSocketImpl._jr$ip$fd(this, new FileDescriptor());
                    this.socketCreate(true);
                }
                if (AbstractPlainSocketImpl._jr$ig$socket(this) != null) {
                    AbstractPlainSocketImpl._jr$ig$socket(this).setCreated();
                }
                if (AbstractPlainSocketImpl._jr$ig$serverSocket(this) != null) {
                    AbstractPlainSocketImpl._jr$ig$serverSocket(this).setCreated();
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void connect(String string, int n2) throws UnknownHostException, IOException {
        boolean bl = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            AbstractPlainSocketImpl._jr$ip$port(this, n2);
            AbstractPlainSocketImpl._jr$ip$address(this, inetAddress);
            this.connectToAddress(inetAddress, n2, ((AbstractPlainSocketImpl)this).timeout);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            try {
                this.close();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    @Override
    protected void connect(InetAddress inetAddress, int n2) throws IOException {
        AbstractPlainSocketImpl._jr$ip$port(this, n2);
        AbstractPlainSocketImpl._jr$ip$address(this, inetAddress);
        try {
            this.connectToAddress(inetAddress, n2, ((AbstractPlainSocketImpl)this).timeout);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void connect(SocketAddress socketAddress, int n2) throws IOException {
        boolean bl = false;
        try {
            if (socketAddress == null || !(g.convertForInstanceOf((Object)socketAddress, InetSocketAddress.class) instanceof InetSocketAddress)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("unsupported address type"));
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)g.convertForCast((Object)socketAddress, InetSocketAddress.class);
            if (inetSocketAddress.isUnresolved()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException(inetSocketAddress.getHostName()));
            }
            AbstractPlainSocketImpl._jr$ip$port(this, inetSocketAddress.getPort());
            AbstractPlainSocketImpl._jr$ip$address(this, inetSocketAddress.getAddress());
            this.connectToAddress(AbstractPlainSocketImpl._jr$ig$address(this), AbstractPlainSocketImpl._jr$ig$port(this), n2);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            try {
                this.close();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    private void connectToAddress(InetAddress inetAddress, int n2, int n3) throws IOException {
        if (inetAddress.isAnyLocalAddress()) {
            this.doConnect(InetAddress.getLocalHost(), n2, n3);
        } else {
            this.doConnect(inetAddress, n2, n3);
        }
    }

    @Override
    public void setOption(int n2, Object object) throws SocketException {
        if (this.isClosedOrPending()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket Closed"));
        }
        boolean bl = true;
        switch (n2) {
            case 128: {
                if (object == null || !(object instanceof Integer) && !(object instanceof Boolean)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Bad parameter for option"));
                }
                if (!(object instanceof Boolean)) break;
                bl = false;
                break;
            }
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Bad parameter for SO_TIMEOUT"));
                }
                int n3 = (Integer)object;
                if (n3 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("timeout < 0"));
                }
                ((AbstractPlainSocketImpl)this).timeout = n3;
                break;
            }
            case 3: {
                if (object == null || !(object instanceof Integer)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("bad argument for IP_TOS"));
                }
                this.trafficClass = (Integer)object;
                break;
            }
            case 15: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Cannot re-bind socket"));
            }
            case 1: {
                if (object == null || !(object instanceof Boolean)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("bad parameter for TCP_NODELAY"));
                }
                bl = (Boolean)object;
                break;
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object > 0) break;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("bad parameter for SO_SNDBUF or SO_RCVBUF"));
            }
            case 8: {
                if (object == null || !(object instanceof Boolean)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("bad parameter for SO_KEEPALIVE"));
                }
                bl = (Boolean)object;
                break;
            }
            case 4099: {
                if (object == null || !(object instanceof Boolean)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("bad parameter for SO_OOBINLINE"));
                }
                bl = (Boolean)object;
                break;
            }
            case 4: {
                if (object == null || !(object instanceof Boolean)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("bad parameter for SO_REUSEADDR"));
                }
                bl = (Boolean)object;
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("unrecognized TCP option: " + n2));
            }
        }
        this.socketSetOption(n2, bl, object);
    }

    @Override
    public Object getOption(int n2) throws SocketException {
        if (this.isClosedOrPending()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket Closed"));
        }
        if (n2 == 4102) {
            return new Integer(((AbstractPlainSocketImpl)this).timeout);
        }
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = this.socketGetOption(n2, null);
                return n3 != -1;
            }
            case 4099: {
                n3 = this.socketGetOption(n2, null);
                return n3 != -1;
            }
            case 128: {
                n3 = this.socketGetOption(n2, null);
                return n3 == -1 ? (h)Boolean.FALSE : (h)new Integer(n3);
            }
            case 4: {
                n3 = this.socketGetOption(n2, null);
                return n3 != -1;
            }
            case 15: {
                InetAddressContainer inetAddressContainer = new InetAddressContainer();
                n3 = this.socketGetOption(n2, inetAddressContainer);
                return InetAddressContainer._jr$ig$addr((Object)inetAddressContainer);
            }
            case 4097: 
            case 4098: {
                n3 = this.socketGetOption(n2, null);
                return new Integer(n3);
            }
            case 3: {
                n3 = this.socketGetOption(n2, null);
                if (n3 == -1) {
                    return new Integer(this.trafficClass);
                }
                return new Integer(n3);
            }
            case 8: {
                n3 = this.socketGetOption(n2, null);
                return n3 != -1;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @af(modifiers=32)
    void doConnect(InetAddress inetAddress, int n2, int n3) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Object object2 = ah.getMonitor((Object)((AbstractPlainSocketImpl)this).fdLock);
                synchronized (object2) {
                    try {
                        if (!(((AbstractPlainSocketImpl)this).closePending || AbstractPlainSocketImpl._jr$ig$socket(this) != null && AbstractPlainSocketImpl._jr$ig$socket(this).isBound())) {
                            NetHooks.beforeTcpConnect(AbstractPlainSocketImpl._jr$ig$fd(this), inetAddress, n2);
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                try {
                    this.acquireFD();
                    try {
                        this.socketConnect(inetAddress, n2, n3);
                        object2 = ah.getMonitor((Object)((AbstractPlainSocketImpl)this).fdLock);
                        synchronized (object2) {
                            try {
                                if (((AbstractPlainSocketImpl)this).closePending) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket closed"));
                                }
                            }
                            catch (Throwable throwable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                        if (AbstractPlainSocketImpl._jr$ig$socket(this) != null) {
                            AbstractPlainSocketImpl._jr$ig$socket(this).setBound();
                            AbstractPlainSocketImpl._jr$ig$socket(this).setConnected();
                        }
                        this.releaseFD();
                    }
                    catch (Throwable throwable) {
                        this.releaseFD();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                catch (IOException iOException) {
                    this.close();
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @af(modifiers=36)
    protected void bind(InetAddress inetAddress, int n2) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Object object2 = ah.getMonitor((Object)((AbstractPlainSocketImpl)this).fdLock);
                synchronized (object2) {
                    try {
                        if (!(((AbstractPlainSocketImpl)this).closePending || AbstractPlainSocketImpl._jr$ig$socket(this) != null && AbstractPlainSocketImpl._jr$ig$socket(this).isBound())) {
                            NetHooks.beforeTcpBind(AbstractPlainSocketImpl._jr$ig$fd(this), inetAddress, n2);
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                this.socketBind(inetAddress, n2);
                if (AbstractPlainSocketImpl._jr$ig$socket(this) != null) {
                    AbstractPlainSocketImpl._jr$ig$socket(this).setBound();
                }
                if (AbstractPlainSocketImpl._jr$ig$serverSocket(this) != null) {
                    AbstractPlainSocketImpl._jr$ig$serverSocket(this).setBound();
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=36)
    protected void listen(int n2) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.socketListen(n2);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accept(SocketImpl socketImpl) throws IOException {
        this.acquireFD();
        try {
            this.socketAccept(socketImpl);
            this.releaseFD();
        }
        catch (Throwable throwable) {
            this.releaseFD();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    @Override
    @af(modifiers=36)
    protected InputStream getInputStream() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosedOrPending()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Socket Closed"));
                }
                if (this.shut_rd) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Socket input is shutdown"));
                }
                if (this.socketInputStream == null) {
                    this.socketInputStream = new SocketInputStream(this);
                }
                return this.socketInputStream;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    void setInputStream(SocketInputStream socketInputStream) {
        this.socketInputStream = socketInputStream;
    }

    @Override
    @af(modifiers=36)
    protected OutputStream getOutputStream() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosedOrPending()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Socket Closed"));
                }
                if (this.shut_wr) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Socket output is shutdown"));
                }
                return new SocketOutputStream(this);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        AbstractPlainSocketImpl._jr$ip$fd(this, fileDescriptor);
    }

    void setAddress(InetAddress inetAddress) {
        AbstractPlainSocketImpl._jr$ip$address(this, inetAddress);
    }

    void setPort(int n2) {
        AbstractPlainSocketImpl._jr$ip$port(this, n2);
    }

    void setLocalPort(int n2) {
        AbstractPlainSocketImpl._jr$ip$localport(this, n2);
    }

    @Override
    @af(modifiers=36)
    protected int available() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosedOrPending()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed."));
                }
                if (this.isConnectionReset()) {
                    return 0;
                }
                int n2 = 0;
                try {
                    n2 = this.socketAvailable();
                    if (n2 == 0 && this.isConnectionResetPending()) {
                        this.setConnectionReset();
                    }
                }
                catch (ConnectionResetException connectionResetException) {
                    this.setConnectionResetPending();
                    try {
                        n2 = this.socketAvailable();
                        if (n2 == 0) {
                            this.setConnectionReset();
                        }
                    }
                    catch (ConnectionResetException connectionResetException2) {
                        // empty catch block
                    }
                }
                return n2;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        block8: {
            Object object = ah.getMonitor((Object)((AbstractPlainSocketImpl)this).fdLock);
            synchronized (object) {
                try {
                    block9: {
                        if (AbstractPlainSocketImpl._jr$ig$fd(this) == null) break block8;
                        if (!((AbstractPlainSocketImpl)this).stream) {
                            ResourceManager.afterUdpClose();
                        }
                        if (((AbstractPlainSocketImpl)this).fdUseCount != 0) break block9;
                        if (((AbstractPlainSocketImpl)this).closePending) {
                            return;
                        }
                        ((AbstractPlainSocketImpl)this).closePending = true;
                        try {
                            this.socketPreClose();
                        }
                        catch (Throwable throwable) {
                            this.socketClose();
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                        this.socketClose();
                        AbstractPlainSocketImpl._jr$ip$fd(this, null);
                        return;
                    }
                    if (!((AbstractPlainSocketImpl)this).closePending) {
                        ((AbstractPlainSocketImpl)this).closePending = true;
                        AbstractPlainSocketImpl abstractPlainSocketImpl = this;
                        ((AbstractPlainSocketImpl)abstractPlainSocketImpl).fdUseCount = ((AbstractPlainSocketImpl)abstractPlainSocketImpl).fdUseCount - 1;
                        this.socketPreClose();
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    @Override
    void reset() throws IOException {
        if (AbstractPlainSocketImpl._jr$ig$fd(this) != null) {
            this.socketClose();
        }
        AbstractPlainSocketImpl._jr$ip$fd(this, null);
        super.reset();
    }

    @Override
    protected void shutdownInput() throws IOException {
        if (AbstractPlainSocketImpl._jr$ig$fd(this) != null) {
            this.socketShutdown(0);
            if (this.socketInputStream != null) {
                this.socketInputStream.setEOF(true);
            }
            this.shut_rd = true;
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        if (AbstractPlainSocketImpl._jr$ig$fd(this) != null) {
            this.socketShutdown(1);
            this.shut_wr = true;
        }
    }

    @Override
    protected boolean supportsUrgentData() {
        return true;
    }

    @Override
    protected void sendUrgentData(int n2) throws IOException {
        if (AbstractPlainSocketImpl._jr$ig$fd(this) == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Socket Closed"));
        }
        this.socketSendUrgentData(n2);
    }

    protected void finalize() throws IOException {
        if (!this._jr$iCur()) {
            return;
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileDescriptor acquireFD() {
        Object object = ah.getMonitor((Object)((AbstractPlainSocketImpl)this).fdLock);
        synchronized (object) {
            try {
                AbstractPlainSocketImpl abstractPlainSocketImpl = this;
                ((AbstractPlainSocketImpl)abstractPlainSocketImpl).fdUseCount = ((AbstractPlainSocketImpl)abstractPlainSocketImpl).fdUseCount + 1;
                return AbstractPlainSocketImpl._jr$ig$fd(this);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void releaseFD() {
        Object object = ah.getMonitor((Object)((AbstractPlainSocketImpl)this).fdLock);
        synchronized (object) {
            try {
                AbstractPlainSocketImpl abstractPlainSocketImpl = this;
                ((AbstractPlainSocketImpl)abstractPlainSocketImpl).fdUseCount = ((AbstractPlainSocketImpl)abstractPlainSocketImpl).fdUseCount - 1;
                if (((AbstractPlainSocketImpl)this).fdUseCount == -1 && AbstractPlainSocketImpl._jr$ig$fd(this) != null) {
                    try {
                        this.socketClose();
                    }
                    catch (IOException iOException) {
                        AbstractPlainSocketImpl._jr$ip$fd(this, null);
                        catch (Throwable throwable) {
                            AbstractPlainSocketImpl._jr$ip$fd(this, null);
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                    }
                    AbstractPlainSocketImpl._jr$ip$fd(this, null);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionReset() {
        Object object = ah.getMonitor((Object)this.resetLock);
        synchronized (object) {
            try {
                return this.resetState == this.CONNECTION_RESET;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionResetPending() {
        Object object = ah.getMonitor((Object)this.resetLock);
        synchronized (object) {
            try {
                return this.resetState == this.CONNECTION_RESET_PENDING;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionReset() {
        Object object = ah.getMonitor((Object)this.resetLock);
        synchronized (object) {
            try {
                this.resetState = this.CONNECTION_RESET;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionResetPending() {
        Object object = ah.getMonitor((Object)this.resetLock);
        synchronized (object) {
            try {
                if (this.resetState == this.CONNECTION_NOT_RESET) {
                    this.resetState = this.CONNECTION_RESET_PENDING;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedOrPending() {
        Object object = ah.getMonitor((Object)((AbstractPlainSocketImpl)this).fdLock);
        synchronized (object) {
            try {
                return ((AbstractPlainSocketImpl)this).closePending || AbstractPlainSocketImpl._jr$ig$fd(this) == null;
                {
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public int getTimeout() {
        return ((AbstractPlainSocketImpl)this).timeout;
    }

    private void socketPreClose() throws IOException {
        this.socketClose0(true);
    }

    protected void socketClose() throws IOException {
        this.socketClose0(false);
    }

    abstract void socketCreate(boolean var1) throws IOException;

    abstract void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    abstract void socketBind(InetAddress var1, int var2) throws IOException;

    abstract void socketListen(int var1) throws IOException;

    abstract void socketAccept(SocketImpl var1) throws IOException;

    abstract int socketAvailable() throws IOException;

    abstract void socketClose0(boolean var1) throws IOException;

    abstract void socketShutdown(int var1) throws IOException;

    abstract void socketSetOption(int var1, boolean var2, Object var3) throws SocketException;

    abstract int socketGetOption(int var1, Object var2) throws SocketException;

    abstract void socketSendUrgentData(int var1) throws IOException;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }

    protected static /* synthetic */ void _jr$ip$fdLock(Object object, Object object2) {
        ((AbstractPlainSocketImpl)object).fdLock = object2;
    }

    private static /* synthetic */ void _jr$ip$CONNECTION_NOT_RESET(AbstractPlainSocketImpl abstractPlainSocketImpl, int n2) {
        abstractPlainSocketImpl.CONNECTION_NOT_RESET = n2;
    }

    private static /* synthetic */ void _jr$ip$CONNECTION_RESET_PENDING(AbstractPlainSocketImpl abstractPlainSocketImpl, int n2) {
        abstractPlainSocketImpl.CONNECTION_RESET_PENDING = n2;
    }

    private static /* synthetic */ void _jr$ip$CONNECTION_RESET(AbstractPlainSocketImpl abstractPlainSocketImpl, int n2) {
        abstractPlainSocketImpl.CONNECTION_RESET = n2;
    }

    private static /* synthetic */ void _jr$ip$resetLock(AbstractPlainSocketImpl abstractPlainSocketImpl, Object object) {
        abstractPlainSocketImpl.resetLock = object;
    }

    protected /* synthetic */ AbstractPlainSocketImpl(h h2) {
        super(h2);
    }
}

