/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetPermission;
import java.net.ProtocolException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Date;

public abstract class HttpURLConnection
extends URLConnection {
    protected String method;
    protected int chunkLength;
    protected int fixedContentLength;
    protected long fixedContentLengthLong;
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    protected int responseCode;
    protected String responseMessage;
    private static boolean followRedirects = true;
    protected boolean instanceFollowRedirects;
    private static final String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"};
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    @Deprecated
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;

    @Override
    public String getHeaderFieldKey(int n2) {
        return null;
    }

    public void setFixedLengthStreamingMode(int n2) {
        if (HttpURLConnection._jr$ig$connected((Object)this)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Already connected"));
        }
        if (((HttpURLConnection)((Object)((Object)this))).chunkLength != -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Chunked encoding streaming mode set"));
        }
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid content length"));
        }
        ((HttpURLConnection)((Object)((Object)this))).fixedContentLength = n2;
    }

    public void setFixedLengthStreamingMode(long l) {
        if (HttpURLConnection._jr$ig$connected((Object)this)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Already connected"));
        }
        if (((HttpURLConnection)((Object)((Object)this))).chunkLength != -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Chunked encoding streaming mode set"));
        }
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid content length"));
        }
        ((HttpURLConnection)((Object)((Object)this))).fixedContentLengthLong = l;
    }

    public void setChunkedStreamingMode(int n2) {
        if (HttpURLConnection._jr$ig$connected((Object)this)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Can't set streaming mode: already connected"));
        }
        if (((HttpURLConnection)((Object)((Object)this))).fixedContentLength != -1 || ((HttpURLConnection)((Object)((Object)this))).fixedContentLengthLong != -1L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Fixed length streaming mode set"));
        }
        ((HttpURLConnection)((Object)((Object)this))).chunkLength = n2 <= 0 ? 4096 : n2;
    }

    @Override
    public String getHeaderField(int n2) {
        return null;
    }

    protected HttpURLConnection(URL uRL) {
        super(uRL);
        this.method = "GET";
        this.chunkLength = -1;
        this.fixedContentLength = -1;
        this.fixedContentLengthLong = -1L;
        this.responseCode = -1;
        this.responseMessage = null;
        this.instanceFollowRedirects = followRedirects;
    }

    public static void setFollowRedirects(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        followRedirects = bl;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        ((HttpURLConnection)((Object)((Object)this))).instanceFollowRedirects = bl;
    }

    public boolean getInstanceFollowRedirects() {
        return ((HttpURLConnection)((Object)((Object)this))).instanceFollowRedirects;
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (HttpURLConnection._jr$ig$connected((Object)this)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProtocolException("Can't reset method: already connected"));
        }
        for (int i = 0; i < methods.length; ++i) {
            SecurityManager securityManager;
            if (!methods[i].equals(string)) continue;
            if (string.equals("TRACE") && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPermission(new NetPermission("allowHttpTrace"));
            }
            ((HttpURLConnection)((Object)((Object)this))).method = string;
            return;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProtocolException("Invalid HTTP method: " + string));
    }

    public String getRequestMethod() {
        return ((HttpURLConnection)((Object)((Object)this))).method;
    }

    public int getResponseCode() throws IOException {
        int n2;
        if (((HttpURLConnection)((Object)((Object)this))).responseCode != -1) {
            return ((HttpURLConnection)((Object)((Object)this))).responseCode;
        }
        Exception exception = null;
        try {
            this.getInputStream();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        String string = this.getHeaderField(0);
        if (string == null) {
            if (exception != null) {
                if (g.convertForInstanceOf((Object)exception, RuntimeException.class) instanceof RuntimeException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((RuntimeException)g.convertForCast((Object)exception, RuntimeException.class)));
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)exception, IOException.class)));
            }
            return -1;
        }
        if (string.startsWith("HTTP/1.") && (n2 = string.indexOf(32)) > 0) {
            int n3 = string.indexOf(32, n2 + 1);
            if (n3 > 0 && n3 < string.length()) {
                ((HttpURLConnection)((Object)((Object)this))).responseMessage = string.substring(n3 + 1);
            }
            if (n3 < 0) {
                n3 = string.length();
            }
            try {
                ((HttpURLConnection)((Object)((Object)this))).responseCode = Integer.parseInt(string.substring(n2 + 1, n3));
                return ((HttpURLConnection)((Object)((Object)this))).responseCode;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getResponseMessage() throws IOException {
        this.getResponseCode();
        return ((HttpURLConnection)((Object)((Object)this))).responseMessage;
    }

    @Override
    public long getHeaderFieldDate(String string, long l) {
        String string2 = this.getHeaderField(string);
        try {
            if (string2.indexOf("GMT") == -1) {
                string2 = string2 + " GMT";
            }
            return Date.parse(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public abstract void disconnect();

    public abstract boolean usingProxy();

    @Override
    public Permission getPermission() throws IOException {
        int n2 = HttpURLConnection._jr$ig$url((Object)this).getPort();
        n2 = n2 < 0 ? 80 : n2;
        String string = HttpURLConnection._jr$ig$url((Object)this).getHost() + ":" + n2;
        SocketPermission socketPermission = new SocketPermission(string, "connect");
        return socketPermission;
    }

    public InputStream getErrorStream() {
        return null;
    }

    protected /* synthetic */ HttpURLConnection(h h2) {
        super(h2);
    }
}

