/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.g;
import java.io.ObjectStreamException;
import java.net.InetAddress;

public final class Inet4Address
extends InetAddress {
    static final int INADDRSZ = 4;
    private static final long serialVersionUID = 3286316764910316507L;
    private static final int loopback = 2130706433;

    Inet4Address() {
        this.holder().hostName = null;
        this.holder().address = 0;
        this.holder().family = 1;
    }

    Inet4Address(String string, byte[] byArray) {
        this.holder().hostName = string;
        this.holder().family = 1;
        if (byArray != null && byArray.length == 4) {
            int n2 = byArray[3] & 0xFF;
            n2 |= byArray[2] << 8 & 0xFF00;
            n2 |= byArray[1] << 16 & 0xFF0000;
            this.holder().address = n2 |= byArray[0] << 24 & 0xFF000000;
        }
    }

    Inet4Address(String string, int n2) {
        this.holder().hostName = string;
        this.holder().family = 1;
        this.holder().address = n2;
    }

    private Object writeReplace() throws ObjectStreamException {
        InetAddress inetAddress = new InetAddress();
        InetAddress.InetAddressHolder._jr$ip$hostName((Object)inetAddress.holder(), this.holder().getHostName());
        InetAddress.InetAddressHolder._jr$ip$address((Object)inetAddress.holder(), this.holder().getAddress());
        InetAddress.InetAddressHolder._jr$ip$family((Object)inetAddress.holder(), 2);
        return inetAddress;
    }

    @Override
    public boolean isMulticastAddress() {
        return (this.holder().getAddress() & 0xF0000000) == -536870912;
    }

    @Override
    public boolean isAnyLocalAddress() {
        return this.holder().getAddress() == 0;
    }

    @Override
    public boolean isLoopbackAddress() {
        byte[] byArray = this.getAddress();
        return byArray[0] == 127;
    }

    @Override
    public boolean isLinkLocalAddress() {
        int n2 = this.holder().getAddress();
        return (n2 >>> 24 & 0xFF) == 169 && (n2 >>> 16 & 0xFF) == 254;
    }

    @Override
    public boolean isSiteLocalAddress() {
        int n2 = this.holder().getAddress();
        return (n2 >>> 24 & 0xFF) == 10 || (n2 >>> 24 & 0xFF) == 172 && (n2 >>> 16 & 0xF0) == 16 || (n2 >>> 24 & 0xFF) == 192 && (n2 >>> 16 & 0xFF) == 168;
    }

    @Override
    public boolean isMCGlobal() {
        byte[] byArray = this.getAddress();
        return (byArray[0] & 0xFF) >= 224 && (byArray[0] & 0xFF) <= 238 && ((byArray[0] & 0xFF) != 224 || byArray[1] != 0 || byArray[2] != 0);
    }

    @Override
    public boolean isMCNodeLocal() {
        return false;
    }

    @Override
    public boolean isMCLinkLocal() {
        int n2 = this.holder().getAddress();
        return (n2 >>> 24 & 0xFF) == 224 && (n2 >>> 16 & 0xFF) == 0 && (n2 >>> 8 & 0xFF) == 0;
    }

    @Override
    public boolean isMCSiteLocal() {
        int n2 = this.holder().getAddress();
        return (n2 >>> 24 & 0xFF) == 239 && (n2 >>> 16 & 0xFF) == 255;
    }

    @Override
    public boolean isMCOrgLocal() {
        int n2 = this.holder().getAddress();
        return (n2 >>> 24 & 0xFF) == 239 && (n2 >>> 16 & 0xFF) >= 192 && (n2 >>> 16 & 0xFF) <= 195;
    }

    @Override
    public byte[] getAddress() {
        int n2 = this.holder().getAddress();
        byte[] byArray = new byte[]{(byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }

    @Override
    public String getHostAddress() {
        return Inet4Address.numericToTextFormat(this.getAddress());
    }

    @Override
    public int hashCode() {
        return this.holder().getAddress();
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof Inet4Address && ((InetAddress)g.convertForCast((Object)object, InetAddress.class)).holder().getAddress() == this.holder().getAddress();
    }

    static String numericToTextFormat(byte[] byArray) {
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    private static native void init();

    static {
        Inet4Address.init();
    }
}

