/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import sun.misc.Unsafe;

public final class Inet6Address
extends InetAddress {
    static final int INADDRSZ = 16;
    private transient int cached_scope_id = 0;
    private final transient Inet6AddressHolder holder6;
    private static final long serialVersionUID = 6880410070516793377L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;
    private static final int INT16SZ = 2;

    Inet6Address() {
        this.holder.init(null, 2);
        this.holder6 = new Inet6AddressHolder(this);
    }

    Inet6Address(String string, byte[] byArray, int n2) {
        this.holder.init(string, 2);
        this.holder6 = new Inet6AddressHolder(this);
        this.holder6.init(byArray, n2);
    }

    Inet6Address(String string, byte[] byArray) {
        this.holder6 = new Inet6AddressHolder(this);
        try {
            this.initif(string, byArray, null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    Inet6Address(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        this.holder6 = new Inet6AddressHolder(this);
        this.initif(string, byArray, networkInterface);
    }

    Inet6Address(String string, byte[] byArray, String string2) throws UnknownHostException {
        this.holder6 = new Inet6AddressHolder(this);
        this.initstr(string, byArray, string2);
    }

    public static Inet6Address getByAddress(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null && byArray.length == 16) {
            return new Inet6Address(string, byArray, networkInterface);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("addr is of illegal length"));
    }

    public static Inet6Address getByAddress(String string, byte[] byArray, int n2) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null && byArray.length == 16) {
            return new Inet6Address(string, byArray, n2);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("addr is of illegal length"));
    }

    private void initstr(String string, byte[] byArray, String string2) throws UnknownHostException {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByName(string2);
            if (networkInterface == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("no such interface " + string2));
            }
            this.initif(string, byArray, networkInterface);
        }
        catch (SocketException socketException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("SocketException thrown" + string2));
        }
    }

    private void initif(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        int n2 = -1;
        this.holder6.init(byArray, networkInterface);
        if (byArray.length == 16) {
            n2 = 2;
        }
        this.holder.init(string, n2);
    }

    private static boolean differentLocalAddressTypes(byte[] byArray, byte[] byArray2) {
        if (Inet6Address.isLinkLocalAddress(byArray) && !Inet6Address.isLinkLocalAddress(byArray2)) {
            return false;
        }
        return !Inet6Address.isSiteLocalAddress(byArray) || Inet6Address.isSiteLocalAddress(byArray2);
    }

    private static int deriveNumericScope(byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            Inet6Address inet6Address;
            InetAddress inetAddress = (InetAddress)g.convertForCast((Object)enumeration.nextElement(), InetAddress.class);
            if (!(inetAddress instanceof Inet6Address) || !Inet6Address.differentLocalAddressTypes(byArray, (inet6Address = (Inet6Address)inetAddress).getAddress())) continue;
            return inet6Address.getScopeId();
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("no scope_id found"));
    }

    private int deriveNumericScope(String string) throws UnknownHostException {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("could not enumerate local network interfaces"));
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (!networkInterface.getName().equals(string)) continue;
            return Inet6Address.deriveNumericScope(((Inet6AddressHolder)((Object)((Object)this.holder6))).ipaddress, networkInterface);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("No matching address found for interface : " + string));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        NetworkInterface networkInterface = null;
        if (this.getClass().getClassLoader() != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SecurityException("invalid address type"));
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        byte[] byArray = (byte[])getField.get("ipaddress", null);
        int n2 = getField.get("scope_id", -1);
        boolean bl = getField.get("scope_id_set", false);
        boolean bl2 = getField.get("scope_ifname_set", false);
        String string = (String)getField.get("ifname", null);
        if (string != null && !"".equals(string)) {
            try {
                networkInterface = NetworkInterface.getByName(string);
                if (networkInterface == null) {
                    bl = false;
                    bl2 = false;
                    n2 = 0;
                } else {
                    try {
                        n2 = Inet6Address.deriveNumericScope(byArray, networkInterface);
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        if ((byArray = (byte[])byArray.clone()).length != 16) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("invalid address length: " + byArray.length));
        }
        if (this.holder.getFamily() != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("invalid address family type"));
        }
        Inet6AddressHolder inet6AddressHolder = new Inet6AddressHolder(this, byArray, n2, bl, networkInterface, bl2);
        UNSAFE.putObject((Object)this, FIELDS_OFFSET, (Object)inet6AddressHolder);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        String string = null;
        if (((Inet6AddressHolder)((Object)((Object)this.holder6))).scope_ifname_set) {
            string = ((Inet6AddressHolder)((Object)((Object)this.holder6))).scope_ifname.getName();
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("ipaddress", ((Inet6AddressHolder)((Object)((Object)this.holder6))).ipaddress);
        putField.put("scope_id", ((Inet6AddressHolder)((Object)((Object)this.holder6))).scope_id);
        putField.put("scope_id_set", ((Inet6AddressHolder)((Object)((Object)this.holder6))).scope_id_set);
        putField.put("scope_ifname_set", ((Inet6AddressHolder)((Object)((Object)this.holder6))).scope_ifname_set);
        putField.put("ifname", string);
        objectOutputStream.writeFields();
    }

    @Override
    public boolean isMulticastAddress() {
        return this.holder6.isMulticastAddress();
    }

    @Override
    public boolean isAnyLocalAddress() {
        return this.holder6.isAnyLocalAddress();
    }

    @Override
    public boolean isLoopbackAddress() {
        return this.holder6.isLoopbackAddress();
    }

    @Override
    public boolean isLinkLocalAddress() {
        return this.holder6.isLinkLocalAddress();
    }

    static boolean isLinkLocalAddress(byte[] byArray) {
        return (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 128;
    }

    @Override
    public boolean isSiteLocalAddress() {
        return this.holder6.isSiteLocalAddress();
    }

    static boolean isSiteLocalAddress(byte[] byArray) {
        return (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 192;
    }

    @Override
    public boolean isMCGlobal() {
        return this.holder6.isMCGlobal();
    }

    @Override
    public boolean isMCNodeLocal() {
        return this.holder6.isMCNodeLocal();
    }

    @Override
    public boolean isMCLinkLocal() {
        return this.holder6.isMCLinkLocal();
    }

    @Override
    public boolean isMCSiteLocal() {
        return this.holder6.isMCSiteLocal();
    }

    @Override
    public boolean isMCOrgLocal() {
        return this.holder6.isMCOrgLocal();
    }

    @Override
    public byte[] getAddress() {
        return (byte[])((Inet6AddressHolder)((Object)((Object)this.holder6))).ipaddress.clone();
    }

    public int getScopeId() {
        return ((Inet6AddressHolder)((Object)((Object)this.holder6))).scope_id;
    }

    public NetworkInterface getScopedInterface() {
        return ((Inet6AddressHolder)((Object)((Object)this.holder6))).scope_ifname;
    }

    @Override
    public String getHostAddress() {
        return this.holder6.getHostAddress();
    }

    @Override
    public int hashCode() {
        return this.holder6.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Inet6Address)) {
            return false;
        }
        Inet6Address inet6Address = (Inet6Address)object;
        return this.holder6.equals((Object)inet6Address.holder6);
    }

    public boolean isIPv4CompatibleAddress() {
        return this.holder6.isIPv4CompatibleAddress();
    }

    static String numericToTextFormat(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(39);
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i << 1] << 8 & 0xFF00 | byArray[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private static native void init();

    static {
        Inet6Address.init();
        Object[] objectArray = new ObjectStreamField[5];
        a.arrayStore((Object[])objectArray, (int)0, (Object)new ObjectStreamField("ipaddress", byte[].class));
        a.arrayStore((Object[])objectArray, (int)1, (Object)new ObjectStreamField("scope_id", Integer.TYPE));
        a.arrayStore((Object[])objectArray, (int)2, (Object)new ObjectStreamField("scope_id_set", Boolean.TYPE));
        a.arrayStore((Object[])objectArray, (int)3, (Object)new ObjectStreamField("scope_ifname_set", Boolean.TYPE));
        a.arrayStore((Object[])objectArray, (int)4, (Object)new ObjectStreamField("ifname", String.class));
        serialPersistentFields = objectArray;
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            FIELDS_OFFSET = unsafe.objectFieldOffset(ai.getCurrentClass(Inet6Address.class).getDeclaredField("holder6"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(reflectiveOperationException));
        }
    }

    private static /* synthetic */ int _jr$ig$cached_scope_id(Inet6Address inet6Address) {
        return inet6Address.cached_scope_id;
    }

    private static /* synthetic */ void _jr$ip$cached_scope_id(Inet6Address inet6Address, int n2) {
        inet6Address.cached_scope_id = n2;
    }

    private static /* synthetic */ Inet6AddressHolder _jr$ig$holder6(Inet6Address inet6Address) {
        return inet6Address.holder6;
    }

    private static /* synthetic */ void _jr$ip$holder6(Inet6Address inet6Address, Inet6AddressHolder inet6AddressHolder) {
        inet6Address.holder6 = inet6AddressHolder;
    }

    private class Inet6AddressHolder
    extends h {
        byte[] ipaddress;
        int scope_id;
        boolean scope_id_set;
        NetworkInterface scope_ifname;
        boolean scope_ifname_set;
        final /* synthetic */ Inet6Address this$0;

        private Inet6AddressHolder(Inet6Address inet6Address) {
            this.this$0 = inet6Address;
            this.scope_id = 0;
            this.scope_id_set = false;
            this.scope_ifname = null;
            this.scope_ifname_set = false;
            this.ipaddress = new byte[16];
        }

        private Inet6AddressHolder(Inet6Address inet6Address, byte[] byArray, int n2, boolean bl, NetworkInterface networkInterface, boolean bl2) {
            this.this$0 = inet6Address;
            this.scope_id = 0;
            this.scope_id_set = false;
            this.scope_ifname = null;
            this.scope_ifname_set = false;
            this.ipaddress = byArray;
            this.scope_id = n2;
            this.scope_id_set = bl;
            this.scope_ifname_set = bl2;
            this.scope_ifname = networkInterface;
        }

        void setAddr(byte[] byArray) {
            if (byArray.length == 16) {
                a.arraycopy((Object)byArray, (int)0, (Object)((Inet6AddressHolder)((Object)((Object)this))).ipaddress, (int)0, (int)16);
            }
        }

        void init(byte[] byArray, int n2) {
            this.setAddr(byArray);
            if (n2 >= 0) {
                ((Inet6AddressHolder)((Object)((Object)this))).scope_id = n2;
                ((Inet6AddressHolder)((Object)((Object)this))).scope_id_set = true;
            }
        }

        void init(byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
            this.setAddr(byArray);
            if (networkInterface != null) {
                ((Inet6AddressHolder)((Object)((Object)this))).scope_id = Inet6Address.deriveNumericScope(((Inet6AddressHolder)((Object)((Object)this))).ipaddress, networkInterface);
                ((Inet6AddressHolder)((Object)((Object)this))).scope_id_set = true;
                ((Inet6AddressHolder)((Object)((Object)this))).scope_ifname = networkInterface;
                ((Inet6AddressHolder)((Object)((Object)this))).scope_ifname_set = true;
            }
        }

        String getHostAddress() {
            String string = Inet6Address.numericToTextFormat(((Inet6AddressHolder)((Object)((Object)this))).ipaddress);
            if (((Inet6AddressHolder)((Object)((Object)this))).scope_ifname_set) {
                string = string + "%" + ((Inet6AddressHolder)((Object)((Object)this))).scope_ifname.getName();
            } else if (((Inet6AddressHolder)((Object)((Object)this))).scope_id_set) {
                string = string + "%" + ((Inet6AddressHolder)((Object)((Object)this))).scope_id;
            }
            return string;
        }

        public boolean equals(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Inet6AddressHolder.class) instanceof Inet6AddressHolder)) {
                return false;
            }
            Inet6AddressHolder inet6AddressHolder = (Inet6AddressHolder)((Object)g.convertForCast((Object)object, Inet6AddressHolder.class));
            for (int i = 0; i < 16; ++i) {
                if (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[i] == ((Inet6AddressHolder)((Object)((Object)inet6AddressHolder))).ipaddress[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (((Inet6AddressHolder)((Object)((Object)this))).ipaddress != null) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < 16) {
                    int n4 = 0;
                    for (int i = 0; i < 4 && n3 < 16; ++i, ++n3) {
                        n4 = (n4 << 8) + ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[n3];
                    }
                    n2 += n4;
                }
                return n2;
            }
            return 0;
        }

        boolean isIPv4CompatibleAddress() {
            return ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[1] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[2] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[3] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[4] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[5] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[6] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[7] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[8] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[9] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[10] == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[11] == 0;
        }

        boolean isMulticastAddress() {
            return (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] & 0xFF) == 255;
        }

        boolean isAnyLocalAddress() {
            byte by = 0;
            for (int i = 0; i < 16; ++i) {
                by = (byte)(by | ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[i]);
            }
            return by == 0;
        }

        boolean isLoopbackAddress() {
            byte by = 0;
            for (int i = 0; i < 15; ++i) {
                by = (byte)(by | ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[i]);
            }
            return by == 0 && ((Inet6AddressHolder)((Object)((Object)this))).ipaddress[15] == 1;
        }

        boolean isLinkLocalAddress() {
            return (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] & 0xFF) == 254 && (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[1] & 0xC0) == 128;
        }

        boolean isSiteLocalAddress() {
            return (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] & 0xFF) == 254 && (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[1] & 0xC0) == 192;
        }

        boolean isMCGlobal() {
            return (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] & 0xFF) == 255 && (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[1] & 0xF) == 14;
        }

        boolean isMCNodeLocal() {
            return (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] & 0xFF) == 255 && (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[1] & 0xF) == 1;
        }

        boolean isMCLinkLocal() {
            return (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] & 0xFF) == 255 && (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[1] & 0xF) == 2;
        }

        boolean isMCSiteLocal() {
            return (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] & 0xFF) == 255 && (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[1] & 0xF) == 5;
        }

        boolean isMCOrgLocal() {
            return (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[0] & 0xFF) == 255 && (((Inet6AddressHolder)((Object)((Object)this))).ipaddress[1] & 0xF) == 8;
        }

        static /* synthetic */ void _jr$ip$ipaddress(Object object, byte[] byArray) {
            ((Inet6AddressHolder)((Object)object)).ipaddress = byArray;
        }

        static /* synthetic */ Inet6Address _jr$ig$this$0(Object object) {
            return ((Inet6AddressHolder)((Object)object)).this$0;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, Inet6Address inet6Address) {
            ((Inet6AddressHolder)((Object)object)).this$0 = inet6Address;
        }

        protected /* synthetic */ Inet6AddressHolder(h h2) {
            super(h2);
        }
    }
}

