/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import sun.misc.Unsafe;
import sun.net.InetAddressCachePolicy;
import sun.net.spi.nameservice.NameService;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class InetAddress
extends h
implements Serializable {
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static transient boolean preferIPv6Address;
    final transient InetAddressHolder holder;
    private static List<NameService> nameServices;
    private transient String canonicalHostName;
    private static final long serialVersionUID = 3286316764910316507L;
    private static Cache addressCache;
    private static Cache negativeCache;
    private static boolean addressCacheInit;
    static InetAddress[] unknown_array;
    static InetAddressImpl impl;
    private static final HashMap<String, Void> lookupTable;
    private static InetAddress cachedLocalHost;
    private static long cacheTime;
    private static final long maxCacheTime = 5000L;
    private static final Object cacheLock;
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;
    private static final ObjectStreamField[] serialPersistentFields;

    InetAddressHolder holder() {
        return ((InetAddress)this).holder;
    }

    InetAddress() {
        this.canonicalHostName = null;
        this.holder = new InetAddressHolder();
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.holder().getHostName(), this.holder().getAddress());
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isReachable(int n2) throws IOException {
        return this.isReachable(null, 0, n2);
    }

    public boolean isReachable(NetworkInterface networkInterface, int n2, int n3) throws IOException {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("ttl can't be negative"));
        }
        if (n3 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("timeout can't be negative"));
        }
        return impl.isReachable(this, n3, networkInterface, n2);
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean bl) {
        if (this.holder().getHostName() == null) {
            ((InetAddressHolder)((Object)((Object)this.holder()))).hostName = InetAddress.getHostFromNameService(this, bl);
        }
        return this.holder().getHostName();
    }

    public String getCanonicalHostName() {
        if (this.canonicalHostName == null) {
            this.canonicalHostName = InetAddress.getHostFromNameService(this, true);
        }
        return this.canonicalHostName;
    }

    private static String getHostFromNameService(InetAddress inetAddress, boolean bl) {
        String string = null;
        Iterator<NameService> iterator = nameServices.iterator();
        while (iterator.hasNext()) {
            NameService nameService = (NameService)g.convertForCast((Object)iterator.next(), NameService.class);
            try {
                Object[] objectArray;
                string = nameService.getHostByAddr(inetAddress.getAddress());
                if (bl && (objectArray = System.getSecurityManager()) != null) {
                    objectArray.checkConnect(string, -1);
                }
                objectArray = InetAddress.getAllByName0(string, bl);
                boolean bl2 = false;
                if (objectArray != null) {
                    for (int i = 0; !bl2 && i < a.arrayLength((Object[])objectArray); ++i) {
                        bl2 = inetAddress.equals((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), InetAddress.class));
                    }
                }
                if (!bl2) {
                    string = inetAddress.getHostAddress();
                    return string;
                }
                break;
            }
            catch (SecurityException securityException) {
                string = inetAddress.getHostAddress();
                break;
            }
            catch (UnknownHostException unknownHostException) {
                string = inetAddress.getHostAddress();
            }
        }
        return string;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        String string = this.holder().getHostName();
        return (string != null ? string : "") + "/" + this.getHostAddress();
    }

    private static void cacheInitIfNeeded() {
        if (!$assertionsDisabled && !Thread.holdsLock(ah.getMonitor((Object)((Object)addressCache)))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (addressCacheInit) {
            return;
        }
        unknown_array = new InetAddress[1];
        a.arrayStore((Object[])unknown_array, (int)0, (Object)impl.anyLocalAddress());
        addressCache.put(impl.anyLocalAddress().getHostName(), unknown_array);
        addressCacheInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAddresses(String string, InetAddress[] inetAddressArray, boolean bl) {
        string = string.toLowerCase();
        Object object = ah.getMonitor((Object)((Object)addressCache));
        synchronized (object) {
            try {
                InetAddress.cacheInitIfNeeded();
                if (bl) {
                    addressCache.put(string, inetAddressArray);
                } else {
                    negativeCache.put(string, inetAddressArray);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress[] getCachedAddresses(String string) {
        string = string.toLowerCase();
        Object object = ah.getMonitor((Object)((Object)addressCache));
        synchronized (object) {
            try {
                InetAddress.cacheInitIfNeeded();
                CacheEntry cacheEntry = addressCache.get(string);
                if (cacheEntry == null) {
                    cacheEntry = negativeCache.get(string);
                }
                if (cacheEntry != null) {
                    return cacheEntry.addresses;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return null;
    }

    private static NameService createNSProvider(String string) {
        if (string == null) {
            return null;
        }
        NameService nameService = null;
        if (string.equals("default")) {
            nameService = new NameService(){

                public InetAddress[] lookupAllHostAddr(String string) throws UnknownHostException {
                    return impl.lookupAllHostAddr(string);
                }

                public String getHostByAddr(byte[] byArray) throws UnknownHostException {
                    return impl.getHostByAddr(byArray);
                }
            };
        } else {
            String string2 = string;
            try {
                nameService = (NameService)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), NameService.class);
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
        return nameService;
    }

    public static InetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null) {
            if (byArray.length == 4) {
                return new Inet4Address(string, byArray);
            }
            if (byArray.length == 16) {
                byte[] byArray2 = IPAddressUtil.convertFromIPv4MappedAddress(byArray);
                if (byArray2 != null) {
                    return new Inet4Address(string, byArray2);
                }
                return new Inet6Address(string, byArray);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("addr is of illegal length"));
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        return (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])InetAddress.getAllByName(string), (int)0), InetAddress.class);
    }

    private static InetAddress getByName(String string, InetAddress inetAddress) throws UnknownHostException {
        return (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])InetAddress.getAllByName(string, inetAddress), (int)0), InetAddress.class);
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string, null);
    }

    private static InetAddress[] getAllByName(String string, InetAddress inetAddress) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            Object[] objectArray = new InetAddress[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)impl.loopbackAddress());
            return objectArray;
        }
        boolean bl = false;
        if (string.charAt(0) == '[') {
            if (string.length() > 2 && string.charAt(string.length() - 1) == ']') {
                string = string.substring(1, string.length() - 1);
                bl = true;
            } else {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException(string + ": invalid IPv6 address"));
            }
        }
        if (Character.digit(string.charAt(0), 16) != -1 || string.charAt(0) == ':') {
            byte[] byArray = null;
            int n2 = -1;
            String string2 = null;
            byArray = IPAddressUtil.textToNumericFormatV4(string);
            if (byArray == null) {
                int n3 = string.indexOf("%");
                if (n3 != -1 && (n2 = InetAddress.checkNumericZone(string)) == -1) {
                    string2 = string.substring(n3 + 1);
                }
                byArray = IPAddressUtil.textToNumericFormatV6(string);
            } else if (bl) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("[" + string + "]"));
            }
            Object[] objectArray = new InetAddress[1];
            if (byArray != null) {
                if (byArray.length == 4) {
                    a.arrayStore((Object[])objectArray, (int)0, (Object)new Inet4Address(null, byArray));
                } else if (string2 != null) {
                    a.arrayStore((Object[])objectArray, (int)0, (Object)new Inet6Address(null, byArray, string2));
                } else {
                    a.arrayStore((Object[])objectArray, (int)0, (Object)new Inet6Address(null, byArray, n2));
                }
                return objectArray;
            }
        } else if (bl) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException("[" + string + "]"));
        }
        return InetAddress.getAllByName0(string, inetAddress, true);
    }

    public static InetAddress getLoopbackAddress() {
        return impl.loopbackAddress();
    }

    private static int checkNumericZone(String string) throws UnknownHostException {
        int n2 = string.indexOf(37);
        int n3 = string.length();
        int n4 = 0;
        if (n2 == -1) {
            return -1;
        }
        for (int i = n2 + 1; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == ']') {
                if (i != n2 + 1) break;
                return -1;
            }
            int n5 = Character.digit(c, 10);
            if (n5 < 0) {
                return -1;
            }
            n4 = n4 * 10 + n5;
        }
        return n4;
    }

    private static InetAddress[] getAllByName0(String string) throws UnknownHostException {
        return InetAddress.getAllByName0(string, true);
    }

    static InetAddress[] getAllByName0(String string, boolean bl) throws UnknownHostException {
        return InetAddress.getAllByName0(string, null, bl);
    }

    private static InetAddress[] getAllByName0(String string, InetAddress inetAddress, boolean bl) throws UnknownHostException {
        InetAddress[] inetAddressArray;
        if (bl && (inetAddressArray = System.getSecurityManager()) != null) {
            inetAddressArray.checkConnect(string, -1);
        }
        if ((inetAddressArray = InetAddress.getCachedAddresses(string)) == null) {
            inetAddressArray = InetAddress.getAddressesFromNameService(string, inetAddress);
        }
        if (!f.ifAcmp((Object)inetAddressArray, (Object)unknown_array)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException(string));
        }
        return (InetAddress[])g.convertForCast((Object)a.cloneArray((Object)inetAddressArray), InetAddress[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress[] getAddressesFromNameService(String string, InetAddress inetAddress) throws UnknownHostException {
        Object[] objectArray = null;
        boolean bl = false;
        UnknownHostException unknownHostException = null;
        objectArray = InetAddress.checkLookupTable(string);
        if (objectArray == null) {
            block11: {
                try {
                    Object object;
                    Iterator<NameService> iterator = nameServices.iterator();
                    while (iterator.hasNext()) {
                        object = (NameService)g.convertForCast((Object)iterator.next(), NameService.class);
                        try {
                            objectArray = object.lookupAllHostAddr(string);
                            bl = true;
                            break;
                        }
                        catch (UnknownHostException unknownHostException2) {
                            if (string.equalsIgnoreCase("localhost")) {
                                Object[] objectArray2;
                                Object[] objectArray3 = new InetAddress[1];
                                a.arrayStore((Object[])objectArray3, (int)0, (Object)impl.loopbackAddress());
                                objectArray = objectArray2 = objectArray3;
                                bl = true;
                                break;
                            }
                            objectArray = unknown_array;
                            bl = false;
                            unknownHostException = unknownHostException2;
                        }
                    }
                    if (inetAddress != null && a.arrayLength((Object[])objectArray) > 1 && !((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), InetAddress.class)).equals(inetAddress)) {
                        int n2;
                        for (n2 = 1; n2 < a.arrayLength((Object[])objectArray) && !((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), InetAddress.class)).equals(inetAddress); ++n2) {
                        }
                        if (n2 < a.arrayLength((Object[])objectArray)) {
                            InetAddress inetAddress2 = inetAddress;
                            for (int i = 0; i < n2; ++i) {
                                object = (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), InetAddress.class);
                                a.arrayStore((Object[])objectArray, (int)i, (Object)inetAddress2);
                                inetAddress2 = object;
                            }
                            a.arrayStore((Object[])objectArray, (int)n2, (Object)inetAddress2);
                        }
                    }
                    InetAddress.cacheAddresses(string, (InetAddress[])objectArray, bl);
                    if (bl || unknownHostException == null) break block11;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion(unknownHostException);
                }
                catch (Throwable throwable) {
                    InetAddress.updateLookupTable(string);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            InetAddress.updateLookupTable(string);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress[] checkLookupTable(String string) {
        InetAddress[] inetAddressArray = ah.getMonitor(lookupTable);
        synchronized (inetAddressArray) {
            try {
                if (!lookupTable.containsKey(string)) {
                    lookupTable.put(string, null);
                    return null;
                }
                while (lookupTable.containsKey(string)) {
                    try {
                        ah.getMonitor(lookupTable).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        inetAddressArray = InetAddress.getCachedAddresses(string);
        if (inetAddressArray == null) {
            Object object = ah.getMonitor(lookupTable);
            synchronized (object) {
                try {
                    lookupTable.put(string, null);
                    return null;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return inetAddressArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookupTable(String string) {
        Object object = ah.getMonitor(lookupTable);
        synchronized (object) {
            try {
                lookupTable.remove(string);
                ah.getMonitor(lookupTable).notifyAll();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        return InetAddress.getByAddress(null, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            String string = impl.getLocalHostName();
            if (securityManager != null) {
                securityManager.checkConnect(string, -1);
            }
            if (string.equals("localhost")) {
                return impl.loopbackAddress();
            }
            InetAddress inetAddress = null;
            Object object = ah.getMonitor((Object)cacheLock);
            synchronized (object) {
                try {
                    long l = System.currentTimeMillis();
                    if (cachedLocalHost != null) {
                        if (l - cacheTime < 5000L) {
                            inetAddress = cachedLocalHost;
                        } else {
                            cachedLocalHost = null;
                        }
                    }
                    if (inetAddress == null) {
                        Object[] objectArray;
                        try {
                            objectArray = InetAddress.getAddressesFromNameService(string, null);
                        }
                        catch (UnknownHostException unknownHostException) {
                            UnknownHostException unknownHostException2 = new UnknownHostException(string + ": " + unknownHostException.getMessage());
                            unknownHostException2.initCause(unknownHostException);
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)unknownHostException2);
                        }
                        cachedLocalHost = (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), InetAddress.class);
                        cacheTime = l;
                        inetAddress = (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), InetAddress.class);
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            return inetAddress;
        }
        catch (SecurityException securityException) {
            return impl.loopbackAddress();
        }
    }

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static InetAddressImpl loadImpl(String string) {
        Object var1_1 = null;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        try {
            var1_1 = ai.getCurrentClass(Class.forName("java.net." + string2 + string)).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access class: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        if (var1_1 == null) {
            try {
                var1_1 = ai.getCurrentClass(Class.forName(string)).newInstance();
            }
            catch (Exception exception) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("System property impl.prefix incorrect"));
            }
        }
        return (InetAddressImpl)g.convertForCast(var1_1, InetAddressImpl.class);
    }

    private void readObjectNoData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SecurityException("invalid address type"));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SecurityException("invalid address type"));
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("hostName", null);
        int n2 = getField.get("address", 0);
        int n3 = getField.get("family", 0);
        InetAddressHolder inetAddressHolder = new InetAddressHolder(string, n2, n3);
        UNSAFE.putObject((Object)this, FIELDS_OFFSET, (Object)inetAddressHolder);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass().getClassLoader() != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SecurityException("invalid address type"));
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("hostName", ((InetAddressHolder)((Object)((Object)this.holder()))).hostName);
        putField.put("address", ((InetAddressHolder)((Object)((Object)this.holder()))).address);
        putField.put("family", ((InetAddressHolder)((Object)((Object)this.holder()))).family);
        objectOutputStream.writeFields();
    }

    static {
        NameService nameService;
        preferIPv6Address = false;
        nameServices = null;
        preferIPv6Address = (Boolean)g.convertForCast(AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses")), Boolean.class);
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        InetAddress.init();
        addressCache = new Cache(Cache.Type.Positive);
        negativeCache = new Cache(Cache.Type.Negative);
        addressCacheInit = false;
        lookupTable = new HashMap();
        impl = InetAddressImplFactory.create();
        Object object = null;
        String string = "sun.net.spi.nameservice.provider.";
        int n2 = 1;
        nameServices = new ArrayList<NameService>();
        object = (String)AccessController.doPrivileged(new GetPropertyAction(string + n2));
        while (object != null) {
            nameService = InetAddress.createNSProvider((String)object);
            if (nameService != null) {
                nameServices.add(nameService);
            }
            object = (String)AccessController.doPrivileged(new GetPropertyAction(string + ++n2));
        }
        if (nameServices.size() == 0) {
            nameService = InetAddress.createNSProvider("default");
            nameServices.add(nameService);
        }
        cachedLocalHost = null;
        cacheTime = 0L;
        cacheLock = new Object();
        try {
            object = Unsafe.getUnsafe();
            FIELDS_OFFSET = ((Unsafe)((Object)object)).objectFieldOffset(ai.getCurrentClass(InetAddress.class).getDeclaredField("holder"));
            UNSAFE = object;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(reflectiveOperationException));
        }
        Object[] objectArray = new ObjectStreamField[3];
        a.arrayStore((Object[])objectArray, (int)0, (Object)new ObjectStreamField("hostName", String.class));
        a.arrayStore((Object[])objectArray, (int)1, (Object)new ObjectStreamField("address", Integer.TYPE));
        a.arrayStore((Object[])objectArray, (int)2, (Object)new ObjectStreamField("family", Integer.TYPE));
        serialPersistentFields = objectArray;
    }

    static /* synthetic */ void _jr$ip$holder(Object object, InetAddressHolder inetAddressHolder) {
        ((InetAddress)object).holder = inetAddressHolder;
    }

    protected /* synthetic */ InetAddress(h h2) {
        super(h2);
    }

    static final class Cache
    extends h {
        private LinkedHashMap<String, CacheEntry> cache;
        private Type type;

        public Cache(Type type) {
            this.type = type;
            this.cache = new LinkedHashMap();
        }

        private int getPolicy() {
            if (!f.ifAcmp((Object)((Object)this.type), (Object)((Object)Type.Positive))) {
                return InetAddressCachePolicy.get();
            }
            return InetAddressCachePolicy.getNegative();
        }

        public Cache put(String string, InetAddress[] inetAddressArray) {
            int n2 = this.getPolicy();
            if (n2 == 0) {
                return this;
            }
            if (n2 != -1) {
                String string22;
                CacheEntry cacheEntry;
                LinkedList<String> linkedList = new LinkedList<String>();
                long l = System.currentTimeMillis();
                Iterator<Object> iterator = this.cache.keySet().iterator();
                while (iterator.hasNext() && ((CacheEntry)((Object)((Object)(cacheEntry = (CacheEntry)((Object)g.convertForCast((Object)((Object)this.cache.get(string22 = (String)iterator.next())), CacheEntry.class)))))).expiration >= 0L && ((CacheEntry)((Object)((Object)cacheEntry))).expiration < l) {
                    linkedList.add(string22);
                }
                for (String string22 : linkedList) {
                    this.cache.remove(string22);
                }
            }
            long l = n2 == -1 ? -1L : System.currentTimeMillis() + (long)(n2 * 1000);
            CacheEntry cacheEntry = new CacheEntry(inetAddressArray, l);
            this.cache.put(string, cacheEntry);
            return this;
        }

        public CacheEntry get(String string) {
            int n2 = this.getPolicy();
            if (n2 == 0) {
                return null;
            }
            CacheEntry cacheEntry = (CacheEntry)((Object)g.convertForCast((Object)((Object)this.cache.get(string)), CacheEntry.class));
            if (cacheEntry != null && n2 != -1 && ((CacheEntry)((Object)((Object)cacheEntry))).expiration >= 0L && ((CacheEntry)((Object)((Object)cacheEntry))).expiration < System.currentTimeMillis()) {
                this.cache.remove(string);
                cacheEntry = null;
            }
            return cacheEntry;
        }

        private static /* synthetic */ LinkedHashMap _jr$ig$cache(Cache cache) {
            return cache.cache;
        }

        private static /* synthetic */ void _jr$ip$cache(Cache cache, LinkedHashMap linkedHashMap) {
            cache.cache = linkedHashMap;
        }

        private static /* synthetic */ Type _jr$ig$type(Cache cache) {
            return cache.type;
        }

        private static /* synthetic */ void _jr$ip$type(Cache cache, Type type) {
            cache.type = type;
        }

        static enum Type {
            Positive,
            Negative;

        }
    }

    static final class CacheEntry
    extends h {
        InetAddress[] addresses;
        long expiration;

        CacheEntry(InetAddress[] inetAddressArray, long l) {
            this.addresses = inetAddressArray;
            this.expiration = l;
        }

        static /* synthetic */ InetAddress[] _jr$ig$addresses(Object object) {
            return ((CacheEntry)((Object)object)).addresses;
        }

        static /* synthetic */ void _jr$ip$addresses(Object object, InetAddress[] inetAddressArray) {
            ((CacheEntry)((Object)object)).addresses = inetAddressArray;
        }

        static /* synthetic */ void _jr$ip$expiration(Object object, long l) {
            ((CacheEntry)((Object)object)).expiration = l;
        }
    }

    static class InetAddressHolder
    extends h {
        String hostName;
        int address;
        int family;

        InetAddressHolder() {
        }

        InetAddressHolder(String string, int n2, int n3) {
            this.hostName = string;
            this.address = n2;
            this.family = n3;
        }

        void init(String string, int n2) {
            ((InetAddressHolder)((Object)((Object)this))).hostName = string;
            if (n2 != -1) {
                ((InetAddressHolder)((Object)((Object)this))).family = n2;
            }
        }

        String getHostName() {
            return ((InetAddressHolder)((Object)((Object)this))).hostName;
        }

        int getAddress() {
            return ((InetAddressHolder)((Object)((Object)this))).address;
        }

        int getFamily() {
            return ((InetAddressHolder)((Object)((Object)this))).family;
        }

        static /* synthetic */ void _jr$ip$address(Object object, int n2) {
            ((InetAddressHolder)((Object)object)).address = n2;
        }

        protected /* synthetic */ InetAddressHolder(h h2) {
            super(h2);
        }
    }
}

