/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import sun.misc.Unsafe;

public class InetSocketAddress
extends SocketAddress {
    private final transient InetSocketAddressHolder holder;
    private static final long serialVersionUID = 5076001401234631237L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;

    private static int checkPort(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("port out of range:" + n2));
        }
        return n2;
    }

    private static String checkHost(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("hostname can't be null"));
        }
        return string;
    }

    public InetSocketAddress(int n2) {
        this(InetAddress.anyLocalAddress(), n2);
    }

    public InetSocketAddress(InetAddress inetAddress, int n2) {
        this.holder = new InetSocketAddressHolder(null, inetAddress == null ? InetAddress.anyLocalAddress() : inetAddress, InetSocketAddress.checkPort(n2));
    }

    public InetSocketAddress(String string, int n2) {
        InetSocketAddress.checkHost(string);
        InetAddress inetAddress = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            string2 = string;
        }
        this.holder = new InetSocketAddressHolder(string2, inetAddress, InetSocketAddress.checkPort(n2));
    }

    private InetSocketAddress(int n2, String string) {
        this.holder = new InetSocketAddressHolder(string, null, n2);
    }

    public static InetSocketAddress createUnresolved(String string, int n2) {
        return new InetSocketAddress(InetSocketAddress.checkPort(n2), InetSocketAddress.checkHost(string));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("hostname", InetSocketAddressHolder._jr$ig$hostname(this.holder));
        putField.put("addr", InetSocketAddressHolder._jr$ig$addr(this.holder));
        putField.put("port", InetSocketAddressHolder._jr$ig$port(this.holder));
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("hostname", null);
        InetAddress inetAddress = (InetAddress)g.convertForCast((Object)getField.get("addr", null), InetAddress.class);
        int n2 = getField.get("port", -1);
        InetSocketAddress.checkPort(n2);
        if (string == null && inetAddress == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("hostname and addr can't both be null"));
        }
        InetSocketAddressHolder inetSocketAddressHolder = new InetSocketAddressHolder(string, inetAddress, n2);
        UNSAFE.putObject((Object)this, FIELDS_OFFSET, (Object)inetSocketAddressHolder);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("Stream data required"));
    }

    public final int getPort() {
        return this.holder.getPort();
    }

    public final InetAddress getAddress() {
        return this.holder.getAddress();
    }

    public final String getHostName() {
        return this.holder.getHostName();
    }

    public final String getHostString() {
        return this.holder.getHostString();
    }

    public final boolean isUnresolved() {
        return this.holder.isUnresolved();
    }

    public String toString() {
        return this.holder.toString();
    }

    public final boolean equals(Object object) {
        if (object == null || !(g.convertForInstanceOf((Object)object, InetSocketAddress.class) instanceof InetSocketAddress)) {
            return false;
        }
        return this.holder.equals((Object)((InetSocketAddress)g.convertForCast((Object)object, InetSocketAddress.class)).holder);
    }

    public final int hashCode() {
        return this.holder.hashCode();
    }

    static {
        Object[] objectArray = new ObjectStreamField[3];
        a.arrayStore((Object[])objectArray, (int)0, (Object)new ObjectStreamField("hostname", String.class));
        a.arrayStore((Object[])objectArray, (int)1, (Object)new ObjectStreamField("addr", InetAddress.class));
        a.arrayStore((Object[])objectArray, (int)2, (Object)new ObjectStreamField("port", Integer.TYPE));
        serialPersistentFields = objectArray;
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            FIELDS_OFFSET = unsafe.objectFieldOffset(ai.getCurrentClass(InetSocketAddress.class).getDeclaredField("holder"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(reflectiveOperationException));
        }
    }

    private static /* synthetic */ void _jr$ip$holder(InetSocketAddress inetSocketAddress, InetSocketAddressHolder inetSocketAddressHolder) {
        inetSocketAddress.holder = inetSocketAddressHolder;
    }

    protected /* synthetic */ InetSocketAddress(h h2) {
        super(h2);
    }

    private static class InetSocketAddressHolder
    extends h {
        private String hostname;
        private InetAddress addr;
        private int port;

        private InetSocketAddressHolder(String string, InetAddress inetAddress, int n2) {
            this.hostname = string;
            this.addr = inetAddress;
            this.port = n2;
        }

        private int getPort() {
            return this.port;
        }

        private InetAddress getAddress() {
            return this.addr;
        }

        private String getHostName() {
            if (this.hostname != null) {
                return this.hostname;
            }
            if (this.addr != null) {
                return this.addr.getHostName();
            }
            return null;
        }

        private String getHostString() {
            if (this.hostname != null) {
                return this.hostname;
            }
            if (this.addr != null) {
                if (this.addr.holder().getHostName() != null) {
                    return this.addr.holder().getHostName();
                }
                return this.addr.getHostAddress();
            }
            return null;
        }

        private boolean isUnresolved() {
            return this.addr == null;
        }

        public String toString() {
            if (this.isUnresolved()) {
                return this.hostname + ":" + this.port;
            }
            return this.addr.toString() + ":" + this.port;
        }

        public final boolean equals(Object object) {
            if (object == null || !(g.convertForInstanceOf((Object)object, InetSocketAddressHolder.class) instanceof InetSocketAddressHolder)) {
                return false;
            }
            InetSocketAddressHolder inetSocketAddressHolder = (InetSocketAddressHolder)((Object)g.convertForCast((Object)object, InetSocketAddressHolder.class));
            boolean bl = this.addr != null ? this.addr.equals(inetSocketAddressHolder.addr) : (this.hostname != null ? inetSocketAddressHolder.addr == null && this.hostname.equalsIgnoreCase(inetSocketAddressHolder.hostname) : inetSocketAddressHolder.addr == null && inetSocketAddressHolder.hostname == null);
            return bl && this.port == inetSocketAddressHolder.port;
        }

        public final int hashCode() {
            if (this.addr != null) {
                return this.addr.hashCode() + this.port;
            }
            if (this.hostname != null) {
                return this.hostname.toLowerCase().hashCode() + this.port;
            }
            return this.port;
        }

        private static /* synthetic */ void _jr$ip$hostname(InetSocketAddressHolder inetSocketAddressHolder, String string) {
            inetSocketAddressHolder.hostname = string;
        }

        private static /* synthetic */ void _jr$ip$addr(InetSocketAddressHolder inetSocketAddressHolder, InetAddress inetAddress) {
            inetSocketAddressHolder.addr = inetAddress;
        }

        private static /* synthetic */ void _jr$ip$port(InetSocketAddressHolder inetSocketAddressHolder, int n2) {
            inetSocketAddressHolder.port = n2;
        }

        protected /* synthetic */ InetSocketAddressHolder(h h2) {
            super(h2);
        }
    }
}

