/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.net.DefaultInterface;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetPermission;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import sun.security.action.LoadLibraryAction;

public final class NetworkInterface
extends h {
    private String name;
    private String displayName;
    private int index;
    private InetAddress[] addrs;
    private InterfaceAddress[] bindings;
    private NetworkInterface[] childs;
    private NetworkInterface parent = null;
    private boolean virtual = false;
    private static final NetworkInterface defaultInterface;
    private static final int defaultIndex;

    NetworkInterface() {
    }

    NetworkInterface(String string, int n, InetAddress[] inetAddressArray) {
        this.name = string;
        this.index = n;
        this.addrs = inetAddressArray;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        /*
         * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
         */
        class CheckedAddresses
        extends h
        implements Enumeration {
            private int i;
            private int count;
            private InetAddress[] local_addrs;
            final /* synthetic */ NetworkInterface this$0;

            CheckedAddresses(NetworkInterface networkInterface) {
                this.this$0 = networkInterface;
                this.i = 0;
                this.count = 0;
                this.local_addrs = new InetAddress[a.arrayLength((Object[])networkInterface.addrs)];
                boolean bl = true;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkPermission(new NetPermission("getNetworkInformation"));
                    }
                    catch (SecurityException securityException) {
                        bl = false;
                    }
                }
                for (int i = 0; i < a.arrayLength((Object[])networkInterface.addrs); ++i) {
                    try {
                        if (securityManager != null && !bl) {
                            securityManager.checkConnect(((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])networkInterface.addrs, (int)i), InetAddress.class)).getHostAddress(), -1);
                        }
                        a.arrayStore((Object[])this.local_addrs, (int)this.count++, (Object)((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])networkInterface.addrs, (int)i), InetAddress.class)));
                        continue;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }

            public InetAddress nextElement() {
                if (this.i < this.count) {
                    Object[] objectArray = this.local_addrs;
                    CheckedAddresses checkedAddresses = this;
                    int n = checkedAddresses.i;
                    checkedAddresses.i = n + 1;
                    return (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n), InetAddress.class);
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }

            @Override
            public boolean hasMoreElements() {
                return this.i < this.count;
            }

            private static /* synthetic */ void _jr$ip$count(CheckedAddresses checkedAddresses, int n) {
                checkedAddresses.count = n;
            }

            private static /* synthetic */ void _jr$ip$local_addrs(CheckedAddresses checkedAddresses, InetAddress[] inetAddressArray) {
                checkedAddresses.local_addrs = inetAddressArray;
            }

            static /* synthetic */ NetworkInterface _jr$ig$this$0(Object object) {
                return ((CheckedAddresses)object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, NetworkInterface networkInterface) {
                ((CheckedAddresses)object).this$0 = networkInterface;
            }

            protected /* synthetic */ CheckedAddresses(h h2) {
                super(h2);
            }
        }
        return new CheckedAddresses(this);
    }

    public List<InterfaceAddress> getInterfaceAddresses() {
        ArrayList<InterfaceAddress> arrayList = new ArrayList<InterfaceAddress>(1);
        SecurityManager securityManager = System.getSecurityManager();
        for (int i = 0; i < a.arrayLength((Object[])this.bindings); ++i) {
            try {
                if (securityManager != null) {
                    securityManager.checkConnect(((InterfaceAddress)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.bindings, (int)i), InterfaceAddress.class))).getAddress().getHostAddress(), -1);
                }
                arrayList.add((InterfaceAddress)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.bindings, (int)i), InterfaceAddress.class)));
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public Enumeration<NetworkInterface> getSubInterfaces() {
        return new SubIFs(this);
    }

    public NetworkInterface getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDisplayName() {
        return "".equals(this.displayName) ? null : this.displayName;
    }

    public static NetworkInterface getByName(String string) throws SocketException {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return NetworkInterface.getByName0(string);
    }

    public static NetworkInterface getByIndex(int n) throws SocketException {
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Interface index can't be negative"));
        }
        return NetworkInterface.getByIndex0(n);
    }

    public static NetworkInterface getByInetAddress(InetAddress inetAddress) throws SocketException {
        if (inetAddress == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!(g.convertForInstanceOf((Object)inetAddress, Inet4Address.class) instanceof Inet4Address) && !(g.convertForInstanceOf((Object)inetAddress, Inet6Address.class) instanceof Inet6Address)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid address type"));
        }
        return NetworkInterface.getByInetAddress0(inetAddress);
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        final NetworkInterface[] networkInterfaceArray = NetworkInterface.getAll();
        if (networkInterfaceArray == null) {
            return null;
        }
        return new Enumeration(){
            private int i;
            {
                this.i = 0;
            }

            public NetworkInterface nextElement() {
                if (networkInterfaceArray != null && this.i < networkInterfaceArray.length) {
                    NetworkInterface networkInterface = networkInterfaceArray[this.i++];
                    return networkInterface;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }

            @Override
            public boolean hasMoreElements() {
                return networkInterfaceArray != null && this.i < networkInterfaceArray.length;
            }

            private static /* synthetic */ int _jr$ig$i(1 var0) {
                return var0.i;
            }

            private static /* synthetic */ void _jr$ip$i(1 var0, int n) {
                var0.i = n;
            }

            static /* synthetic */ NetworkInterface[] _jr$ig$val$netifs(Object object) {
                return (object).networkInterfaceArray;
            }

            static /* synthetic */ void _jr$ip$val$netifs(Object object, NetworkInterface[] networkInterfaceArray2) {
                (object).networkInterfaceArray = networkInterfaceArray2;
            }
        };
    }

    private static native NetworkInterface[] getAll() throws SocketException;

    private static native NetworkInterface getByName0(String var0) throws SocketException;

    private static native NetworkInterface getByIndex0(int var0) throws SocketException;

    private static native NetworkInterface getByInetAddress0(InetAddress var0) throws SocketException;

    public boolean isUp() throws SocketException {
        return NetworkInterface.isUp0(this.name, this.index);
    }

    public boolean isLoopback() throws SocketException {
        return NetworkInterface.isLoopback0(this.name, this.index);
    }

    public boolean isPointToPoint() throws SocketException {
        return NetworkInterface.isP2P0(this.name, this.index);
    }

    public boolean supportsMulticast() throws SocketException {
        return NetworkInterface.supportsMulticast0(this.name, this.index);
    }

    public byte[] getHardwareAddress() throws SocketException {
        block4: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkPermission(new NetPermission("getNetworkInformation"));
                }
                catch (SecurityException securityException) {
                    if (this.getInetAddresses().hasMoreElements()) break block4;
                    return null;
                }
            }
        }
        Object[] objectArray = this.addrs;
        int n = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n; ++i) {
            InetAddress inetAddress = (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), InetAddress.class);
            if (!(g.convertForInstanceOf((Object)inetAddress, Inet4Address.class) instanceof Inet4Address)) continue;
            return NetworkInterface.getMacAddr0(((Inet4Address)g.convertForCast((Object)inetAddress, Inet4Address.class)).getAddress(), this.name, this.index);
        }
        return NetworkInterface.getMacAddr0(null, this.name, this.index);
    }

    public int getMTU() throws SocketException {
        return NetworkInterface.getMTU0(this.name, this.index);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    private static native boolean isUp0(String var0, int var1) throws SocketException;

    private static native boolean isLoopback0(String var0, int var1) throws SocketException;

    private static native boolean supportsMulticast0(String var0, int var1) throws SocketException;

    private static native boolean isP2P0(String var0, int var1) throws SocketException;

    private static native byte[] getMacAddr0(byte[] var0, String var1, int var2) throws SocketException;

    private static native int getMTU0(String var0, int var1) throws SocketException;

    public boolean equals(Object object) {
        if (!(object instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface networkInterface = (NetworkInterface)((Object)object);
        if (this.name != null ? !this.name.equals(networkInterface.name) : networkInterface.name != null) {
            return false;
        }
        if (this.addrs == null) {
            return networkInterface.addrs == null;
        }
        if (networkInterface.addrs == null) {
            return false;
        }
        if (a.arrayLength((Object[])this.addrs) != a.arrayLength((Object[])networkInterface.addrs)) {
            return false;
        }
        Object[] objectArray = networkInterface.addrs;
        int n = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int k = 0; k < n; ++k) {
                if (!((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])this.addrs, (int)i), InetAddress.class)).equals((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)k), InetAddress.class))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public String toString() {
        String string = "name:";
        string = string + (this.name == null ? "null" : this.name);
        if (this.displayName != null) {
            string = string + " (" + this.displayName + ")";
        }
        return string;
    }

    private static native void init();

    static NetworkInterface getDefault() {
        return defaultInterface;
    }

    static /* synthetic */ NetworkInterface[] access$100(NetworkInterface networkInterface) {
        return networkInterface.childs;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        NetworkInterface.init();
        defaultInterface = DefaultInterface.getDefault();
        defaultIndex = defaultInterface != null ? defaultInterface.getIndex() : 0;
    }

    private static /* synthetic */ String _jr$ig$name(NetworkInterface networkInterface) {
        return networkInterface.name;
    }

    private static /* synthetic */ void _jr$ip$name(NetworkInterface networkInterface, String string) {
        networkInterface.name = string;
    }

    private static /* synthetic */ String _jr$ig$displayName(NetworkInterface networkInterface) {
        return networkInterface.displayName;
    }

    private static /* synthetic */ void _jr$ip$displayName(NetworkInterface networkInterface, String string) {
        networkInterface.displayName = string;
    }

    private static /* synthetic */ int _jr$ig$index(NetworkInterface networkInterface) {
        return networkInterface.index;
    }

    private static /* synthetic */ void _jr$ip$index(NetworkInterface networkInterface, int n) {
        networkInterface.index = n;
    }

    private static /* synthetic */ InetAddress[] _jr$ig$addrs(NetworkInterface networkInterface) {
        return networkInterface.addrs;
    }

    private static /* synthetic */ void _jr$ip$addrs(NetworkInterface networkInterface, InetAddress[] inetAddressArray) {
        networkInterface.addrs = inetAddressArray;
    }

    private static /* synthetic */ InterfaceAddress[] _jr$ig$bindings(NetworkInterface networkInterface) {
        return networkInterface.bindings;
    }

    private static /* synthetic */ void _jr$ip$bindings(NetworkInterface networkInterface, InterfaceAddress[] interfaceAddressArray) {
        networkInterface.bindings = interfaceAddressArray;
    }

    private static /* synthetic */ NetworkInterface[] _jr$ig$childs(NetworkInterface networkInterface) {
        return networkInterface.childs;
    }

    private static /* synthetic */ void _jr$ip$childs(NetworkInterface networkInterface, NetworkInterface[] networkInterfaceArray) {
        networkInterface.childs = networkInterfaceArray;
    }

    private static /* synthetic */ NetworkInterface _jr$ig$parent(NetworkInterface networkInterface) {
        return networkInterface.parent;
    }

    private static /* synthetic */ void _jr$ip$parent(NetworkInterface networkInterface, NetworkInterface networkInterface2) {
        networkInterface.parent = networkInterface2;
    }

    private static /* synthetic */ boolean _jr$ig$virtual(NetworkInterface networkInterface) {
        return networkInterface.virtual;
    }

    private static /* synthetic */ void _jr$ip$virtual(NetworkInterface networkInterface, boolean bl) {
        networkInterface.virtual = bl;
    }
}

