/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetUtil;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImpl;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public class ServerSocket
extends h
implements Closeable {
    private boolean created;
    private boolean bound;
    private boolean closed;
    private Object closeLock;
    private SocketImpl impl;
    private boolean oldImpl;
    private static SocketImplFactory factory = null;

    ServerSocket(SocketImpl socketImpl) {
        this.created = false;
        this.bound = false;
        this.closed = false;
        this.closeLock = new Object();
        this.oldImpl = false;
        this.impl = socketImpl;
        socketImpl.setServerSocket(this);
    }

    public ServerSocket() throws IOException {
        this.created = false;
        this.bound = false;
        this.closed = false;
        this.closeLock = new Object();
        this.oldImpl = false;
        this.setImpl();
    }

    public ServerSocket(int n2) throws IOException {
        this(n2, 50, null);
    }

    public ServerSocket(int n2, int n3) throws IOException {
        this(n2, n3, null);
    }

    public ServerSocket(int n2, int n3, InetAddress inetAddress) throws IOException {
        this.created = false;
        this.bound = false;
        this.closed = false;
        this.closeLock = new Object();
        this.oldImpl = false;
        this.setImpl();
        if (n2 < 0 || n2 > 65535) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Port value out of range: " + n2));
        }
        if (n3 < 1) {
            n3 = 50;
        }
        try {
            this.bind(new InetSocketAddress(inetAddress, n2), n3);
        }
        catch (SecurityException securityException) {
            this.close();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)securityException);
        }
        catch (IOException iOException) {
            this.close();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.oldImpl = true;
        }
    }

    private void setImpl() {
        if (factory != null) {
            this.impl = ServerSocket.factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            this.impl = new SocksSocketImpl();
        }
        if (this.impl != null) {
            this.impl.setServerSocket(this);
        }
    }

    void createImpl() throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(true);
            this.created = true;
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException(iOException.getMessage()));
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    public void bind(SocketAddress socketAddress, int n2) throws IOException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.oldImpl && this.isBound()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Already bound"));
        }
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        if (!(g.convertForInstanceOf((Object)socketAddress, InetSocketAddress.class) instanceof InetSocketAddress)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unsupported address type"));
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)g.convertForCast((Object)socketAddress, InetSocketAddress.class);
        if (inetSocketAddress.isUnresolved()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Unresolved address"));
        }
        if (n2 < 1) {
            n2 = 50;
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            this.getImpl().bind(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            this.getImpl().listen(n2);
            this.bound = true;
        }
        catch (SecurityException securityException) {
            this.bound = false;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)securityException);
        }
        catch (IOException iOException) {
            this.bound = false;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        try {
            SecurityManager securityManager;
            InetAddress inetAddress = this.getImpl().getInetAddress();
            if (!NetUtil.doRevealLocalAddress() && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
            }
            return inetAddress;
        }
        catch (SecurityException securityException) {
            return InetAddress.getLoopbackAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.isBound()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is not bound yet"));
        }
        Socket socket = new Socket((SocketImpl)g.convertForCast(null, SocketImpl.class));
        this.implAccept(socket);
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        SocketImpl socketImpl = null;
        try {
            if (Socket._jr$ig$impl(socket) == null) {
                socket.setImpl();
            } else {
                Socket._jr$ig$impl(socket).reset();
            }
            socketImpl = Socket._jr$ig$impl(socket);
            Socket._jr$ip$impl(socket, null);
            SocketImpl._jr$ip$address(socketImpl, new InetAddress());
            SocketImpl._jr$ip$fd(socketImpl, new FileDescriptor());
            this.getImpl().accept(socketImpl);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkAccept(socketImpl.getInetAddress().getHostAddress(), socketImpl.getPort());
            }
        }
        catch (IOException iOException) {
            if (socketImpl != null) {
                socketImpl.reset();
            }
            Socket._jr$ip$impl(socket, socketImpl);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
        catch (SecurityException securityException) {
            if (socketImpl != null) {
                socketImpl.reset();
            }
            Socket._jr$ip$impl(socket, socketImpl);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)securityException);
        }
        Socket._jr$ip$impl(socket, socketImpl);
        socket.postAccept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                if (this.isClosed()) {
                    return;
                }
                if (this.created) {
                    this.impl.close();
                }
                this.closed = true;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                return this.closed;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public void setSoTimeout(int n2) throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                this.getImpl().setOption(4102, new Integer(n2));
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public int getSoTimeout() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                Object object2 = this.getImpl().getOption(4102);
                if (object2 instanceof Integer) {
                    return (Integer)object2;
                }
                return 0;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        this.getImpl().setOption(4, bl);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        InetAddress inetAddress = !NetUtil.doRevealLocalAddress() && System.getSecurityManager() != null ? InetAddress.getLoopbackAddress() : this.impl.getInetAddress();
        return "ServerSocket[addr=" + inetAddress + ",localport=" + this.impl.getLocalPort() + "]";
    }

    void setBound() {
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("factory already defined"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }

    @af(modifiers=33)
    public void setReceiveBufferSize(int n2) throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (n2 <= 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("negative receive size"));
                }
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                this.getImpl().setOption(4098, new Integer(n2));
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public int getReceiveBufferSize() throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                int n2 = 0;
                Object object2 = this.getImpl().getOption(4098);
                if (object2 instanceof Integer) {
                    n2 = (Integer)object2;
                }
                return n2;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void setPerformancePreferences(int n2, int n3, int n4) {
    }

    static /* synthetic */ SocketImpl access$000(ServerSocket serverSocket) {
        return serverSocket.impl;
    }

    private static /* synthetic */ void _jr$ip$closeLock(ServerSocket serverSocket, Object object) {
        serverSocket.closeLock = object;
    }

    protected /* synthetic */ ServerSocket(h h2) {
        super(h2);
    }
}

