/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetUtil;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImpl;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import sun.net.ApplicationProxy;

public class Socket
extends h
implements Closeable {
    private boolean created;
    private boolean bound;
    private boolean connected;
    private boolean closed;
    private Object closeLock;
    private boolean shutIn;
    private boolean shutOut;
    SocketImpl impl;
    private boolean oldImpl;
    private static SocketImplFactory factory = null;

    public Socket() {
        this.created = false;
        this.bound = false;
        this.connected = false;
        this.closed = false;
        this.closeLock = new Object();
        this.shutIn = false;
        this.shutOut = false;
        this.oldImpl = false;
        this.setImpl();
    }

    public Socket(Proxy proxy) {
        Proxy proxy2;
        this.created = false;
        this.bound = false;
        this.connected = false;
        this.closed = false;
        this.closeLock = new Object();
        this.shutIn = false;
        this.shutOut = false;
        this.oldImpl = false;
        if (proxy == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid Proxy"));
        }
        Proxy proxy3 = proxy2 = !f.ifAcmp((Object)proxy, (Object)Proxy.NO_PROXY) ? Proxy.NO_PROXY : ApplicationProxy.create(proxy);
        if (!f.ifAcmp((Object)((Object)proxy2.type()), (Object)((Object)Proxy.Type.SOCKS))) {
            SecurityManager securityManager = System.getSecurityManager();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)g.convertForCast((Object)proxy2.address(), InetSocketAddress.class);
            if (inetSocketAddress.getAddress() != null) {
                this.checkAddress(inetSocketAddress.getAddress(), "Socket");
            }
            if (securityManager != null) {
                if (inetSocketAddress.isUnresolved()) {
                    inetSocketAddress = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                }
                if (inetSocketAddress.isUnresolved()) {
                    securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                } else {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
            }
            this.impl = new SocksSocketImpl(proxy2);
            this.impl.setSocket(this);
        } else if (!f.ifAcmp((Object)proxy2, (Object)Proxy.NO_PROXY)) {
            if (factory == null) {
                this.impl = new PlainSocketImpl();
                this.impl.setSocket(this);
            } else {
                this.setImpl();
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid Proxy"));
        }
    }

    protected Socket(SocketImpl socketImpl) throws SocketException {
        this.created = false;
        this.bound = false;
        this.connected = false;
        this.closed = false;
        this.closeLock = new Object();
        this.shutIn = false;
        this.shutOut = false;
        this.oldImpl = false;
        this.impl = socketImpl;
        if (socketImpl != null) {
            this.checkOldImpl();
            this.impl.setSocket(this);
        }
    }

    public Socket(String string, int n2) throws UnknownHostException, IOException {
        this(string != null ? new InetSocketAddress(string, n2) : new InetSocketAddress(InetAddress.getByName(null), n2), (SocketAddress)g.convertForCast(null, SocketAddress.class), true);
    }

    public Socket(InetAddress inetAddress, int n2) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n2) : null, (SocketAddress)g.convertForCast(null, SocketAddress.class), true);
    }

    public Socket(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        this(string != null ? new InetSocketAddress(string, n2) : new InetSocketAddress(InetAddress.getByName(null), n2), new InetSocketAddress(inetAddress, n3), true);
    }

    public Socket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n2) : null, new InetSocketAddress(inetAddress2, n3), true);
    }

    @Deprecated
    public Socket(String string, int n2, boolean bl) throws IOException {
        this(string != null ? new InetSocketAddress(string, n2) : new InetSocketAddress(InetAddress.getByName(null), n2), (SocketAddress)g.convertForCast(null, SocketAddress.class), bl);
    }

    @Deprecated
    public Socket(InetAddress inetAddress, int n2, boolean bl) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n2) : null, new InetSocketAddress(0), bl);
    }

    private Socket(SocketAddress socketAddress, SocketAddress socketAddress2, boolean bl) throws IOException {
        this.created = false;
        this.bound = false;
        this.connected = false;
        this.closed = false;
        this.closeLock = new Object();
        this.shutIn = false;
        this.shutOut = false;
        this.oldImpl = false;
        this.setImpl();
        if (socketAddress == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        try {
            this.createImpl(bl);
            if (socketAddress2 != null) {
                this.bind(socketAddress2);
            }
            if (socketAddress != null) {
                this.connect(socketAddress);
            }
        }
        catch (IOException iOException) {
            this.close();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
    }

    void createImpl(boolean bl) throws SocketException {
        if (((Socket)this).impl == null) {
            this.setImpl();
        }
        try {
            ((Socket)this).impl.create(bl);
            this.created = true;
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException(iOException.getMessage()));
        }
    }

    private void checkOldImpl() {
        if (((Socket)this).impl == null) {
            return;
        }
        this.oldImpl = (Boolean)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), Boolean.class);
    }

    void setImpl() {
        if (factory != null) {
            ((Socket)this).impl = Socket.factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            ((Socket)this).impl = new SocksSocketImpl();
        }
        if (((Socket)this).impl != null) {
            ((Socket)this).impl.setSocket(this);
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl(true);
        }
        return ((Socket)this).impl;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    public void connect(SocketAddress socketAddress, int n2) throws IOException {
        if (socketAddress == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("connect: The address can't be null"));
        }
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("connect: timeout can't be negative"));
        }
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.oldImpl && this.isConnected()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("already connected"));
        }
        if (!(g.convertForInstanceOf((Object)socketAddress, InetSocketAddress.class) instanceof InetSocketAddress)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unsupported address type"));
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)g.convertForCast((Object)socketAddress, InetSocketAddress.class);
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n3 = inetSocketAddress.getPort();
        this.checkAddress(inetAddress, "connect");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (inetSocketAddress.isUnresolved()) {
                securityManager.checkConnect(inetSocketAddress.getHostName(), n3);
            } else {
                securityManager.checkConnect(inetAddress.getHostAddress(), n3);
            }
        }
        if (!this.created) {
            this.createImpl(true);
        }
        if (!this.oldImpl) {
            ((Socket)this).impl.connect(inetSocketAddress, n2);
        } else if (n2 == 0) {
            if (inetSocketAddress.isUnresolved()) {
                ((Socket)this).impl.connect(inetAddress.getHostName(), n3);
            } else {
                ((Socket)this).impl.connect(inetAddress, n3);
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("SocketImpl.connect(addr, timeout)"));
        }
        this.connected = true;
        this.bound = true;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.oldImpl && this.isBound()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Already bound"));
        }
        if (socketAddress != null && !(g.convertForInstanceOf((Object)socketAddress, InetSocketAddress.class) instanceof InetSocketAddress)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unsupported address type"));
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)g.convertForCast((Object)socketAddress, InetSocketAddress.class);
        if (inetSocketAddress != null && inetSocketAddress.isUnresolved()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Unresolved address"));
        }
        if (inetSocketAddress == null) {
            inetSocketAddress = new InetSocketAddress(0);
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n2 = inetSocketAddress.getPort();
        this.checkAddress(inetAddress, "bind");
        this.getImpl().bind(inetAddress, n2);
        this.bound = true;
    }

    private void checkAddress(InetAddress inetAddress, String string) {
        if (inetAddress == null) {
            return;
        }
        if (!(g.convertForInstanceOf((Object)inetAddress, Inet4Address.class) instanceof Inet4Address) && !(g.convertForInstanceOf((Object)inetAddress, Inet6Address.class) instanceof Inet6Address)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string + ": invalid address type"));
        }
    }

    final void postAccept() {
        this.connected = true;
        this.created = true;
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    void setBound() {
        this.bound = true;
    }

    void setConnected() {
        this.connected = true;
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            return InetAddress.anyLocalAddress();
        }
        InetAddress inetAddress = null;
        try {
            SecurityManager securityManager;
            inetAddress = (InetAddress)g.convertForCast((Object)this.getImpl().getOption(15), InetAddress.class);
            if (!NetUtil.doRevealLocalAddress() && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
            }
            if (inetAddress.isAnyLocalAddress()) {
                inetAddress = InetAddress.anyLocalAddress();
            }
        }
        catch (SecurityException securityException) {
            inetAddress = InetAddress.getLoopbackAddress();
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress();
        }
        return inetAddress;
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.isConnected()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is not connected"));
        }
        if (this.isInputShutdown()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket input is shutdown"));
        }
        Socket socket = this;
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), InputStream.class);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)privilegedActionException.getException(), IOException.class)));
        }
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.isConnected()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is not connected"));
        }
        if (this.isOutputShutdown()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket output is shutdown"));
        }
        Socket socket = this;
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), OutputStream.class);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)privilegedActionException.getException(), IOException.class)));
        }
        return outputStream;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        this.getImpl().setOption(1, bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        return (Boolean)g.convertForCast((Object)this.getImpl().getOption(1), Boolean.class);
    }

    public void setSoLinger(boolean bl, int n2) throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!bl) {
            this.getImpl().setOption(128, new Boolean(bl));
        } else {
            if (n2 < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid value for SO_LINGER"));
            }
            if (n2 > 65535) {
                n2 = 65535;
            }
            this.getImpl().setOption(128, new Integer(n2));
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        Object object = this.getImpl().getOption(128);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public void sendUrgentData(int n2) throws IOException {
        if (!this.getImpl().supportsUrgentData()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Urgent data not supported"));
        }
        this.getImpl().sendUrgentData(n2);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        this.getImpl().setOption(4099, bl);
    }

    public boolean getOOBInline() throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        return (Boolean)g.convertForCast((Object)this.getImpl().getOption(4099), Boolean.class);
    }

    @af(modifiers=33)
    public void setSoTimeout(int n2) throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                if (n2 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("timeout can't be negative"));
                }
                this.getImpl().setOption(4102, new Integer(n2));
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public int getSoTimeout() throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                Object object2 = this.getImpl().getOption(4102);
                if (object2 instanceof Integer) {
                    return (Integer)object2;
                }
                return 0;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public void setSendBufferSize(int n2) throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (n2 <= 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("negative send size"));
                }
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                this.getImpl().setOption(4097, new Integer(n2));
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public int getSendBufferSize() throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                int n2 = 0;
                Object object2 = this.getImpl().getOption(4097);
                if (object2 instanceof Integer) {
                    n2 = (Integer)object2;
                }
                return n2;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public void setReceiveBufferSize(int n2) throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (n2 <= 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid receive size"));
                }
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                this.getImpl().setOption(4098, new Integer(n2));
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public int getReceiveBufferSize() throws SocketException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.isClosed()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
                }
                int n2 = 0;
                Object object2 = this.getImpl().getOption(4098);
                if (object2 instanceof Integer) {
                    n2 = (Integer)object2;
                }
                return n2;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        this.getImpl().setOption(8, bl);
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        return (Boolean)g.convertForCast((Object)this.getImpl().getOption(8), Boolean.class);
    }

    public void setTrafficClass(int n2) throws SocketException {
        if (n2 < 0 || n2 > 255) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("tc is not in range 0 -- 255"));
        }
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        this.getImpl().setOption(3, new Integer(n2));
    }

    public int getTrafficClass() throws SocketException {
        return (Integer)this.getImpl().getOption(3);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        this.getImpl().setOption(4, bl);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        return (Boolean)g.convertForCast((Object)((Boolean)g.convertForCast((Object)this.getImpl().getOption(4), Boolean.class)), Boolean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @af(modifiers=33)
    public void close() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Object object2 = ah.getMonitor((Object)this.closeLock);
                synchronized (object2) {
                    try {
                        if (this.isClosed()) {
                            return;
                        }
                        if (this.created) {
                            ((Socket)this).impl.close();
                        }
                        this.closed = true;
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.isConnected()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is not connected"));
        }
        if (this.isInputShutdown()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket input is already shutdown"));
        }
        this.getImpl().shutdownInput();
        this.shutIn = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is closed"));
        }
        if (!this.isConnected()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket is not connected"));
        }
        if (this.isOutputShutdown()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("Socket output is already shutdown"));
        }
        this.getImpl().shutdownOutput();
        this.shutOut = true;
    }

    public String toString() {
        try {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.connected || this.oldImpl;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = ah.getMonitor((Object)this.closeLock);
        synchronized (object) {
            try {
                return this.closed;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public boolean isInputShutdown() {
        return this.shutIn;
    }

    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SocketException("factory already defined"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }

    public void setPerformancePreferences(int n2, int n3, int n4) {
    }

    private static /* synthetic */ void _jr$ip$closeLock(Socket socket, Object object) {
        socket.closeLock = object;
    }

    protected /* synthetic */ Socket(h h2) {
        super(h2);
    }
}

