/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketPermissionCollection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import sun.net.RegisteredDomain;
import sun.net.util.IPAddressUtil;
import sun.net.www.URLConnection;
import sun.security.action.GetBooleanAction;
import sun.security.util.Debug;

public final class SocketPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -7204263841984476862L;
    private static final int CONNECT = 1;
    private static final int LISTEN = 2;
    private static final int ACCEPT = 4;
    private static final int RESOLVE = 8;
    private static final int NONE = 0;
    private static final int ALL = 15;
    private static final int PORT_MIN = 0;
    private static final int PORT_MAX = 65535;
    private static final int PRIV_PORT_MAX = 1023;
    private transient int mask;
    private String actions;
    private transient String hostname;
    private transient String cname;
    private transient InetAddress[] addresses;
    private transient boolean wildcard;
    private transient boolean init_with_ip;
    private transient boolean invalid;
    private transient int[] portrange;
    private transient boolean defaultDeny = false;
    private transient boolean untrusted;
    private transient boolean trusted;
    private static boolean trustNameService;
    private static Debug debug;
    private static boolean debugInit;
    private transient String cdomain;
    private transient String hdomain;

    private static synchronized Debug getDebug() {
        if (!debugInit) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public SocketPermission(String string, String string2) {
        super(SocketPermission.getHost(string));
        this.init(this.getName(), SocketPermission.getMask(string2));
    }

    SocketPermission(String string, int n2) {
        super(SocketPermission.getHost(string));
        this.init(this.getName(), n2);
    }

    private void setDeny() {
        this.defaultDeny = true;
    }

    private static String getHost(String string) {
        int n2;
        if (string.equals("")) {
            return "localhost";
        }
        if (string.charAt(0) != '[' && (n2 = string.indexOf(58)) != string.lastIndexOf(58)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            int n3 = stringTokenizer.countTokens();
            if (n3 == 9) {
                n2 = string.lastIndexOf(58);
                string = "[" + string.substring(0, n2) + "]" + string.substring(n2);
            } else if (n3 == 8 && string.indexOf("::") == -1) {
                string = "[" + string + "]";
            } else {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Ambiguous hostport part"));
            }
        }
        return string;
    }

    private int[] parsePort(String string) throws Exception {
        if (string == null || string.equals("") || string.equals("*")) {
            return new int[]{0, 65535};
        }
        int n2 = string.indexOf(45);
        if (n2 == -1) {
            int n3 = Integer.parseInt(string);
            return new int[]{n3, n3};
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        int n4 = string2.equals("") ? 0 : Integer.parseInt(string2);
        int n5 = string3.equals("") ? 65535 : Integer.parseInt(string3);
        if (n4 < 0 || n5 < 0 || n5 < n4) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid port range"));
        }
        return new int[]{n4, n5};
    }

    private void init(String string, int n2) {
        char c;
        if ((n2 & 0xF) != n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid actions mask"));
        }
        this.mask = n2 | 8;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        String string2 = string;
        if (string.charAt(0) == '[') {
            n4 = 1;
            n3 = string.indexOf(93);
            if (n3 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid host/port: " + string));
            }
            string = string.substring(n4, n3);
            n6 = string2.indexOf(58, n3 + 1);
        } else {
            n4 = 0;
            n5 = n6 = string.indexOf(58, n3);
            if (n6 != -1) {
                string = string.substring(n4, n5);
            }
        }
        if (n6 != -1) {
            String string3 = string2.substring(n6 + 1);
            try {
                this.portrange = this.parsePort(string3);
            }
            catch (Exception exception) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid port range: " + string3));
            }
        } else {
            this.portrange = new int[]{0, 65535};
        }
        this.hostname = string;
        if (string.lastIndexOf(42) > 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid host wildcard specification"));
        }
        if (string.startsWith("*")) {
            this.wildcard = true;
            if (string.equals("*")) {
                this.cname = "";
            } else if (string.startsWith("*.")) {
                this.cname = string.substring(1).toLowerCase();
            } else {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid host wildcard specification"));
            }
            return;
        }
        if (string.length() > 0 && ((c = string.charAt(0)) == ':' || Character.digit(c, 16) != -1)) {
            byte[] byArray = IPAddressUtil.textToNumericFormatV4(string);
            if (byArray == null) {
                byArray = IPAddressUtil.textToNumericFormatV6(string);
            }
            if (byArray != null) {
                try {
                    Object[] objectArray = new InetAddress[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)InetAddress.getByAddress(byArray));
                    this.addresses = objectArray;
                    this.init_with_ip = true;
                }
                catch (UnknownHostException unknownHostException) {
                    this.invalid = true;
                }
            }
        }
    }

    private static int getMask(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("action can't be null"));
        }
        if (string.equals("")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("action can't be empty"));
        }
        int n2 = 0;
        if (!f.ifAcmp((Object)string, (Object)"resolve")) {
            return 8;
        }
        if (!f.ifAcmp((Object)string, (Object)"connect")) {
            return 1;
        }
        if (!f.ifAcmp((Object)string, (Object)"listen")) {
            return 2;
        }
        if (!f.ifAcmp((Object)string, (Object)"accept")) {
            return 4;
        }
        if (!f.ifAcmp((Object)string, (Object)"connect,accept")) {
            return 5;
        }
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        if (n3 < 0) {
            return n2;
        }
        while (n3 != -1) {
            int n4;
            char c;
            while (n3 != -1 && ((c = cArray[n3]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n3;
            }
            if (!(n3 < 6 || cArray[n3 - 6] != 'c' && cArray[n3 - 6] != 'C' || cArray[n3 - 5] != 'o' && cArray[n3 - 5] != 'O' || cArray[n3 - 4] != 'n' && cArray[n3 - 4] != 'N' || cArray[n3 - 3] != 'n' && cArray[n3 - 3] != 'N' || cArray[n3 - 2] != 'e' && cArray[n3 - 2] != 'E' || cArray[n3 - 1] != 'c' && cArray[n3 - 1] != 'C' || cArray[n3] != 't' && cArray[n3] != 'T')) {
                n4 = 7;
                n2 |= 1;
            } else if (!(n3 < 6 || cArray[n3 - 6] != 'r' && cArray[n3 - 6] != 'R' || cArray[n3 - 5] != 'e' && cArray[n3 - 5] != 'E' || cArray[n3 - 4] != 's' && cArray[n3 - 4] != 'S' || cArray[n3 - 3] != 'o' && cArray[n3 - 3] != 'O' || cArray[n3 - 2] != 'l' && cArray[n3 - 2] != 'L' || cArray[n3 - 1] != 'v' && cArray[n3 - 1] != 'V' || cArray[n3] != 'e' && cArray[n3] != 'E')) {
                n4 = 7;
                n2 |= 8;
            } else if (!(n3 < 5 || cArray[n3 - 5] != 'l' && cArray[n3 - 5] != 'L' || cArray[n3 - 4] != 'i' && cArray[n3 - 4] != 'I' || cArray[n3 - 3] != 's' && cArray[n3 - 3] != 'S' || cArray[n3 - 2] != 't' && cArray[n3 - 2] != 'T' || cArray[n3 - 1] != 'e' && cArray[n3 - 1] != 'E' || cArray[n3] != 'n' && cArray[n3] != 'N')) {
                n4 = 6;
                n2 |= 2;
            } else if (!(n3 < 5 || cArray[n3 - 5] != 'a' && cArray[n3 - 5] != 'A' || cArray[n3 - 4] != 'c' && cArray[n3 - 4] != 'C' || cArray[n3 - 3] != 'c' && cArray[n3 - 3] != 'C' || cArray[n3 - 2] != 'e' && cArray[n3 - 2] != 'E' || cArray[n3 - 1] != 'p' && cArray[n3 - 1] != 'P' || cArray[n3] != 't' && cArray[n3] != 'T')) {
                n4 = 6;
                n2 |= 4;
            } else {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid permission: " + string));
            }
            boolean bl = false;
            while (n3 >= n4 && !bl) {
                switch (cArray[n3 - n4]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid permission: " + string));
                    }
                }
                --n3;
            }
            n3 -= n4;
        }
        return n2;
    }

    private boolean isUntrusted() throws UnknownHostException {
        if (this.trusted) {
            return false;
        }
        if (this.invalid || this.untrusted) {
            return true;
        }
        try {
            if (!trustNameService && (this.defaultDeny || URLConnection.isProxiedHost(this.hostname))) {
                if (this.cname == null) {
                    this.getCanonName();
                }
                if (!this.match(this.cname, this.hostname) && !this.authorized(this.hostname, ((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])this.addresses, (int)0), InetAddress.class)).getAddress())) {
                    this.untrusted = true;
                    Debug debug = SocketPermission.getDebug();
                    if (debug != null && Debug.isOn("failure")) {
                        debug.println("socket access restriction: proxied host (" + (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])this.addresses, (int)0), InetAddress.class) + ")" + " does not match " + this.cname + " from reverse lookup");
                    }
                    return true;
                }
                this.trusted = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)unknownHostException);
        }
        return false;
    }

    void getCanonName() throws UnknownHostException {
        if (this.cname != null || this.invalid || this.untrusted) {
            return;
        }
        try {
            if (this.addresses == null) {
                this.getIP();
            }
            this.cname = this.init_with_ip ? ((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])this.addresses, (int)0), InetAddress.class)).getHostName(false).toLowerCase() : InetAddress.getByName(((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])this.addresses, (int)0), InetAddress.class)).getHostAddress()).getHostName(false).toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)unknownHostException);
        }
    }

    private boolean match(String string, String string2) {
        String string3;
        String string4 = string.toLowerCase();
        if (string4.startsWith(string3 = string2.toLowerCase()) && (string4.length() == string3.length() || string4.charAt(string3.length()) == '.')) {
            return true;
        }
        if (this.cdomain == null) {
            this.cdomain = RegisteredDomain.getRegisteredDomain((String)string4);
        }
        if (this.hdomain == null) {
            this.hdomain = RegisteredDomain.getRegisteredDomain((String)string3);
        }
        return this.cdomain.length() != 0 && this.hdomain.length() != 0 && this.cdomain.equals(this.hdomain);
    }

    private boolean authorized(String string, byte[] byArray) {
        if (byArray.length == 4) {
            return this.authorizedIPv4(string, byArray);
        }
        if (byArray.length == 16) {
            return this.authorizedIPv6(string, byArray);
        }
        return false;
    }

    private boolean authorizedIPv4(String string, byte[] byArray) {
        block4: {
            String string2 = "";
            try {
                string2 = "auth." + (byArray[3] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[0] & 0xFF) + ".in-addr.arpa";
                string2 = this.hostname + '.' + string2;
                InetAddress inetAddress = (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])InetAddress.getAllByName0(string2, false), (int)0), InetAddress.class);
                if (inetAddress.equals(InetAddress.getByAddress(byArray))) {
                    return true;
                }
                Debug debug = SocketPermission.getDebug();
                if (debug != null && Debug.isOn("failure")) {
                    debug.println("socket access restriction: IP address of " + inetAddress + " != " + InetAddress.getByAddress(byArray));
                }
            }
            catch (UnknownHostException unknownHostException) {
                Debug debug = SocketPermission.getDebug();
                if (debug == null || !Debug.isOn("failure")) break block4;
                debug.println("socket access restriction: forward lookup failed for " + string2);
            }
        }
        return false;
    }

    private boolean authorizedIPv6(String string, byte[] byArray) {
        block5: {
            String string2 = "";
            try {
                StringBuffer stringBuffer = new StringBuffer(39);
                for (int i = 15; i >= 0; --i) {
                    stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
                    stringBuffer.append('.');
                    stringBuffer.append(Integer.toHexString(byArray[i] >> 4 & 0xF));
                    stringBuffer.append('.');
                }
                string2 = "auth." + stringBuffer.toString() + "IP6.ARPA";
                string2 = this.hostname + '.' + string2;
                InetAddress inetAddress = (InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])InetAddress.getAllByName0(string2, false), (int)0), InetAddress.class);
                if (inetAddress.equals(InetAddress.getByAddress(byArray))) {
                    return true;
                }
                Debug debug = SocketPermission.getDebug();
                if (debug != null && Debug.isOn("failure")) {
                    debug.println("socket access restriction: IP address of " + inetAddress + " != " + InetAddress.getByAddress(byArray));
                }
            }
            catch (UnknownHostException unknownHostException) {
                Debug debug = SocketPermission.getDebug();
                if (debug == null || !Debug.isOn("failure")) break block5;
                debug.println("socket access restriction: forward lookup failed for " + string2);
            }
        }
        return false;
    }

    void getIP() throws UnknownHostException {
        if (this.addresses != null || this.wildcard || this.invalid) {
            return;
        }
        try {
            int n2;
            String string = this.getName().charAt(0) == '[' ? this.getName().substring(1, this.getName().indexOf(93)) : ((n2 = this.getName().indexOf(":")) == -1 ? this.getName() : this.getName().substring(0, n2));
            Object[] objectArray = new InetAddress[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])InetAddress.getAllByName0(string, false), (int)0), InetAddress.class)));
            this.addresses = objectArray;
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)unknownHostException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.invalid = true;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnknownHostException(this.getName()));
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        if (!f.ifAcmp((Object)permission, (Object)this)) {
            return true;
        }
        SocketPermission socketPermission = (SocketPermission)permission;
        return (this.mask & socketPermission.mask) == socketPermission.mask && this.impliesIgnoreMask(socketPermission);
    }

    boolean impliesIgnoreMask(SocketPermission socketPermission) {
        if ((socketPermission.mask & 8) != socketPermission.mask && (socketPermission.portrange[0] < this.portrange[0] || socketPermission.portrange[1] > this.portrange[1])) {
            return false;
        }
        if (this.wildcard && "".equals(this.cname)) {
            return true;
        }
        if (this.invalid || socketPermission.invalid) {
            return this.compareHostnames(socketPermission);
        }
        try {
            if (this.init_with_ip) {
                if (socketPermission.wildcard) {
                    return false;
                }
                if (socketPermission.init_with_ip) {
                    return ((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])this.addresses, (int)0), InetAddress.class)).equals((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])socketPermission.addresses, (int)0), InetAddress.class));
                }
                if (socketPermission.addresses == null) {
                    socketPermission.getIP();
                }
                for (int i = 0; i < a.arrayLength((Object[])socketPermission.addresses); ++i) {
                    if (!((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])this.addresses, (int)0), InetAddress.class)).equals((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])socketPermission.addresses, (int)i), InetAddress.class))) continue;
                    return true;
                }
                return false;
            }
            if (this.wildcard || socketPermission.wildcard) {
                if (this.wildcard && socketPermission.wildcard) {
                    return socketPermission.cname.endsWith(this.cname);
                }
                if (socketPermission.wildcard) {
                    return false;
                }
                if (socketPermission.cname == null) {
                    socketPermission.getCanonName();
                }
                return socketPermission.cname.endsWith(this.cname);
            }
            if (this.addresses == null) {
                this.getIP();
            }
            if (socketPermission.addresses == null) {
                socketPermission.getIP();
            }
            if (!socketPermission.init_with_ip || !this.isUntrusted()) {
                for (int i = 0; i < a.arrayLength((Object[])this.addresses); ++i) {
                    for (int k = 0; k < a.arrayLength((Object[])socketPermission.addresses); ++k) {
                        if (!((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])this.addresses, (int)i), InetAddress.class)).equals((InetAddress)g.convertForCast((Object)a.arrayLoad((Object[])socketPermission.addresses, (int)k), InetAddress.class))) continue;
                        return true;
                    }
                }
                if (this.cname == null) {
                    this.getCanonName();
                }
                if (socketPermission.cname == null) {
                    socketPermission.getCanonName();
                }
                return this.cname.equalsIgnoreCase(socketPermission.cname);
            }
        }
        catch (UnknownHostException unknownHostException) {
            return this.compareHostnames(socketPermission);
        }
        return false;
    }

    private boolean compareHostnames(SocketPermission socketPermission) {
        String string = this.hostname;
        String string2 = socketPermission.hostname;
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    @Override
    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)this)) {
            return true;
        }
        if (!(object instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)object;
        if (this.mask != socketPermission.mask) {
            return false;
        }
        if ((socketPermission.mask & 8) != socketPermission.mask && (this.portrange[0] != socketPermission.portrange[0] || this.portrange[1] != socketPermission.portrange[1])) {
            return false;
        }
        if (this.getName().equalsIgnoreCase(socketPermission.getName())) {
            return true;
        }
        try {
            this.getCanonName();
            socketPermission.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (this.invalid || socketPermission.invalid) {
            return false;
        }
        if (this.cname != null) {
            return this.cname.equalsIgnoreCase(socketPermission.cname);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.init_with_ip || this.wildcard) {
            return this.getName().hashCode();
        }
        try {
            this.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (this.invalid || this.cname == null) {
            return this.getName().hashCode();
        }
        return this.cname.hashCode();
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if ((n2 & 1) == 1) {
            bl = true;
            stringBuilder.append("connect");
        }
        if ((n2 & 2) == 2) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("listen");
        }
        if ((n2 & 4) == 4) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("accept");
        }
        if ((n2 & 8) == 8) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("resolve");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = SocketPermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SocketPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), SocketPermission.getMask(this.actions));
    }

    static {
        debug = null;
        debugInit = false;
        Boolean bl = (Boolean)g.convertForCast(AccessController.doPrivileged(new GetBooleanAction("sun.net.trustNameService")), Boolean.class);
        trustNameService = bl;
    }

    private static /* synthetic */ int _jr$ig$mask(SocketPermission socketPermission) {
        return socketPermission.mask;
    }

    private static /* synthetic */ void _jr$ip$mask(SocketPermission socketPermission, int n2) {
        socketPermission.mask = n2;
    }

    private static /* synthetic */ String _jr$ig$actions(SocketPermission socketPermission) {
        return socketPermission.actions;
    }

    private static /* synthetic */ void _jr$ip$actions(SocketPermission socketPermission, String string) {
        socketPermission.actions = string;
    }

    private static /* synthetic */ String _jr$ig$hostname(SocketPermission socketPermission) {
        return socketPermission.hostname;
    }

    private static /* synthetic */ void _jr$ip$hostname(SocketPermission socketPermission, String string) {
        socketPermission.hostname = string;
    }

    private static /* synthetic */ String _jr$ig$cname(SocketPermission socketPermission) {
        return socketPermission.cname;
    }

    private static /* synthetic */ void _jr$ip$cname(SocketPermission socketPermission, String string) {
        socketPermission.cname = string;
    }

    private static /* synthetic */ InetAddress[] _jr$ig$addresses(SocketPermission socketPermission) {
        return socketPermission.addresses;
    }

    private static /* synthetic */ void _jr$ip$addresses(SocketPermission socketPermission, InetAddress[] inetAddressArray) {
        socketPermission.addresses = inetAddressArray;
    }

    private static /* synthetic */ boolean _jr$ig$wildcard(SocketPermission socketPermission) {
        return socketPermission.wildcard;
    }

    private static /* synthetic */ void _jr$ip$wildcard(SocketPermission socketPermission, boolean bl) {
        socketPermission.wildcard = bl;
    }

    private static /* synthetic */ boolean _jr$ig$init_with_ip(SocketPermission socketPermission) {
        return socketPermission.init_with_ip;
    }

    private static /* synthetic */ void _jr$ip$init_with_ip(SocketPermission socketPermission, boolean bl) {
        socketPermission.init_with_ip = bl;
    }

    private static /* synthetic */ boolean _jr$ig$invalid(SocketPermission socketPermission) {
        return socketPermission.invalid;
    }

    private static /* synthetic */ void _jr$ip$invalid(SocketPermission socketPermission, boolean bl) {
        socketPermission.invalid = bl;
    }

    private static /* synthetic */ int[] _jr$ig$portrange(SocketPermission socketPermission) {
        return socketPermission.portrange;
    }

    private static /* synthetic */ void _jr$ip$portrange(SocketPermission socketPermission, int[] nArray) {
        socketPermission.portrange = nArray;
    }

    private static /* synthetic */ boolean _jr$ig$defaultDeny(SocketPermission socketPermission) {
        return socketPermission.defaultDeny;
    }

    private static /* synthetic */ void _jr$ip$defaultDeny(SocketPermission socketPermission, boolean bl) {
        socketPermission.defaultDeny = bl;
    }

    private static /* synthetic */ boolean _jr$ig$untrusted(SocketPermission socketPermission) {
        return socketPermission.untrusted;
    }

    private static /* synthetic */ void _jr$ip$untrusted(SocketPermission socketPermission, boolean bl) {
        socketPermission.untrusted = bl;
    }

    private static /* synthetic */ boolean _jr$ig$trusted(SocketPermission socketPermission) {
        return socketPermission.trusted;
    }

    private static /* synthetic */ void _jr$ip$trusted(SocketPermission socketPermission, boolean bl) {
        socketPermission.trusted = bl;
    }

    private static /* synthetic */ String _jr$ig$cdomain(SocketPermission socketPermission) {
        return socketPermission.cdomain;
    }

    private static /* synthetic */ void _jr$ip$cdomain(SocketPermission socketPermission, String string) {
        socketPermission.cdomain = string;
    }

    private static /* synthetic */ String _jr$ig$hdomain(SocketPermission socketPermission) {
        return socketPermission.hdomain;
    }

    private static /* synthetic */ void _jr$ip$hdomain(SocketPermission socketPermission, String string) {
        socketPermission.hdomain = string;
    }
}

