/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapCharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.StringCharBuffer;

public abstract class CharBuffer
extends Buffer
implements Comparable<CharBuffer>,
Appendable,
CharSequence,
Readable {
    final char[] hb;
    final int offset;
    boolean isReadOnly;

    CharBuffer(int n2, int n3, int n4, int n5, char[] cArray, int n6) {
        super(n2, n3, n4, n5);
        this.hb = cArray;
        this.offset = n6;
    }

    CharBuffer(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null, 0);
    }

    public static CharBuffer allocate(int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        return new HeapCharBuffer(n2, n2);
    }

    public static CharBuffer wrap(char[] cArray, int n2, int n3) {
        try {
            return new HeapCharBuffer(cArray, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
    }

    public static CharBuffer wrap(char[] cArray) {
        return CharBuffer.wrap(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        int n2 = charBuffer.remaining();
        int n3 = this.remaining();
        if (n3 == 0) {
            return -1;
        }
        int n4 = Math.min(n3, n2);
        int n5 = this.limit();
        if (n2 < n3) {
            this.limit(this.position() + n4);
        }
        try {
            if (n4 > 0) {
                charBuffer.put(this);
            }
        }
        catch (Throwable throwable) {
            this.limit(n5);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.limit(n5);
        return n4;
    }

    public static CharBuffer wrap(CharSequence charSequence, int n2, int n3) {
        try {
            return new StringCharBuffer(charSequence, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
    }

    public static CharBuffer wrap(CharSequence charSequence) {
        return CharBuffer.wrap(charSequence, 0, charSequence.length());
    }

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public CharBuffer get(char[] cArray, int n2, int n3) {
        CharBuffer.checkBounds(n2, n3, cArray.length);
        if (n3 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferUnderflowException());
        }
        int n4 = n2 + n3;
        for (int i = n2; i < n4; ++i) {
            cArray[i] = this.get();
        }
        return this;
    }

    public CharBuffer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (!f.ifAcmp((Object)charBuffer, (Object)this)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        int n2 = charBuffer.remaining();
        if (n2 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
        }
        for (int i = 0; i < n2; ++i) {
            this.put(charBuffer.get());
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n2, int n3) {
        CharBuffer.checkBounds(n2, n3, cArray.length);
        if (n3 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
        }
        int n4 = n2 + n3;
        for (int i = n2; i < n4; ++i) {
            this.put(cArray[i]);
        }
        return this;
    }

    public final CharBuffer put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public CharBuffer put(String string, int n2, int n3) {
        CharBuffer.checkBounds(n2, n3 - n2, string.length());
        for (int i = n2; i < n3; ++i) {
            this.put(string.charAt(i));
        }
        return this;
    }

    public final CharBuffer put(String string) {
        return this.put(string, 0, string.length());
    }

    @Override
    public final boolean hasArray() {
        return ((CharBuffer)this).hb != null && !((CharBuffer)this).isReadOnly;
    }

    public final char[] array() {
        if (((CharBuffer)this).hb == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        if (((CharBuffer)this).isReadOnly) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ReadOnlyBufferException());
        }
        return ((CharBuffer)this).hb;
    }

    @Override
    public final int arrayOffset() {
        if (((CharBuffer)this).hb == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        if (((CharBuffer)this).isReadOnly) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ReadOnlyBufferException());
        }
        return ((CharBuffer)this).offset;
    }

    public abstract CharBuffer compact();

    @Override
    public abstract boolean isDirect();

    public int hashCode() {
        int n2 = 1;
        int n3 = this.position();
        for (int i = this.limit() - 1; i >= n3; --i) {
            n2 = 31 * n2 + this.get(i);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, CharBuffer.class) instanceof CharBuffer)) {
            return false;
        }
        CharBuffer charBuffer = (CharBuffer)g.convertForCast((Object)object, CharBuffer.class);
        if (this.remaining() != charBuffer.remaining()) {
            return false;
        }
        int n2 = this.position();
        int n3 = this.limit() - 1;
        int n4 = charBuffer.limit() - 1;
        while (n3 >= n2) {
            if (!CharBuffer.equals(this.get(n3), charBuffer.get(n4))) {
                return false;
            }
            --n3;
            --n4;
        }
        return true;
    }

    private static boolean equals(char c2, char c3) {
        return c2 == c3;
    }

    @Override
    public int compareTo(CharBuffer charBuffer) {
        int n2 = this.position() + Math.min(this.remaining(), charBuffer.remaining());
        int n3 = this.position();
        int n4 = charBuffer.position();
        while (n3 < n2) {
            int n5 = CharBuffer.compare(this.get(n3), charBuffer.get(n4));
            if (n5 != 0) {
                return n5;
            }
            ++n3;
            ++n4;
        }
        return this.remaining() - charBuffer.remaining();
    }

    private static int compare(char c2, char c3) {
        return Character.compare(c2, c3);
    }

    @Override
    public String toString() {
        return this.toString(this.position(), this.limit());
    }

    abstract String toString(int var1, int var2);

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public final char charAt(int n2) {
        return this.get(this.position() + this.checkIndex(n2, 1));
    }

    @Override
    public abstract CharBuffer subSequence(int var1, int var2);

    @Override
    public CharBuffer append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.put("null");
        }
        return this.put(charSequence.toString());
    }

    @Override
    public CharBuffer append(CharSequence charSequence, int n2, int n3) {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        return this.put(charSequence2.subSequence(n2, n3).toString());
    }

    @Override
    public CharBuffer append(char c2) {
        return this.put(c2);
    }

    public abstract ByteOrder order();

    static /* synthetic */ void _jr$ip$hb(Object object, char[] cArray) {
        ((CharBuffer)object).hb = cArray;
    }

    static /* synthetic */ void _jr$ip$offset(Object object, int n2) {
        ((CharBuffer)object).offset = n2;
    }

    static /* synthetic */ void _jr$ip$isReadOnly(Object object, boolean bl) {
        ((CharBuffer)object).isReadOnly = bl;
    }

    protected /* synthetic */ CharBuffer(h h2) {
        super(h2);
    }
}

