/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileDescriptor;
import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferR;
import java.nio.DirectCharBufferS;
import java.nio.DirectCharBufferU;
import java.nio.DirectDoubleBufferS;
import java.nio.DirectDoubleBufferU;
import java.nio.DirectFloatBufferS;
import java.nio.DirectFloatBufferU;
import java.nio.DirectIntBufferS;
import java.nio.DirectIntBufferU;
import java.nio.DirectLongBufferS;
import java.nio.DirectLongBufferU;
import java.nio.DirectShortBufferS;
import java.nio.DirectShortBufferU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.nio.ch.DirectBuffer;

class DirectByteBuffer
extends MappedByteBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(byte[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;
    private final Cleaner cleaner;

    @Override
    public Object attachment() {
        return this.att;
    }

    public Cleaner cleaner() {
        return this.cleaner;
    }

    DirectByteBuffer(int n) {
        super(-1, 0, n, n);
        boolean bl = VM.isDirectMemoryPageAligned();
        int n2 = Bits.pageSize();
        long l = Math.max(1L, (long)n + (long)(bl ? n2 : 0));
        Bits.reserveMemory(l, n);
        long l2 = 0L;
        try {
            l2 = unsafe.allocateMemory(l);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Bits.unreserveMemory(l, n);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)outOfMemoryError);
        }
        unsafe.setMemory(l2, l, (byte)0);
        this.address = bl && l2 % (long)n2 != 0L ? l2 + (long)n2 - (l2 & (long)(n2 - 1)) : l2;
        this.cleaner = Cleaner.create(this, new Deallocator(l2, l, n));
        this.att = null;
    }

    DirectByteBuffer(long l, int n, Object object) {
        super(-1, 0, n, n);
        this.address = l;
        this.cleaner = null;
        this.att = object;
    }

    private DirectByteBuffer(long l, int n) {
        super(-1, 0, n, n);
        this.address = l;
        this.cleaner = null;
        this.att = null;
    }

    protected DirectByteBuffer(int n, long l, FileDescriptor fileDescriptor, Runnable runnable) {
        super(-1, 0, n, n, fileDescriptor);
        this.address = l;
        this.cleaner = Cleaner.create(this, runnable);
        this.att = null;
    }

    DirectByteBuffer(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.cleaner = null;
        this.att = directBuffer;
    }

    @Override
    public ByteBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 0;
        if (!$assertionsDisabled && n4 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        return new DirectByteBuffer(this, -1, 0, n3, n3, n4);
    }

    @Override
    public ByteBuffer duplicate() {
        return new DirectByteBuffer(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferR((DirectBuffer)this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return DirectByteBuffer._jr$ig$address(this);
    }

    private long ix(int n) {
        return DirectByteBuffer._jr$ig$address(this) + (long)(n << 0);
    }

    @Override
    public byte get() {
        return unsafe.getByte(this.ix(this.nextGetIndex()));
    }

    @Override
    public byte get(int n) {
        return unsafe.getByte(this.ix(this.checkIndex(n)));
    }

    @Override
    public ByteBuffer get(byte[] byArray, int n, int n2) {
        if (n2 << 0 > 6) {
            int n3;
            DirectByteBuffer.checkBounds(n, n2, byArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            if (!$assertionsDisabled && n4 > n5) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferUnderflowException());
            }
            Bits.copyToArray(this.ix(n4), byArray, arrayBaseOffset, n << 0, n2 << 0);
            this.position(n4 + n2);
        } else {
            super.get(byArray, n, n2);
        }
        return this;
    }

    @Override
    public ByteBuffer put(byte by) {
        unsafe.putByte(this.ix(this.nextPutIndex()), by);
        return this;
    }

    @Override
    public ByteBuffer put(int n, byte by) {
        unsafe.putByte(this.ix(this.checkIndex(n)), by);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (g.convertForInstanceOf((Object)byteBuffer, DirectByteBuffer.class) instanceof DirectByteBuffer) {
            int n;
            if (!f.ifAcmp((Object)byteBuffer, (Object)this)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
            }
            DirectByteBuffer directByteBuffer = (DirectByteBuffer)g.convertForCast((Object)byteBuffer, DirectByteBuffer.class);
            int n2 = directByteBuffer.position();
            int n3 = directByteBuffer.limit();
            if (!$assertionsDisabled && n2 > n3) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
            }
            unsafe.copyMemory(directByteBuffer.ix(n2), this.ix(n5), n4 << 0);
            directByteBuffer.position(n2 + n4);
            this.position(n5 + n4);
        } else if (ByteBuffer._jr$ig$hb(byteBuffer) != null) {
            int n = byteBuffer.position();
            int n8 = byteBuffer.limit();
            if (!$assertionsDisabled && n > n8) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(ByteBuffer._jr$ig$hb(byteBuffer), ByteBuffer._jr$ig$offset(byteBuffer) + n, n9);
            byteBuffer.position(n + n9);
        } else {
            super.put(byteBuffer);
        }
        return this;
    }

    @Override
    public ByteBuffer put(byte[] byArray, int n, int n2) {
        if (n2 << 0 > 6) {
            int n3;
            DirectByteBuffer.checkBounds(n, n2, byArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            if (!$assertionsDisabled && n4 > n5) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
            }
            Bits.copyFromArray(byArray, arrayBaseOffset, n << 0, this.ix(n4), n2 << 0);
            this.position(n4 + n2);
        } else {
            super.put(byArray, n, n2);
        }
        return this;
    }

    @Override
    public ByteBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), n3 << 0);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    byte _get(int n) {
        return unsafe.getByte(DirectByteBuffer._jr$ig$address(this) + (long)n);
    }

    @Override
    void _put(int n, byte by) {
        unsafe.putByte(DirectByteBuffer._jr$ig$address(this) + (long)n, by);
    }

    private char getChar(long l) {
        if (unaligned) {
            char c = unsafe.getChar(l);
            return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? c : Bits.swap(c);
        }
        return Bits.getChar(l, DirectByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public char getChar() {
        return this.getChar(this.ix(this.nextGetIndex(2)));
    }

    @Override
    public char getChar(int n) {
        return this.getChar(this.ix(this.checkIndex(n, 2)));
    }

    private ByteBuffer putChar(long l, char c) {
        if (unaligned) {
            char c2 = c;
            unsafe.putChar(l, DirectByteBuffer._jr$ig$nativeByteOrder(this) ? c2 : Bits.swap(c2));
        } else {
            Bits.putChar(l, c, DirectByteBuffer._jr$ig$bigEndian(this));
        }
        return this;
    }

    @Override
    public ByteBuffer putChar(char c) {
        this.putChar(this.ix(this.nextPutIndex(2)), c);
        return this;
    }

    @Override
    public ByteBuffer putChar(int n, char c) {
        this.putChar(this.ix(this.checkIndex(n, 2)), c);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 1;
        if (!unaligned && (DirectByteBuffer._jr$ig$address(this) + (long)n) % 2L != 0L) {
            return DirectByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsCharBufferB((ByteBuffer)this, -1, 0, n4, n4, n) : new ByteBufferAsCharBufferL((ByteBuffer)this, -1, 0, n4, n4, n);
        }
        return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? new DirectCharBufferU((DirectBuffer)this, -1, 0, n4, n4, n) : new DirectCharBufferS((DirectBuffer)this, -1, 0, n4, n4, n);
    }

    private short getShort(long l) {
        if (unaligned) {
            short s = unsafe.getShort(l);
            return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? s : Bits.swap(s);
        }
        return Bits.getShort(l, DirectByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public short getShort() {
        return this.getShort(this.ix(this.nextGetIndex(2)));
    }

    @Override
    public short getShort(int n) {
        return this.getShort(this.ix(this.checkIndex(n, 2)));
    }

    private ByteBuffer putShort(long l, short s) {
        if (unaligned) {
            short s2 = s;
            unsafe.putShort(l, DirectByteBuffer._jr$ig$nativeByteOrder(this) ? s2 : Bits.swap(s2));
        } else {
            Bits.putShort(l, s, DirectByteBuffer._jr$ig$bigEndian(this));
        }
        return this;
    }

    @Override
    public ByteBuffer putShort(short s) {
        this.putShort(this.ix(this.nextPutIndex(2)), s);
        return this;
    }

    @Override
    public ByteBuffer putShort(int n, short s) {
        this.putShort(this.ix(this.checkIndex(n, 2)), s);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 1;
        if (!unaligned && (DirectByteBuffer._jr$ig$address(this) + (long)n) % 2L != 0L) {
            return DirectByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsShortBufferB((ByteBuffer)this, -1, 0, n4, n4, n) : new ByteBufferAsShortBufferL((ByteBuffer)this, -1, 0, n4, n4, n);
        }
        return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? new DirectShortBufferU((DirectBuffer)this, -1, 0, n4, n4, n) : new DirectShortBufferS((DirectBuffer)this, -1, 0, n4, n4, n);
    }

    private int getInt(long l) {
        if (unaligned) {
            int n = unsafe.getInt(l);
            return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? n : Bits.swap(n);
        }
        return Bits.getInt(l, DirectByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public int getInt() {
        return this.getInt(this.ix(this.nextGetIndex(4)));
    }

    @Override
    public int getInt(int n) {
        return this.getInt(this.ix(this.checkIndex(n, 4)));
    }

    private ByteBuffer putInt(long l, int n) {
        if (unaligned) {
            int n2 = n;
            unsafe.putInt(l, DirectByteBuffer._jr$ig$nativeByteOrder(this) ? n2 : Bits.swap(n2));
        } else {
            Bits.putInt(l, n, DirectByteBuffer._jr$ig$bigEndian(this));
        }
        return this;
    }

    @Override
    public ByteBuffer putInt(int n) {
        this.putInt(this.ix(this.nextPutIndex(4)), n);
        return this;
    }

    @Override
    public ByteBuffer putInt(int n, int n2) {
        this.putInt(this.ix(this.checkIndex(n, 4)), n2);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 2;
        if (!unaligned && (DirectByteBuffer._jr$ig$address(this) + (long)n) % 4L != 0L) {
            return DirectByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsIntBufferB((ByteBuffer)this, -1, 0, n4, n4, n) : new ByteBufferAsIntBufferL((ByteBuffer)this, -1, 0, n4, n4, n);
        }
        return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? new DirectIntBufferU((DirectBuffer)this, -1, 0, n4, n4, n) : new DirectIntBufferS((DirectBuffer)this, -1, 0, n4, n4, n);
    }

    private long getLong(long l) {
        if (unaligned) {
            long l2 = unsafe.getLong(l);
            return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? l2 : Bits.swap(l2);
        }
        return Bits.getLong(l, DirectByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public long getLong() {
        return this.getLong(this.ix(this.nextGetIndex(8)));
    }

    @Override
    public long getLong(int n) {
        return this.getLong(this.ix(this.checkIndex(n, 8)));
    }

    private ByteBuffer putLong(long l, long l2) {
        if (unaligned) {
            long l3 = l2;
            unsafe.putLong(l, DirectByteBuffer._jr$ig$nativeByteOrder(this) ? l3 : Bits.swap(l3));
        } else {
            Bits.putLong(l, l2, DirectByteBuffer._jr$ig$bigEndian(this));
        }
        return this;
    }

    @Override
    public ByteBuffer putLong(long l) {
        this.putLong(this.ix(this.nextPutIndex(8)), l);
        return this;
    }

    @Override
    public ByteBuffer putLong(int n, long l) {
        this.putLong(this.ix(this.checkIndex(n, 8)), l);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 3;
        if (!unaligned && (DirectByteBuffer._jr$ig$address(this) + (long)n) % 8L != 0L) {
            return DirectByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsLongBufferB((ByteBuffer)this, -1, 0, n4, n4, n) : new ByteBufferAsLongBufferL((ByteBuffer)this, -1, 0, n4, n4, n);
        }
        return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? new DirectLongBufferU(this, -1, 0, n4, n4, n) : new DirectLongBufferS((DirectBuffer)this, -1, 0, n4, n4, n);
    }

    private float getFloat(long l) {
        if (unaligned) {
            int n = unsafe.getInt(l);
            return Float.intBitsToFloat(DirectByteBuffer._jr$ig$nativeByteOrder(this) ? n : Bits.swap(n));
        }
        return Bits.getFloat(l, DirectByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public float getFloat() {
        return this.getFloat(this.ix(this.nextGetIndex(4)));
    }

    @Override
    public float getFloat(int n) {
        return this.getFloat(this.ix(this.checkIndex(n, 4)));
    }

    private ByteBuffer putFloat(long l, float f2) {
        if (unaligned) {
            int n = Float.floatToRawIntBits(f2);
            unsafe.putInt(l, DirectByteBuffer._jr$ig$nativeByteOrder(this) ? n : Bits.swap(n));
        } else {
            Bits.putFloat(l, f2, DirectByteBuffer._jr$ig$bigEndian(this));
        }
        return this;
    }

    @Override
    public ByteBuffer putFloat(float f2) {
        this.putFloat(this.ix(this.nextPutIndex(4)), f2);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int n, float f2) {
        this.putFloat(this.ix(this.checkIndex(n, 4)), f2);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 2;
        if (!unaligned && (DirectByteBuffer._jr$ig$address(this) + (long)n) % 4L != 0L) {
            return DirectByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsFloatBufferB((ByteBuffer)this, -1, 0, n4, n4, n) : new ByteBufferAsFloatBufferL((ByteBuffer)this, -1, 0, n4, n4, n);
        }
        return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? new DirectFloatBufferU((DirectBuffer)this, -1, 0, n4, n4, n) : new DirectFloatBufferS((DirectBuffer)this, -1, 0, n4, n4, n);
    }

    private double getDouble(long l) {
        if (unaligned) {
            long l2 = unsafe.getLong(l);
            return Double.longBitsToDouble(DirectByteBuffer._jr$ig$nativeByteOrder(this) ? l2 : Bits.swap(l2));
        }
        return Bits.getDouble(l, DirectByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public double getDouble() {
        return this.getDouble(this.ix(this.nextGetIndex(8)));
    }

    @Override
    public double getDouble(int n) {
        return this.getDouble(this.ix(this.checkIndex(n, 8)));
    }

    private ByteBuffer putDouble(long l, double d) {
        if (unaligned) {
            long l2 = Double.doubleToRawLongBits(d);
            unsafe.putLong(l, DirectByteBuffer._jr$ig$nativeByteOrder(this) ? l2 : Bits.swap(l2));
        } else {
            Bits.putDouble(l, d, DirectByteBuffer._jr$ig$bigEndian(this));
        }
        return this;
    }

    @Override
    public ByteBuffer putDouble(double d) {
        this.putDouble(this.ix(this.nextPutIndex(8)), d);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int n, double d) {
        this.putDouble(this.ix(this.checkIndex(n, 8)), d);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n3 >> 3;
        if (!unaligned && (DirectByteBuffer._jr$ig$address(this) + (long)n) % 8L != 0L) {
            return DirectByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsDoubleBufferB((ByteBuffer)this, -1, 0, n4, n4, n) : new ByteBufferAsDoubleBufferL((ByteBuffer)this, -1, 0, n4, n4, n);
        }
        return DirectByteBuffer._jr$ig$nativeByteOrder(this) ? new DirectDoubleBufferU((DirectBuffer)this, -1, 0, n4, n4, n) : new DirectDoubleBufferS((DirectBuffer)this, -1, 0, n4, n4, n);
    }

    private static /* synthetic */ void _jr$ip$att(DirectByteBuffer directByteBuffer, Object object) {
        directByteBuffer.att = object;
    }

    private static /* synthetic */ void _jr$ip$cleaner(DirectByteBuffer directByteBuffer, Cleaner cleaner) {
        directByteBuffer.cleaner = cleaner;
    }

    protected /* synthetic */ DirectByteBuffer(h h2) {
        super(h2);
    }

    private static class Deallocator
    extends h
    implements Runnable {
        private static Unsafe unsafe = Unsafe.getUnsafe();
        private long address;
        private long size;
        private int capacity;

        private Deallocator(long l, long l2, int n) {
            if (!$assertionsDisabled && l == 0L) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
            }
            this.address = l;
            this.size = l2;
            this.capacity = n;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            unsafe.freeMemory(this.address);
            this.address = 0L;
            Bits.unreserveMemory(this.size, this.capacity);
        }

        private static /* synthetic */ void _jr$ip$size(Deallocator deallocator, long l) {
            deallocator.size = l;
        }

        private static /* synthetic */ void _jr$ip$capacity(Deallocator deallocator, int n) {
            deallocator.capacity = n;
        }

        protected /* synthetic */ Deallocator(h h2) {
            super(h2);
        }
    }
}

