/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBufferR;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

class HeapByteBuffer
extends ByteBuffer {
    HeapByteBuffer(int n2, int n3) {
        super(-1, 0, n3, n2, new byte[n2], 0);
    }

    HeapByteBuffer(byte[] byArray, int n2, int n3) {
        super(-1, n2, n2 + n3, byArray.length, byArray, 0);
    }

    protected HeapByteBuffer(byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, byArray, n6);
    }

    @Override
    public ByteBuffer slice() {
        return new HeapByteBuffer(HeapByteBuffer._jr$ig$hb(this), -1, 0, this.remaining(), this.remaining(), this.position() + HeapByteBuffer._jr$ig$offset(this));
    }

    @Override
    public ByteBuffer duplicate() {
        return new HeapByteBuffer(HeapByteBuffer._jr$ig$hb(this), this.markValue(), this.position(), this.limit(), this.capacity(), HeapByteBuffer._jr$ig$offset(this));
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new HeapByteBufferR(HeapByteBuffer._jr$ig$hb(this), this.markValue(), this.position(), this.limit(), this.capacity(), HeapByteBuffer._jr$ig$offset(this));
    }

    protected int ix(int n2) {
        return n2 + HeapByteBuffer._jr$ig$offset(this);
    }

    @Override
    public byte get() {
        return HeapByteBuffer._jr$ig$hb(this)[this.ix(this.nextGetIndex())];
    }

    @Override
    public byte get(int n2) {
        return HeapByteBuffer._jr$ig$hb(this)[this.ix(this.checkIndex(n2))];
    }

    @Override
    public ByteBuffer get(byte[] byArray, int n2, int n3) {
        HeapByteBuffer.checkBounds(n2, n3, byArray.length);
        if (n3 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferUnderflowException());
        }
        a.arraycopy((Object)HeapByteBuffer._jr$ig$hb(this), (int)this.ix(this.position()), (Object)byArray, (int)n2, (int)n3);
        this.position(this.position() + n3);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuffer put(byte by) {
        HeapByteBuffer._jr$ig$hb((Object)this)[this.ix((int)this.nextPutIndex())] = by;
        return this;
    }

    @Override
    public ByteBuffer put(int n2, byte by) {
        HeapByteBuffer._jr$ig$hb((Object)this)[this.ix((int)this.checkIndex((int)n2))] = by;
        return this;
    }

    @Override
    public ByteBuffer put(byte[] byArray, int n2, int n3) {
        HeapByteBuffer.checkBounds(n2, n3, byArray.length);
        if (n3 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
        }
        a.arraycopy((Object)byArray, (int)n2, (Object)HeapByteBuffer._jr$ig$hb(this), (int)this.ix(this.position()), (int)n3);
        this.position(this.position() + n3);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (g.convertForInstanceOf((Object)byteBuffer, HeapByteBuffer.class) instanceof HeapByteBuffer) {
            if (!f.ifAcmp((Object)byteBuffer, (Object)this)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
            }
            HeapByteBuffer heapByteBuffer = (HeapByteBuffer)g.convertForCast((Object)byteBuffer, HeapByteBuffer.class);
            int n2 = heapByteBuffer.remaining();
            if (n2 > this.remaining()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
            }
            a.arraycopy((Object)HeapByteBuffer._jr$ig$hb(heapByteBuffer), (int)heapByteBuffer.ix(heapByteBuffer.position()), (Object)HeapByteBuffer._jr$ig$hb(this), (int)this.ix(this.position()), (int)n2);
            heapByteBuffer.position(heapByteBuffer.position() + n2);
            this.position(this.position() + n2);
        } else if (byteBuffer.isDirect()) {
            int n3 = byteBuffer.remaining();
            if (n3 > this.remaining()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
            }
            byteBuffer.get(HeapByteBuffer._jr$ig$hb(this), this.ix(this.position()), n3);
            this.position(this.position() + n3);
        } else {
            super.put(byteBuffer);
        }
        return this;
    }

    @Override
    public ByteBuffer compact() {
        a.arraycopy((Object)HeapByteBuffer._jr$ig$hb(this), (int)this.ix(this.position()), (Object)HeapByteBuffer._jr$ig$hb(this), (int)this.ix(0), (int)this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    byte _get(int n2) {
        return HeapByteBuffer._jr$ig$hb(this)[n2];
    }

    @Override
    void _put(int n2, byte by) {
        HeapByteBuffer._jr$ig$hb((Object)this)[n2] = by;
    }

    @Override
    public char getChar() {
        return Bits.getChar(this, this.ix(this.nextGetIndex(2)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public char getChar(int n2) {
        return Bits.getChar(this, this.ix(this.checkIndex(n2, 2)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public ByteBuffer putChar(char c) {
        Bits.putChar(this, this.ix(this.nextPutIndex(2)), c, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public ByteBuffer putChar(int n2, char c) {
        Bits.putChar(this, this.ix(this.checkIndex(n2, 2)), c, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        int n2 = this.remaining() >> 1;
        int n3 = HeapByteBuffer._jr$ig$offset(this) + this.position();
        return HeapByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsCharBufferB((ByteBuffer)this, -1, 0, n2, n2, n3) : new ByteBufferAsCharBufferL((ByteBuffer)this, -1, 0, n2, n2, n3);
    }

    @Override
    public short getShort() {
        return Bits.getShort(this, this.ix(this.nextGetIndex(2)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public short getShort(int n2) {
        return Bits.getShort(this, this.ix(this.checkIndex(n2, 2)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public ByteBuffer putShort(short s) {
        Bits.putShort(this, this.ix(this.nextPutIndex(2)), s, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public ByteBuffer putShort(int n2, short s) {
        Bits.putShort(this, this.ix(this.checkIndex(n2, 2)), s, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int n2 = this.remaining() >> 1;
        int n3 = HeapByteBuffer._jr$ig$offset(this) + this.position();
        return HeapByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsShortBufferB((ByteBuffer)this, -1, 0, n2, n2, n3) : new ByteBufferAsShortBufferL((ByteBuffer)this, -1, 0, n2, n2, n3);
    }

    @Override
    public int getInt() {
        return Bits.getInt(this, this.ix(this.nextGetIndex(4)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public int getInt(int n2) {
        return Bits.getInt(this, this.ix(this.checkIndex(n2, 4)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public ByteBuffer putInt(int n2) {
        Bits.putInt(this, this.ix(this.nextPutIndex(4)), n2, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public ByteBuffer putInt(int n2, int n3) {
        Bits.putInt(this, this.ix(this.checkIndex(n2, 4)), n3, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int n2 = this.remaining() >> 2;
        int n3 = HeapByteBuffer._jr$ig$offset(this) + this.position();
        return HeapByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsIntBufferB((ByteBuffer)this, -1, 0, n2, n2, n3) : new ByteBufferAsIntBufferL((ByteBuffer)this, -1, 0, n2, n2, n3);
    }

    @Override
    public long getLong() {
        return Bits.getLong(this, this.ix(this.nextGetIndex(8)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public long getLong(int n2) {
        return Bits.getLong(this, this.ix(this.checkIndex(n2, 8)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public ByteBuffer putLong(long l) {
        Bits.putLong(this, this.ix(this.nextPutIndex(8)), l, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public ByteBuffer putLong(int n2, long l) {
        Bits.putLong(this, this.ix(this.checkIndex(n2, 8)), l, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        int n2 = this.remaining() >> 3;
        int n3 = HeapByteBuffer._jr$ig$offset(this) + this.position();
        return HeapByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsLongBufferB((ByteBuffer)this, -1, 0, n2, n2, n3) : new ByteBufferAsLongBufferL((ByteBuffer)this, -1, 0, n2, n2, n3);
    }

    @Override
    public float getFloat() {
        return Bits.getFloat(this, this.ix(this.nextGetIndex(4)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public float getFloat(int n2) {
        return Bits.getFloat(this, this.ix(this.checkIndex(n2, 4)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public ByteBuffer putFloat(float f2) {
        Bits.putFloat(this, this.ix(this.nextPutIndex(4)), f2, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public ByteBuffer putFloat(int n2, float f2) {
        Bits.putFloat(this, this.ix(this.checkIndex(n2, 4)), f2, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int n2 = this.remaining() >> 2;
        int n3 = HeapByteBuffer._jr$ig$offset(this) + this.position();
        return HeapByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsFloatBufferB((ByteBuffer)this, -1, 0, n2, n2, n3) : new ByteBufferAsFloatBufferL((ByteBuffer)this, -1, 0, n2, n2, n3);
    }

    @Override
    public double getDouble() {
        return Bits.getDouble(this, this.ix(this.nextGetIndex(8)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public double getDouble(int n2) {
        return Bits.getDouble(this, this.ix(this.checkIndex(n2, 8)), HeapByteBuffer._jr$ig$bigEndian(this));
    }

    @Override
    public ByteBuffer putDouble(double d) {
        Bits.putDouble(this, this.ix(this.nextPutIndex(8)), d, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public ByteBuffer putDouble(int n2, double d) {
        Bits.putDouble(this, this.ix(this.checkIndex(n2, 8)), d, HeapByteBuffer._jr$ig$bigEndian(this));
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int n2 = this.remaining() >> 3;
        int n3 = HeapByteBuffer._jr$ig$offset(this) + this.position();
        return HeapByteBuffer._jr$ig$bigEndian(this) ? new ByteBufferAsDoubleBufferB((ByteBuffer)this, -1, 0, n2, n2, n3) : new ByteBufferAsDoubleBufferL((ByteBuffer)this, -1, 0, n2, n2, n3);
    }

    protected /* synthetic */ HeapByteBuffer(h h2) {
        super(h2);
    }
}

