/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBufferR;

class HeapCharBuffer
extends CharBuffer {
    HeapCharBuffer(int n, int n2) {
        super(-1, 0, n2, n, new char[n], 0);
    }

    HeapCharBuffer(char[] cArray, int n, int n2) {
        super(-1, n, n + n2, cArray.length, cArray, 0);
    }

    protected HeapCharBuffer(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, cArray, n5);
    }

    @Override
    public CharBuffer slice() {
        return new HeapCharBuffer(HeapCharBuffer._jr$ig$hb(this), -1, 0, this.remaining(), this.remaining(), this.position() + HeapCharBuffer._jr$ig$offset(this));
    }

    @Override
    public CharBuffer duplicate() {
        return new HeapCharBuffer(HeapCharBuffer._jr$ig$hb(this), this.markValue(), this.position(), this.limit(), this.capacity(), HeapCharBuffer._jr$ig$offset(this));
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new HeapCharBufferR(HeapCharBuffer._jr$ig$hb(this), this.markValue(), this.position(), this.limit(), this.capacity(), HeapCharBuffer._jr$ig$offset(this));
    }

    protected int ix(int n) {
        return n + HeapCharBuffer._jr$ig$offset(this);
    }

    @Override
    public char get() {
        return HeapCharBuffer._jr$ig$hb(this)[this.ix(this.nextGetIndex())];
    }

    @Override
    public char get(int n) {
        return HeapCharBuffer._jr$ig$hb(this)[this.ix(this.checkIndex(n))];
    }

    @Override
    public CharBuffer get(char[] cArray, int n, int n2) {
        HeapCharBuffer.checkBounds(n, n2, cArray.length);
        if (n2 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferUnderflowException());
        }
        a.arraycopy((Object)HeapCharBuffer._jr$ig$hb(this), (int)this.ix(this.position()), (Object)cArray, (int)n, (int)n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public CharBuffer put(char c) {
        HeapCharBuffer._jr$ig$hb((Object)this)[this.ix((int)this.nextPutIndex())] = c;
        return this;
    }

    @Override
    public CharBuffer put(int n, char c) {
        HeapCharBuffer._jr$ig$hb((Object)this)[this.ix((int)this.checkIndex((int)n))] = c;
        return this;
    }

    @Override
    public CharBuffer put(char[] cArray, int n, int n2) {
        HeapCharBuffer.checkBounds(n, n2, cArray.length);
        if (n2 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
        }
        a.arraycopy((Object)cArray, (int)n, (Object)HeapCharBuffer._jr$ig$hb(this), (int)this.ix(this.position()), (int)n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public CharBuffer put(CharBuffer charBuffer) {
        if (g.convertForInstanceOf((Object)charBuffer, HeapCharBuffer.class) instanceof HeapCharBuffer) {
            if (!f.ifAcmp((Object)charBuffer, (Object)this)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
            }
            HeapCharBuffer heapCharBuffer = (HeapCharBuffer)g.convertForCast((Object)charBuffer, HeapCharBuffer.class);
            int n = heapCharBuffer.remaining();
            if (n > this.remaining()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
            }
            a.arraycopy((Object)HeapCharBuffer._jr$ig$hb(heapCharBuffer), (int)heapCharBuffer.ix(heapCharBuffer.position()), (Object)HeapCharBuffer._jr$ig$hb(this), (int)this.ix(this.position()), (int)n);
            heapCharBuffer.position(heapCharBuffer.position() + n);
            this.position(this.position() + n);
        } else if (charBuffer.isDirect()) {
            int n = charBuffer.remaining();
            if (n > this.remaining()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
            }
            charBuffer.get(HeapCharBuffer._jr$ig$hb(this), this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(charBuffer);
        }
        return this;
    }

    @Override
    public CharBuffer compact() {
        a.arraycopy((Object)HeapCharBuffer._jr$ig$hb(this), (int)this.ix(this.position()), (Object)HeapCharBuffer._jr$ig$hb(this), (int)this.ix(0), (int)this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    String toString(int n, int n2) {
        try {
            return new String(HeapCharBuffer._jr$ig$hb(this), n + HeapCharBuffer._jr$ig$offset(this), n2 - n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
    }

    @Override
    public CharBuffer subSequence(int n, int n2) {
        if (n < 0 || n2 > this.length() || n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        int n3 = this.position();
        return new HeapCharBuffer(HeapCharBuffer._jr$ig$hb(this), -1, n3 + n, n3 + n2, this.capacity(), HeapCharBuffer._jr$ig$offset(this));
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    protected /* synthetic */ HeapCharBuffer(h h2) {
        super(h2);
    }
}

