/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class LongBuffer
extends Buffer
implements Comparable<LongBuffer> {
    final long[] hb;
    final int offset;
    boolean isReadOnly;

    LongBuffer(int n, int n2, int n3, int n4, long[] lArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = lArray;
        this.offset = n5;
    }

    LongBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    public static LongBuffer allocate(int n) {
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        return new HeapLongBuffer(n, n);
    }

    public static LongBuffer wrap(long[] lArray, int n, int n2) {
        try {
            return new HeapLongBuffer(lArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
    }

    public static LongBuffer wrap(long[] lArray) {
        return LongBuffer.wrap(lArray, 0, lArray.length);
    }

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public LongBuffer get(long[] lArray, int n, int n2) {
        LongBuffer.checkBounds(n, n2, lArray.length);
        if (n2 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferUnderflowException());
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            lArray[i] = this.get();
        }
        return this;
    }

    public LongBuffer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (!f.ifAcmp((Object)longBuffer, (Object)this)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        int n = longBuffer.remaining();
        if (n > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
        }
        for (int i = 0; i < n; ++i) {
            this.put(longBuffer.get());
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n, int n2) {
        LongBuffer.checkBounds(n, n2, lArray.length);
        if (n2 > this.remaining()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BufferOverflowException());
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(lArray[i]);
        }
        return this;
    }

    public final LongBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    @Override
    public final boolean hasArray() {
        return ((LongBuffer)this).hb != null && !((LongBuffer)this).isReadOnly;
    }

    public final long[] array() {
        if (((LongBuffer)this).hb == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        if (((LongBuffer)this).isReadOnly) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ReadOnlyBufferException());
        }
        return ((LongBuffer)this).hb;
    }

    @Override
    public final int arrayOffset() {
        if (((LongBuffer)this).hb == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
        if (((LongBuffer)this).isReadOnly) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ReadOnlyBufferException());
        }
        return ((LongBuffer)this).offset;
    }

    public abstract LongBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(x.getName(this.getClass()));
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + (int)this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, LongBuffer.class) instanceof LongBuffer)) {
            return false;
        }
        LongBuffer longBuffer = (LongBuffer)g.convertForCast((Object)object, LongBuffer.class);
        if (this.remaining() != longBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = longBuffer.limit() - 1;
        while (n2 >= n) {
            if (!LongBuffer.equals(this.get(n2), longBuffer.get(n3))) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    private static boolean equals(long l, long l2) {
        return l == l2;
    }

    @Override
    public int compareTo(LongBuffer longBuffer) {
        int n = this.position() + Math.min(this.remaining(), longBuffer.remaining());
        int n2 = this.position();
        int n3 = longBuffer.position();
        while (n2 < n) {
            int n4 = LongBuffer.compare(this.get(n2), longBuffer.get(n3));
            if (n4 != 0) {
                return n4;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - longBuffer.remaining();
    }

    private static int compare(long l, long l2) {
        return Long.compare(l, l2);
    }

    public abstract ByteOrder order();

    static /* synthetic */ void _jr$ip$hb(Object object, long[] lArray) {
        ((LongBuffer)object).hb = lArray;
    }

    static /* synthetic */ void _jr$ip$offset(Object object, int n) {
        ((LongBuffer)object).offset = n;
    }

    static /* synthetic */ void _jr$ip$isReadOnly(Object object, boolean bl) {
        ((LongBuffer)object).isReadOnly = bl;
    }

    protected /* synthetic */ LongBuffer(h h2) {
        super(h2);
    }
}

