/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.zeroturnaround.jrebelbase.h;
import java.io.FileDescriptor;
import java.nio.Bits;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public abstract class MappedByteBuffer
extends ByteBuffer {
    private final FileDescriptor fd;
    private static byte unused;

    MappedByteBuffer(int n, int n2, int n3, int n4, FileDescriptor fileDescriptor) {
        super(n, n2, n3, n4);
        this.fd = fileDescriptor;
    }

    MappedByteBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.fd = null;
    }

    private void checkMapped() {
        if (this.fd == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }
    }

    private long mappingOffset() {
        int n = Bits.pageSize();
        long l = MappedByteBuffer._jr$ig$address(this) % (long)n;
        return l >= 0L ? l : (long)n + l;
    }

    private long mappingAddress(long l) {
        return MappedByteBuffer._jr$ig$address(this) - l;
    }

    private long mappingLength(long l) {
        return (long)this.capacity() + l;
    }

    public final boolean isLoaded() {
        this.checkMapped();
        if (MappedByteBuffer._jr$ig$address(this) == 0L || this.capacity() == 0) {
            return true;
        }
        long l = this.mappingOffset();
        long l2 = this.mappingLength(l);
        return this._jr$jnim$isLoaded0(this.mappingAddress(l), l2, Bits.pageCount(l2));
    }

    public final MappedByteBuffer load() {
        this.checkMapped();
        if (MappedByteBuffer._jr$ig$address(this) == 0L || this.capacity() == 0) {
            return this;
        }
        long l = this.mappingOffset();
        long l2 = this.mappingLength(l);
        this._jr$jnim$load0(this.mappingAddress(l), l2);
        Unsafe unsafe = Unsafe.getUnsafe();
        int n = Bits.pageSize();
        int n2 = Bits.pageCount(l2);
        long l3 = this.mappingAddress(l);
        byte by = 0;
        for (int i = 0; i < n2; ++i) {
            by = (byte)(by ^ unsafe.getByte(l3));
            l3 += (long)n;
        }
        if (unused != 0) {
            unused = by;
        }
        return this;
    }

    public final MappedByteBuffer force() {
        this.checkMapped();
        if (MappedByteBuffer._jr$ig$address(this) != 0L && this.capacity() != 0) {
            long l = this.mappingOffset();
            this._jr$jnim$force0(this.fd, this.mappingAddress(l), this.mappingLength(l));
        }
        return this;
    }

    private boolean _jr$jnim$isLoaded0(long l, long l2, int n) {
        return ((MappedByteBuffer)this._jr$gOrg()).isLoaded0(l, l2, n);
    }

    private native boolean isLoaded0(long var1, long var3, int var5);

    private void _jr$jnim$load0(long l, long l2) {
        ((MappedByteBuffer)this._jr$gOrg()).load0(l, l2);
    }

    private native void load0(long var1, long var3);

    private void _jr$jnim$force0(FileDescriptor fileDescriptor, long l, long l2) {
        ((MappedByteBuffer)this._jr$gOrg()).force0(fileDescriptor, l, l2);
    }

    private native void force0(FileDescriptor var1, long var2, long var4);

    private static /* synthetic */ void _jr$ip$fd(MappedByteBuffer mappedByteBuffer, FileDescriptor fileDescriptor) {
        mappedByteBuffer.fd = fileDescriptor;
    }

    protected /* synthetic */ MappedByteBuffer(h h2) {
        super(h2);
    }
}

